<?php
/*
Plugin Name: WPPizza Gateway - MyCod
Description: WPPizza Gateway Development: A COD Type Gateway Example plugin for developing your own COD type WPPizza Gateway. Edit the file as required as per instructions, then activate the plugin and adjust settings in WPPizza -> Gateways - Requires WPPIZZA 3.0+
Author: ollybach
Plugin URI: https://www.wp-pizza.com
Author URI: https://www.wp-pizza.com
Version: 1.0

Copyright (c) 2023, Oliver Bach
All rights reserved.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/********************************************
	 Exit if accessed directly
*********************************************/
if ( ! defined( 'ABSPATH' ) ) exit;

/********************************************************************
#	on uninstall, remove options from table
*********************************************************************/
register_uninstall_hook( __FILE__, 'wppizza_gateway_mycod_uninstall');

/********************************************************************
#
#	register the gateway (class) as an additional WPPizza Gateway
#
*********************************************************************/
function wppizza_register_gateway_mycod( $gateways ) {	

	$gateways[] = 'WPPIZZA_GATEWAY_MYCOD'; //the gateway class to register 

return $gateways;
}
add_filter( 'wppizza_register_gateways', 'wppizza_register_gateway_mycod' );



/********************************************************************
#
#	The Gateway Class 
#	(class name must start with WPPIZZA_GATEWAY_)
#
*********************************************************************/
class WPPIZZA_GATEWAY_MYCOD{

	/*****************************
		[required]
	*****************************/
	/*
		@type : string( must NOT be empty)
		@param : gateway version number
	*/
	public $gatewayVersion = '1.0';

	/*
		Name of the Gateway (Displayed in Admin)	
		@type : string (must NOT be empty)
		@param : string
		gateway name
	*/
	public $gatewayName = 'My COD Gateway';

	/*
		@type : array
		@param : options of gateway
	*/
	public $gatewayOptions = array();	

	/*
		@type : string (can be empty)
		@param : string
		additional description of gateway displayed in ADMIN area
	*/
	public $gatewayDescription = 'Some more information about this gateway';

	/*
		@type : string (can be empty)
		@param : string
		default printed under gateway options FRONTEND
		can be changed/localized/emptied in admin
	*/
	public $gatewayAdditionalInfo = '';

	/*
		@type : bool
		@param : bool
		enable discounts on usage (rather than surcharges)
	*/
	public $gatewayDiscount = true;

	/*
		@type : bool
		@param : bool
		automatically enable on install
	*/
	public $gatewayAutoEnable = true;

	/*
		@type : string
		@param : MUST BE 'cod'
	*/
	public $gatewayType = 'cod';



	/******************************************************************************************************************
	*
	*
	*	[construct]
	*
	*
	******************************************************************************************************************/
	function __construct() {
		/************************
			[get gateway options]
		************************/
		$this -> gatewayOptions = get_option(__CLASS__, 0);
	}
}
?>