/*
 * WP Real Estate plugin by MyThemeShop
 * https://wordpress.com/plugins/wp-real-estate/
 */
(function ($, undefined) {
	'use strict';
	var defaults = {
		item: 3,
		autoWidth: false,
		slideMove: 1,
		slideMargin: 10,
		addClass: '',
		mode: 'slide',
		useCSS: true,
		cssEasing: 'ease', //'cubic-bezier(0.25, 0, 0.25, 1)',
		easing: 'linear', //'for jquery animation',//
		speed: 400, //ms'
		auto: false,
		pauseOnHover: false,
		loop: false,
		slideEndAnimation: true,
		pause: 2000,
		keyPress: false,
		controls: true,
		prevHtml: '',
		nextHtml: '',
		rtl: false,
		adaptiveHeight: false,
		vertical: false,
		verticalHeight: 500,
		vThumbWidth: 100,
		thumbItem: 10,
		pager: true,
		gallery: false,
		galleryMargin: 5,
		thumbMargin: 5,
		currentPagerPosition: 'middle',
		enableTouch: true,
		enableDrag: true,
		freeMove: true,
		swipeThreshold: 40,
		responsive: [],
		/* jshint ignore:start */
		onBeforeStart: function ($el) {},
		onSliderLoad: function ($el) {},
		onBeforeSlide: function ($el, scene) {},
		onAfterSlide: function ($el, scene) {},
		onBeforeNextSlide: function ($el, scene) {},
		onBeforePrevSlide: function ($el, scene) {}
		/* jshint ignore:end */
	};
	$.fn.lightSlider = function (options) {
		if (this.length === 0) {
			return this;
		}

		if (this.length > 1) {
			this.each(function () {
				$(this).lightSlider(options);
			});
			return this;
		}

		var plugin = {},
			settings = $.extend(true, {}, defaults, options),
			settingsTemp = {},
			$el = this;
		plugin.$el = this;

		if (settings.mode === 'fade') {
			settings.vertical = false;
		}
		var $children = $el.children(),
			windowW = $(window).width(),
			breakpoint = null,
			resposiveObj = null,
			length = 0,
			w = 0,
			on = false,
			elSize = 0,
			$slide = '',
			scene = 0,
			property = (settings.vertical === true) ? 'height' : 'width',
			gutter = (settings.vertical === true) ? 'margin-bottom' : 'margin-right',
			slideValue = 0,
			pagerWidth = 0,
			slideWidth = 0,
			thumbWidth = 0,
			interval = null,
			isTouch = ('ontouchstart' in document.documentElement);
		var refresh = {};

		refresh.chbreakpoint = function () {
			windowW = $(window).width();
			if (settings.responsive.length) {
				var item;
				if (settings.autoWidth === false) {
					item = settings.item;
				}
				if (windowW < settings.responsive[0].breakpoint) {
					for (var i = 0; i < settings.responsive.length; i++) {
						if (windowW < settings.responsive[i].breakpoint) {
							breakpoint = settings.responsive[i].breakpoint;
							resposiveObj = settings.responsive[i];
						}
					}
				}
				if (typeof resposiveObj !== 'undefined' && resposiveObj !== null) {
					for (var j in resposiveObj.settings) {
						if (resposiveObj.settings.hasOwnProperty(j)) {
							if (typeof settingsTemp[j] === 'undefined' || settingsTemp[j] === null) {
								settingsTemp[j] = settings[j];
							}
							settings[j] = resposiveObj.settings[j];
						}
					}
				}
				if (!$.isEmptyObject(settingsTemp) && windowW > settings.responsive[0].breakpoint) {
					for (var k in settingsTemp) {
						if (settingsTemp.hasOwnProperty(k)) {
							settings[k] = settingsTemp[k];
						}
					}
				}
				if (settings.autoWidth === false) {
					if (slideValue > 0 && slideWidth > 0) {
						if (item !== settings.item) {
							scene = Math.round(slideValue / ((slideWidth + settings.slideMargin) * settings.slideMove));
						}
					}
				}
			}
		};

		refresh.calSW = function () {
			if (settings.autoWidth === false) {
				slideWidth = (elSize - ((settings.item * (settings.slideMargin)) - settings.slideMargin)) / settings.item;
			}
		};

		refresh.calWidth = function (cln) {
			var ln = cln === true ? $slide.find('.lslide').length : $children.length;
			if (settings.autoWidth === false) {
				w = ln * (slideWidth + settings.slideMargin);
			} else {
				w = 0;
				for (var i = 0; i < ln; i++) {
					w += (parseInt($children.eq(i).width()) + settings.slideMargin);
				}
			}
			return w;
		};
		plugin = {
			doCss: function () {
				var support = function () {
					var transition = ['transition', 'MozTransition', 'WebkitTransition', 'OTransition', 'msTransition', 'KhtmlTransition'];
					var root = document.documentElement;
					for (var i = 0; i < transition.length; i++) {
						if (transition[i] in root.style) {
							return true;
						}
					}
				};
				if (settings.useCSS && support()) {
					return true;
				}
				return false;
			},
			keyPress: function () {
				if (settings.keyPress) {
					$(document).on('keyup.lightslider', function (e) {
						if (!$(':focus').is('input, textarea')) {
							if (e.preventDefault) {
								e.preventDefault();
							} else {
								e.returnValue = false;
							}
							if (e.keyCode === 37) {
								$el.goToPrevSlide();
							} else if (e.keyCode === 39) {
								$el.goToNextSlide();
							}
						}
					});
				}
			},
			controls: function () {
				if (settings.controls) {
					$el.after('<div class="lSAction"><a class="lSPrev">' + settings.prevHtml + '</a><a class="lSNext">' + settings.nextHtml + '</a></div>');
					if (!settings.autoWidth) {
						if (length <= settings.item) {
							$slide.find('.lSAction').hide();
						}
					} else {
						if (refresh.calWidth(false) < elSize) {
							$slide.find('.lSAction').hide();
						}
					}
					$slide.find('.lSAction a').on('click', function (e) {
						if (e.preventDefault) {
							e.preventDefault();
						} else {
							e.returnValue = false;
						}
						if ($(this).attr('class') === 'lSPrev') {
							$el.goToPrevSlide();
						} else {
							$el.goToNextSlide();
						}
						return false;
					});
				}
			},
			initialStyle: function () {
				var $this = this;
				if (settings.mode === 'fade') {
					settings.autoWidth = false;
					settings.slideEndAnimation = false;
				}
				if (settings.auto) {
					settings.slideEndAnimation = false;
				}
				if (settings.autoWidth) {
					settings.slideMove = 1;
					settings.item = 1;
				}
				if (settings.loop) {
					settings.slideMove = 1;
					settings.freeMove = false;
				}
				settings.onBeforeStart.call(this, $el);
				refresh.chbreakpoint();
				$el.addClass('lightSlider').wrap('<div class="lSSlideOuter ' + settings.addClass + '"><div class="lSSlideWrapper"></div></div>');
				$slide = $el.parent('.lSSlideWrapper');
				if (settings.rtl === true) {
					$slide.parent().addClass('lSrtl');
				}
				if (settings.vertical) {
					$slide.parent().addClass('vertical');
					elSize = settings.verticalHeight;
					$slide.css('height', elSize + 'px');
				} else {
					elSize = $el.outerWidth();
				}
				$children.addClass('lslide');
				if (settings.loop === true && settings.mode === 'slide') {
					refresh.calSW();
					refresh.clone = function () {
						if (refresh.calWidth(true) > elSize) {
							/**/
							var tWr = 0,
								tI = 0;
							for (var k = 0; k < $children.length; k++) {
								tWr += (parseInt($el.find('.lslide').eq(k).width()) + settings.slideMargin);
								tI++;
								if (tWr >= (elSize + settings.slideMargin)) {
									break;
								}
							}
							var tItem = settings.autoWidth === true ? tI : settings.item;

							/**/
							if (tItem < $el.find('.clone.left').length) {
								for (var i = 0; i < $el.find('.clone.left').length - tItem; i++) {
									$children.eq(i).remove();
								}
							}
							if (tItem < $el.find('.clone.right').length) {
								for (var j = $children.length - 1; j > ($children.length - 1 - $el.find('.clone.right').length); j--) {
									scene--;
									$children.eq(j).remove();
								}
							}
							/**/
							for (var n = $el.find('.clone.right').length; n < tItem; n++) {
								$el.find('.lslide').eq(n).clone().removeClass('lslide').addClass('clone right').appendTo($el);
								scene++;
							}
							for (var m = $el.find('.lslide').length - $el.find('.clone.left').length; m > ($el.find('.lslide').length - tItem); m--) {
								$el.find('.lslide').eq(m - 1).clone().removeClass('lslide').addClass('clone left').prependTo($el);
							}
							$children = $el.children();
						} else {
							if ($children.hasClass('clone')) {
								$el.find('.clone').remove();
								$this.move($el, 0);
							}
						}
					};
					refresh.clone();
				}
				refresh.sSW = function () {
					length = $children.length;
					if (settings.rtl === true && settings.vertical === false) {
						gutter = 'margin-left';
					}
					if (settings.autoWidth === false) {
						$children.css(property, slideWidth + 'px');
					}
					$children.css(gutter, settings.slideMargin + 'px');
					w = refresh.calWidth(false);
					$el.css(property, w + 'px');
					if (settings.loop === true && settings.mode === 'slide') {
						if (on === false) {
							scene = $el.find('.clone.left').length;
						}
					}
				};
				refresh.calL = function () {
					$children = $el.children();
					length = $children.length;
				};
				if (this.doCss()) {
					$slide.addClass('usingCss');
				}
				refresh.calL();
				if (settings.mode === 'slide') {
					refresh.calSW();
					refresh.sSW();
					if (settings.loop === true) {
						slideValue = $this.slideValue();
						this.move($el, slideValue);
					}
					if (settings.vertical === false) {
						this.setHeight($el, false);
					}

				} else {
					this.setHeight($el, true);
					$el.addClass('lSFade');
					if (!this.doCss()) {
						$children.fadeOut(0);
						$children.eq(scene).fadeIn(0);
					}
				}
				if (settings.loop === true && settings.mode === 'slide') {
					$children.eq(scene).addClass('active');
				} else {
					$children.first().addClass('active');
				}
			},
			pager: function () {
				var $this = this;
				refresh.createPager = function () {
					thumbWidth = (elSize - ((settings.thumbItem * (settings.thumbMargin)) - settings.thumbMargin)) / settings.thumbItem;
					var $children = $slide.find('.lslide');
					var length = $slide.find('.lslide').length;
					var i = 0,
						pagers = '',
						v = 0;
					for (i = 0; i < length; i++) {
						if (settings.mode === 'slide') {
							// calculate scene * slide value
							if (!settings.autoWidth) {
								v = i * ((slideWidth + settings.slideMargin) * settings.slideMove);
							} else {
								v += ((parseInt($children.eq(i).width()) + settings.slideMargin) * settings.slideMove);
							}
						}
						var thumb = $children.eq(i * settings.slideMove).attr('data-thumb');
						if (settings.gallery === true) {
							pagers += '<li style="width:100%;' + property + ':' + thumbWidth + 'px;' + gutter + ':' + settings.thumbMargin + 'px"><a href="#"><img src="' + thumb + '" /></a></li>';
						} else {
							pagers += '<li><a href="#">' + (i + 1) + '</a></li>';
						}
						if (settings.mode === 'slide') {
							if ((v) >= w - elSize - settings.slideMargin) {
								i = i + 1;
								var minPgr = 2;
								if (settings.autoWidth) {
									pagers += '<li><a href="#">' + (i + 1) + '</a></li>';
									minPgr = 1;
								}
								if (i < minPgr) {
									pagers = null;
									$slide.parent().addClass('noPager');
								} else {
									$slide.parent().removeClass('noPager');
								}
								break;
							}
						}
					}
					var $cSouter = $slide.parent();
					$cSouter.find('.lSPager').html(pagers); 
					if (settings.gallery === true) {
						if (settings.vertical === true) {
							// set Gallery thumbnail width
							$cSouter.find('.lSPager').css('width', settings.vThumbWidth + 'px');
						}
						pagerWidth = (i * (settings.thumbMargin + thumbWidth)) + 0.5;
						$cSouter.find('.lSPager').css({
							property: pagerWidth + 'px',
							'transition-duration': settings.speed + 'ms'
						});
						if (settings.vertical === true) {
							$slide.parent().css('padding-right', (settings.vThumbWidth + settings.galleryMargin) + 'px');
						}
						$cSouter.find('.lSPager').css(property, pagerWidth + 'px');
					}
					var $pager = $cSouter.find('.lSPager').find('li');
					$pager.first().addClass('active');
					$pager.on('click', function () {
						if (settings.loop === true && settings.mode === 'slide') {
							scene = scene + ($pager.index(this) - $cSouter.find('.lSPager').find('li.active').index());
						} else {
							scene = $pager.index(this);
						}
						$el.mode(false);
						if (settings.gallery === true) {
							$this.slideThumb();
						}
						return false;
					});
				};
				if (settings.pager) {
					var cl = 'lSpg';
					if (settings.gallery) {
						cl = 'lSGallery';
					}
					$slide.after('<ul class="lSPager ' + cl + '"></ul>');
					var gMargin = (settings.vertical) ? 'margin-left' : 'margin-top';
					$slide.parent().find('.lSPager').css(gMargin, settings.galleryMargin + 'px');
					refresh.createPager();
				}

				setTimeout(function () {
					refresh.init();
				}, 0);
			},
			setHeight: function (ob, fade) {
				var obj = null,
					$this = this;
				if (settings.loop) {
					obj = ob.children('.lslide ').first();
				} else {
					obj = ob.children().first();
				}
				var setCss = function () {
					var tH = obj.outerHeight(),
						tP = 0,
						tHT = tH;
					if (fade) {
						tH = 0;
						tP = ((tHT) * 100) / elSize;
					}
					ob.css({
						'height': tH + 'px',
						'padding-bottom': tP + '%'
					});
				};
				setCss();
				if (obj.find('img').length) {
					if ( obj.find('img')[0].complete) {
						setCss();
						if (!interval) {
							$this.auto();
						}   
					}else{
						obj.find('img').on('load', function () {
							setTimeout(function () {
								setCss();
								if (!interval) {
									$this.auto();
								}
							}, 100);
						});
					}
				}else{
					if (!interval) {
						$this.auto();
					}
				}
			},
			active: function (ob, t) {
				if (this.doCss() && settings.mode === 'fade') {
					$slide.addClass('on');
				}
				var sc = 0;
				if (scene * settings.slideMove < length) {
					ob.removeClass('active');
					if (!this.doCss() && settings.mode === 'fade' && t === false) {
						ob.fadeOut(settings.speed);
					}
					if (t === true) {
						sc = scene;
					} else {
						sc = scene * settings.slideMove;
					}
					//t === true ? sc = scene : sc = scene * settings.slideMove;
					var l, nl;
					if (t === true) {
						l = ob.length;
						nl = l - 1;
						if (sc + 1 >= l) {
							sc = nl;
						}
					}
					if (settings.loop === true && settings.mode === 'slide') {
						//t === true ? sc = scene - $el.find('.clone.left').length : sc = scene * settings.slideMove;
						if (t === true) {
							sc = scene - $el.find('.clone.left').length;
						} else {
							sc = scene * settings.slideMove;
						}
						if (t === true) {
							l = ob.length;
							nl = l - 1;
							if (sc + 1 === l) {
								sc = nl;
							} else if (sc + 1 > l) {
								sc = 0;
							}
						}
					}

					if (!this.doCss() && settings.mode === 'fade' && t === false) {
						ob.eq(sc).fadeIn(settings.speed);
					}
					ob.eq(sc).addClass('active');
				} else {
					ob.removeClass('active');
					ob.eq(ob.length - 1).addClass('active');
					if (!this.doCss() && settings.mode === 'fade' && t === false) {
						ob.fadeOut(settings.speed);
						ob.eq(sc).fadeIn(settings.speed);
					}
				}
			},
			move: function (ob, v) {
				if (settings.rtl === true) {
					v = -v;
				}
				if (this.doCss()) {
					if (settings.vertical === true) {
						ob.css({
							'transform': 'translate3d(0px, ' + (-v) + 'px, 0px)',
							'-webkit-transform': 'translate3d(0px, ' + (-v) + 'px, 0px)'
						});
					} else {
						ob.css({
							'transform': 'translate3d(' + (-v) + 'px, 0px, 0px)',
							'-webkit-transform': 'translate3d(' + (-v) + 'px, 0px, 0px)',
						});
					}
				} else {
					if (settings.vertical === true) {
						ob.css('position', 'relative').animate({
							top: -v + 'px'
						}, settings.speed, settings.easing);
					} else {
						ob.css('position', 'relative').animate({
							left: -v + 'px'
						}, settings.speed, settings.easing);
					}
				}
				var $thumb = $slide.parent().find('.lSPager').find('li');
				this.active($thumb, true);
			},
			fade: function () {
				this.active($children, false);
				var $thumb = $slide.parent().find('.lSPager').find('li');
				this.active($thumb, true);
			},
			slide: function () {
				var $this = this;
				refresh.calSlide = function () {
					if (w > elSize) {
						slideValue = $this.slideValue();
						$this.active($children, false);
						if ((slideValue) > w - elSize - settings.slideMargin) {
							slideValue = w - elSize - settings.slideMargin;
						} else if (slideValue < 0) {
							slideValue = 0;
						}
						$this.move($el, slideValue);
						if (settings.loop === true && settings.mode === 'slide') {
							if (scene >= (length - ($el.find('.clone.left').length / settings.slideMove))) {
								$this.resetSlide($el.find('.clone.left').length);
							}
							if (scene === 0) {
								$this.resetSlide($slide.find('.lslide').length);
							}
						}
					}
				};
				refresh.calSlide();
			},
			resetSlide: function (s) {
				var $this = this;
				$slide.find('.lSAction a').addClass('disabled');
				setTimeout(function () {
					scene = s;
					$slide.css('transition-duration', '0ms');
					slideValue = $this.slideValue();
					$this.active($children, false);
					plugin.move($el, slideValue);
					setTimeout(function () {
						$slide.css('transition-duration', settings.speed + 'ms');
						$slide.find('.lSAction a').removeClass('disabled');
					}, 50);
				}, settings.speed + 100);
			},
			slideValue: function () {
				var _sV = 0;
				if (settings.autoWidth === false) {
					_sV = scene * ((slideWidth + settings.slideMargin) * settings.slideMove);
				} else {
					_sV = 0;
					for (var i = 0; i < scene; i++) {
						_sV += (parseInt($children.eq(i).width()) + settings.slideMargin);
					}
				}
				return _sV;
			},
			slideThumb: function () {
				var position;
				switch (settings.currentPagerPosition) {
				case 'left':
					position = 0;
					break;
				case 'middle':
					position = (elSize / 2) - (thumbWidth / 2);
					break;
				case 'right':
					position = elSize - thumbWidth;
				}
				var sc = scene - $el.find('.clone.left').length;
				var $pager = $slide.parent().find('.lSPager');
				if (settings.mode === 'slide' && settings.loop === true) {
					if (sc >= $pager.children().length) {
						sc = 0;
					} else if (sc < 0) {
						sc = $pager.children().length;
					}
				}
				var thumbSlide = sc * ((thumbWidth + settings.thumbMargin)) - (position);
				if ((thumbSlide + elSize) > pagerWidth) {
					thumbSlide = pagerWidth - elSize - settings.thumbMargin;
				}
				if (thumbSlide < 0) {
					thumbSlide = 0;
				}
				this.move($pager, thumbSlide);
			},
			auto: function () {
				if (settings.auto) {
					clearInterval(interval);
					interval = setInterval(function () {
						$el.goToNextSlide();
					}, settings.pause);
				}
			},
			pauseOnHover: function(){
				var $this = this;
				if (settings.auto && settings.pauseOnHover) {
					$slide.on('mouseenter', function(){
						$(this).addClass('ls-hover');
						$el.pause();
						settings.auto = true;
					});
					$slide.on('mouseleave',function(){
						$(this).removeClass('ls-hover');
						if (!$slide.find('.lightSlider').hasClass('lsGrabbing')) {
							$this.auto();
						}
					});
				}
			},
			touchMove: function (endCoords, startCoords) {
				$slide.css('transition-duration', '0ms');
				if (settings.mode === 'slide') {
					var distance = endCoords - startCoords;
					var swipeVal = slideValue - distance;
					if ((swipeVal) >= w - elSize - settings.slideMargin) {
						if (settings.freeMove === false) {
							swipeVal = w - elSize - settings.slideMargin;
						} else {
							var swipeValT = w - elSize - settings.slideMargin;
							swipeVal = swipeValT + ((swipeVal - swipeValT) / 5);

						}
					} else if (swipeVal < 0) {
						if (settings.freeMove === false) {
							swipeVal = 0;
						} else {
							swipeVal = swipeVal / 5;
						}
					}
					this.move($el, swipeVal);
				}
			},

			touchEnd: function (distance) {
				$slide.css('transition-duration', settings.speed + 'ms');
				if (settings.mode === 'slide') {
					var mxVal = false;
					var _next = true;
					slideValue = slideValue - distance;
					if ((slideValue) > w - elSize - settings.slideMargin) {
						slideValue = w - elSize - settings.slideMargin;
						if (settings.autoWidth === false) {
							mxVal = true;
						}
					} else if (slideValue < 0) {
						slideValue = 0;
					}
					var gC = function (next) {
						var ad = 0;
						if (!mxVal) {
							if (next) {
								ad = 1;
							}
						}
						if (!settings.autoWidth) {
							var num = slideValue / ((slideWidth + settings.slideMargin) * settings.slideMove);
							scene = parseInt(num) + ad;
							if (slideValue >= (w - elSize - settings.slideMargin)) {
								if (num % 1 !== 0) {
									scene++;
								}
							}
						} else {
							var tW = 0;
							for (var i = 0; i < $children.length; i++) {
								tW += (parseInt($children.eq(i).width()) + settings.slideMargin);
								scene = i + ad;
								if (tW >= slideValue) {
									break;
								}
							}
						}
					};
					if (distance >= settings.swipeThreshold) {
						gC(false);
						_next = false;
					} else if (distance <= -settings.swipeThreshold) {
						gC(true);
						_next = false;
					}
					$el.mode(_next);
					this.slideThumb();
				} else {
					if (distance >= settings.swipeThreshold) {
						$el.goToPrevSlide();
					} else if (distance <= -settings.swipeThreshold) {
						$el.goToNextSlide();
					}
				}
			},



			enableDrag: function () {
				var $this = this;
				if (!isTouch) {
					var startCoords = 0,
						endCoords = 0,
						isDraging = false;
					$slide.find('.lightSlider').addClass('lsGrab');
					$slide.on('mousedown', function (e) {
						if (w < elSize) {
							if (w !== 0) {
								return false;
							}
						}
						if ($(e.target).attr('class') !== ('lSPrev') && $(e.target).attr('class') !== ('lSNext')) {
							startCoords = (settings.vertical === true) ? e.pageY : e.pageX;
							isDraging = true;
							if (e.preventDefault) {
								e.preventDefault();
							} else {
								e.returnValue = false;
							}
							// ** Fix for webkit cursor issue https://code.google.com/p/chromium/issues/detail?id=26723
							$slide.scrollLeft += 1;
							$slide.scrollLeft -= 1;
							// *
							$slide.find('.lightSlider').removeClass('lsGrab').addClass('lsGrabbing');
							clearInterval(interval);
						}
					});
					$(window).on('mousemove', function (e) {
						if (isDraging) {
							endCoords = (settings.vertical === true) ? e.pageY : e.pageX;
							$this.touchMove(endCoords, startCoords);
						}
					});
					$(window).on('mouseup', function (e) {
						if (isDraging) {
							$slide.find('.lightSlider').removeClass('lsGrabbing').addClass('lsGrab');
							isDraging = false;
							endCoords = (settings.vertical === true) ? e.pageY : e.pageX;
							var distance = endCoords - startCoords;
							if (Math.abs(distance) >= settings.swipeThreshold) {
								$(window).on('click.ls', function (e) {
									if (e.preventDefault) {
										e.preventDefault();
									} else {
										e.returnValue = false;
									}
									e.stopImmediatePropagation();
									e.stopPropagation();
									$(window).off('click.ls');
								});
							}

							$this.touchEnd(distance);

						}
					});
				}
			},




			enableTouch: function () {
				var $this = this;
				if (isTouch) {
					var startCoords = {},
						endCoords = {};
					$slide.on('touchstart', function (e) {
						endCoords = e.originalEvent.targetTouches[0];
						startCoords.pageX = e.originalEvent.targetTouches[0].pageX;
						startCoords.pageY = e.originalEvent.targetTouches[0].pageY;
						clearInterval(interval);
					});
					$slide.on('touchmove', function (e) {
						if (w < elSize) {
							if (w !== 0) {
								return false;
							}
						}
						var orig = e.originalEvent;
						endCoords = orig.targetTouches[0];
						var xMovement = Math.abs(endCoords.pageX - startCoords.pageX);
						var yMovement = Math.abs(endCoords.pageY - startCoords.pageY);
						if (settings.vertical === true) {
							if ((yMovement * 3) > xMovement) {
								e.preventDefault();
							}
							$this.touchMove(endCoords.pageY, startCoords.pageY);
						} else {
							if ((xMovement * 3) > yMovement) {
								e.preventDefault();
							}
							$this.touchMove(endCoords.pageX, startCoords.pageX);
						}

					});
					$slide.on('touchend', function () {
						if (w < elSize) {
							if (w !== 0) {
								return false;
							}
						}
						var distance;
						if (settings.vertical === true) {
							distance = endCoords.pageY - startCoords.pageY;
						} else {
							distance = endCoords.pageX - startCoords.pageX;
						}
						$this.touchEnd(distance);
					});
				}
			},
			build: function () {
				var $this = this;
				$this.initialStyle();
				if (this.doCss()) {

					if (settings.enableTouch === true) {
						$this.enableTouch();
					}
					if (settings.enableDrag === true) {
						$this.enableDrag();
					}
				}

				$(window).on('focus', function(){
					$this.auto();
				});
				
				$(window).on('blur', function(){
					clearInterval(interval);
				});

				$this.pager();
				$this.pauseOnHover();
				$this.controls();
				$this.keyPress();
			}
		};
		plugin.build();
		refresh.init = function () {
			refresh.chbreakpoint();
			if (settings.vertical === true) {
				if (settings.item > 1) {
					elSize = settings.verticalHeight;
				} else {
					elSize = $children.outerHeight();
				}
				$slide.css('height', elSize + 'px');
			} else {
				elSize = $slide.outerWidth();
			}
			if (settings.loop === true && settings.mode === 'slide') {
				refresh.clone();
			}
			refresh.calL();
			if (settings.mode === 'slide') {
				$el.removeClass('lSSlide');
			}
			if (settings.mode === 'slide') {
				refresh.calSW();
				refresh.sSW();
			}
			setTimeout(function () {
				if (settings.mode === 'slide') {
					$el.addClass('lSSlide');
				}
			}, 1000);
			if (settings.pager) {
				refresh.createPager();
			}
			if (settings.adaptiveHeight === true && settings.vertical === false) {
				$el.css('height', $children.eq(scene).outerHeight(true));
			}
			if (settings.adaptiveHeight === false) {
				if (settings.mode === 'slide') {
					if (settings.vertical === false) {
						plugin.setHeight($el, false);
					}else{
						plugin.auto();
					}
				} else {
					plugin.setHeight($el, true);
				}
			}
			if (settings.gallery === true) {
				plugin.slideThumb();
			}
			if (settings.mode === 'slide') {
				plugin.slide();
			}
			if (settings.autoWidth === false) {
				if ($children.length <= settings.item) {
					$slide.find('.lSAction').hide();
				} else {
					$slide.find('.lSAction').show();
				}
			} else {
				if ((refresh.calWidth(false) < elSize) && (w !== 0)) {
					$slide.find('.lSAction').hide();
				} else {
					$slide.find('.lSAction').show();
				}
			}
		};
		$el.goToPrevSlide = function () {
			if (scene > 0) {
				settings.onBeforePrevSlide.call(this, $el, scene);
				scene--;
				$el.mode(false);
				if (settings.gallery === true) {
					plugin.slideThumb();
				}
			} else {
				if (settings.loop === true) {
					settings.onBeforePrevSlide.call(this, $el, scene);
					if (settings.mode === 'fade') {
						var l = (length - 1);
						scene = parseInt(l / settings.slideMove);
					}
					$el.mode(false);
					if (settings.gallery === true) {
						plugin.slideThumb();
					}
				} else if (settings.slideEndAnimation === true) {
					$el.addClass('leftEnd');
					setTimeout(function () {
						$el.removeClass('leftEnd');
					}, 400);
				}
			}
		};
		$el.goToNextSlide = function () {
			var nextI = true;
			if (settings.mode === 'slide') {
				var _slideValue = plugin.slideValue();
				nextI = _slideValue < w - elSize - settings.slideMargin;
			}
			if (((scene * settings.slideMove) < length - settings.slideMove) && nextI) {
				settings.onBeforeNextSlide.call(this, $el, scene);
				scene++;
				$el.mode(false);
				if (settings.gallery === true) {
					plugin.slideThumb();
				}
			} else {
				if (settings.loop === true) {
					settings.onBeforeNextSlide.call(this, $el, scene);
					scene = 0;
					$el.mode(false);
					if (settings.gallery === true) {
						plugin.slideThumb();
					}
				} else if (settings.slideEndAnimation === true) {
					$el.addClass('rightEnd');
					setTimeout(function () {
						$el.removeClass('rightEnd');
					}, 400);
				}
			}
		};
		$el.mode = function (_touch) {
			if (settings.adaptiveHeight === true && settings.vertical === false) {
				$el.css('height', $children.eq(scene).outerHeight(true));
			}
			if (on === false) {
				if (settings.mode === 'slide') {
					if (plugin.doCss()) {
						$el.addClass('lSSlide');
						if (settings.speed !== '') {
							$slide.css('transition-duration', settings.speed + 'ms');
						}
						if (settings.cssEasing !== '') {
							$slide.css('transition-timing-function', settings.cssEasing);
						}
					}
				} else {
					if (plugin.doCss()) {
						if (settings.speed !== '') {
							$el.css('transition-duration', settings.speed + 'ms');
						}
						if (settings.cssEasing !== '') {
							$el.css('transition-timing-function', settings.cssEasing);
						}
					}
				}
			}
			if (!_touch) {
				settings.onBeforeSlide.call(this, $el, scene);
			}
			if (settings.mode === 'slide') {
				plugin.slide();
			} else {
				plugin.fade();
			}
			if (!$slide.hasClass('ls-hover')) {
				plugin.auto();
			}
			setTimeout(function () {
				if (!_touch) {
					settings.onAfterSlide.call(this, $el, scene);
				}
			}, settings.speed);
			on = true;
		};
		$el.play = function () {
			$el.goToNextSlide();
			settings.auto = true;
			plugin.auto();
		};
		$el.pause = function () {
			settings.auto = false;
			clearInterval(interval);
		};
		$el.refresh = function () {
			refresh.init();
		};
		$el.getCurrentSlideCount = function () {
			var sc = scene;
			if (settings.loop) {
				var ln = $slide.find('.lslide').length,
					cl = $el.find('.clone.left').length;
				if (scene <= cl - 1) {
					sc = ln + (scene - cl);
				} else if (scene >= (ln + cl)) {
					sc = scene - ln - cl;
				} else {
					sc = scene - cl;
				}
			}
			return sc + 1;
		}; 
		$el.getTotalSlideCount = function () {
			return $slide.find('.lslide').length;
		};
		$el.goToSlide = function (s) {
			if (settings.loop) {
				scene = (s + $el.find('.clone.left').length - 1);
			} else {
				scene = s;
			}
			$el.mode(false);
			if (settings.gallery === true) {
				plugin.slideThumb();
			}
		};
		$el.destroy = function () {
			if ($el.lightSlider) {
				$el.goToPrevSlide = function(){};
				$el.goToNextSlide = function(){};
				$el.mode = function(){};
				$el.play = function(){};
				$el.pause = function(){};
				$el.refresh = function(){};
				$el.getCurrentSlideCount = function(){};
				$el.getTotalSlideCount = function(){};
				$el.goToSlide = function(){}; 
				$el.lightSlider = null;
				refresh = {
					init : function(){}
				};
				$el.parent().parent().find('.lSAction, .lSPager').remove();
				$el.removeClass('lightSlider lSFade lSSlide lsGrab lsGrabbing leftEnd right').removeAttr('style').unwrap().unwrap();
				$el.children().removeAttr('style');
				$children.removeClass('lslide active');
				$el.find('.clone').remove();
				$children = null;
				interval = null;
				on = false;
				scene = 0;
			}

		};
		setTimeout(function () {
			settings.onSliderLoad.call(this, $el);
		}, 10);
		$(window).on('resize orientationchange', function (e) {
			setTimeout(function () {
				if (e.preventDefault) {
					e.preventDefault();
				} else {
					e.returnValue = false;
				}
				refresh.init();
			}, 200);
		});
		return this;
	};
}(jQuery));

(function( $ ) {
	'use strict';

	/**
	 * Slider
	 */

	var is_rtl = false;
	if ($('body').hasClass('rtl'))
		is_rtl = true;

	if ($("#image-gallery").length > 0) {
		load_wre_gallery_data();
	}
	
	$('.agents-carousel').each(function (e) {

		var data = $.parseJSON($(this).attr('data-value'));
		if (data.view == 'carousel') {

			var autoplay, pager, loop = true;
			var show_controllers = true;
			if (data.autoplay == 'false')
				autoplay = false;

			if (data.dots == 'false')
				pager = false;

			if (data.loop == 'false')
				loop = false;

			if (data.controls == 'false')
				show_controllers = false;

			var mode = data.effect;
			var items = parseInt(data.items);
			$(this).removeAttr('data-value');

			$(this).lightSlider({
				item: items,
				autoWidth: false,
				slideMove: 1, // slidemove will be 1 if loop is true
				slideMargin: 10,
				addClass: '',
				mode: mode,
				useCSS: true,
				cssEasing: 'ease', //'cubic-bezier(0.25, 0, 0.25, 1)',//
				easing: 'linear', //'for jquery animation',////
				controls: show_controllers,
				speed: 400, //ms'
				auto: autoplay,
				loop: loop,
				slideEndAnimation: true,
				pause: 2000,
				keyPress: false,
				prevHtml: '<i class="prev wre-icon-arrow-2"></i>',
				nextHtml: '<i class="next wre-icon-arrow-2"></i>',
				rtl: is_rtl,
				thumbItem: 10,
				pager: pager,
				thumbMargin: 5,
				currentPagerPosition: 'middle',
				enableTouch: true,
				enableDrag: true,
				freeMove: true,
				swipeThreshold: 40,
				responsive: [
					{
						breakpoint: 767,
						settings: {
							item: 1,
							adaptiveHeight: true
						}
					}
				],
			});

		}

	});


	function load_wre_gallery_data() {
		
		var defaults = {

			mode: 'lg-slide',

			// Ex : 'ease'
			cssEasing: 'ease',

			//'for jquery animation'
			easing: 'linear',
			speed: 600,
			height: '100%',
			width: '100%',
			addClass: '',
			startClass: 'lg-start-zoom',
			backdropDuration: 150,
			hideBarsDelay: 6000,

			useLeft: false,

			closable: true,
			loop: true,
			escKey: true,
			keyPress: true,
			controls: true,
			slideEndAnimatoin: true,
			hideControlOnEnd: false,
			mousewheel: true,

			getCaptionFromTitleOrAlt: true,

			// .lg-item || '.lg-sub-html'
			appendSubHtmlTo: '.lg-sub-html',

			subHtmlSelectorRelative: false,

			/**
			 * @desc number of preload slides
			 * will exicute only after the current slide is fully loaded.
			 *
			 * @ex you clicked on 4th image and if preload = 1 then 3rd slide and 5th
			 * slide will be loaded in the background after the 4th slide is fully loaded..
			 * if preload is 2 then 2nd 3rd 5th 6th slides will be preloaded.. ... ...
			 *
			 */
			preload: 1,
			showAfterLoad: true,
			selector: '',
			selectWithin: '',
			nextHtml: '',
			prevHtml: '',

			// 0, 1
			index: false,

			iframeMaxWidth: '100%',

			download: true,
			counter: true,
			appendCounterTo: '.lg-toolbar',

			swipeThreshold: 50,
			enableSwipe: true,
			enableDrag: true,

			dynamic: false,
			dynamicEl: [],
			galleryId: 1
		};

		function Plugin(element, options) {

			// Current lightGallery element
			this.el = element;

			// Current jquery element
			this.$el = $(element);

			// lightGallery settings
			this.s = $.extend({}, defaults, options);

			// When using dynamic mode, ensure dynamicEl is an array
			if (this.s.dynamic && this.s.dynamicEl !== 'undefined' && this.s.dynamicEl.constructor === Array && !this.s.dynamicEl.length) {
				throw ('When using dynamic mode, you must also define dynamicEl as an Array.');
			}

			// lightGallery modules
			this.modules = {};

			// false when lightgallery complete first slide;
			this.lGalleryOn = false;

			this.lgBusy = false;

			// Timeout function for hiding controls;
			this.hideBartimeout = false;

			// To determine browser supports for touch events;
			this.isTouch = ('ontouchstart' in document.documentElement);

			// Disable hideControlOnEnd if sildeEndAnimation is true
			if (this.s.slideEndAnimatoin) {
				this.s.hideControlOnEnd = false;
			}

			// Gallery items
			if (this.s.dynamic) {
				this.$items = this.s.dynamicEl;
			} else {
				if (this.s.selector === 'this') {
					this.$items = this.$el;
				} else if (this.s.selector !== '') {
					if (this.s.selectWithin) {
						this.$items = $(this.s.selectWithin).find(this.s.selector);
					} else {
						this.$items = this.$el.find($(this.s.selector));
					}
				} else {
					this.$items = this.$el.children();
				}
			}

			// .lg-item
			this.$slide = '';

			// .lg-outer
			this.$outer = '';

			this.init();

			return this;
		}

		Plugin.prototype.init = function() {

			var _this = this;

			// s.preload should not be more than $item.length
			if (_this.s.preload > _this.$items.length) {
				_this.s.preload = _this.$items.length;
			}

			// if dynamic option is enabled execute immediately
			var _hash = window.location.hash;
			if (_hash.indexOf('lg=' + this.s.galleryId) > 0) {

				_this.index = parseInt(_hash.split('&slide=')[1], 10);

				$('body').addClass('lg-from-hash');
				if (!$('body').hasClass('lg-on')) {
					setTimeout(function() {
						_this.build(_this.index);
					});

					$('body').addClass('lg-on');
				}
			}

			if (_this.s.dynamic) {

				_this.$el.trigger('onBeforeOpen.lg');

				_this.index = _this.s.index || 0;

				// prevent accidental double execution
				if (!$('body').hasClass('lg-on')) {
					setTimeout(function() {
						_this.build(_this.index);
						$('body').addClass('lg-on');
					});
				}
			} else {

				// Using different namespace for click because click event should not unbind if selector is same object('this')
				_this.$items.on('click.lgcustom', function(event) {

					// For IE8
					try {
						event.preventDefault();
						event.preventDefault();
					} catch (er) {
						event.returnValue = false;
					}

					_this.$el.trigger('onBeforeOpen.lg');

					_this.index = _this.s.index || _this.$items.index(this);

					// prevent accidental double execution
					if (!$('body').hasClass('lg-on')) {
						_this.build(_this.index);
						$('body').addClass('lg-on');
					}
				});
			}

		};

		Plugin.prototype.build = function(index) {

			var _this = this;

			_this.structure();

			// module constructor
			$.each($.fn.lightGallery.modules, function(key) {
				_this.modules[key] = new $.fn.lightGallery.modules[key](_this.el);
			});

			// initiate slide function
			_this.slide(index, false, false, false);

			if (_this.s.keyPress) {
				_this.keyPress();
			}

			if (_this.$items.length > 1) {

				_this.arrow();

				setTimeout(function() {
					_this.enableDrag();
					_this.enableSwipe();
				}, 50);

				if (_this.s.mousewheel) {
					_this.mousewheel();
				}
			}

			_this.counter();

			_this.closeGallery();

			_this.$el.trigger('onAfterOpen.lg');

			// Hide controllers if mouse doesn't move for some period
			_this.$outer.on('mousemove.lg click.lg touchstart.lg', function() {

				_this.$outer.removeClass('lg-hide-items');

				clearTimeout(_this.hideBartimeout);

				// Timeout will be cleared on each slide movement also
				_this.hideBartimeout = setTimeout(function() {
					_this.$outer.addClass('lg-hide-items');
				}, _this.s.hideBarsDelay);

			});

			_this.$outer.trigger('mousemove.lg');

		};

		Plugin.prototype.structure = function() {
			var list = '';
			var controls = '';
			var i = 0;
			var subHtmlCont = '';
			var template;
			var _this = this;

			$('body').append('<div class="lg-backdrop"></div>');
			$('.lg-backdrop').css('transition-duration', this.s.backdropDuration + 'ms');

			// Create gallery items
			for (i = 0; i < this.$items.length; i++) {
				list += '<div class="lg-item"></div>';
			}

			// Create controlls
			if (this.s.controls && this.$items.length > 1) {
				controls = '<div class="lg-actions">' +
					'<div class="lg-prev lg-icon">' + this.s.prevHtml + '</div>' +
					'<div class="lg-next lg-icon">' + this.s.nextHtml + '</div>' +
					'</div>';
			}

			if (this.s.appendSubHtmlTo === '.lg-sub-html') {
				subHtmlCont = '<div class="lg-sub-html"></div>';
			}

			template = '<div class="lg-outer ' + this.s.addClass + ' ' + this.s.startClass + '">' +
				'<div class="lg" style="width:' + this.s.width + '; height:' + this.s.height + '">' +
				'<div class="lg-inner">' + list + '</div>' +
				'<div class="lg-toolbar lg-group">' +
				'<span class="lg-close lg-icon"></span>' +
				'</div>' +
				controls +
				subHtmlCont +
				'</div>' +
				'</div>';

			$('body').append(template);
			this.$outer = $('.lg-outer');
			this.$slide = this.$outer.find('.lg-item');

			if (this.s.useLeft) {
				this.$outer.addClass('lg-use-left');

				// Set mode lg-slide if use left is true;
				this.s.mode = 'lg-slide';
			} else {
				this.$outer.addClass('lg-use-css3');
			}

			// For fixed height gallery
			_this.setTop();
			$(window).on('resize.lg orientationchange.lg', function() {
				setTimeout(function() {
					_this.setTop();
				}, 100);
			});

			// add class lg-current to remove initial transition
			this.$slide.eq(this.index).addClass('lg-current');

			// add Class for css support and transition mode
			if (this.doCss()) {
				this.$outer.addClass('lg-css3');
			} else {
				this.$outer.addClass('lg-css');

				// Set speed 0 because no animation will happen if browser doesn't support css3
				this.s.speed = 0;
			}

			this.$outer.addClass(this.s.mode);

			if (this.s.enableDrag && this.$items.length > 1) {
				this.$outer.addClass('lg-grab');
			}

			if (this.s.showAfterLoad) {
				this.$outer.addClass('lg-show-after-load');
			}

			if (this.doCss()) {
				var $inner = this.$outer.find('.lg-inner');
				$inner.css('transition-timing-function', this.s.cssEasing);
				$inner.css('transition-duration', this.s.speed + 'ms');
			}

			setTimeout(function() {
				$('.lg-backdrop').addClass('in');
			});

			setTimeout(function() {
				_this.$outer.addClass('lg-visible');
			}, this.s.backdropDuration);

			if (this.s.download) {
				this.$outer.find('.lg-toolbar').append('<a id="lg-download" target="_blank" download class="lg-download lg-icon"></a>');
			}

			// Store the current scroll top value to scroll back after closing the gallery..
			this.prevScrollTop = $(window).scrollTop();

		};

		// For fixed height gallery
		Plugin.prototype.setTop = function() {
			if (this.s.height !== '100%') {
				var wH = $(window).height();
				var top = (wH - parseInt(this.s.height, 10)) / 2;
				var $lGallery = this.$outer.find('.lg');
				if (wH >= parseInt(this.s.height, 10)) {
					$lGallery.css('top', top + 'px');
				} else {
					$lGallery.css('top', '0px');
				}
			}
		};

		// Find css3 support
		Plugin.prototype.doCss = function() {
			// check for css animation support
			var support = function() {
				var transition = ['transition', 'MozTransition', 'WebkitTransition', 'OTransition', 'msTransition', 'KhtmlTransition'];
				var root = document.documentElement;
				var i = 0;
				for (i = 0; i < transition.length; i++) {
					if (transition[i] in root.style) {
						return true;
					}
				}
			};

			if (support()) {
				return true;
			}

			return false;
		};

		/**
		 *  @desc Check the given src is video
		 *  @param {String} src
		 *  @return {Object} video type
		 *  Ex:{ youtube  :  ["//www.youtube.com/watch?v=c0asJgSyxcY", "c0asJgSyxcY"] }
		 */
		Plugin.prototype.isVideo = function(src, index) {

			var html;
			if (this.s.dynamic) {
				html = this.s.dynamicEl[index].html;
			} else {
				html = this.$items.eq(index).attr('data-html');
			}

			if (!src && html) {
				return {
					html5: true
				};
			}

			var youtube = src.match(/\/\/(?:www\.)?youtu(?:\.be|be\.com)\/(?:watch\?v=|embed\/)?([a-z0-9\-\_\%]+)/i);
			var vimeo = src.match(/\/\/(?:www\.)?vimeo.com\/([0-9a-z\-_]+)/i);
			var dailymotion = src.match(/\/\/(?:www\.)?dai.ly\/([0-9a-z\-_]+)/i);
			var vk = src.match(/\/\/(?:www\.)?(?:vk\.com|vkontakte\.ru)\/(?:video_ext\.php\?)(.*)/i);

			if (youtube) {
				return {
					youtube: youtube
				};
			} else if (vimeo) {
				return {
					vimeo: vimeo
				};
			} else if (dailymotion) {
				return {
					dailymotion: dailymotion
				};
			} else if (vk) {
				return {
					vk: vk
				};
			}
		};

		/**
		 *  @desc Create image counter
		 *  Ex: 1/10
		 */
		Plugin.prototype.counter = function() {
			if (this.s.counter) {
				$(this.s.appendCounterTo).append('<div id="lg-counter"><span id="lg-counter-current">' + (parseInt(this.index, 10) + 1) + '</span> / <span id="lg-counter-all">' + this.$items.length + '</span></div>');
			}
		};

		/**
		 *  @desc add sub-html into the slide
		 *  @param {Number} index - index of the slide
		 */
		Plugin.prototype.addHtml = function(index) {
			var subHtml = null;
			var subHtmlUrl;
			var $currentEle;
			if (this.s.dynamic) {
				if (this.s.dynamicEl[index].subHtmlUrl) {
					subHtmlUrl = this.s.dynamicEl[index].subHtmlUrl;
				} else {
					subHtml = this.s.dynamicEl[index].subHtml;
				}
			} else {
				$currentEle = this.$items.eq(index);
				if ($currentEle.attr('data-sub-html-url')) {
					subHtmlUrl = $currentEle.attr('data-sub-html-url');
				} else {
					subHtml = $currentEle.attr('data-sub-html');
					if (this.s.getCaptionFromTitleOrAlt && !subHtml) {
						subHtml = $currentEle.attr('title') || $currentEle.find('img').first().attr('alt');
					}
				}
			}

			if (!subHtmlUrl) {
				if (typeof subHtml !== 'undefined' && subHtml !== null) {

					// get first letter of subhtml
					// if first letter starts with . or # get the html form the jQuery object
					var fL = subHtml.substring(0, 1);
					if (fL === '.' || fL === '#') {
						if (this.s.subHtmlSelectorRelative && !this.s.dynamic) {
							subHtml = $currentEle.find(subHtml).html();
						} else {
							subHtml = $(subHtml).html();
						}
					}
				} else {
					subHtml = '';
				}
			}

			if (this.s.appendSubHtmlTo === '.lg-sub-html') {

				if (subHtmlUrl) {
					this.$outer.find(this.s.appendSubHtmlTo).load(subHtmlUrl);
				} else {
					this.$outer.find(this.s.appendSubHtmlTo).html(subHtml);
				}

			} else {

				if (subHtmlUrl) {
					this.$slide.eq(index).load(subHtmlUrl);
				} else {
					this.$slide.eq(index).append(subHtml);
				}
			}

			// Add lg-empty-html class if title doesn't exist
			if (typeof subHtml !== 'undefined' && subHtml !== null) {
				if (subHtml === '') {
					this.$outer.find(this.s.appendSubHtmlTo).addClass('lg-empty-html');
				} else {
					this.$outer.find(this.s.appendSubHtmlTo).removeClass('lg-empty-html');
				}
			}

			this.$el.trigger('onAfterAppendSubHtml.lg', [index]);
		};

		/**
		 *  @desc Preload slides
		 *  @param {Number} index - index of the slide
		 */
		Plugin.prototype.preload = function(index) {
			var i = 1;
			var j = 1;
			for (i = 1; i <= this.s.preload; i++) {
				if (i >= this.$items.length - index) {
					break;
				}

				this.loadContent(index + i, false, 0);
			}

			for (j = 1; j <= this.s.preload; j++) {
				if (index - j < 0) {
					break;
				}

				this.loadContent(index - j, false, 0);
			}
		};

		/**
		 *  @desc Load slide content into slide.
		 *  @param {Number} index - index of the slide.
		 *  @param {Boolean} rec - if true call loadcontent() function again.
		 *  @param {Boolean} delay - delay for adding complete class. it is 0 except first time.
		 */
		Plugin.prototype.loadContent = function(index, rec, delay) {

			var _this = this;
			var _hasPoster = false;
			var _$img;
			var _src;
			var _poster;
			var _srcset;
			var _sizes;
			var _html;
			var getResponsiveSrc = function(srcItms) {
				var rsWidth = [];
				var rsSrc = [];
				for (var i = 0; i < srcItms.length; i++) {
					var __src = srcItms[i].split(' ');

					// Manage empty space
					if (__src[0] === '') {
						__src.splice(0, 1);
					}

					rsSrc.push(__src[0]);
					rsWidth.push(__src[1]);
				}

				var wWidth = $(window).width();
				for (var j = 0; j < rsWidth.length; j++) {
					if (parseInt(rsWidth[j], 10) > wWidth) {
						_src = rsSrc[j];
						break;
					}
				}
			};

			if (_this.s.dynamic) {

				if (_this.s.dynamicEl[index].poster) {
					_hasPoster = true;
					_poster = _this.s.dynamicEl[index].poster;
				}

				_html = _this.s.dynamicEl[index].html;
				_src = _this.s.dynamicEl[index].src;

				if (_this.s.dynamicEl[index].responsive) {
					var srcDyItms = _this.s.dynamicEl[index].responsive.split(',');
					getResponsiveSrc(srcDyItms);
				}

				_srcset = _this.s.dynamicEl[index].srcset;
				_sizes = _this.s.dynamicEl[index].sizes;

			} else {

				if (_this.$items.eq(index).attr('data-poster')) {
					_hasPoster = true;
					_poster = _this.$items.eq(index).attr('data-poster');
				}

				_html = _this.$items.eq(index).attr('data-html');
				_src = _this.$items.eq(index).attr('href') || _this.$items.eq(index).attr('data-src');

				if (_this.$items.eq(index).attr('data-responsive')) {
					var srcItms = _this.$items.eq(index).attr('data-responsive').split(',');
					getResponsiveSrc(srcItms);
				}

				_srcset = _this.$items.eq(index).attr('data-srcset');
				_sizes = _this.$items.eq(index).attr('data-sizes');

			}

			//if (_src || _srcset || _sizes || _poster) {

			var iframe = false;
			if (_this.s.dynamic) {
				if (_this.s.dynamicEl[index].iframe) {
					iframe = true;
				}
			} else {
				if (_this.$items.eq(index).attr('data-iframe') === 'true') {
					iframe = true;
				}
			}

			var _isVideo = _this.isVideo(_src, index);
			if (!_this.$slide.eq(index).hasClass('lg-loaded')) {
				if (iframe) {
					_this.$slide.eq(index).prepend('<div class="lg-video-cont" style="max-width:' + _this.s.iframeMaxWidth + '"><div class="lg-video"><iframe class="lg-object" frameborder="0" src="' + _src + '"  allowfullscreen="true"></iframe></div></div>');
				} else if (_hasPoster) {
					var videoClass = '';
					if (_isVideo && _isVideo.youtube) {
						videoClass = 'lg-has-youtube';
					} else if (_isVideo && _isVideo.vimeo) {
						videoClass = 'lg-has-vimeo';
					} else {
						videoClass = 'lg-has-html5';
					}

					_this.$slide.eq(index).prepend('<div class="lg-video-cont ' + videoClass + ' "><div class="lg-video"><span class="lg-video-play"></span><img class="lg-object lg-has-poster" src="' + _poster + '" /></div></div>');

				} else if (_isVideo) {
					_this.$slide.eq(index).prepend('<div class="lg-video-cont "><div class="lg-video"></div></div>');
					_this.$el.trigger('hasVideo.lg', [index, _src, _html]);
				} else {
					_this.$slide.eq(index).prepend('<div class="lg-img-wrap"><img class="lg-object lg-image" src="' + _src + '" /></div>');
				}

				_this.$el.trigger('onAferAppendSlide.lg', [index]);

				_$img = _this.$slide.eq(index).find('.lg-object');
				if (_sizes) {
					_$img.attr('sizes', _sizes);
				}

				if (_srcset) {
					_$img.attr('srcset', _srcset);
					try {
						picturefill({
							elements: [_$img[0]]
						});
					} catch (e) {
						console.warn('lightGallery :- If you want srcset to be supported for older browser please include picturefil version 2 javascript library in your document.');
					}
				}

				if (this.s.appendSubHtmlTo !== '.lg-sub-html') {
					_this.addHtml(index);
				}

				_this.$slide.eq(index).addClass('lg-loaded');
			}

			_this.$slide.eq(index).find('.lg-object').on('load.lg error.lg', function() {

				// For first time add some delay for displaying the start animation.
				var _speed = 0;

				// Do not change the delay value because it is required for zoom plugin.
				// If gallery opened from direct url (hash) speed value should be 0
				if (delay && !$('body').hasClass('lg-from-hash')) {
					_speed = delay;
				}

				setTimeout(function() {
					_this.$slide.eq(index).addClass('lg-complete');
					_this.$el.trigger('onSlideItemLoad.lg', [index, delay || 0]);
				}, _speed);

			});

			// @todo check load state for html5 videos
			if (_isVideo && _isVideo.html5 && !_hasPoster) {
				_this.$slide.eq(index).addClass('lg-complete');
			}

			if (rec === true) {
				if (!_this.$slide.eq(index).hasClass('lg-complete')) {
					_this.$slide.eq(index).find('.lg-object').on('load.lg error.lg', function() {
						_this.preload(index);
					});
				} else {
					_this.preload(index);
				}
			}

			//}
		};

		/**
		*   @desc slide function for lightgallery
			** Slide() gets call on start
			** ** Set lg.on true once slide() function gets called.
			** Call loadContent() on slide() function inside setTimeout
			** ** On first slide we do not want any animation like slide of fade
			** ** So on first slide( if lg.on if false that is first slide) loadContent() should start loading immediately
			** ** Else loadContent() should wait for the transition to complete.
			** ** So set timeout s.speed + 50
		<=> ** loadContent() will load slide content in to the particular slide
			** ** It has recursion (rec) parameter. if rec === true loadContent() will call preload() function.
			** ** preload will execute only when the previous slide is fully loaded (images iframe)
			** ** avoid simultaneous image load
		<=> ** Preload() will check for s.preload value and call loadContent() again accoring to preload value
			** loadContent()  <====> Preload();

		*   @param {Number} index - index of the slide
		*   @param {Boolean} fromTouch - true if slide function called via touch event or mouse drag
		*   @param {Boolean} fromThumb - true if slide function called via thumbnail click
		*   @param {String} direction - Direction of the slide(next/prev)
		*/
		Plugin.prototype.slide = function(index, fromTouch, fromThumb, direction) {

			var _prevIndex = this.$outer.find('.lg-current').index();
			var _this = this;

			// Prevent if multiple call
			// Required for hsh plugin
			if (_this.lGalleryOn && (_prevIndex === index)) {
				return;
			}

			var _length = this.$slide.length;
			var _time = _this.lGalleryOn ? this.s.speed : 0;

			if (!_this.lgBusy) {

				if (this.s.download) {
					var _src;
					if (_this.s.dynamic) {
						_src = _this.s.dynamicEl[index].downloadUrl !== false && (_this.s.dynamicEl[index].downloadUrl || _this.s.dynamicEl[index].src);
					} else {
						_src = _this.$items.eq(index).attr('data-download-url') !== 'false' && (_this.$items.eq(index).attr('data-download-url') || _this.$items.eq(index).attr('href') || _this.$items.eq(index).attr('data-src'));

					}

					if (_src) {
						$('#lg-download').attr('href', _src);
						_this.$outer.removeClass('lg-hide-download');
					} else {
						_this.$outer.addClass('lg-hide-download');
					}
				}

				this.$el.trigger('onBeforeSlide.lg', [_prevIndex, index, fromTouch, fromThumb]);

				_this.lgBusy = true;

				clearTimeout(_this.hideBartimeout);

				// Add title if this.s.appendSubHtmlTo === lg-sub-html
				if (this.s.appendSubHtmlTo === '.lg-sub-html') {

					// wait for slide animation to complete
					setTimeout(function() {
						_this.addHtml(index);
					}, _time);
				}

				this.arrowDisable(index);

				if (!direction) {
					if (index < _prevIndex) {
						direction = 'prev';
					} else if (index > _prevIndex) {
						direction = 'next';
					}
				}

				if (!fromTouch) {

					// remove all transitions
					_this.$outer.addClass('lg-no-trans');

					this.$slide.removeClass('lg-prev-slide lg-next-slide');

					if (direction === 'prev') {

						//prevslide
						this.$slide.eq(index).addClass('lg-prev-slide');
						this.$slide.eq(_prevIndex).addClass('lg-next-slide');
					} else {

						// next slide
						this.$slide.eq(index).addClass('lg-next-slide');
						this.$slide.eq(_prevIndex).addClass('lg-prev-slide');
					}

					// give 50 ms for browser to add/remove class
					setTimeout(function() {
						_this.$slide.removeClass('lg-current');

						//_this.$slide.eq(_prevIndex).removeClass('lg-current');
						_this.$slide.eq(index).addClass('lg-current');

						// reset all transitions
						_this.$outer.removeClass('lg-no-trans');
					}, 50);
				} else {

					this.$slide.removeClass('lg-prev-slide lg-current lg-next-slide');
					var touchPrev;
					var touchNext;
					if (_length > 2) {
						touchPrev = index - 1;
						touchNext = index + 1;

						if ((index === 0) && (_prevIndex === _length - 1)) {

							// next slide
							touchNext = 0;
							touchPrev = _length - 1;
						} else if ((index === _length - 1) && (_prevIndex === 0)) {

							// prev slide
							touchNext = 0;
							touchPrev = _length - 1;
						}

					} else {
						touchPrev = 0;
						touchNext = 1;
					}

					if (direction === 'prev') {
						_this.$slide.eq(touchNext).addClass('lg-next-slide');
					} else {
						_this.$slide.eq(touchPrev).addClass('lg-prev-slide');
					}

					_this.$slide.eq(index).addClass('lg-current');
				}

				if (_this.lGalleryOn) {
					setTimeout(function() {
						_this.loadContent(index, true, 0);
					}, this.s.speed + 50);

					setTimeout(function() {
						_this.lgBusy = false;
						_this.$el.trigger('onAfterSlide.lg', [_prevIndex, index, fromTouch, fromThumb]);
					}, this.s.speed);

				} else {
					_this.loadContent(index, true, _this.s.backdropDuration);

					_this.lgBusy = false;
					_this.$el.trigger('onAfterSlide.lg', [_prevIndex, index, fromTouch, fromThumb]);
				}

				_this.lGalleryOn = true;

				if (this.s.counter) {
					$('#lg-counter-current').text(index + 1);
				}

			}

		};

		/**
		 *  @desc Go to next slide
		 *  @param {Boolean} fromTouch - true if slide function called via touch event
		 */
		Plugin.prototype.goToNextSlide = function(fromTouch) {
			var _this = this;
			var _loop = _this.s.loop;
			if (fromTouch && _this.$slide.length < 3) {
				_loop = false;
			}

			if (!_this.lgBusy) {
				if ((_this.index + 1) < _this.$slide.length) {
					_this.index++;
					_this.$el.trigger('onBeforeNextSlide.lg', [_this.index]);
					_this.slide(_this.index, fromTouch, false, 'next');
				} else {
					if (_loop) {
						_this.index = 0;
						_this.$el.trigger('onBeforeNextSlide.lg', [_this.index]);
						_this.slide(_this.index, fromTouch, false, 'next');
					} else if (_this.s.slideEndAnimatoin && !fromTouch) {
						_this.$outer.addClass('lg-right-end');
						setTimeout(function() {
							_this.$outer.removeClass('lg-right-end');
						}, 400);
					}
				}
			}
		};

		/**
		 *  @desc Go to previous slide
		 *  @param {Boolean} fromTouch - true if slide function called via touch event
		 */
		Plugin.prototype.goToPrevSlide = function(fromTouch) {
			var _this = this;
			var _loop = _this.s.loop;
			if (fromTouch && _this.$slide.length < 3) {
				_loop = false;
			}

			if (!_this.lgBusy) {
				if (_this.index > 0) {
					_this.index--;
					_this.$el.trigger('onBeforePrevSlide.lg', [_this.index, fromTouch]);
					_this.slide(_this.index, fromTouch, false, 'prev');
				} else {
					if (_loop) {
						_this.index = _this.$items.length - 1;
						_this.$el.trigger('onBeforePrevSlide.lg', [_this.index, fromTouch]);
						_this.slide(_this.index, fromTouch, false, 'prev');
					} else if (_this.s.slideEndAnimatoin && !fromTouch) {
						_this.$outer.addClass('lg-left-end');
						setTimeout(function() {
							_this.$outer.removeClass('lg-left-end');
						}, 400);
					}
				}
			}
		};

		Plugin.prototype.keyPress = function() {
			var _this = this;
			if (this.$items.length > 1) {
				$(window).on('keyup.lg', function(e) {
					if (_this.$items.length > 1) {
						if (e.keyCode === 37) {
							e.preventDefault();
							_this.goToPrevSlide();
						}

						if (e.keyCode === 39) {
							e.preventDefault();
							_this.goToNextSlide();
						}
					}
				});
			}

			$(window).on('keydown.lg', function(e) {
				if (_this.s.escKey === true && e.keyCode === 27) {
					e.preventDefault();
					if (!_this.$outer.hasClass('lg-thumb-open')) {
						_this.destroy();
					} else {
						_this.$outer.removeClass('lg-thumb-open');
					}
				}
			});
		};

		Plugin.prototype.arrow = function() {
			var _this = this;
			this.$outer.find('.lg-prev').on('click.lg', function() {
				_this.goToPrevSlide();
			});

			this.$outer.find('.lg-next').on('click.lg', function() {
				_this.goToNextSlide();
			});
		};

		Plugin.prototype.arrowDisable = function(index) {

			// Disable arrows if s.hideControlOnEnd is true
			if (!this.s.loop && this.s.hideControlOnEnd) {
				if ((index + 1) < this.$slide.length) {
					this.$outer.find('.lg-next').removeAttr('disabled').removeClass('disabled');
				} else {
					this.$outer.find('.lg-next').attr('disabled', 'disabled').addClass('disabled');
				}

				if (index > 0) {
					this.$outer.find('.lg-prev').removeAttr('disabled').removeClass('disabled');
				} else {
					this.$outer.find('.lg-prev').attr('disabled', 'disabled').addClass('disabled');
				}
			}
		};

		Plugin.prototype.setTranslate = function($el, xValue, yValue) {
			// jQuery supports Automatic CSS prefixing since jQuery 1.8.0
			if (this.s.useLeft) {
				$el.css('left', xValue);
			} else {
				$el.css({
					transform: 'translate3d(' + (xValue) + 'px, ' + yValue + 'px, 0px)'
				});
			}
		};

		Plugin.prototype.touchMove = function(startCoords, endCoords) {

			var distance = endCoords - startCoords;

			if (Math.abs(distance) > 15) {
				// reset opacity and transition duration
				this.$outer.addClass('lg-dragging');

				// move current slide
				this.setTranslate(this.$slide.eq(this.index), distance, 0);

				// move next and prev slide with current slide
				this.setTranslate($('.lg-prev-slide'), -this.$slide.eq(this.index).width() + distance, 0);
				this.setTranslate($('.lg-next-slide'), this.$slide.eq(this.index).width() + distance, 0);
			}
		};

		Plugin.prototype.touchEnd = function(distance) {
			var _this = this;

			// keep slide animation for any mode while dragg/swipe
			if (_this.s.mode !== 'lg-slide') {
				_this.$outer.addClass('lg-slide');
			}

			this.$slide.not('.lg-current, .lg-prev-slide, .lg-next-slide').css('opacity', '0');

			// set transition duration
			setTimeout(function() {
				_this.$outer.removeClass('lg-dragging');
				if ((distance < 0) && (Math.abs(distance) > _this.s.swipeThreshold)) {
					_this.goToNextSlide(true);
				} else if ((distance > 0) && (Math.abs(distance) > _this.s.swipeThreshold)) {
					_this.goToPrevSlide(true);
				} else if (Math.abs(distance) < 5) {

					// Trigger click if distance is less than 5 pix
					_this.$el.trigger('onSlideClick.lg');
				}

				_this.$slide.removeAttr('style');
			});

			// remove slide class once drag/swipe is completed if mode is not slide
			setTimeout(function() {
				if (!_this.$outer.hasClass('lg-dragging') && _this.s.mode !== 'lg-slide') {
					_this.$outer.removeClass('lg-slide');
				}
			}, _this.s.speed + 100);

		};

		Plugin.prototype.enableSwipe = function() {
			var _this = this;
			var startCoords = 0;
			var endCoords = 0;
			var isMoved = false;

			if (_this.s.enableSwipe && _this.isTouch && _this.doCss()) {

				_this.$slide.on('touchstart.lg', function(e) {
					if (!_this.$outer.hasClass('lg-zoomed') && !_this.lgBusy) {
						e.preventDefault();
						_this.manageSwipeClass();
						startCoords = e.originalEvent.targetTouches[0].pageX;
					}
				});

				_this.$slide.on('touchmove.lg', function(e) {
					if (!_this.$outer.hasClass('lg-zoomed')) {
						e.preventDefault();
						endCoords = e.originalEvent.targetTouches[0].pageX;
						_this.touchMove(startCoords, endCoords);
						isMoved = true;
					}
				});

				_this.$slide.on('touchend.lg', function() {
					if (!_this.$outer.hasClass('lg-zoomed')) {
						if (isMoved) {
							isMoved = false;
							_this.touchEnd(endCoords - startCoords);
						} else {
							_this.$el.trigger('onSlideClick.lg');
						}
					}
				});
			}

		};

		Plugin.prototype.enableDrag = function() {
			var _this = this;
			var startCoords = 0;
			var endCoords = 0;
			var isDraging = false;
			var isMoved = false;
			if (_this.s.enableDrag && !_this.isTouch && _this.doCss()) {
				_this.$slide.on('mousedown.lg', function(e) {
					// execute only on .lg-object
					if (!_this.$outer.hasClass('lg-zoomed')) {
						if ($(e.target).hasClass('lg-object') || $(e.target).hasClass('lg-video-play')) {
							e.preventDefault();

							if (!_this.lgBusy) {
								_this.manageSwipeClass();
								startCoords = e.pageX;
								isDraging = true;

								// ** Fix for webkit cursor issue https://code.google.com/p/chromium/issues/detail?id=26723
								_this.$outer.scrollLeft += 1;
								_this.$outer.scrollLeft -= 1;

								// *

								_this.$outer.removeClass('lg-grab').addClass('lg-grabbing');

								_this.$el.trigger('onDragstart.lg');
							}

						}
					}
				});

				$(window).on('mousemove.lg', function(e) {
					if (isDraging) {
						isMoved = true;
						endCoords = e.pageX;
						_this.touchMove(startCoords, endCoords);
						_this.$el.trigger('onDragmove.lg');
					}
				});

				$(window).on('mouseup.lg', function(e) {
					if (isMoved) {
						isMoved = false;
						_this.touchEnd(endCoords - startCoords);
						_this.$el.trigger('onDragend.lg');
					} else if ($(e.target).hasClass('lg-object') || $(e.target).hasClass('lg-video-play')) {
						_this.$el.trigger('onSlideClick.lg');
					}

					// Prevent execution on click
					if (isDraging) {
						isDraging = false;
						_this.$outer.removeClass('lg-grabbing').addClass('lg-grab');
					}
				});

			}
		};

		Plugin.prototype.manageSwipeClass = function() {
			var _touchNext = this.index + 1;
			var _touchPrev = this.index - 1;
			if (this.s.loop && this.$slide.length > 2) {
				if (this.index === 0) {
					_touchPrev = this.$slide.length - 1;
				} else if (this.index === this.$slide.length - 1) {
					_touchNext = 0;
				}
			}

			this.$slide.removeClass('lg-next-slide lg-prev-slide');
			if (_touchPrev > -1) {
				this.$slide.eq(_touchPrev).addClass('lg-prev-slide');
			}

			this.$slide.eq(_touchNext).addClass('lg-next-slide');
		};

		Plugin.prototype.mousewheel = function() {
			var _this = this;
			_this.$outer.on('mousewheel.lg', function(e) {

				if (!e.deltaY) {
					return;
				}

				if (e.deltaY > 0) {
					_this.goToPrevSlide();
				} else {
					_this.goToNextSlide();
				}

				e.preventDefault();
			});

		};

		Plugin.prototype.closeGallery = function() {

			var _this = this;
			var mousedown = false;
			this.$outer.find('.lg-close').on('click.lg', function() {
				_this.destroy();
			});

			if (_this.s.closable) {

				// If you drag the slide and release outside gallery gets close on chrome
				// for preventing this check mousedown and mouseup happened on .lg-item or lg-outer
				_this.$outer.on('mousedown.lg', function(e) {

					if ($(e.target).is('.lg-outer') || $(e.target).is('.lg-item ') || $(e.target).is('.lg-img-wrap')) {
						mousedown = true;
					} else {
						mousedown = false;
					}

				});

				_this.$outer.on('mouseup.lg', function(e) {

					if ($(e.target).is('.lg-outer') || $(e.target).is('.lg-item ') || $(e.target).is('.lg-img-wrap') && mousedown) {
						if (!_this.$outer.hasClass('lg-dragging')) {
							_this.destroy();
						}
					}

				});

			}

		};

		Plugin.prototype.destroy = function(d) {

			var _this = this;

			if (!d) {
				_this.$el.trigger('onBeforeClose.lg');
				$(window).scrollTop(_this.prevScrollTop);
			}


			/**
			 * if d is false or undefined destroy will only close the gallery
			 * plugins instance remains with the element
			 *
			 * if d is true destroy will completely remove the plugin
			 */

			if (d) {
				if (!_this.s.dynamic) {
					// only when not using dynamic mode is $items a jquery collection
					this.$items.off('click.lg click.lgcustom');
				}

				$.removeData(_this.el, 'lightGallery');
			}

			// Unbind all events added by lightGallery
			this.$el.off('.lg.tm');

			// Distroy all lightGallery modules
			$.each($.fn.lightGallery.modules, function(key) {
				if (_this.modules[key]) {
					_this.modules[key].destroy();
				}
			});

			this.lGalleryOn = false;

			clearTimeout(_this.hideBartimeout);
			this.hideBartimeout = false;
			$(window).off('.lg');
			$('body').removeClass('lg-on lg-from-hash');

			if (_this.$outer) {
				_this.$outer.removeClass('lg-visible');
			}

			$('.lg-backdrop').removeClass('in');

			setTimeout(function() {
				if (_this.$outer) {
					_this.$outer.remove();
				}

				$('.lg-backdrop').remove();

				if (!d) {
					_this.$el.trigger('onCloseAfter.lg');
				}

			}, _this.s.backdropDuration + 50);
		};

		$.fn.lightGallery = function(options) {
			return this.each(function() {
				if (!$.data(this, 'lightGallery')) {
					$.data(this, 'lightGallery', new Plugin(this, options));
				} else {
					try {
						$(this).data('lightGallery').init();
					} catch (err) {
						console.error('lightGallery has not initiated properly');
					}
				}
			});
		};

		$.fn.lightGallery.modules = {};

		$('#image-gallery').lightSlider({
			thumbItem: parseInt(wre_slider.thumbs_shown),
			mode: wre_slider.gallery_mode,
			auto: wre_slider.auto_slide,
			pause: parseInt(wre_slider.slide_delay),
			speed: parseInt(wre_slider.slide_duration),
			prevHtml: wre_slider.gallery_prev,
			nextHtml: wre_slider.gallery_next,
			pager: true,
			controls: true,
			addClass: 'listing-gallery',
			gallery: true,
			item: 1,
			autoWidth: false,
			loop: true,
			slideMargin: 0,
			galleryMargin: 10,
			thumbMargin: 10,
			enableDrag: false,
			currentPagerPosition: 'left',
			rtl: is_rtl,
			onSliderLoad: function (el) {
				el.lightGallery({
					selector: '#image-gallery .lslide'
				});
			}
		});
	}

})(jQuery);