/*jslint browser: true, devel: true, for:true, this:true */
/*global jQuery, window, _app_, _app_ms_, jstz, Swipe, FB, gapi */

/**
 * WP BASE Common scripts
 *
 * @author		Hakan Ozevin
 * @package     WP BASE
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @version		3.0.1
 * @since       3.0
 */

jQuery(document).ready(function($){
    "use strict";

	/* Find current url and add parameters  */
	function buildUrl(params){
		return window.location.protocol + "//" +
			   window.location.host + window.location.pathname + "?" + params.join("&");
	}

	/* Hide/Show Book in Table View Columns acc to parent width  */
	function adjustTableColumns() {
		var edge = _app_.bookTableEdge;
		if (parseInt(edge) > 0){
			$.each($(document).find("table.app-book"), function(){
				var tbl = $(this);
				if (!tbl.find("th.app-book-date").length ||
                    !tbl.find("th.app-book-time").length ||
                    !tbl.find("th.app-book-date_time").length){
                        return false;
                    }
				if (parseInt(tbl.outerWidth()) < parseInt(edge)){
					tbl.find(".app-book-date,.app-book-day,.app-book-time").hide();
					tbl.find(".app-book-date_time").show();
				} else {
					tbl.find(".app-book-date,.app-book-day,.app-book-time").show();
					tbl.find(".app-book-date_time").hide();
				}

			});
		}
	}

	$(window).resize(function() {
		adjustTableColumns();
	});

	/* Switch between short/long and single letter weekday names  */
	function toggleWeekNames() {
		$.each($(document).find(".app-list table"), function() {
			var tbl = $(this);
			var width = tbl.width();
			if (width < 400) {
				tbl.find("th span.normal").hide();
				tbl.find("th span.initial").show();
			} else {
				tbl.find("th span.normal").show();
				tbl.find("th span.initial").hide();
			}
		});
	}

	$(window).resize(function() {
		clearTimeout($.data(this, 'resizeTimer2'));
		$.data(this, 'resizeTimer2', setTimeout( function() {
			toggleWeekNames();
		}, 500));
	});


	/* Dummy functions for non-mobile and mobile devices */
	/* They return nothing and still chainable */
	if (_app_.is.mobile) {
		$.fn.qtip = function() {
			return $.fn.qtip;
		};
	}

	/* Prevent disabled buttons fire */
	$(document).on("click", ".app-disabled-button", function(e){
		e.preventDefault();
		return false;
	});

	/* app_value is a global array of booked time slots */
	function getValue(){
		return $(document).data("app_value") || [];
	}

	function setValue(val) {
		$(document).data("app_value", val);
	}

	/* Check if cart is activated by the shortcode */
	function hasCart(){
		return ($(".has-cart").length && parseInt($(".has-cart").val()) > 0) ? 1 : 0;
	}

	/* Enable confirmation checkout button */
	function enableButton() {
		$(".app-conf-button").removeClass("app-disabled-button").css("opacity",1).blur().qtip({
			content: {
				text: _app_.checkout_button_tip
			},
			hide: _app_.qtipHide,
			position: _app_.qtipPos,
			style: _app_.qtipSmall
		});
	}
	_app_.enableButton = function() {
		enableButton();
	};

	/* Disable confirmation checkout button */
	function disableButton(reason) {
		var app_value = getValue();
		var q_text = app_value.length === 0 ? _app_.too_less : _app_.no_gateway;
		$(".app-conf-button").addClass("app-disabled-button").css("opacity", _app_.opacity).blur().qtip({
			content: {
				text: reason || $(this).data("disable_reason") || q_text
			},
			hide: _app_.qtipHide,
			position: _app_.qtipPos,
			style: _app_.qtipSmall
		});
	}
	_app_.disableButton = function(reason) {
		disableButton(reason);
	};

	/* Scroll to the selected target and focus */
	function goTo($t){
		if (_app_.is.noScroll) {
			return false;
		}
		if ($t){
			$.scrollTo($t, {
				duration: _app_.scroll_duration,
				axis: "y",
				offset: -1*parseInt(_app_.offset),
				onAfter: function(tg){
					if (_app_.is.focus) {
						tg.focus();
					}
				}
			});
			return true;
		}
		return false;
	}

	/* Refreshing page and if set, redirection after confirmation */
	function refreshPage(r) {
		if (r.refresh_url && parseInt(r.refresh_url) === -1){
			return false;
		}

		$.infoPanel("refreshing");
		var rurl = r.refresh_url || _app_.refresh_url || $.locationUrl();
		if (r.app_id) {
			rurl += ( rurl.match( /[\?]/g ) ? '&' : '?' ) + 'app_id='+ r.app_id;
		}
		window.location.href = rurl;
	}

	/* Open confirmation dialog */
	function openDialog(r){
		if (r.no_dialog || _app_.is.noDialog) {
			if (r.refresh) {
				refreshPage(r);
			}
			return false;
		}
		var cl = r.f_alert ? "app-conf-dialog app-warning" : "app-conf-dialog";
		if ( r.status || r.app_status ) {
			cl = cl + " app-nopane";
		}
		var confirmWrap = $("<div class='app-conf-dialog-content'></div>");
		var w = window.innerWidth;
		var dwidth = 0;
		if (w > 600) {
			dwidth = 600;
		} else {
			dwidth= w-30;
		}

		setTimeout( function() {
			confirmWrap.html(r.confirm_text).dialog({
				title: r.confirm_title,
				modal: _app_.is.modal,
				width: dwidth,
				buttons: [
					{	text: _app_.close,
						click: function() {
							$(this).dialog("close");
							if(r.refresh || r.price === 0) {
								refreshPage(r);
							}
						}
					}
				],
				create: function() {
					var icon = r.icon || "info";
					 $(this).siblings().find(".ui-dialog-title")
							.html("<span class='ui-icon ui-icon-conf ui-icon-" + icon + "'></span>" + r.confirm_title);
				},
				open: function() {
					$(".ui-widget-overlay").bind("click", function() {
						$(this).siblings('.ui-dialog').find('.ui-dialog-content').dialog("close");
					});
				},
				close: function() {
					if (r.refresh || r.price === 0) {
						refreshPage(r);
					}
				},
				position: {
					my: "center top+" + parseInt(_app_.dialog_offset),
					at: "center top",
					of: window
				},
				draggable:false,
				dialogClass: _app_.is.mobile ? "app-mobile " + cl : cl,
				hide: _app_.hideEffect,
				show: _app_.showEffect
			});
			$(document).trigger("app-conf-dialog-opened");
		}, r.delay || 10);
	}

	/* Check if there is an openDialog request */
	function checkDialogOpen() {
		var notice = $(document).find(".app-notice-template");
		if (!notice.length) {
			return false;
		}
		if (parseInt(notice.data("alert")) === 1) {
			alert($.trim(notice.text()));
		} else {
			openDialog({
				confirm_text: notice.data("dialog_text"),
				confirm_title: notice.data("dialog_title"),
				icon: notice.data("icon"),
				delay: notice.data("delay"),
				refresh_url: notice.data("refresh_url"),
				app_status: notice.data("app_status")
			});
		}
	}
	checkDialogOpen();

	/* dialog to be used instead of alert */
	_app_.alertDialog = function(message){
		openDialog({
			confirm_text: message,
			confirm_title: _app_.error_short,
			refresh: false,
			price: 999,
			f_alert: true
		});
	};

	/**
	 * Initiate Swipe function
	 */
	var WPB_Swipe = {

		created_index_max: 3,
		current_index_h: -1,
		current_index: -1,

		/* Bring book table and fill swipe slider */
		bringBookTable: function(index) {
			var me = this;
			var target = index + 3;
			if (target > me.created_index_max) {
				var target_el = $("div.app-wrap[data-index='" + target + "']");
				$.post(_app_.ajax_url, {
					wpb_ajax: true,
					action: "bringBookTable",
					post_id: _app_.post_id,
					type: target_el.data("type"),
					start_ts: target_el.data("start-ts"),
					title: target_el.data("title"),
					logged: target_el.data("logged"),
					notlogged: target_el.data("notlogged")
				}, function(r) {
					me.current_index = -1; // This allows first call
					if (r.html) {
						target_el.html(r.html);
						target_el.find(".ui-button").addClass("ui-shadow");
						me.created_index_max = Math.max(me.created_index_max, target);
						return true;
					}
				}, "json");
			}
		},

		/* Set height=1px to slides out of sight after transition complete */
		adjustHeight: function (index) {
			var me = this;
			if (index === me.current_index_h) {
				return;
			}
			me.current_index_h = index;
			var $this = $("div.app-wrap[data-index='" + index + "']");
			if ($this && $this.length) {
				$("div.app-wrap[data-index]").not($this).css("height", "1px");
				$this.css("height", "auto");
			}
		},

		run: function() {
			var me = this;
			/* Swipe.js call */
			if (typeof Swipe === "function" && _app_.is.mobile) {
				var slider = document.getElementById('app-slider');
				var startSlide = 0;
				var wpbSwipe = new Swipe(slider, {
				  startSlide: startSlide,
				  speed: 400,
				  auto: 0,
				  continuous: false,
				  disableScroll: false,
				  stopPropagation: false,
				  callback: function(index) {me.bringBookTable(index); },
				  transitionEnd: function(index) {me.adjustHeight(index); }
				});
				setTimeout(function() {
					if (document.getElementById('app-slider')) {
						wpbSwipe.setup();
						me.created_index_max = 3;
					}
				}, 10);
			}
		}
	};

   /**
	 * Arrange Booking in Flex View
	 */
	var WPB_Flex = {

		/* Adjust height for mode fitHeights */
		fitHeights: function(blocks){
			if (blocks.length < 2){
				return false;
			}
			var maxHeight = Math.max.apply(null, blocks.map( function (){
				var me = $(this);
				var netHeight = 0;
				var pad_bottom = parseInt(
					me.find(".app-compact-day-button-holder")
					  .css("padding-bottom")
					  .replace("px", "")
					);
				var pad_top = parseInt(
					me.find(".app-compact-day-button-holder")
					  .css("padding-top").replace("px", "")
					  );
				var my_offset = me.offset();
				var my_offsetTop = my_offset.top;
				var my_height = me.height();
				var my_bottom = my_offsetTop + my_height;
				var chld = me.find("button").last();
				if (chld.length) {
					var chld_height = chld.height();
					var chld_offset = chld.offset();
					var chld_offsetTop = chld_offset.top;
					var chld_bottom = chld_height + chld_offsetTop;
					netHeight = my_height + chld_bottom - my_bottom + 10 + pad_bottom + pad_top;
				}
				return netHeight;
			}).get());

			blocks.height(maxHeight);
		},

		/* Adjust height for mode fitHeightsPerRow */
		fitHeightsPerRow: function(blocks){
			var me = this;
			if (blocks.length < 2){
				return false;
			}
			var $this = blocks.first();
			var my_offset = $this.offset();
			var first_offsetTop = my_offset.top;
			var row = blocks.filter( function() {
				var o_offset = $(this).offset();
				var o_offsetTop = o_offset.top;
				return o_offsetTop === first_offsetTop;
			});
			me.fitHeights(row);
			blocks = blocks.not(row);
			me.fitHeightsPerRow(blocks);
		},

		/* Adjust margin bottom for title on horizontal layout */
		fitColumns: function(blocks){
			if (!blocks.length){
				return false;
			}
			$.each(blocks, function(){
				var par = $(this).find(".app-compact-day-button-holder");
				var title = par.find("div.app-compact-day-title");
				var my_height = title.innerHeight();
				var par_height = par.innerHeight();
				if (my_height < par_height-5){
					var dif = par_height - my_height;
					title.css("margin-bottom", dif +"px");
				}
			});
		},

		exec: function() {
			var me = this;
			$.each(_app_.flex_modes, function(ignore, mode) {
				var $container = $("div.app_compact_" + mode);
				if (parseInt( $container.length) < 1 ){
					return true;
				}
				$.each($container, function(){
					if ($(this).length && $(this).is(":hidden")) {
						return true;
					}
					var $blocks = $(this).find("div.app-compact-day");
					$(this).imagesLoaded( function() {
						if ("fitRows" === mode || "moduloColumns" === mode ) {
							$(this).isotope({
							  itemSelector: ".app-compact-day",
								layoutMode: mode
							});
						} else if ("fitHeights" === mode) {
							me.fitHeights($blocks);
						} else if ("fitHeightsPerRow" === mode) {
							me.fitHeightsPerRow($blocks);
						} else if ("fitColumns" === mode) {
							me.fitColumns($blocks);
						}
					});

					if ("fitHeights" === mode) {
						$(window).on("resize", function() {
							me.fitHeights($blocks);
						});
					} else if ("fitHeightsPerRow" === mode) {
						$(window).on("resize", function() {
							me.fitHeightsPerRow($blocks);
						});
					}
				});
			});
		}
	};

	/* Adjust padding right for last visible menu element */
	/* Also match last items width to first one if there are 2 lines */
	function adjustMenuPadding() {
		var menus = $("div.app-flex-menu div.app-flex-item:visible");
		$.each(menus, function(i){
			var me = $(this);
			var next_i = i + 1;
			if (menus[next_i] === undefined || parseInt($(menus[next_i]).width()) < 10) {
				me.addClass("app-item-last-in-line");
			} else {
				var my_offset = me.offset();
				var him = $(menus[next_i]);
				var his_offset = him.offset();
				if (Math.abs( his_offset.top - my_offset.top) > 30 ) {
					me.addClass("app-item-last-in-line");
				} else {
					me.removeClass("app-item-last-in-line");
				}
			}
		});
	}

	/* Redraw multiselect */
	function refreshMS(){
		if (typeof $.mobile !== "object" && typeof $.fn.multiselect === "function" && !_app_.is.noMS) {
			$.each($(".app_ms"), function(){
				if ($(this).data().hasOwnProperty( "echMultiselect") ) {
					$(this).multiselect("refresh");
				}
			});
		}
	}
	$(window).resize(function() {
		refreshMS();
		adjustMenuPadding();
	});

	function readTZ() {
		var tz = "";
		if (typeof jstz === "object") {
			var timezone = jstz.determine();
			tz = timezone.name();
		}
		return tz;
	}

	/* Add tooltip to display appointments in calendar cells and various style corrections */
	function updateElements(when) {

		toggleWeekNames();
		adjustTableColumns();

		if ( typeof $.fn.multiselect === "function" && !_app_.is.mobile && !_app_.is.noMS) {
			var filter_ops = {label:_app_.filterLabel || _app_.search,
								placeholder: _app_.filterPholder
							};

			var msLoc = $(".app_select_locations").multiselect({
				classes:"app_locations app_ms",
				open: function(ignore, ui){_app_.openMs(ui);}
				});
			if (_app_.is.locFilter) {
				msLoc.multiselectfilter(filter_ops);
			}

			var msService = $(".app_select_services").multiselect({
				classes:"app_services app_ms",
				open: function(ignore, ui){_app_.openMs(ui);}
			});
			if (_app_.is.serviceFilter) {
				msService.multiselectfilter(filter_ops);
			}

			var msWorker = $(".app_select_workers").multiselect({
				classes:"app_workers app_ms",
				open: function(ignore, ui){_app_.openMs(ui);}
			});
			if (_app_.is.workerFilter) {
				msWorker.multiselectfilter(filter_ops);
			}
			$(".app_select_durations").multiselect({classes:"app_durations app_ms"});

			var usersSel = $(".app_select_users:not(.app_no_ms)");
			usersSel.multiselect({
				classes:"app_users app_ms",
				buttonWidth: usersSel.data("buttonwidth") || "100%",
				selectedList: usersSel.data("selectedList") || 3
			}).multiselectfilter(filter_ops);

			$(".app_select_theme:not(.app_no_ms)").multiselect({classes:"app_themes app_ms"});
			$(".app_select_timezone:not(.app_no_ms)").multiselect({
				classes: "app_timezones app_ms",
				buttonWidth: $(this).data("buttonwidth") || "100%"
			}).multiselectfilter(filter_ops);

			var whTimeZoneSel = $(".app_wh_timezone:not(.app_no_ms)");
			whTimeZoneSel.multiselect({
				classes: "app_timezones app-ms-small",
				buttonWidth: whTimeZoneSel.data("buttonwidth") || "200",
				noneSelectedText: whTimeZoneSel.data("noneselectedtext") || "Select"
			}).multiselectfilter(filter_ops);

			$(".app_select_seats:not(.app_no_ms)").multiselect({buttonWidth:"30%",classes:"app_seats app_ms"});
			$(".app_select_extras:not(.app_no_ms)").multiselect({
				selectedList: 3,
				classes: "app_extras app_ms",
				header: [],
				open: function(ignore, ui) {_app_.openMs(ui);}
			});
			$(".app_select_repeat").multiselect({buttonWidth:"30%",classes:"app_repeat app_ms"});
			$(".app_select_repeat_unit").multiselect({buttonWidth:"30%",classes:"app_repeat_unit app_ms"});
			$(".app_select_lang:not(.app_no_ms)").multiselect({ classes:"app-multilang app_ms", buttonWidth:"100%" }).multiselectfilter(filter_ops);
			$(".app_select_credits:not(.app-selected):not(.app_no_ms)").multiselect({classes:"app_credits app_ms", buttonWidth: $(this).data("buttonwidth") || "100%"});
			$(".app-select-multiple").multiselect({
				selectedList: 3,
				classes: "app-multiple app_ms",
				buttonWidth: $(this).data("buttonwidth") || "100%",
				header: []
			});
		}

		$.styleButtons();

		$(".ui-button").addClass("ui-shadow");

		if (typeof $.fn.quickfit === "function" && _app_.is.quickfit) {
			$(".app-fem th span").quickfit({min:12.5, max:14});
			$(".app-book-flex-button").quickfit({min:8, max:14});
			$(".app-timezone-note").quickfit({min:11, max:14});
		}

		adjustMenuPadding();

		if (when !== "pre-conf") {
			WPB_Swipe.run();
		}

		$(".app-wrap, .app-wrap-widget, .app-conf-wrapper, .app-list-wrapper, .app-debug")
		  .find("[title][title!='']").each(function() {
			var title = $(this).attr("title");
			if ($(this).hasClass("app-all")) {
				return false;
			}
			if ($(this).hasClass("app-full")) {
				return true;
			}
			var ttip = title ? title.replace(/●/g,"<br />") : "";
			$(this).qtip({
				overwrite: false,
				content: {
					text: ttip,
					title: $(this).data("title")
				},
				style: _app_.qtipNarrow,
				position: {
					viewport: $(window)
				}
			});
		});

		$(".has_inline_appointment:not(.app-all),.app-weekly-admin .busy,.app-weekly-admin .has_appointment:not(.app-all)," +
		  ".app-weekly-account .busy,.app-weekly-account .has_appointment:not(.app-all),.app-unassigned .app-cell-inline," +
		  ".app-bp-profile .busy,.app-bp-profile .has_appointment:not(.app-all)," +
		  ".app-monthly-admin .has_appointment,.app-monthly-admin .busy,.app-monthly-account .has_appointment,.app-monthly-account .busy").qtip({
			content: {
				text: function(ignore, api) {
					var weekly = $(this).parents().hasClass("app-weekly-admin") ? 1:0;
					api.elements.content.html(_app_.loading);
					$(this).parents("td").attr("title","");
					return $.ajax({
						url: _app_.ajax_url,
						type: "POST",
						dataType: "json",
						data: {
							weekly: weekly,
							app_val: $(this).find(".app-packed").val() || $(this).parents("td").find(".app-packed").val(),
							action: "app_bookings_in_tooltip"
						}
					})
					.then( function(res) {
						var content = res.result;
						return content;
					}, function(ignore, status, error) {
						api.set("content.text", status + ": " + error);
					});
				}
			},
			hide: _app_.qtipHide,
			position: _app_.qtipPosBottom,
			style: _app_.qtipSmall
		});

		_app_.openMs = function(ui){
			var menu = ui.menu;
			var labels = menu.find("label");

			var lsw = "service";
			if (ui.btn.hasClass("app_locations")) {
				lsw = "location";
			} else if (ui.btn.hasClass("app_workers")) {
				lsw = "worker";
			} else if (ui.btn.hasClass("app_extras")) {
				lsw = "extra";
			}

			var slc = ui.element; // Select element
			var pages_ = slc.data("with_page");
			if (!pages_){
				return false;
			}
			var pages = pages_.toString(); // comma delimited services or workers
			if (parseInt(pages.length) === 0){
				return false;
			}
			var arr = pages.split(",");
			if (!arr){
				return false;
			}

			$.each(labels, function(){
				var id = $(this).find("input").val();
				if ($.inArray(id, arr) !== -1) {
					$(this).addClass("with-page");
					var title = slc.find("option").filter( function() {return $(this).val() === id;}).text();
					$(this).attr("title", title);
				}
			});

			var desc = slc.data("desc"); // excerpt, page_content, etc
			var ex_len = slc.data("ex_len"); // excerpt length

			$(".with-page").qtip({
				content: {
					text: function(ignore, api) {
						api.set("content.title", $(this).attr("title"));
						var id = $(this).find("input").val();
						var cache_cl = "app-desc-cache-" + lsw + "-" + id;
						var cache = $("<div class='" + cache_cl + "' />");
						if (parseInt($(document).find("."+cache_cl).length) > 0) {
							return $(document).find("."+cache_cl).html();
						}
						api.elements.content.html(_app_.loading);
						return $.ajax({
							url: _app_.ajax_url,
							type: "POST",
							dataType: "json",
							data: {
								wpb_ajax: true,
								id: $(this).find("input").val(),
								desc: desc,
								ex_len: ex_len,
								lsw: lsw,
								post_id: parseInt(_app_.post_id),
								app_lang: $.urlParam("app_lang"),
								action: "app_lsw_tooltip"
							}
						})
						.then(function(res) {
							var content = res.result;
							if (content) {
								cache.html(content)
									 .appendTo($(document.body)).hide();
							}
							return content;
						}, function(ignore, status, error) {
							api.set("content.text", status + ": " + error);
							cache.remove();
						});
					}
				},
				show: {
					ready: false
				},
				hide: _app_.qtipHide,
				position: _app_.qtipPos,
				style: _app_.qtipNarrow
			}, event);
		};

		// Display tooltip for Map
		$(document).on( "mouseenter", ".app_map", function(event){
			var $this = $(this);
			var loc_id = $this.data("loc_id");
			if (!loc_id){
				return false;
			}
			var title = $this.data("address");
			var cache_cl = "app-map-cache-"+loc_id;
			var cache = $("<div class='"+cache_cl+"' />");
			$this.qtip({
				content: {
					text: function(ignore, api) {
						if (parseInt($(document).find("."+cache_cl).length ) > 0 ) {
							return $(document).find("."+cache_cl).html();
						}
						api.elements.content.html(_app_.loading);
						return $.ajax({
							url: _app_.ajax_url,
							type: "POST",
							dataType: "json",
							data: {
								wpb_ajax: true,
								loc_id: loc_id,
								action: "app_display_map"
							}
						})
						.then(function(res) {
							var content = res.result;
							if (content) {
								cache.html(content)
									 .appendTo($(document.body)).hide();
							}
							return content;
						}, function(ignore, status, error) {
							api.set("content.text", status + ": " + error);
						});
					},
					title: title
				},
				show: {
					event: event.type,
					ready: true
				},
				hide: _app_.qtipHide,
				position: _app_.qtipPos,
				style:{
					width: _app_.map_width,
					widget: true,
					def: false,
					classes: "app-no-max"
				}
			}, event);
		});

		$(document).trigger("elements_updated");
	}

	/**
	 * Prepare tooltip content
	 */
	function eventTT($this) {
		var tpl = $(document).find(".app-event-template");
		if (tpl.length === 0) {
			return false;
		}
		var wrap = $("<div />").html(tpl.html());
		var det = $this.data("details");
		var tt = ".app-event-tt-";
		wrap.find(tt + "image").html(det.image);
		wrap.find(tt + "title").html(det.title);
		wrap.find(tt + "desc").html(det.desc);
		wrap.find(tt + "time").html(det.time);
		wrap.find(tt + "href").val(det.href);
		if (det.loc) {
			wrap.find(tt + "loc").html(det.loc).show();
		} else {
			wrap.find(tt + "loc").hide();
		}
		return wrap.html();
	}

	/**
	 * Events calendar tooltip
	 */
	function eventsQtip() {
		$(".app-events-calendar li").each(function() {
			var $this = $(this);
			var ttText = eventTT($this);
			if (!ttText) {
				return false;
			}

			$this.qtip({
				overwrite: true,
				content: {
					text: ttText
				},
				hide: _app_.qtipHide,
				style: _app_.qtipDef,
				position: _app_.qtipPosBottom
			});
		});
	}
	eventsQtip();

	/**
	 * Close tooltip + redirect for mobile
	 */
	$(document).on("touchend", "body", function(e) {
		var target = $(e.target);
		var par = target.parents("tr.app-tt-ins");
		if (par.length) {
			var href = par.data("href");
			if (href) {
				window.location.href = href;
				return false;
			}
		}
		$(document).find("tr.app-tt-ins").remove();
	});

	/**
	 * Open tooltip
	 */
	$(document).on("click touchend", ".app-events-calendar li", function(e) {
		var $this = $(this);
		var href = $this.data("href");
		if (e.type === "touchend") {
			var ttText = eventTT($this);
			if (!ttText) {
				return false;
			}
			$(document).find("tr.app-tt-ins").remove();
			var row = $("<tr class='app-tt-ins' data-href='"+href+"'><td colspan='7'>" + ttText + "</td></tr>");
			$this.parents("tr").first().after(row);
			return false;
		}

		if (href) {
			window.location.href = href;
		}
	});

	/**
	 * Redirect for non-mobile
	 */
	$(document).on("click", ".app-event-tt", function() {
		var $this = $(this);
		var href = $this.find(".app-event-tt-href").val();
		if (href) {
			window.location.href = href;
		}
	});

	/* Helper for Update calendars - Fixes buttons qtip before/after animations */
	function updateBtns( ) {
		$(".ui-button").addClass("ui-state-default").qtip();
		$(".app-book-now-button").button({
		  icons: { primary: "ui-icon-cart" }
		}).qtip();
		eventsQtip();
	}

	/* Read confirmation form values for pre_conf, update and post_conf */
	function readForm(cw, elm){
		var app_user_data = {};
		var app_cc_data = {};
		var postUdfData = {};
		var postLopData = {};
		var postSpecialData = {};
		var active_id;
		var parScode;

		var app_id = $(".app_gateway_form").find(".app_id").val() || 0;
		if (!app_id && cw.find(".app-edit-id")) {
			app_id = cw.find(".app-edit-id").val();
		}
		var editing = parseInt(cw.find(".app_editing_value").val());
		var user_fields = (editing > 0 && $(document).find("app-template-for-edit").length)
						  ? $(document).find("app-template-for-edit").data("user_fields")
						  : cw.data("user_fields");
		$.each(user_fields, function(ignore, v) {
			app_user_data[v] = cw.find(".app-" + v + "-field-entry").val();
		});

		cw.find(".app_billing_line input, .app_billing_line select").each( function() {
			var input_name = $(this).prop("name") ? $(this).prop("name") : $(this).prop("id");
			var input_val = $(this).val();
			app_cc_data[input_name] = input_val;
		});

		if ( typeof elm === "object" && elm.parents(".app-scode").length ) {
			parScode = elm.parents(".app-scode").first();
			active_id = parScode.attr("id");
		} else {
			parScode = $(document.body);
		}

		var scode = [];
		$.each( $(document).find(".app-scode"), function(i,v){
			scode[i] = {
				id: $(this).attr("id"),
				scode: $(v).data("scode")
			};
		});

		var postData = {
			wpb_ajax:true,
			ajax_nonce: _app_.nonce,
			action: "post_confirmation",
			post_id: parseInt(_app_.post_id),
			popup_id: parseInt(_app_.popup_id),
			scode: JSON.stringify(scode),
			active_id: active_id,
			app_id: app_id,
			bp_displayed_user_id: _app_.bp_displayed_user_id,
			bp_tab: _app_.bp_tab,
			has_cart: hasCart(),
			value: getValue(),
			editing: editing,
			cap: cw.data("cap"),
			app_user_id: $(".app_select_users option:selected").val(),
			app_user_data: JSON.stringify(app_user_data),
			app_user_fields: JSON.stringify(user_fields),
			app_note: cw.find(".app-note-field-entry").val(),
			app_remember: cw.find(".app-remember-field-entry").is(":checked") ? 1 : "",
			app_location: cw.find(".app_select_locations") ? cw.find(".app_select_locations").val() : 0,
			app_service: cw.find(".app_select_services") ? cw.find(".app_select_services").val() : 0,
			app_category: $(document).find(".app_select_services")
						  ? $(document).find(".app_select_services option:selected").closest("optgroup").data("category_id")
						  : 0,
			app_worker: cw.find(".app_select_workers") ? cw.find(".app_select_workers").val() : 0,
			app_date: cw.find(".app-edit-date") ? cw.find(".app-edit-date").val() : 0,
			app_time: cw.find(".app-edit-time") ? cw.find(".app-edit-time").val() : 0,
			app_duration: parScode.find(".app_select_durations option:selected").val(),
			app_repeat: parScode.find(".app_select_repeat option:selected").val(),
			app_repeat_unit: parScode.find(".app_select_repeat_unit option:selected").val(),
			app_repeat_unit_alt: parScode.find(".app_repeat_unit_alt").val(),
			app_seats: parScode.find(".app_select_seats option:selected").val(),
			app_credits: $(".app_select_credits option:selected").val(),
			app_coupon: $(".app-coupon-field-entry").val(),
			app_extras: $(".app_select_extras option:selected").map(function() {return this.value;}).get().join(","),
			app_disp_price: $(".app-disp-price").val(),
			app_payment_method: cw.find("input:radio[name='app_choose_gateway']").is(":checked")
								? cw.find("input:radio[name='app_choose_gateway']:checked").val()
								: "",
			app_cc_submit: cw.find(".app-cc-submit") ? cw.find(".app-cc-submit").val() : 0,
			app_cc_data: JSON.stringify(app_cc_data),
			stripeToken: cw.find(".stripeToken") ? cw.find(".stripeToken").val() : "",
			paymillToken: cw.find(".paymillToken") ? cw.find(".paymillToken").val() : "",
			simplify_token: cw.find(".simplify_token") ? cw.find(".simplify_token").val() : "",
			app_confirm_email_username: cw.find(".app_confirm_email_username").val(),
			app_lang: _app_.lang,
			app_eb: $(document).find(".app-eb-table").attr("id"),
			tzstring: readTZ()
		};

		/* Add udf values to post data */
		cw.find("[class*=app-udf-field-entry]").each( function() {
			var udf_name = $(this).attr("name");
			var udf_value = "";
			if ($(this).hasClass("app-udf-checkbox")){
				udf_value = $(this).is(":checked")?1:0;
			} else {
				udf_value = $(this).val();
			}
			postUdfData[udf_name] = udf_value;
		});
		$.extend(postData, postUdfData);

		/* Add lop values to post data */
		cw.find("input[class*=app-lop-text], select[class*=app-lop-select]").each( function(){
			var lop_name=$(this).attr("name");
			var lop_value=$(this).val();
			postLopData[lop_name] = lop_value;
		});
		$.extend(postData, postLopData);

		/* Add special values to post data */
		cw.find("input[class*=app-special-text], select[class*=app-special-select]").each( function(){
			var sp_name=$(this).attr("name");
			var sp_value=$(this).val();
			postSpecialData[sp_name] = sp_value;
		});
		$.extend(postData, postSpecialData);

		$(document).trigger("app-read-post-data", postData);

		$.extend(postData, $(document).data("app-add-post-data") || {});

		return postData;
	}

	/* Add required fields booking notes to the form */
	function addSupMark(){
		var cw = $(document).find(".app-conf-wrapper").first();
		if (cw.find("sup").not(".app-next-day, .app-all-day").length && !cw.find(".app-required-note").length) {
			$(".app-required-note").remove();
			cw.find("fieldset .app-conf-final-note").before("<div class='app-required-note'><sup> *</sup>"+_app_.required+"</div>");
		}
	}

	/* Fix tooltips for prices */
	function ttRegularPrice() {
		$('.app_old_price').qtip({
			content:{text:_app_.tt_regular_price},
			show:{
				when:false,
				ready:true,
				delay:2000
			},
			hide: {
				event:false,
				inactive:5000
			},
			style: _app_.qtipSmall,
			position: _app_.qtipPosLeft
		});
	}

	/* Fix tooltips for discounted prices */
	function ttDiscPrice(coupon) {
		var tt_text = coupon ? _app_.tt_coupon : _app_.tt_discounted_price;
		if ( !tt_text ) {
			return false;
		}

		$('.app_new_price').qtip({
			content:{text:tt_text},
			show:{
				when: false,
				ready: true,
				delay: 3000
			},
			hide: {
				event:false,
				inactive:3000
			},
			style: _app_.qtipSmall,
			position: _app_.qtipPos
		});
	}

	/* Update price after seats field or workers or any select field change, or coupon entered */
	function updatePrice($this) {
		var cw = $this.parents(".app-conf-wrapper");
		var editing = parseInt(cw.find(".app_editing_value").val());
		if (editing){
			return false;
		}
		if ($this.parents(".app_gateway_form").length > 0){
			return false;
		}
		$(document).trigger("update-price");
		$.infoPanel("calculating");
		$this.attr("disabled",true);
		var worker_pulldown = $this.parents().find("select.app_select_workers_conf");
		var app_value = getValue();
		if (worker_pulldown.length) {
			var sel_worker = worker_pulldown.val();
			// update app_value - This cannot be multiple apps, so we can take the 1st element
			if (app_value.length > 0) {
				var temp = app_value[0].split("_");
				temp[4] = sel_worker;
				app_value[0] = temp.join("_");
			}
		}
		var pre_data = readForm(cw);
		pre_data.action = "pre_confirmation_update";
		pre_data.value = app_value;
		setValue(app_value);

		$.post(_app_.ajax_url, pre_data, function(r) {
			$this.attr("disabled",false);
			if (r) {
				if (r.error) {
					alert(r.error);
				} else {
					var coupon = !!$this.hasClass("app-coupon-field-entry");
					$('.app_new_price').qtip("destroy");
					ttDiscPrice(coupon);
					$(".app-conf-price").html(r.price);
					$(".app-disp-price").val(r.disp_price);
					if (r.amount){
						$(".app-conf-amount").html(r.amount).show();
					}
					updateElements();
				}
			} else {
				alert(_app_.con_error);
			}
		}, "json");

	}

	/* Start Countdown */
	function startCountdown(r) {
		var rt = r.remaining_time || parseInt(_app_.remaining_time);
		if (rt && $(".app-conf-countdown").length && typeof $.fn.appCountdown === "function") {
			$(".app-conf-countdown").appCountdown({
				format:_app_.countdown_format,
				until:rt,
				onTick: function (p) {
					var bstart = _app_.blink_starts;
					if (bstart && $.appCountdown.periodsToSeconds(p) === parseInt(bstart)) {
						$(this).addClass("app_blink app-error");
					}
				},
				onExpiry:function() {
					var params = [
						"app_empty_cart=1",
						"ajax_nonce="+_app_.nonce
					];
					window.location.href = buildUrl(params);
				}
			});
			$(".app_countdown_dropdown_title.app-title").css("visibility","visible").show();
		}
	}

	/* Pause Countdown */
	function pauseCountdown(){
		if ($(".app-conf-countdown").length && typeof $.fn.appCountdown === "function") {
			$(".app-conf-countdown").appCountdown("pause");
		}
	}

	/* Start slider */
	function slider(task) {
		var curSlide,$item,$this,par,sl,h1;

		$.each($(".flexslider"), function(i){
			$item = $(this);
			curSlide = $(document).data("currentSlider"+i);

			$item.removeData("flexslider");
			$this = $item.flexslider({
				animation: "slide",
				animationLoop: true,
				animationSpeed: 1000,
				customDirectionNav: $item.prev().find(".app-nextprev a"),
				itemWidth: parseInt(_app_.sliderWidth),
				itemMargin: parseInt(_app_.sliderMargin),
				minItems: parseInt(_app_.sliderCount),
				maxItems: parseInt(_app_.sliderCount),
				prevText: "",
				nextText: "",
				pauseOnHover: true,
				slideshow: "first_load" === task ? _app_.is.slideshow : false,
				rtl: _app_.is.rtl,
				after: function(sl){
					$(document).data("currentSlider"+i, sl.currentSlide);
				}
			});
			par = $this.parents(".app-flex-menu");
			sl = $this.data("flexslider");
			h1 = sl ? sl.computedW : _app_.sliderWidth;
			$this.css("height", h1 + "px");

			if (!curSlide && par.find("li.current").length && sl.move > 1) {
				curSlide = Math.min(sl.last, Math.max(0, Math.floor((par.find("li.current").data("no") - 1)/(sl.move - 1))));
			}

			if (curSlide && "browse" !== task) {
				sl.flexAnimate(curSlide);
			}
		});
	}

	/* Evaluate pre confirmation reply if there is no error */
	function preConfReply(r){
		startCountdown(r);
		setValue(r.new_value);
		var slot;

		if (r.blocked){
			$.each(r.blocked, function(ignore,v){
				slot = $( "[data-packed^='"+v+"']" );
				if (slot.hasClass("free")) {
					slot.removeClass("free").addClass("busy");
				}
			});
		}

		var cl_slot = $(document).data("last_clicked_slot");
		var cw = $(".app-conf-wrapper");
		if (cl_slot) {
			var el = cl_slot.parents(".app-wrap").siblings(".app-conf-wrapper");
			if (el.length) {
				cw = el;
			}
		}

		$(document).trigger("app-conf-wrapper-before-open", r, cw);

		if ( cw.hasClass("app-disabled") ) {
			return false;
		}

		cw.show();

		$(document).trigger("app-conf-wrapper-opened", r);

		addSupMark();

		$(".app-conf-location").html(r.loc);
		$(".app-conf-location-address").html(r.loc_address);
		$(".app-conf-category").html(r.category);
		$(".app-conf-service").html(r.service);
		if (r.worker) {
			$(".app-conf-worker").html(r.worker).show();
		} else {
			$(".app-conf-worker").hide();
		}
		$(".app-conf-start").html(r.start);
		$(".app-conf-end").html(r.end);
		if (r.lasts) {
			$(".app-conf-lasts").html(r.lasts).show();
		} else {
			$(".app-conf-lasts").hide();
		}
		if (r.cart_contents) {
			$(".app-conf-details").html(r.cart_contents).show();
		} else {
			$(".app-conf-details").hide();
		}
		if (r.price) {
			$(".app-conf-price").html(r.price).show();
		}
		$(".app-disp-price").val(r.disp_price);

		ttRegularPrice();
		ttDiscPrice();

		if (r.deposit){
			$(".app-conf-deposit").html(r.deposit).show();
		} else {
			$(".app-conf-deposit").hide();
		}
		if (r.amount){
			$(".app-conf-amount").html(r.amount).show();
		} else {
			$(".app-conf-amount").hide();
		}
		if (r.seats){
			$(".app-conf-seats").html(r.seats).show();
		} else {
			$(".app-conf-seats").hide();
		}
		if (r.coupon){
			$(".app-conf-coupon").html(r.coupon).show();
		} else {
			$(".app-conf-coupon").hide();
		}
		if (r.extra){
			$(".app-conf-extra").html(r.extra).show();
			$(".app_select_extras:not(.app_no_ms)").multiselect({selectedList:3, classes:"app_extras", header:[]});
		} else {
			$(".app-conf-extra").hide();
		}

		$.each(_app_.user_fields, function(ignore, v) {
			if (r[v] === "ask"){
				$(".app-" + v + "-field").show();
			}
		});
		if (r.note === "ask"){
			$(".app-note-field").show();
		}
		if (r.udf === "ask"){
			$.each(r.udf_values, function(ignore, value) {
				$(".app-udf-field-"+value).show();
			});
		}
		if (r.remember === "ask"){
			$(".app-remember-field").show();
		}
		if (r.payment === "ask"){
			if (parseInt(_app_.active_gateways) > 1) {
				$(".app-payment-field").show();
			}
			if (!$("input:radio[name=app_choose_gateway]:checked").val()) {
				disableButton();
			}
		}
		if (r.additional === "ask"){
			$(".app-additional-field").show();
		}

		if (r.lop){
			$(".app-lop").html(r.lop).show();
		}

		if (r.special){
			$(".app-special").html(r.special).show();
		} else {
			$(".app-special").hide();
		}

		var btn = $(".app-conf-button");
		btn.button( "option", "label", r.button_text || btn.data( "button_text") );

		$.each($(".app-conf-wrapper fieldset div"), function() {
			if ($.trim($(this).html()) === ""){
				$(this).addClass("app-mb0");
			} else {
				$(this).removeClass("app-mb0");
			}
		});

		updateElements("pre-conf");

		cw.find("input,textarea,select").addClass("ui-shadow");

		$(document).trigger("app-conf-wrapper-elements-updated", r);

		var focus_el = cw.find("input:visible,select:visible").first();

		if (focus_el.length) {
			goTo(focus_el);
		} else {
			goTo( cw.find("button").first() );
		}
	}

	/* Start Pre confirmation */
	function preConf(el, last_clicked){
		if (_app_.atCheckout || $(this).hasClass("app-disabled-button")){
			return false;
		}
		if (parseInt(_app_.login_not_met) > 0){
			return false;
		}
		if (_app_.preProcess){
			return false;
		}

		_app_.preProcess = true;
		$(document).trigger("pre-process");

		var cl_slot = el || last_clicked;

		// Quit if clicked on admin
		if (parseInt( cl_slot.parents(".app-wrap-admin").length) > 0 ){
			return false;
		}

		$(document).data("last_clicked_slot", cl_slot);
		if (parseInt(cl_slot.parents(".app-monthly-wrapper").length) > 0 && !cl_slot.hasClass("daily")){
			return false;
		}

		$.infoPanel("preparing_form");

		var app_value = getValue();
		if (!hasCart() && !last_clicked) {
			app_value = [];
		}
		var deleted_value = "";
		var api = cl_slot.qtip("api");

		var old_content = (el.length && api && typeof api.get === "function") ? api.get('content.text') : "";
		if (!cl_slot.hasClass("app-selected")){
			if (!hasCart()){
				cl_slot.parents(".app-sc").find(".app-selected").removeClass("app-selected");
			}
			cl_slot.addClass("app-selected");
			if (old_content) {
				api.set('content.text', old_content.replace(_app_.click_hint,_app_.selected));
			}
			if (cl_slot.hasClass("app-book-now-button")){
				cl_slot.addClass("app-disabled-button");
			}
			app_value.push(cl_slot.find(".app-packed").val());
		} else if ( !_app_.is.sticky ) {
			cl_slot.removeClass("app-selected");
			if (old_content) {
				api.set('content.text', old_content.replace(_app_.click_to_remove,_app_.click_hint));
			}
			deleted_value = cl_slot.find(".app-packed").val();
			var index_ = app_value.indexOf(deleted_value);
			if (index_ > -1 ) {
				app_value.splice(index_,1);
			}
		} else if (!hasCart()) {
			var temp = cl_slot.find(".app-packed").val();
			if ($.inArray(temp, app_value) === -1) {
				app_value.push(temp);
			}
		}

		setValue(app_value);
		if (app_value.length === 0) {
			disableButton();
		} else {
			enableButton();
		}

		var cw = $(document).find(".app-conf-wrapper").first();
		var pre_data = readForm(cw, el);
		pre_data.action = "pre_confirmation";
		pre_data.value = app_value;
		pre_data.deleted_value = deleted_value;

		var dur = parseInt(pre_data.app_duration);
		var par = cl_slot.parents(".app-sc");

		if (parseInt(par.length) > 0) {
			par.find(".app-selected-start").removeClass("app-selected-start");
			par.find(".app-selected-middle").removeClass("app-selected-middle");
			par.find(".app-selected-end").removeClass("app-selected-end");
			if (dur > 1440 || (_app_.is.pro && dur === 1440)) {
				var sel = par.find(".app-selected");
				if (parseInt(sel.length) <= 0) {
					sel = par.find(".app-selected-day");
				}
				if (parseInt(sel.length) > 0) {
					sel.addClass("app-selected-start");
					var start = parseInt(sel.find(".app-select-ts").val());
					var end = start + dur*60;
					var i;
					par.find(".app-select-ts[value='" + end + "']").parent("td").addClass("app-selected-end");
					for ( i = start + 1440; i < end; i = i + 1440 ) {
						par.find(".app-select-ts[value='" + i + "']").parent("td").addClass("app-selected-middle");
					}
				}
			}
		}

		$.post(_app_.ajax_url, pre_data, function(r) {
			_app_.preProcess = false;
			cl_slot.removeClass("app-disabled-button");
			if (!r) {
				alert(_app_.con_error);
				return false;
			}
			if (r.error) {
				if (r.start) {
					$(".app-conf-start").html(r.start);
				}
				if (r.end) {
					$(".app-conf-end").html(r.end);
				}
				if (r.lasts) {
					$(".app-conf-lasts").html(r.lasts).show();
				}
				if (r.price) {
					$(".app-conf-price").html(r.price).show();
				}
				if (r.remove_last && Array.isArray(app_value)){
					var removed = app_value.pop();
					par.find("[data-packed="+removed+"]").removeClass("app-selected");
					var day_arr = removed.split("_");
					var day_ts = day_arr[0];
					par.find(".daily.app_day_" + day_ts).removeClass("app-selected");
				}

				openDialog({
					confirm_text: r.error,
					confirm_title: _app_.error_short,
					refresh: false,
					price: 999
				});

				cl_slot.css("opacity","1");
				$(document).trigger("pre-conf-error");
			} else {
				preConfReply(r);
			}
		}, "json");
	}

	/* Update calendars with pagination buttons or service change */
	var updatingCals = false;

	function updateCals($this) {
		if (updatingCals){
			return false;
		}

		/* Save last selected day */
		var day = $(document).find(".app_day.app-selected-day:not(.daily):not(.notpossible)").first();
		if (day.length) {
			var dayArr = day.attr("class").split(" ").filter(function(value){
				return value.indexOf("app_day_") > -1;
			});
			$(document).data("last_selected_day", dayArr.join("."));
		}

		var task, unit, step, parScode, active_id;

		if ( typeof $this === "string" ) {
			task = $this;
		} else if ( $this.hasClass("app-browse") ) {
			task = "browse";
			unit = $this.data("unit");
			step = $this.data("step");
		} else if ( $this.hasClass("app_select_seats") ) {
			task = "seats_changed";
		}

		if ( typeof $this === "object" && $this.parents(".app-scode").length ) {
			parScode = $this.parents(".app-scode").first();
			active_id = parScode.attr("id");
		} else {
			parScode = $(document.body);
		}

		updatingCals = true;
		$(document).trigger("app-updating-calendars", task);

		$.infoPanel(task);

		var arr = $(document).data("shift_register") || [];
		var scode = {};

		$.each( $(document).find(".app-scode"), function(i,v){
			scode[i] = {
				id: $(this).attr("id"),
				scode: $(v).data("scode")
			};
		});

		var updateCalData = {
			wpb_ajax: true,
			action: "update_cals",
			task: task,
			prev_clicked: $(document).data("prev_clicked") || 0,
			app_last_timestamps: JSON.stringify(arr),
			tab: _app_.tab,
			screen_base: _app_.screen_base,
			post_id: parseInt(_app_.post_id),
			popup_id: parseInt(_app_.popup_id),
			scode: JSON.stringify(scode),
			active_id: active_id,
			step: step,
			unit: unit,
			app_location_id: $(document).data("location") || parScode.find(".app_select_locations option:selected").val() || 0,
			app_service_id: $(document).data("service") || parScode.find(".app_select_services option:selected").val() || 0,
			app_worker_id: $(document).data("worker") || $.urlParam("app_worker_id") || parScode.find(".app_select_workers option:selected").val() || 0,
			tzstring: readTZ(),
			app_lang: $.urlParam("app_lang"),
			app_timestamp: _app_.selTS || _app_.defTS,
			used_widgets: _app_.used_widgets,
			bp_displayed_user_id: _app_.bp_displayed_user_id,
			bp_tab: _app_.bp_tab,
			app_seats: parScode.find(".app_select_seats option:selected").val(),
			app_duration: parScode.find(".app_select_durations option:selected").val(),
			app_repeat: parScode.find(".app_select_repeat option:selected").val(),
			app_repeat_unit: parScode.find(".app_select_repeat_unit option:selected").val(),
			app_repeat_unit_alt: parScode.find(".app_repeat_unit_alt").val()
		};

		$(document).trigger("app-read-post-data", updateCalData);

		$.extend(updateCalData, $(document).data("app-add-post-data") || {});

		$.post(_app_.ajax_url, updateCalData, function(r) {
			var me, parBrowse, cl = "";
			updatingCals = false;
			$(document).trigger("app-calendars-updated", r);
			if (!r) {
				alert(_app_.con_error);
				return false;
			}
			if (r.htmlMenus){
				$.each(r.htmlMenus, function( k, v) {
					if ($(this).hasClass("app_replaced")){return true;}
					var menu2 = parScode.find(".app-menu").eq(k).replaceWith(v);
					menu2.addClass("app_replaced");
				});
			}
			if (r.html) {
				$.each(r.html, function(k, v) {
					if ($(this).hasClass("app_replaced")){
						return true;
					}
					parScode.find(".app-wrap").not(".app-book-child, .app-swipe-child")
								  .eq(k).replaceWith(v).addClass("app_replaced");
				});
			}
			if (r.htmlCompact) {
				$.each(r.htmlCompact, function(k, v) {
					if ($(this).hasClass("app_replaced")){
						return true;
					}
					if ( Number.isInteger(k) ) {
						parScode.parent().find(".app-compact-book-wrapper-gr1").eq(k).replaceWith(v);
					} else {
						$(document).find("#" + k).replaceWith(v);
					}
				});
			}

			if (r.widgets) {
				$.each(r.widgets, function( k, v) {
				  $("#appointments_shortcode-" + k).html(v);
				});
			}

			if (r.prev) {
				me = $(".app-previous a");
				me.data("tstamp", r.prev);
				parBrowse = me.parent(".app-previous");
				if (parBrowse.length) {
					if ("hide" === r.prev) {
						parBrowse.css("visibility","hidden");
					} else {
						cl = parBrowse.attr("class").replace(/\d+/g, r.prev);
						parBrowse.attr("class", cl).css("visibility", "visible");
					}
				}
			}
			if (r.next) {
				me = $(".app-next a");
				me.data("tstamp", r.next);
				parBrowse = me.parent(".app-next");
				if (parBrowse.length) {
					if ("hide" === r.next) {
						parBrowse.css("visibility", "hidden");
					} else {
						cl = parBrowse.attr("class").replace(/\d+/g, r.next);
						parBrowse.attr("class", cl).css("visibility", "visible");
					}
				}
			}

			updateBtns();

			if (task === "seats_changed" && $(document).data("last_clicked_slot")){
				preConf($("click"), $(document).data("last_clicked_slot"));
			}

			WPB_Flex.exec();
			slider(task);

			/* Let qtip reload */
			r.parScodeId = parScode.attr("id");
			$(document).trigger("calendars_updated", r);

		}, "json");
	}

	if (_app_.is.lazyLoad) {
		updateCals("first_load");
	}

	/* Event listener to add tooltip to calendar cells after pagination clicks */
	$(document).on("calendars_updated", updateElements);

	/* Select location */
	$(document).on("change", ".app_select_locations", function() {
		if ($(this).parents(".app-edit-wrapper").length) {
			return false;
		}
		updateCals($(this));
		$(document).trigger("update-locations");
	});
	$(document).on("click", "li.app-location", function() {
		if (_app_.atCheckout) {
			return false;
		}
		$(document).data("location", $(this).data("location"));
		updateCals($(this));
		$(document).trigger("update-locations");
	});

	/* Select service */
	$(document).on("change", ".app_select_services", function() {
		if (_app_.atCheckout || $(this).parents(".app-edit-wrapper").length){
			return false;
		}
		updateCals($(this));
		$(document).trigger("update-services");
	});
	$(document).on("click", "li.app-service", function() {
		if (_app_.atCheckout) {
			return false;
		}
		$(document).data("service", $(this).data("service"));
		updateCals($(this));
		$(document).trigger("update-services");
	});

	/* Select duration */
	$(document).on("change",".app_select_durations",function() {
		if (_app_.atCheckout){
			return false;
		}
		updateCals($(this));
		$(document).trigger("update-durations");
	});

	/* Select provider */
	$(document).on("change", ".app_select_workers", function() {
		if ($(this).parents(".app-edit-wrapper").length) {
			return false;
		}
		updateCals($(this));
		$(document).trigger("update-workers");
	});
	$(document).on("click", "li.app-worker", function() {
		if (_app_.atCheckout) {
			return false;
		}
		$(document).data("worker", $(this).data("worker"));
		updateCals($(this));
		$(document).trigger("update-workers");
	});

	/* Select recurring appt repeat/repeat unit */
	$(document).on("change", ".app_select_repeat,.app_select_repeat_unit", function(){
		updateCals($(this));
	});

	/* Select seats */
	$(document).on("change", ".app_select_seats:not(.no-update-cals)", function(){
		updateCals($(this));
	});

	/* Select date */
	$.each($(".app_select_date"), function() {
		if (typeof $.fn.datepicker !== "function") {
			return false;
		}
		var $this = $(this);
		$this.datepicker({
			dateFormat: _app_.js_date_format,
			firstDay: _app_.start_of_week,
			maxDate: $this.data("maxdate") ? parseInt($this.data("maxdate")) : null,
			minDate: $.isNumeric($this.data("mindate")) ? $this.data("mindate") : null,
			changeMonth: true,
			changeYear: true,
			monthNamesShort: _app_.monthNamesShort,
			dayNamesMin: _app_.dayNamesMin,
			onSelect:function() {
				$("input.app_select_date").val($(this).val());
				$.infoPanel();
				var date1 = new Date();
				var offset = -60 * date1.getTimezoneOffset();
				_app_.selTS = parseInt($this.datepicker("getDate")/1000,10) + offset;
				updateCals($this);
			}
		});
	});

	/* Select user */
	$(document).on("change", ".app_select_users", function() {
		var $this = $(this);
		var sel_user = parseInt($this.val());
		var par = $(document).find(".app-conf-wrapper");
	    if (sel_user === 0) {
			$.each(par.find("input"), function () {
				$(this).val("");
			});
			$.each(par.find("select"), function () {
				$(this).find('option:first').prop('selected', 'selected');
			});
			return false;
		}

		if (sel_user === parseInt($this.data("current_user_id"))) {
			return false;
		}

		var bob_data = {
			wpb_ajax: true,
			action: "bob_update",
			ajax_nonce: _app_.nonce,
			app_user_id: sel_user
		};
		$.infoPanel();
		$.post(_app_.ajax_url, bob_data, function (r) {
			if ( r ) {
				if ( r.error ) {
					alert(r.error);
				} else if (r) {
					$.each(r, function(k, v) {
					  par.find(".app-"+k+"-field input").val(v);
					});
				}
			} else {
				alert(_app_.con_error);
			}
		}, "json");
	});

	/* Select credits */
	$(document).on("change", ".app_select_credits", function(){
		preConf($(this));
	});

	/* Clicking on any book button or cell */
	$(document).on( _app_.click_event || "click",
		".free.daily,.app-schedule-wrapper:not(.app-weekly-account) table td.free:not(.app_select_wh):not(.no-new-link)," +
		".app-schedule-wrapper:not(.app-weekly-account) table td.waiting,.app-timetable div.free:not(.app-disabled)," +
		" .app-timetable div.waiting,.app-book-now-button, .app-book-flex-button", function() {
			preConf($(this));
		}
	);

	/* Browse buttons */
	$(document).on("click", ".app-next a, .app-previous a", function(e) {
		e.preventDefault();
		if (_app_.atCheckout){
			return false;
		}
		var btn = $(this);
		btn.addClass("app-disabled-button");
		var par = btn.parent();
		var prev_clicked = par.hasClass("app-previous") ? 1 : 0;
		$(document).data("prev_clicked", prev_clicked);
		var arr = $(document).data("shift_register") || [];
		var temp = $("table.app-book").data("last_values") || [];
		if (!prev_clicked){
			arr.unshift(temp);
			$(document).data("shift_register", arr);
		}
		_app_.selTS = btn.data("tstamp") || par.attr("class").split(" ")[1];
		updateCals(btn);
		if (prev_clicked){
			arr.shift();
			$(document).data("shift_register", arr);
		}
		btn.removeClass("app-disabled-button");
	});

	/* Clicking monthly calendar day cell to bring timetable */
	function bringTT(_this, firstLoad) {
		if (_app_.atCheckout){
			return false;
		}
		var $this = _this || $(this);
		var par = $this.parents(".app-list");
		if (par.find(".app_blink").length > 0){
			return false;
		}

		par.find(".app-selected-day").removeClass("app-selected-day");
		$this.addClass("app-selected-day");

		var val = $this.find(".app-packed").val();
		var start = val.split("_")[0].toString();
		var cl = ".app_timetable_"+start;
		var wrap = $this.parents(".app-list").find(".app-timetable-wrapper");
		var ttable = wrap.find(cl);
		var parScode;

		if (ttable.length && _app_.is.cacheTTable) {
			wrap.find(".app-timetable").hide();
			ttable.slideDown("slow");
			if (!firstLoad) {
				goTo(wrap);
			}
			return false;
		}

		if ( typeof $this === "object" && $this.parents(".app-scode").length ) {
			parScode = $this.parents(".app-scode").first();
		} else {
			parScode = $(document.body);
		}

		$.infoPanel("preparing_timetable");

		$.post(_app_.ajax_url, {
			wpb_ajax: true,
			ajax_nonce: _app_.nonce,
			action: "bring_timetable",
			post_id: parseInt(_app_.post_id),
			display_mode: par.find(".app-monthly-wrapper").data("display_mode"),
			force_min_time: par.find(".app-monthly-wrapper").data("force_min_time"),
			app_value: val,
			app_service_id: parScode.find(".app_select_services option:selected").val(),
			app_duration: parScode.find(".app_select_durations option:selected").val(),
			app_repeat: parScode.find(".app_select_repeat option:selected").val(),
			app_repeat_unit: parScode.find(".app_select_repeat_unit option:selected").val(),
			app_repeat_unit_alt: parScode.find(".app_repeat_unit_alt").val(),
			app_seats: parScode.find(".app_select_seats option:selected").val()
		}, function(r){
			wrap.children().hide();
			if (r && r.seats) {
				var seatsDiv = parScode.find(".app_seats");
				seatsDiv.html(r.seats);
			}
			if (r && r.data) {
				var data = $(r.data);
				wrap.append(data);
				data.slideDown("slow");
				updateElements();
				if (!firstLoad) {
					goTo(wrap);
				}
			}
		}, "json");
	}

	/* Clicking monthly calendar day cell to bring timetable */
	$(document).on("click", ".app_day.free:not(.daily):not(.no-new-link),.app_day.waiting:not(.daily)", function() {
		if ( !$(this).parents(".app-monthly-account").length ) {
			bringTT($(this));
		}
	});

	/* Automatically open timetable on page load if today is free */
	function bringTTForToday(r) {
		if ( !_app_.is.autoOpenTTable ) {
			return false;
		}

		var par = (typeof r === "object" && typeof r.parScodeId === "string") ? $(document).find("#" + r.parScodeId) : $(document);

		var common = ":not(.daily):not(.notpossible)";
		var tsSelected = par.find(".app_day.ts-selected" + common);
		var day = $(document).data("last_selected_day");
		var lastSelected = day ? par.find(".free." + day + common) : false;
		var today = par.find(".app_day.today" + common);
		var firstFree = par.find(".app_day.first-free" + common);

		if (tsSelected.length) {
			bringTT(tsSelected.first(), true);
		} else if (lastSelected.length) {
			bringTT(lastSelected, true);
		} else if (today.length) {
			bringTT(today.first(), true);
		} else if (firstFree.length) {
			bringTT(firstFree.first(), true);
		}
	}
	bringTTForToday();

	$(document).on("calendars_updated", function(ignore, r) {
		bringTTForToday(r);
	});

	/* Determine if confirmation form 1 or 2 columns */
	function confFormLayout(){
		$.each($(document).find(".app-conf-wrapper"), function () {
			var chld = $(this).find(".app-conf-fields-gr1");
			if (!chld.hasClass("app-conf-fields-gr-auto")) {
				return false;
			}
			var width = $(this).innerWidth();
			var edge_width = chld.data("edge_width");
			if (width > edge_width) {
				chld.addClass("app_2column");
				chld.next().addClass("app_2column");
			}
			if ((width + 20) < edge_width) {
				chld.removeClass("app_2column");
				chld.next().removeClass("app_2column");
			}
		});
		refreshMS();
	}
	confFormLayout();
	$(document).on("app-conf-wrapper-opened", confFormLayout);
	$(window).resize(function() {
		clearTimeout($.data(this, 'resizeTimer'));
		$.data(this, 'resizeTimer', setTimeout(function() {
			confFormLayout();
		}, 500));
	});

	/* Cancel button - Refresh the page */
	$(document).on("click", ".app-conf-cancel-button", function() {
		var urlPar = ["app_empty_cart=1", "ajax_nonce=" + _app_.nonce];
		var confirmWrap = $("<div class='app-cancel-dialog-content' data-dialog='true' >" +
							_app_.cancel_confirm_text + "</div>");
		var editing = false;
		if ($(this).parents(".app-edit-wrapper").length){
			editing = true;
		}
		var w = window.innerWidth;
		var dwidth = 0;
		if (w > 600) {
			dwidth = 500;
		} else {
			dwidth= w - 30;
		}
		confirmWrap.dialog({
			resizable: false,
			width: dwidth,
			modal: _app_.is.modal,
			dialogClass: _app_.is.mobile ? "app-mobile app-no-title app-cancel-dialog" : "app-no-title app-cancel-dialog",
			hide: _app_.hideEffect,
			show: _app_.showEffect,
			buttons: [
				{text: _app_.cancel_confirm_yes,
					click: function() {
						if (!editing) {
							$.infoPanel("refreshing");
							window.location.href = buildUrl(urlPar);
						}
						$(this).dialog("destroy");
						$(".ui-dialog").each(function() {
							$(this).dialog().dialog("destroy").remove();
						});
						$(document).trigger("app-cancelled");
					}
				},
				{text: _app_.cancel_confirm_no,
					click: function() {
						$(this).dialog("destroy").remove();
					}
				}
			]
		});
	});

	/* Give an alert if a required field is missing */
	function fieldAlert($this){
		if ($this.hasClass("app-udf-checkbox") || $this.hasClass("app-select")){
			$this.parent().addClass("app-missing-field");
		} else {
			$this.addClass("app-missing-field");
		}
		$this.parents("label").addClass("ui-state-error");
		var h = window.innerHeight;
		var first_cl = $this.attr('class').split(" ")[0];
		first_cl = first_cl ? first_cl+'-warning' : '';
		// Special warning text for field, e.g. _app_.app-email-field-entry-warning
		var confirm_text = (first_cl && _app_[first_cl] !== undefined) ? _app_[first_cl] : _app_.warning_text;
		$.scrollTo( $this, { duration: 500, axis: "y", offset: -1*(parseInt(h/2)) + 100,
			onAfter:function() {
				openDialog({
					confirm_text:confirm_text,
					confirm_title:_app_.error_short,
					refresh:false,
					price:999,
					f_alert: true,
					no_dialog: _app_.is.noDialog
				});
			}
		});
		return false;
	}

	/* Build cart on first page load */
	function buildCart() {
		if (!_app_.cart_values.length){
			return false;
		}
		var cw = $(document).find(".app-conf-wrapper").first();
		if (!cw.length){
			return false;
		}
		var cart_data = readForm(cw);
		cart_data.value = _app_.cart_values;
		cart_data.action = "pre_confirmation_update";

		$.post(_app_.ajax_url, cart_data, function(r) {
			if (!r) {
				alert(_app_.con_error);
				return false;
			}
			if (r.error) {
				openDialog({
					confirm_text: r.error,
					confirm_title: _app_.error_short,
					refresh: false,
					price: 999
				});
			} else {
				preConfReply(r);
			}
		}, "json");
	}

	updateElements();
	startCountdown({});
	WPB_Flex.exec();
	buildCart();
	slider("first_load");

	/* Update price after seats field or workers or any select field or radio button change */
	$(document).on("change", ".app-seats-field-entry, .app_select_workers_conf," +
		".app-conf-wrapper select, .app-conf-wrapper input[type=radio], .app-conf-wrapper .app-update-price", function() {
			$(this).parents("label").removeClass("ui-state-error");
			updatePrice($(this));
	});

	/* Update price after coupon entered */
	$(document).on("blur", ".app-coupon-field-entry", function() {
		var $this = $(this);
		if ($this.val() || $(document).data("coupon_value_entered") ) {
			$(document).data("coupon_value_entered",true);
			updatePrice($this);
		}
	});

	/* A field set as price entry will trigger update price */
	$(document).on("blur", ".app-price-field-entry", function() {
		$(this).parents("label").removeClass("ui-state-error");
		updatePrice($(this));
	});

	/* In multiple bookings, when continue button is clicked scroll up to last click point */
	$(document).on("click", ".app-cont-btn", function() {
		if (!hasCart()){
			return false;
		}
		var lcs = $(document).data("last_clicked_slot");
		var target = lcs || $(".free:first");
		goTo(target);
	});

	/* In multiple bookings, delete selected booking */
	/* It can also be deleted by the clicked slot - see _app_.preConf */
	$(document).on("click", ".app-remove-cart-item", function() {
		var $this = $(this);
		if ($this.hasClass("removed")){
			return false;
		}
		if (_app_.preProcess){
			return false;
		}

		$.infoPanel();
		_app_.preProcess = true;
		var app_value = getValue();
		var net_val = $this.data("value");
		var index_ = app_value.indexOf(net_val);
		if (index_ > -1) {
			app_value.splice(index_,1);
		}
		if (app_value.length === 0) {
			disableButton();
		}

		var cw = $this.parents(".app-conf-wrapper");
		var pre_data = readForm(cw);
		pre_data.action = "pre_confirmation_update";
		pre_data.value = app_value;
		pre_data.deleted_value = net_val;
		setValue(app_value);

		var qtip_text = $this.qtip("option", "content.text");
		var new_content = String(qtip_text).replace(_app_.click_to_remove, _app_.removed);
		$this.qtip("option", "content.text", new_content);
		$this.parent().css("opacity", _app_.opacity).css("text-decoration", "line-through");
		$(document).find("input[value='" + net_val + "']").parent().css("opacity" ,1).parent("button").css("opacity" ,1);

		$.post(_app_.ajax_url, pre_data, function(r) {
			_app_.preProcess = false;
			if (r && !r.error) {
				if (r.unblocked){
					var slot;
					$.each(r.unblocked, function(ignore,v){
						slot = $( "[data-packed^='"+v+"']" );
						if (slot.hasClass("busy")) {
							slot.removeClass("busy app-selected").addClass("free");
						}
					});
				}

				if (r.disp_price){
					$(".app-disp-price").val(r.disp_price);
				}
				if (r.start) {
					$(".app-conf-start").html(r.start);
				}
				if (r.end) {
					$(".app-conf-end").html(r.end);
				}
				if (r.lasts) {
					$(".app-conf-lasts").html(r.lasts).show();
				}
				if (r.amount) {
					$(".app-conf-amount").html(r.amount);
				}
				if (r.price) {
					$(".app-conf-price").html(r.price).show();
				}
				if (r.deposit) {
					$(".app-conf-deposit").html(r.deposit);
				}
				$this.addClass("removed");
			} else if (r.error) {
				openDialog({
					confirm_text:r.error,
					confirm_title:_app_.error_short,
					refresh:false,
					price:999
				});
			} else {
				alert(_app_.con_error);
			}
		}, "json");
	});

	/* Show tooltip for gateway instructions */
	$.each($("div.app-payment-gateway-item"), function(ignore, val) {
		var $this = $(val);
		var gateway = $this.data("gateway");
		var title = $this.data("gateway_title");
		var tt = $.trim($(".app-"+gateway+"-instr").html());
		if (tt) {
			$this.qtip({
				content: {
					title: title,
					text: tt
				},
				hide: _app_.qtipHide,
				position: _app_.qtipPosTop,
				style: _app_.qtipNarrow
			});
		}
	});

	/* Select gateways */
	/* By clicking on the image */
	$(document).on("click", ".app-payment-gateway-item a", function() {
		$(this).parent().find("input:radio").attr("checked", "checked");
		if ($("input:radio[name=app_choose_gateway]:checked").val()) {
			enableButton();
		}
	});
	/* By checking the checkbox */
	$(document).on("change", "input:radio[name='app_choose_gateway']", function() {
		if ($(this).is(":checked")) {
			$(this).parents().find(".app_gateway_form").hide();
			var sel_gateway = $(this).val();
			$(this).parents().find("." + sel_gateway).show();
			var app_value = getValue();
			if (app_value.length > 0) {
				enableButton();
			}
		}
	});

	/**
	 * Handle Checkout - Post Confirmation
	 */
	var WPB_Post_Confirmation = {

		init: function(btn) {
			var me = this;
			var cw = btn.parents(".app-conf-wrapper");
			$(document).trigger("app-checkout-pre");

			me.check(cw);
		},

		/* Check if required user and udf fields filled */
		check: function(cw) {
			var me = this;
			var fields_filled = true;
			$.each(cw.find(".app-required:visible"), function() {
				var $this = $(this);
				$this.removeClass("app-missing-field");
				$this.parent().removeClass("app-missing-field");
				$this.parents("label").removeClass("ui-state-error");
				var type = $this.prop("type");
				if ("text" === type || "textarea" === type) {
					if ("" === $.trim($this.val())) {
						fieldAlert($this);
						fields_filled = false;
						return false;
					}
				} else if ("radio" === type || "checkbox" === type) {
					if (!$this.is(":checked")) {
						fieldAlert($this);
						fields_filled = false;
						return false;
					}
				} else if ($this.is("select")) {
					if (!$this.val()) {
						fieldAlert($this);
						fields_filled = false;
						return false;
					}
				}
			});
			if (!fields_filled) {
				return false;
			}

			var broken = false;
			$.each(_app_.user_fields, function(ignore, v) {
				$(this).removeClass("app-missing-field");
				$(this).parents("label").removeClass("ui-state-error");
				var field = cw.find(".app-" + v + "-field");
				var field_i = cw.find(".app-" + v + "-field-entry");
				var field_v = field_i.val();
				if (field.is(":visible") && $.trim(field_v) === ""){
					field_i.parents("label").addClass("ui-state-error");
					field_i.bind("focus", function() {
						$(this).parents("label").removeClass("ui-state-error");
					});
					fieldAlert(field_i);
					broken = true;
					return false;
				}
			});
			if (broken) {
				return false;
			}

			/* For plugins to hook */
			$(document).trigger("app-checkout-check", _app_.user_fields);

			setTimeout(function(){
				if ( $(document).data("app-checkout-external-error") ) {
					return false;
				}

				me.prepare(cw);
			}, 200 );
		},

		/* Disable button and show wait notices */
		prepare: function(cw) {
			var me = this;
			disableButton();
			$.infoPanel("booking");

			$(".app-conf-button").after("<span class='app_blink'>" + _app_.please_wait + "</span>");
			$(".app-conf-cancel-button").attr("disabled",true);
			$.each(cw.find(".app-missing-field"), function() {
				$(this).removeClass("app-missing-field");
				$(this).parents("label").removeClass("ui-state-error");
			});

			me.post(cw);
		},

		/* Make post request and handle reply */
		post: function(cw) {
			var me = this;

			var postData = readForm(cw);

			$.post(_app_.ajax_url, postData, function (r) {
				$(document).trigger("app-conf-dialog-before-open", r);
				$(".app-conf-cancel-button").attr("disabled",false);
				if (!r) {
					alert(_app_.con_error);
					return false;
				}
				if (r.error) {
					$(document).trigger("app-checkout-error", r);
					me.error(r, cw);
				} else {
					$(document).trigger("app-checkout", r);
					pauseCountdown();
					if (parseInt(r.refresh) === 1 || ( parseInt(r.price) === 0 && !r.wc && !r.edd)) {
						me.confirmed(r);
					} else {
						if (r.blocked){
							$.each(r.blocked, function(ignore,v){
								var slots = $(".app-packed[value="+v+"]").parents(".free");
								slots.removeClass("free").addClass("busy");
							});
						}
						if (r.form) {
							me.showForm(r);
						}

						if (r.wc > 0) {
							me.woocommerce(r);
						} else if (r.edd > 0) {
							me.edd(r);
						} else if (r.method === "stripe" || r.method === "paymill" || r.method === "simplify" || r.method === "2checkout") {
							if (r.step === "generate-token"){
								$.infoPanel("checkout");
								$(".app-conf-wrapper").trigger("app-execute-" + r.method);
							}
						} else if (r.method === "paypal-standard" || r.method === "paypal-express") {
							$.infoPanel("checkout");
							$(".app-" + r.method + "-form").submit();
						}
					}
				}
			}, "json");
		},

		/* Handle error reply */
		error: function(r, cw){
			$(".app_blink").remove();
			if (r.goTo){
				var target = cw.find("."+r.goTo);
				if (target) {
					target.addClass("app-missing-field");
					target.parents("label").addClass("ui-state-error");
					goTo(target);
				}
			}
			openDialog({
				confirm_text: r.error,
				confirm_title: r.confirm_title || _app_.error_short,
				refresh: false,
				price: 999,
				hide: _app_.hideEffect,
				show: _app_.showEffect
			});
			$(".app-disp-price").val(r.disp_price);
			if (r.price){
				$(".app-conf-price").html(r.price);
				$(".app-conf-price").fadeIn(500).fadeOut(500).fadeIn(500).fadeOut(500).fadeIn(500);
			}
			enableButton();
		},

		/* Handle dialog or message box display on confirmation */
		confirmed: function(r) {
			$(".app_blink").remove();
			if (!r.confirm_text && !_app_.is.mobile) {
				var msg = r.is_editing ? _app_.edited : _app_.received;
				alert(msg);
				refreshPage(r);
			} else {
				openDialog(r);
			}
		},

		/* Display payment/CC form */
		showForm: function(r){
			_app_.atCheckout = true;
			var cc_form = $(".app_gateway_form");
			cc_form.html(r.form);
			var cc_par = cc_form.parents(".app-conf-wrapper");
			cc_par.find("div").not(".app-conf-fields-gr,.app_gateway_form,.app_billing_line,.app_billing_line_inner,.app-conf-buttons,.app-no-hide").hide();
			cc_par.find("legend").text(_app_.cc_legend);
			cc_par.find(".app-conf-button .ui-button-text").html(r.f_amount);
			if (r.method === "paypal-standard" || r.method === "paypal-express") {
				cc_par.before("<span class='app_blink'>" + _app_.please_wait + "</span>");
				cc_par.css("visibility", "hidden");
				goTo($(".app_blink"));
			} else {
				$(".app_blink").remove();
				enableButton();
				cc_form.show();
				goTo(cc_form.find("input:visible:first"));
				$(document).trigger("app-cc-form-opened", r );
			}
			addSupMark();
		},

		/* Handle Woo reply */
		woocommerce: function(r) {
			$(".app_blink").remove();
			$(".app-conf-wrapper").hide();
			var wc_form = $(document).find(".variations_form");
			wc_form.find("input[name='variation_id'], input.variation_id").val(r.variation);
			$(document).find(".single_add_to_cart_button")
					   .removeClass("disabled wc-variation-selection-needed").click();
			if (r.refresh_url) {
				$.infoPanel("checkout");
				setTimeout(function() {
					refreshPage(r);
				}, 2000);
			} else {
				var target = $(".woocommerce.widget_shopping_cart").length > 0
							 ? $(".woocommerce.widget_shopping_cart")
							 : $(".app-sc").first();
				goTo(target);
			}
		},

		/* Handle EDD reply */
		edd: function(r) {
			$(".app_blink").remove();
			$(".app-conf-wrapper").hide();
			var edd_form = $(document).find(".edd_download_purchase_form.app_edd_form");
			edd_form.find(".edd-submit").data("price", r.price);
			edd_form.find(".app_price_id").val(r.price_id);
			edd_form.find(".edd-submit").click();
			if (r.refresh_url) {
				$.infoPanel("checkout");
				setTimeout(function() {
					refreshPage(r);
				}, 2000);
			}
		}
	};

	/* Trigger checkout - post confirmation */
	$(document).on("click",".app-conf-button", function() {
		var btn = $(this);
		if (btn.hasClass("app-disabled-button")){
			return false;
		}
		WPB_Post_Confirmation.init(btn);
	});

	/* Paypal Express - Move to confirmation */
	if ($.urlParam('app_ask_confirm') && 2 === parseInt($(".app_editing_value").val())) {
		$(".app-conf-fields-gr2").hide();
		goTo($(".app-conf-wrapper"));
	}

	/* Beautify Credit card input */
	$(document).on("keyup", "#card_num", function(){
		var me = $(this);
		if (me.val() === me.data("lastValue")) {
			return;
		}
		var caretPos = me.data("selStart");
		var sanVal = me.val().replace(/[^0-9]/gi, '');
		var parts = [];
		var i = 0;
		var len;
		var c;

		for (len = sanVal.length; i < len; i +=4) {
			parts.push(sanVal.substring(i, i + 4));
		}
		for (i = caretPos - 1; i>= 0; i = i - 1) {
			c = me.val()[i];
			if (c < "0" || c> "9") {
				caretPos = caretPos - 1;
			}
		}
		caretPos += Math.floor(caretPos / 4);

		var joined = parts.join(" ");
		me.data("lastValue", joined);
		me.val(joined);
		me.data("selStart", caretPos );
	});

	/* Hide empty widgets */
	$.each($(".widget_appointments_shortcode"), function(){
		if ($.trim($(this).text) === ""){
			$(this).css("display", "none");
		}
	});

	/* Monthly widget click to redirect */
	$("div.app_monthly_calendar_widget td.free").click( function () {
		var ts = $(this).find(".app-select-ts").val();
		var href = $(document).find(".app-monthly-widget").data("href");
		var service = $(document).find(".app-monthly-widget").data("service");
		var par = ["app_timestamp=" + ts, "app_service_id=" + service];
		if (href){
			window.location.href = href + "?" + par.join("&");
		} else {
			window.location.href = buildUrl(par);
		}
	});

	/* Countdown localization */
	$(function() {
		if (typeof $.fn.appCountdown === "function") {
			$.appCountdown.regionalOptions["wp-base"] = {
				labels: _app_.countdown_pl,
				labels1: _app_.countdown_sin,
				compactLabels: ["y", "m", "w", "d"],
				whichLabels: null,
				timeSeparator: ":",
				isRTL: _app_.is.rtl
			};
			$.appCountdown.setDefaults($.appCountdown.regionalOptions["wp-base"]);
		}
	});

	/* Divi Compatibility */
	(function() {
		if (!_app_.is.diviActive) {
			return false;
		}
		var et_sc = $(document).find(".app-sc");
		$.each(et_sc, function() {
			var et_par = $(this).parents("div[id^='et_']");
			$.each(et_par, function(){
				$(this).attr("id","");
			});
		});
	}());

	/* BuddyBoss Compatibility */
	(function() {
		var body = $("body.app-bp-bookings.buddyboss-theme");
		if (! body.length) {
			return false;
		}
		var par = $("#app-navbar.app-dash-navbar").parent();
		if (!par.length) {
			par = $("#subnav").parent();
		}
		par.addClass("app-bp-item-body-inner");
		var pos = par.css("position");
		if (pos === "static") {
			par.css("position", "relative");
		}

		if ( typeof $.fn.BossSocialMenu === "function" ) {
			$( "#bp-wpb-settings-personal-li" ).parent().BossSocialMenu( 35 );
		}
	}());

	/* Login */
	function createLogin ($me) {
		if ($("#app-login_links-wrapper").length) {
			$("#app-login_links-wrapper").remove();
		}
		$me.parents('.appointments-login').after('<div id="app-login_links-wrapper" />');
		var $root = $("#app-login_links-wrapper");
		var methods = _app_.login_methods;
		var fb_li =	($.inArray('Facebook', methods) > -1) ? '<li><a href="javascript:void(0)" class="app-login_link app-login_link-facebook">' + _app_.facebook + '</a></li>' : '';
		var tw_li =	($.inArray('Twitter', methods) > -1) ? '<li><a href="javascript:void(0)" class="app-login_link app-login_link-twitter">' + _app_.twitter + '</a></li>' : '';
		var google_li = ($.inArray('Google+', methods) > -1) ? (
			_app_.gg_client_id
			? '<li><span id="signinButton"> <span class="g-signin" data-callback="app_google_plus_login_callback" data-clientid="' + _app_.gg_client_id + '" data-cookiepolicy="single_host_origin" data-scope="profile email"> </span> </span></li>'
			: '<li><a href="javascript:void(0)" class="app-login_link app-login_link-google">' + _app_.google + '</a></li>') : '';
		var wp_li =	($.inArray('WordPress', methods) > -1) ? '<li><a href="javascript:void(0)" class="app-login_link app-login_link-wordpress">' + _app_.wordpress + '</a></li>' : '';
		$root.html(
			'<ul class="app-login_links">' +
				fb_li + tw_li + google_li + wp_li +
				'<li class="app_login_submit"><input type="text" class="app_username" placeholder="'+_app_.username+'"/>' +
				'<input type="password" class="app_password" placeholder="'+_app_.password+'"/>' +
				'<button class="app-login_link app-login_link-submit ui-button ui-btn ui-state-default">' + _app_.submit + '</button></li>' +
				'<li><button class="app-login_link app-login_link-cancel app-cancel-button ui-button ui-btn ui-state-default">' + _app_.cancel + '</button></li>' +
			'</ul>'
		);

		$.styleButtons();

		$root.find(".app-login_link").each( function () {
			var $lnk = $(this);
			var callback = false;
			if ($lnk.is(".app-login_link-facebook")) {
				// Facebook login
				callback = function () {
					FB.login(function (resp) {
						if (resp.authResponse) {
							$.infoPanel("logging_in");
							var user_id = resp.authResponse.userID;
							var token = resp.authResponse.accessToken;
							FB.api("/me", {fields: "name,email"}, function(response) {
								$.post(_app_.ajax_url, {
									"action": "app_facebook_login",
									"task": "front_end_login",
									"user_id": user_id,
									"token": token,
									"name": response.name,
									"email": response.email
								}, function (data) {
									var status = 0;
									try {
										status = parseInt(data.status);
									} catch(ignore) {
										status = 0;
									}
									if (!status) {
										$root.remove();
										return false;
									}
									if (data.status && data.status === 1) {
										$(".appointments-login_inner").text(_app_.logged_in);
										window.location.href = window.location.href;
										window.location.reload();
									} else {
										alert(_app_.con_error);
									}
								}, "json");
							});
						}
					}, {scope: 'email'});
					return false;
				};
			} else if ($lnk.is(".app-login_link-twitter")) {
				callback = function () {
					var twLogin = window.open('',
					"twitter_login",
					"scrollbars=no,resizable=no,toolbar=no,location=no,directories=no,status=no,menubar=no,copyhistory=no,height=400,width=600");
					twLogin.document.write(_app_.please_wait || "Please wait...");
					$.post(_app_.ajax_url, {
						"action": "app_get_twitter_auth_url",
						"post_id": _app_.post_id,
						"url": window.location.toString()
					}, function (data) {
						var href = data.url;
						_app_.twCback = function () {
							$(twLogin).off("unload", _app_.twCback);
							_app_.tTimer = setInterval( function () {
								try {
									if (twLogin.location.hostname === window.location.hostname) {
										clearInterval(_app_.tTimer);
										twLogin.close();
										var location = twLogin.location;
										var search = '';
										try {
											search = location.search;
										} catch (ignore) {
											search = "";
										}
										twLogin.close();
										$.infoPanel("logging_in");
										$.post(_app_.ajax_url, {
											"action": "app_twitter_login",
											"task": "front_end_login",
											"secret": data.secret,
											"data": search
										}, function (data) {
											var status = 0;
											try {
												status = parseInt(data.status, 10);
											} catch (ignore) {
												status = 0;
											}
											if (!status) {
												$root.remove();
												return false;
											}
											if (data.status && data.status === 1) {
												$(".appointments-login_inner").text(_app_.logged_in);
												window.location.href = window.location.href;
												window.location.reload();
											} else {
												alert(_app_.error);
											}
										}, "json");
									}
								} catch (ignore) {}
							}, 300);
						};
						$(twLogin).on("unload", _app_.twCback);
						twLogin.location = href;
					}, "json");
					return false;
				};
			} else if ($lnk.is(".app-login_link-google")) {
				callback = function () {
					var googleLogin = window.open('https://www.google.com/accounts',
					"google_login",
					"scrollbars=no,resizable=no,toolbar=no,location=no,directories=no,status=no,menubar=no,copyhistory=no,height=400,width=800"
					);
					$.post(_app_.ajax_url, {
						"action": "app_get_google_auth_url",
						"url": window.location.href
					}, function (data) {
						var href = data.url;
						googleLogin.location = href;
						_app_.gTimer = setInterval( function () {
							try {
								if (googleLogin.location.hostname === window.location.hostname) {
									clearInterval(_app_.gTimer);
									googleLogin.close();
									$.infoPanel("logging_in");
									$.post(_app_.ajax_url, {
										"action": "app_google_login",
										"task": "front_end_login"
									}, function (data) {
										var status = 0;
										try {
											status = parseInt(data.status);
										} catch (ignore) {
											status = 0;
										}
										if (!status) {
											$root.remove();
											$me.click();
											return false;
										}
										if (data.status && data.status === 1) {
											$(".appointments-login_inner").text(_app_.logged_in);
											window.location.href = window.location.href;
											window.location.reload();
										} else {
											alert(_app_.con_error);
										}
									});
								}
							} catch (ignore) {}
						}, 300);
					}, "json");
					return false;
				};
			} else if ($lnk.is(".app-login_link-wordpress")) {
				// Pass on to wordpress login
				callback = function () {
					$(".app_login_submit").show();
					return false;
				};
			} else if ($lnk.is(".app-login_link-submit")) {
				callback = function () {
					$(".app-error").remove();
					$.infoPanel("logging_in");
					$.post(_app_.ajax_url, {
							"action": "app_ajax_login",
							"task": "front_end_login",
							"log": $lnk.parents(".app_login_submit").find(".app_username").val(),
							"pwd": $lnk.parents(".app_login_submit").find(".app_password").val(),
							"rememberme": 1
						}, function (data) {
							var status = 0;
							try {
								status = parseInt(data.status);
							} catch (ignore) {
								status = 0;
							}
							if (!status) {
								$lnk.after("<div class='app-error'>" + data.error + "</div>");
								return false;
							}
							if (data.status && data.status === 1) {
								$(".appointments-login_inner").text(_app_.logged_in);
								window.location.href = window.location.href;
								window.location.reload();
							} else {
								alert(_app_.con_error);
							}
						}, "json"
					);
				};
			} else if ($lnk.is(".app-login_link-cancel")) {
				// Drop entire thing
				callback = function () {
					$root.remove();
					return false;
				};
			}
			if (callback) {
				$lnk
				.unbind('click')
				.bind('click', callback);}
		});
		if (_app_.gg_client_id && "undefined" !== typeof gapi && "undefined" !== typeof gapi.signin) {
			gapi.signin.go();
		}
	}

	function signinCallback(authResult) {
		if (authResult.status.signed_in) {
			$.post(_app_.ajax_url, {
				"action": "app_google_plus_login",
				"token": authResult.access_token
			}, function () {
				window.location.href = window.location.href;
				window.location.reload();
			}, "json");
		}
	}

	// Init Login
	$(function() {
		$(document).on("click", ".appointments-login_show_login", function(e){
			if (!_app_.is.pro) {
				return true;
			}
			if (parseInt(_app_.login_methods.length) >0){
				e.preventDefault();
				createLogin($(this));
				if (_app_.gg_client_id) {
					window.app_google_plus_login_callback = signinCallback;
					(function() {
						var po = document.createElement('script');
						po.type = 'text/javascript';
						po.async = true;
						po.src = 'https://apis.google.com/js/client:plusone.js';
						var s = document.getElementsByTagName('script')[0];
						s.parentNode.insertBefore(po, s);
					}());
				}
			} else {
				if (confirm(_app_.redirect)){
					window.location.href = _app_.login_url;
				} else {
					return false;
				}
			}

			return false;
		});

	});

    /**
     * Front End Edit
     */
	var WPB_FEE = {

		locked: false,

		/**
		 * Event listeners
		 */
		init: function () {
			var me = this;
			var appID = 0;

			var temp = $(document).find(".app-template-for-edit");
			if (temp && temp.length > 0) {
				appID = temp.data("app_id");
				me.openDialog(appID, false);
			}

			$(document).on("click", ".app-list-edit", function (e) {
				e.preventDefault();
				var $this = $(this);
				if ($this.hasClass("app-disabled-button")) {
					return false;
				}

				$this.addClass("app-disabled-button");
				$this.closest("tr").css("opacity",_app_.opacity);
				appID = $this.data("app_id");
				me.openDialog(appID, $this);
			});

			$(document).on( "change", ".app-edit-wrapper .app_select_locations, .app-edit-wrapper .app_select_services," +
			".app-edit-wrapper .app_select_workers, .app-edit-wrapper .app-edit-time, .app-edit-wrapper .app_select_seats", function () {
				me.update($(this));
			});

			$(document).on("app-cancelled", function(){
				$(".app-list-edit").closest("tr").css("opacity","1");
				$(".app-list-edit").removeClass("app-disabled-button");
			});
		},

		/**
		 * Open dialog with selected app_id
		 * @param appID integer Booking id
		 * @param btn	object	Clicked edit button
		 */
		openDialog: function (appID, btn) {
			var me = this;
			$.infoPanel("reading");
			var w = window.innerWidth;
			var dwidth = 0;
			if (w > 600) {
				dwidth = 600;
			} else {
				dwidth= w - 30;
			}

			me.locked = true;
			$(".app-edit-wrapper").remove();
			var cap = btn ? btn.data("cap") : "read";
			var edit_data = {
				action: "open_edit_dialog",
				wpb_ajax: true,
				app_id: appID,
				post_id: _app_.post_id,
				edit_nonce: _app_.edit_nonce,
				cap: cap,
				app_lang: _app_.lang,
				override: btn ? btn.data("override") : ""
			};
			var editWrap = $("<div class='app-fee-wrapper'></div>");

			$.post(_app_.ajax_url, edit_data, function(r) {
				$(document).trigger("app-edit-dialog-before-open");
				me.locked = false;
				if (r.error) {
					alert(r.error);
					if (btn) {
						btn.closest("tr").css("opacity","1");
					}
				} else if (r.success) {
					var $h = $(r.success);
					$h.find("fieldset").css("margin","0").css("box-sizing","border-box").css("border","none");
					$h.find("legend").remove();
					$h.find(".ui-icon").remove();
					if (r.show_these) {
						$.each(r.show_these, function(ignore, value) {
							$h.find(value).show();
						});
					}

					me.adjust($h);
					editWrap.html($h).dialog({
						closeOnEscape: false,
						dialogClass: "app-fee",
						width: dwidth,
						title: r.title,
						open: function(){
							$(".ui-dialog").find(".ui-dialog-titlebar-close").hide();
						},
						position: {
							my: "center top+50",
							at: "center top",
							of: window
						},
						draggable: true,
						modal: _app_.is.modal,
						hide: _app_.hideEffect,
						show: _app_.showEffect
					});
					editWrap.find(".blocked-days").data("blocked",r.dates);
					me.dPicker();
					$.styleButtons();
					$(document).trigger("app-edit-dialog-opened", r);
				} else {
					alert(_app_.con_error);
				}
			}, "json");
		},

		adjust: function($h) {
			$h = $h || $(document).find("div.app-edit-wrapper");
			var w = window.innerWidth;
			if ( w < 650 ) {
				$h.addClass("above-input");
			} else {
				$h.removeClass("above-input");
			}
		},

		dPicker: function () {
			if (typeof $.fn.datepicker !== "function") {
				return false;
			}
			var me = this;
			$.each($(".app-date-field-entry:not([readonly]), .app-edit-date:not([readonly])"), function () {
				var $this = $(this);
				var datelist = [];
				$this.datepicker({
					dateFormat: "yy-mm-dd",
					maxDate: $this.data("maxdate") ? $this.data("maxdate") : null,
					firstDay:_app_.start_of_week,
					beforeShowDay: function(date){
						if ($this.attr("readonly")){
							return false;
						}
						if ($this.hasClass("app-date-field-entry")){
							return [true];
						}
						datelist = $this.parents(".app-edit-wrapper").find(".blocked-days").data("blocked");
						var string = $.datepicker.formatDate("yy-mm-dd", date);
						return [$.inArray(string, datelist)>-1];
					},
					onSelect:function(){
						me.update();
					}
				});
			});
		},

		/**
		 * Update dialog fields when a selection has been changed
		 */
		update: function (elm) {
			var me = this;
			var $this = elm || $(".datepicker");
			var par = $this.parents(".app-edit-wrapper");
			var locWrap = par.find(".app-conf-loc");
			var servicesWrap = par.find(".app-conf-service");
			var workerWrap = par.find(".app-conf-worker");
			var startWrap = par.find(".app-conf-start");
			var startDdown = startWrap.find(".app-edit-date");
			var timeDdown = startWrap.find(".app-edit-time");
			var priceWrap = par.find(".app-conf-price");
			var data = readForm(par);
			var app_id = par.find(".app-edit-id").val();
			data.app_id = app_id;
			data.edit_nonce = _app_.edit_nonce;
			data.app_date = startDdown.val();
			data.app_start = timeDdown.val();
			data.action = "update_edit";
			$.infoPanel();

			$.post(_app_.ajax_url, data, function (r) {
				if (r.error) {
					alert(r.error);
				} else if (r) {
					locWrap.html(r.locs);
					servicesWrap.html(r.services);
					workerWrap.html(r.workers);
					timeDdown.html(r.times);
					priceWrap.html(r.price);
					par.find(".blocked-days").data("blocked",r.dates);
					me.dPicker();
					var dpicker_id = par.find(".datepicker").attr("id");
					par.find("#" + dpicker_id).datepicker("refresh");

					if (r.pax_options) {
						var $el = par.find("select.app_select_seats");
						$el.empty();
						$.each(r.pax_options, function(key, selected) {
							$el.append($("<option></option>").attr("value", key).text(key)
															 .attr("selected", !!parseInt(selected) > 0));
						});
					}

					if (r.pax_sel) {
						var lopno = 0;
						var fields = par.find(".app-lop-field");
						var min = r.pax_pot ? Math.min(r.pax_pot, r.pax_sel) : r.pax_sel;
						$.each(fields, function(){
							lopno = $(this).data("lopno");
							if (lopno <= min) {
								$(this).show();
							} else {
								$(this).hide();
							}
						});
					}
				} else {
					alert(_app_.con_error);
				}
			}, "json");
		}
	};
	WPB_FEE.init();
	$(window).on("resize", function() {
		WPB_FEE.adjust();
	});

	/**
	 * Resize all dialogs on the page upon window size change
	 */
	function resize_dialog() {
		var dlgs = $(document).find(".ui-dialog");
		$.each(dlgs, function() {
			var id = $(this).find(".ui-dialog-content").attr("id");
			var elem = $(document).find("#"+id);
			if (!elem.length || !elem.data().hasOwnProperty("uiDialog")) {
				return true;
			}

			if (!elem.data("width")) {
				elem.data("width", elem.dialog("option", "width"));
			}

			var wWidth = $(window).width();
			var setWidth = Math.min(wWidth * 0.8, elem.data("width"));

			// check & set width
			if ((elem.data("width")) > wWidth || elem.hasClass("resizedW")) {
				elem.dialog("option", "width", setWidth).parent().css("max-width", "none");
				elem.addClass("resizedW");
			}

			// only recenter & add overflow if dialog has been resized
			if (elem.hasClass("resizedW")) {
				elem.position("of", window);
				elem.css("overflow", "auto");
			}
		});
	}
	$(window).on("resize", function() {
		resize_dialog();
	});

	$(document).trigger("app-front-loaded");

});
