/*jslint browser: true, devel: true, for:true, this:true */
/*global jQuery, window, _app_, pagenow, CodeMirror, SignaturePad, wp */
jQuery(document).ready( function ($) {
"use strict";

	function init(){
		/* Set qtip viewport */
		_app_.qtipPos.viewport = $(window);
		_app_.qtipPosLeft.viewport = $(window);
		_app_.qtipPosBottom.viewport = $(window);
		_app_.qtipPosTop.viewport = $(window);
		return;
	}
	init();
	
	if (_app_.is.mobile) {
		$.fn.qtip = function() {
			return $.fn.qtip;
		};
	}

	/* Remove # from url so that page can be refreshed */
	$.locationUrl = function() {
		var loc = window.location.href;
		var index = loc.indexOf("#");
		if (index > 0) {
			loc = loc.substring(0, index);
		}
		return String(loc);
	}
	
	/* Read $_GET url parameter */
	/* https://stackoverflow.com/a/39768285 */
	$.urlParam = function(name){
		return String(location.search.split( name + "=")[1] || "").split("&")[0];
	};

	/* Read hash of the current url */
	$.readHash = function(){
		return String(location.hash);
	};

	/* Catch $_GET vars
	 * http://stackoverflow.com/a/1586333
	 */
	$.readGet = function (name) {
		var part = name;
		var parts = String(window.location.search.substr(1)).split("&");
		var get = {};
		var i;
		var temp;
		for (i = 0; i < parts.length; i = i + 1) {
			temp = parts[i].split("=");
			get[decodeURIComponent(temp[0])] = decodeURIComponent(temp[1]);
		}
		return get[part];
	};

	/* http://phpjs.org/functions/wpb_number_format/ */
	$.numFormat = function(number) {
        var decimals = 2;
		if (parseInt(_app_.curr_decimal) === 0) {decimals=0;}

		number = String(number).replace(/[^0-9+\-Ee.]/g, "");
		var n = !Number.isFinite(Number(number)) ? 0 : Number(number);
		var prec = !Number.isFinite(Number(decimals)) ? 0 : Math.abs(decimals);
		var sep = _app_.thousands_sep;
		var dec = _app_.decimal_sep;
		var s = "";
        var str = "";
		var toFixedFix = function (n, prec) {
			var k = Math.pow(10, prec);
			return Number(Math.round(n * k) / k).toFixed(prec);
		};

        str = prec ? toFixedFix(n, prec) : String(Math.round(n));
		s = str.split(".");
		if (s[0].length > 3) {
			s[0] = s[0].replace(/\B(?=(?:\d{3})+(?!\d))/g, sep);
		}
		if (parseInt(s[1] || "").length < prec) {
			s[1] = s[1] || "";
			var arr = [];
			s[1] += arr(prec - s[1].length + 1).join("0");
		}
		return s.join(dec);
	};

	/* Close info panel */
	$.closePanel = function() {
		$(".app-compact-book-wrapper, .app-wrap").css("opacity",1);
		$('div.app-updating-panel').find(".app-updating").text(_app_.done);
		$.unblockUI({ fadeOut: 700 });
	};
	$(document).ajaxStop($.closePanel);

	/* Open info panel */
	$.infoPanel = function(task){
		if (!task || "first_load" === task || "browse" === task) {
			$(".app-compact-book-wrapper, .app-wrap").css("opacity",_app_.opacity);
			if ( "first_load" === task ) {
				return false;
			}
		}

		var msg = ( task && _app_[task] ) ? _app_[task] : _app_.updating_text;
		var is_checkout = task === "booking";
		var panel = $("div#app-updating-panel");
		if (!panel.length) {
			return false;
		}
		
		panel.find(".app-updating").text(msg);

		$.blockUI.defaults.css = {};
		$.blockUI.defaults.themedCSS = {
			width: "auto",
			top: "50%",
			left: "50%",
			right: "initial",
			overflow: "initial",
			"-ms-transform": "translate(-50%, -50%)",
			"-webkit-transform": "translate(-50%, -50%)",
			"transform": "translate(-50%, -50%)"
		};
		if(!$(".blockUI").length) {
			$.blockUI({
				blockMsgClass: "app-blockUI",
				message: panel,
				fadeIn: 200,
				fadeOut: 700,
				theme: is_checkout,
				showOverlay: is_checkout,
				centerY: is_checkout,
				ignoreIfBlocked: true
			});
		}
	};

	/* Add icons to buttons */
	$.styleButtons = function () {
		$(document).on({
			mouseenter: function () {
				$(this).addClass("ui-state-hover");
			},
			mouseleave: function () {
				$(this).removeClass("ui-state-hover");
			}
		}, ".ui-button");

		$(".app-book-now-button").button({
		  icons: { primary: "ui-icon-cart" }
		}).qtip();
		$(".app-conf-cancel-button").button({
		  icons: { primary: "ui-icon-cancel" }
		});
		$(".app-list-cancel").button({
		  icons: { primary: "ui-icon-trash" }
		});
		$(".app-list-confirm").button({
		  icons: { primary: "ui-icon-circle-check" }
		});		
		$(".app-list-pay").button({
		  icons: { primary: "ui-icon-contact" }
		});		
		$(".app-conf-button").button({
		  icons: { primary: "ui-icon-check" }
		});
		$(".app-cont-btn").button({
		  icons: { primary: "ui-icon-arrowreturnthick-1-n" }
		});
		$(".app-list-edit.ui-button").button({
		  icons: { primary: "ui-icon-pencil" }
		});
		$(".app-pdf-button.ui-button").button({
		  icons: { primary: "ui-icon-document" }
		});
		$(".ui-button")
		.addClass("ui-state-default ui-shadow ui-btn-" + _app_.swatch)
		.qtip({style:_app_.qtipDef});
	};

	if (typeof $.fn.datepicker === "function") {
		$.each($(".app-date-field-entry"), function() {
			var $this = $(this);
			$this.datepicker({
				dateFormat: _app_.js_date_format,
				firstDay: _app_.start_of_week,
				maxDate: $this.attr("data-maxdate")
						? $this.data("maxdate")
						: null,
				changeMonth: true,
				changeYear: true,
				monthNamesShort: _app_.monthNamesShort,
				dayNamesMin: _app_.dayNamesMin
			});
		});
	}

	/**
	* Common for Admin and Front
	*/
	var WPB_Common = {
		init: function(){
			this.doBind();
			this.sigPad();
		},
		doBind: function(){
			var me = this;
			$(document).on("click", ".app-disabled-button", function (e) {
				me.disableButton(e);
			});

            $(document).on("click", ".app-open-terms", function (e) {
                me.openTermsDialog(e);
            });

		},
		disableButton: function(e){
			e.preventDefault();
			return false;
		},

        /**
         * Open terms & conditions dialog
         */
        openTermsDialog: function () {
            var w = window.innerWidth;
            var dwidth = w - 30;
            if (w > 950) {
                dwidth = 950;
            }
            $("<div></div>").html($(".app-terms-text").html()).dialog({
                width: dwidth,
                title: $(".app-terms-title").text(),
                position: {my: "center top-50", at: "center top", of: window, collision: "none"},
                modal: _app_.is.modal,
                classes: {"ui-dialog": "app-terms"},
                dialogClass: "app-terms",
                buttons: [
                    {text: _app_.close || "Close",
                            click: function () {
                        $(this).dialog("close");
                    }}
                ]
            });
        },
		
		/**
		* Read signature
		*/
		sigPad: function(){
			if ( typeof SignaturePad !== "function" && typeof SignaturePad !== "object" ){
				return;
			}
			var wrapper = document.getElementById("signature-pad");
			if ( !$(wrapper).length ) {
				return false;
			}
			
			var clearButton = wrapper.querySelector("[data-action=clear]");
			var canvas = wrapper.querySelector("canvas");
			var sig_val = $(document).find("#signature-pad input.app-signature-value").val();
			$.sPad = new SignaturePad(canvas, {
				backgroundColor: 'rgb(255, 255, 255)',
				onEnd: function(){
					$(wrapper).data("signature", $.sPad.toData());
				}
			});

			$.sPad.fromData(sig_val);

			function resizeCanvas() {
				var ratio =  Math.max(window.devicePixelRatio || 1, 1);
				canvas.width = canvas.offsetWidth * ratio;
				canvas.height = canvas.offsetHeight * ratio;
				canvas.getContext("2d").scale(ratio, ratio);
				$.sPad.clear();
				var sigData = $(wrapper).data("signature");
				if ( sigData ) {
					$.sPad.fromData( sigData );
				}
			}
			window.onresize = resizeCanvas;
			resizeCanvas();
			
			$(document).on("app-conf-wrapper-opened", function(){
				resizeCanvas();
			});

			clearButton.addEventListener("click", function () {
			  $.sPad.clear();
			  $(wrapper).data("signature", null);
			});

			$(document).on("app-checkout-pre", function(){
				var dataURL = $.sPad.toDataURL();
				$(document).find("#signature-pad input.app-signature-value").val(dataURL);
			});
		}
	};

	WPB_Common.init();


	/**
	 * Arrange List of Bookings and app-list table
	 */
	var WPB_List = {
		init: function() {
			var me = this;
			$.extend( $.fn.dataTableExt.oJUIClasses, {
				"sFilterInput": "ui-toolbar ui-state-default app-no-save-alert app-w-select",
				"sLengthSelect": "ui-toolbar ui-state-default app-no-save-alert"
			});
			$.fn.dataTable.moment( _app_.moment_format, _app_.locale );
			
			var tbl = $("table.app-list");
			var dt = tbl.DataTable(me.args(tbl));
			this.dt_api = dt;
			$(document).find(".fg-toolbar").removeClass("ui-widget-header");
			dt.on("draw.dt", function () {
				$.styleButtons();
			});
			
			$(".app_save_profile_submit").click(function (e) {
				me.ratesSubmit(e);
			});

			$(document).on( "click", ".app-list button.app-list-cancel", function(e) {
				var $this = $(this);
				if ($this.hasClass("app-disabled-button")) {
					return false;
				}
				e.preventDefault();
				$this.addClass("app-disabled-button");
				$this.closest("tr").css("opacity", "0.3");
				var r = window.confirm(_app_.cancel_app_confirm);
				if ( !r ) {
					$this.removeClass("app-disabled-button");
					$this.closest("tr").css("opacity", "1");
				} else {
					me.cancel($this);
				}
			});
			
			$(document).on( "click", ".app-list button.app-list-confirm", function(e) {
				var $this = $(this);
				if ($this.hasClass("app-disabled-button")) {
					return false;
				}
				e.preventDefault();
				$this.addClass("app-disabled-button");
				$this.closest("tr").css("opacity", "0.3");
				var r = window.confirm(_app_.confirmConfirm);
				if ( !r ) {
					$this.removeClass("app-disabled-button");
					$this.closest("tr").css("opacity", "1");
				} else {
					me.confirm($this);
				}
			});			
			
			$(document).on( "click", ".app-list button.app-list-pay", function(e) {
				var $this = $(this);
				if ($this.hasClass("app-disabled-button")) {
					return false;
				}
				e.preventDefault();
				$this.addClass("app-disabled-button");
				$this.closest("tr").css("opacity", "0.3");
				window.location.href = $this.data("href");
			});			
		},
		
        /**
         * Let hidden fields to be submitted
         */
        ratesSubmit: function (e) {
			e.preventDefault();
            var $this = $(e.target);
            var par = $this.parents("form");
            // Submit hidden fields
            // https://datatables.net/plug-ins/api/fnGetHiddenNodes
            var nodes;
            var display = par.find('tbody tr');
            nodes = this.dt_api.rows().nodes().toArray();
            /* Remove nodes which are being displayed */
            var i = 0;
            var iIndex = 0;
            for (i = 0; i < display.length; i = i + 1) {
                iIndex = $.inArray(display[i], nodes);

                if (iIndex !== -1) {
                    nodes.splice(iIndex, 1);
                }
            }
            par.find(".app_rates_hidden").append(nodes);
            par.submit();
        },
		
		/* DataTable arguments */
		args: function(tbl) {
			return {
				"bAutoWidth": true,
				"initComplete": $.styleButtons(),
				"fnInitComplete": function () {
					tbl.css({opacity: 0.0, visibility: "visible"}).animate({opacity: 1.0});
					var s = $.readGet('app_s');
					var filter = $(".dataTables_filter input");
					filter.attr("placeholder", _app_.search).val(s);
					if (s) {
						filter.trigger("keyup");
					}
				},
				"lengthMenu": [ [10, 25, 50, 100, -1], [10, 25, 50, 100, _app_.all] ],
				"pageLength": tbl.data("page_length") || _app_.page_length || 10,
				"responsive": true,
				"aaSorting": [ ],
				"bJQueryUI": true,
				"aoColumnDefs" : [ {
					"bSortable" : false,
					"aTargets" : [ 
						"app-list-gcal-header",
						"app-list-confirm-header",
						"app-list-edit-header",
						"app-list-cancel-header", 
						"app-list-pdf-header" 
					]
				} ],
				"language": {
					"info": _app_.info,
					"emptyTable": _app_.no_appointments,
					"paginate": {
					  "next": _app_.next,
					   "previous": _app_.previous
					},
					"search": "",
					"lengthMenu": _app_.length_menu
				}
			};
		},
		
		/* Handle cancel */
		cancel: function ($this) {
			var cancel_id = $this.data("app_id");
			if (!cancel_id) {
				return false;
			}
			
			$.infoPanel();
			
			var cancel_data = {
				action: "cancel_app", 
				app_id: cancel_id, 
				cancel_nonce: _app_.cancel_nonce, 
				args: $this.parents("table.app-list").data("args")
			};
			$.post(_app_.ajax_url, cancel_data, function(r) {
				$this.closest("tr").css("opacity", "1");
				if (!r) {
					alert(_app_.con_error);
					return false;
				}
				if (r.error ) {
					alert(r.error);
				} else if (r.success) {
					alert(_app_.cancelled);
					window.location.href = window.location.href;
				}
			}, "json");
		},
		
		/* Handle confirm */
		confirm: function ($this) {
			var confirm_id = $this.data("app_id");
			if (!confirm_id) {
				return false;
			}
			
			$.infoPanel();
			
			var confirm_data = {
				action: "confirm_app", 
				app_id: confirm_id, 
				confirm_nonce: _app_.confirm_nonce, 
				args: $this.parents("table.app-list").data("args")
			};
			$.post(_app_.ajax_url, confirm_data, function(r) {
				$this.closest("tr").css("opacity", "1");
				if (!r) {
					alert(_app_.con_error);
					return false;
				}
				if (r.error ) {
					alert(r.error);
				} else if (r.success) {
					alert(_app_.confirmed_message);
					window.location.href = window.location.href;
				}
			}, "json");
		},

		/* Show children in qtip */
		qtip: function () {
			$(".app-list-service-name").qtip({
				overwrite: true,
				content: {
					text: function(ignore, api) {
						api.elements.content.html(_app_.please_wait);
						return $.ajax({
							url: _app_.ajax_url,
							type: "POST",
							dataType: "json",
							data: {
								wpb_ajax: true,
								app_id: $(this).data("app_id"),
								args: $(this).parents("table.app-list").data("args"),
								action: "app_show_children_in_tooltip"
							}
						})
						.then(function(res) {
							var content = res.result;
							return content;
						}, function(ignore, status, error) {
							api.set("content.text", status + ": " + error);
						});
					}
				},
				hide: _app_.qtipHide,
				position: _app_.qtipPos,
				style: _app_.qtipSmall
			});			
		}
	};

	WPB_List.init();
	
	$(document).on("app-client-record-opened", function(){
		WPB_List.init();
	});
	
	$(document).on("click", ".app-become-vendor", function(e){
		e.preventDefault();
		var $this = $(this);
		$this.addClass("app-disabled-button");
		var r = window.confirm(_app_.confirm_vendor);

		if ( !r ) {
			$this.removeClass("app-disabled-button");
		} else {
			$.infoPanel();
			
			var data = {
				action: "app_become_vendor", 
				user_id: $this.data("user_id"), 
				confirm_nonce: _app_.confirm_nonce 
			};
			$.post(_app_.ajax_url, data, function(r) {
				if (!r) {
					$this.removeClass("app-disabled-button");
					alert(_app_.con_error);
					return false;
				}
				if (r.error ) {
					alert(r.error);
				} else if (r.success) {
					alert(r.success);
				}					
			}, "json");				
		}
	});

	$(document).on("click",".app-remove-image", function(){
		var $this = $(this);
		var par = $this.parents(".app-image-upload").first();
		var pholder = par.find(".pholder_img").val();
		
		par.find(".app-main-image").attr("src", pholder);
		par.find(".app-main-avatar").attr("src", pholder);
		par.find(".criteria-image-url").val("");
		par.find(".criteria-image-id").val("");
		$this.addClass("has-pholder");
	});

	var imgUploader;

	$(document).on('click','.app-upload-file-btn,.app-upload-image-btn', function(e) {
		e.preventDefault();

		var btn = $(this);
		var par = btn.parents("tr").first();
		
		imgUploader = wp.media.frames.file_frame = wp.media({
			title: _app_.choose_image,
			button: {
				text:  _app_.choose_image
			},
			multiple: false,
			library: {
				type: 'image'
			}
		});

		imgUploader.open();

		imgUploader.on('select', function() {
			var attachment = imgUploader.state().get('selection').first().toJSON();
			var url = attachment.url;
			var attachId = attachment.id;
			
		   par.find( "img.app-main-image" ).attr({
				src: url
			});
		   par.find( "img.app-main-avatar" ).attr({
				src: url
			});
			par.find( ".criteria-image-url" ).val(url);
			
			par.find( ".criteria-image-id" ).val(attachId);
			
			par.find( ".app-remove-image" ).removeClass("has-pholder");
		});

	});

});

/*
 * jQuery UI MultiSelect Widget 3.0.0pre
 * Copyright (c) 2012 Eric Hynds
 *
 * Depends:
 *   - jQuery 1.8+                          (http://api.jquery.com/)
 *   - jQuery UI 1.11 widget factory   (http://api.jqueryui.com/jQuery.widget/)
 *
 * Optional:
 *   - jQuery UI effects
 *   - jQuery UI position utility
 *
 * Dual licensed under the MIT and GPL licenses:
 *   http://www.opensource.org/licenses/mit-license.php
 *   http://www.gnu.org/licenses/gpl.html
 *
 */
(function($, _app_) {
   
   var multiselectID = 0;

   
   
   var linkDefaults = {
      'open': {
         'class': 'ui-multiselect-open',
         'icon': '<span class="ui-icon ui-icon-triangle-1-s"></span',
         'title': 'Open'
      },
      'close': {
         'class': 'ui-multiselect-close',
         'icon': '<span class="ui-icon ui-icon-circle-close"></span>',
         'title': 'Close'
      },
      'checkAll': {
         'class': 'ui-multiselect-all',
         'icon': '<span class="ui-icon ui-icon-check"></span>',
         'text': _app_.checkAll || 'Check all',
         'title': _app_.checkAll || 'Check all'
      },
      'uncheckAll': {
         'class': 'ui-multiselect-none',
         'icon': '<span class="ui-icon ui-icon-closethick"></span>',
         'text': _app_.uncheckAll || 'Uncheck all',
         'title': _app_.uncheckAll || 'Uncheck all'
      },
      'flipAll': {
         'class': 'ui-multiselect-flip',
         'icon': '<span class="ui-icon ui-icon-arrowrefresh-1-w"></span>',
         'text': 'Flip all',
         'title': 'Flip all'
      },
      'collapse': {
         'icon': '<span class="ui-icon ui-icon-minusthick"></span>',
         'title': 'Collapse'
      },
      'expand': {
         'icon': '<span class="ui-icon ui-icon-plusthick"></span>',
         'title': 'Expand'
      },
      'collapseAll': {
         'class': 'ui-multiselect-collapseall',
         'icon': '<span class="ui-icon ui-icon-minus"></span>',
         'text': 'Collapse all',
         'title': 'Collapse all'
      },
      'expandAll': {
         'class': 'ui-multiselect-expandall',
         'icon': '<span class="ui-icon ui-icon-plus"></span>',
         'text': 'Expand all',
         'title': 'Expand all'
      }
   };

   $.widget("ech.multiselect", {

   
   options: {
      buttonWidth: 225,                 
      menuWidth: null,                    
      menuHeight: _app_.menuHeight || 'auto', 
      resizableMenu: false,               
      appendTo: null,                     
      position: {},                       
      zIndex: null,                       
      classes: '',                        
      header: ['checkAll','uncheckAll'],  
      linkInfo: null,                     
      noneSelectedText: 'Select', 		
      selectedText: '# of # selected',    
      selectedList: 3,                    
      selectedListSeparator: ', ',        
      maxSelected: null,                  
      openEffect: null,                   
      closeEffect: null,                  
      autoOpen: false,                    
      htmlText: [],                       
      wrapText: ['button','header','options'],  
      listbox: false,                     
      addInputNames: true,                
      disableInputsOnToggle: true,        
      groupsSelectable: true,             
      groupsCollapsable: false,           
      groupColumns: false                 
    },

    
    _getAppendEl: function() {
      var elem = this.options.appendTo;         

      if (elem) {                               
        elem = !!elem.jquery ? elem : ( !!elem.nodeType ? $(elem) : this.document.find(elem).eq(0) );
      }
      if (!elem || !elem[0]) {
        elem = this.element.closest('.ui-front, dialog');
      }
      if (!elem.length) {
        elem = $(document.body);                 
      }
      return elem;
    },

   
   _create: function() {
      var $element = this.element;
      var elSelect = $element[0];
      var options = this.options;
      var classes = options.classes;

      
      var linkInfo = ( this.linkInfo = $.extend(true, {}, linkDefaults, options.linkInfo || {}) );

      
      this._selectWidth = $element.outerWidth();
      $element.hide();

      
      options.htmlText = options.htmlText || [];
      var wrapText = ( options.wrapText = options.wrapText || [] );

      
      this.speed = $.fx.speeds._default;
      this._isOpen = false;

      
      
      this._namespaceID = this.eventNamespace;
      
      this.multiselectID = multiselectID++;

      if (!options.listbox) {
         
         var $button = ( this.$button = $( document.createElement('button') ) )
               .addClass('ui-multiselect ui-widget ui-state-default ui-corner-all'
                           + (wrapText.indexOf('button') > -1 ? '' : ' ui-multiselect-nowrap' )
                           + (classes ? ' ' + classes : '')
                           )
               .attr({
                 'type': 'button',
                 'title': elSelect.title,
                 'tabIndex': elSelect.tabIndex,
                 'id': elSelect.id ? elSelect.id  + '_ms' : null
               })
               .prop('aria-haspopup', true)
               .html( this._linkHTML('<span class="{{class}}" title="{{title}}">{{icon}}</span>', 'open') );

         this.$buttonlabel = $( document.createElement('span') )
               .html(options.noneSelectedText || $element[0].placeholder)
               .appendTo( $button );
      }

      
      
      var headerLinksHTML = '';
      if (!options.header) {}  
      else if (typeof options.header === 'string') {
         headerLinksHTML = '<li>' + options.header + '</li>';
      }
      else if (options.header.constructor == Array) {
         for (var x = 0, len = options.header.length; x < len; x++) {
            var linkInfoKey = options.header[x];
            if ( linkInfoKey && linkInfoKey in this.linkInfo
               && !(options.maxSelected && linkInfoKey === 'checkAll')
               && ['open','close','collapse','expand'].indexOf(linkInfoKey) === -1 ) {
                  headerLinksHTML += this._linkHTML('<li><a class="{{class}}" title="{{title}}">{{icon}}<span>{{text}}</span></a></li>', linkInfoKey);
            }
         }
      }

      this.$headerLinkContainer = $( document.createElement('ul') )
            .addClass('ui-helper-reset')
            .html( headerLinksHTML
                  + ( !options.listbox
                     ? this._linkHTML('<li class="{{class}}"><a class="{{class}}" title="{{title}}">{{icon}}</a></li>', 'close')
                     : '' ) );

      
      var $header = ( this.$header = $( document.createElement('div') ) )
            .addClass('ui-multiselect-header ui-widget-header ui-corner-all ui-helper-clearfix')
            .append( this.$headerLinkContainer );

      
      var $checkboxes = ( this.$checkboxes = $( document.createElement('ul') ) )
            .addClass('ui-multiselect-checkboxes ui-helper-reset' + (wrapText.indexOf('options') > -1 ? '' : ' ui-multiselect-nowrap'));

      
      var $menu = ( this.$menu = $( document.createElement('div') ) )
            .addClass('ui-multiselect-menu ui-widget ui-widget-content ui-corner-all'
                      + (elSelect.multiple ? '' : ' ui-multiselect-single')
                      + (!options.listbox ? '' : ' ui-multiselect-listbox')
                      + (classes ? ' ' + classes : ''))
            .append($header, $checkboxes);

      if (!options.listbox) {
         $button.insertAfter($element);
         var $appendEl = this._getAppendEl();
         $appendEl.append($menu);
         
         if ( !options.zIndex && !$appendEl.hasClass('ui-front') ) {
            var $uiFront = this.element.closest('.ui-front, dialog');
            options.zIndex = Math.max( $uiFront && parseInt($uiFront.css('z-index'), 10) + 1 || 0,
                                                   $appendEl && parseInt($appendEl.css('z-index'), 10) + 1 || 0);
         }

         if (options.zIndex) {
            $menu.css('z-index', options.zIndex);
         }
         
         options.position = $.extend({'my': 'left top', 'at': 'left bottom', 'of': $button}, options.position || {});
      }
      else {
         $menu.insertAfter($element);  
      }
	  
      this._bindEvents();

      
      this.refresh(true);
   },

    
   _linkHTML: function(linkTemplate, linkID) {
      var self = this;
      return linkTemplate.replace(/{{(.*?)}}/ig, function(m, p1){ return self.linkInfo[linkID][p1] } )
                                 .replace('<span></span>', '');
   },

    
    _init: function() {
      var elSelect = this.element[0];

      if (this.options.header !== false) {
         this.$headerLinkContainer
              .find('.ui-multiselect-all, .ui-multiselect-none, .ui-multiselect-flip')
              .toggle( !!elSelect.multiple );
      }
      else {
         this.$header.hide();
      }

      if (this.options.autoOpen && !this.options.listbox) {
        this.open();
      }

      if (elSelect.disabled) {
        this.disable();
      }
    },

    
   _makeOption: function(option) {
      var self = this;
      var title = option.title || null;
      var elSelect = self.element.get(0);
      
      var id = elSelect.id || self.multiselectID;
      var inputID = 'ui-multiselect-' + self.multiselectID + '-' + (option.id || id + '-option-' + self.inputIdCounter++);
      
      var isMultiple = elSelect.multiple;
      var isDisabled = option.disabled;
      var isSelected = option.selected;

      var input = document.createElement('input');
      var inputAttribs = {
        "type": isMultiple ? 'checkbox' : 'radio',
        "id": inputID,
        "title": title,
        "value": option.value,
        "name": self.options.addInputNames ? "multiselect_" + id : null,
        "checked": isSelected ? "checked" : null,
        "aria-selected": isSelected ? "true" : null,
        "disabled": isDisabled ? "disabled" : null,
        "aria-disabled": isDisabled ? "true" : null
      };
      for (var name in inputAttribs) {
        if (inputAttribs[name] !== null) {
          input.setAttribute(name,inputAttribs[name]);
        }
      }
      
      var optionAttribs = option.attributes;
      var len = optionAttribs.length;
      for (var x = 0; x < len; x++) {
        var attribute = optionAttribs[x];
        if ( /^data\-.+/.test(attribute.name) ) {
          input.setAttribute(attribute.name, attribute.value);
        }
      }

      
      var span = document.createElement('span');
      if ( self.options.htmlText.indexOf('options') > -1 ) {
        span.innerHTML = option.innerHTML;
      }
      else {
        span.textContent = option.textContent;
      }

      
      var optionImageSrc = option.getAttribute('data-image-src');
      if (optionImageSrc) {
        var img = document.createElement('img');
        img.setAttribute('src', optionImageSrc);
        span.insertBefore(img, span.firstChild);
      }

      var label = document.createElement('label');
      label.setAttribute('for', inputID);
      if (title !== null) {
        label.setAttribute('title', title);
      }
      label.className += (isDisabled ? ' ui-state-disabled' : '')
                          + (isSelected && !isMultiple ? ' ui-state-active' : '')
                          + ' ui-corner-all';
      label.appendChild(input);
      label.appendChild(span);

      var item = document.createElement('li');
      item.className = (isDisabled ? 'ui-multiselect-disabled ' : '')
                        + (option.className || '');
      item.appendChild(label);

      return item;
    },

    
    _buildOptionList: function() {
      var self = this;
      var list = [];

      this.inputIdCounter = 0;

      this.element.children().each( function() {
        var elem = this;

        if (elem.tagName.toUpperCase() === 'OPTGROUP') {
          var options = [];

          $(elem).children().each( function() {
            options.push(self._makeOption(this));
          });

          
          var $collapseButton = !!self.options.groupsCollapsable
                                 ? $( document.createElement('button') )
                                    .attr({'title': self.linkInfo.collapse.title})
                                    .addClass('ui-state-default ui-corner-all ui-multiselect-collapser')
                                    .html(self.linkInfo.collapse.icon)
                                 : null;
          var $optGroupLabel = $( document.createElement('a') )
                                    .addClass('ui-multiselect-grouplabel'
                                      + (self.options.groupsSelectable ? ' ui-multiselect-selectable' : ''))
                                    .html( elem.getAttribute('label') );
          var $optionGroup = $( document.createElement('ul') ).append(options);
          var $optGroupItem = $( document.createElement('li') )
                                 .addClass('ui-multiselect-optgroup'
                                    + (self.options.groupColumns ? ' ui-multiselect-columns' : '')
                                    + (elem.className ? ' ' + elem.className : ''))
                                 .append($collapseButton, $optGroupLabel, $optionGroup)
          list.push($optGroupItem);
        }
        else {
          list.push(self._makeOption(elem));
        }
      });

      this.$checkboxes.empty().append(list);
   },

    
    refresh: function(init) {
      var $element = this.element;

      
      if (this.options.header !== false) {
         this.$headerLinkContainer
              .find('.ui-multiselect-all, .ui-multiselect-none, .ui-multiselect-flip')
              .toggle( !!$element[0].multiple );
      }

      this._buildOptionList();                                  
      this._updateCache();                                      

      if (!this.options.listbox) {
         this._setButtonWidth();
         this.update(true);
      }
      else {
         if (!this._isOpen) {
            this.$menu.show();
            this._isOpen = true;
         }
         this._setMenuWidth();
         this._setMenuHeight();
      }

      
      if (!init) {
        this._trigger('refresh');
      }
    },

    
    _updateCache: function() {
      
      this._savedButtonWidth = 0;
      this._savedMenuWidth = 0;
      this._savedMenuHeight = 0;

      
      this.$header = this.$menu.children('.ui-multiselect-header');
      this.$checkboxes = this.$menu.children('.ui-multiselect-checkboxes');

      
      this.$labels = this.$menu.find('label');
      this.$inputs = this.$labels.children('input').not(".ui-multiselect-filter"); 

      
      if ( this.element.is(':data("ech-multiselectfilter")') ) {
            this.element.data('ech-multiselectfilter').updateCache(true);
      }
    },

    
    resync : function(skipDisabled) {
      var $inputs = this.$inputs;
      var $options = this.element.find('option');

      if ($inputs.length === $options.length) {
         var inputValues = {};
         $inputs.not(!!skipDisabled ? ':disabled' : '').each( function() {
            inputValues[this.value] = this;
         });
         $options.not(!!skipDisabled ? ':disabled' : '').each( function() {
            if (this.value in inputValues) {
               inputValues[this.value].checked = this.selected;
            }
         });
         this._trigger('resync');
         this.update();
      }
      else {
         this.refresh();
      }
    },

   
    update: function(isDefault) {
      if (!!this.options.listbox) {
         return;
      }
      var self = this;
      var options = self.options;
      var selectedList = options.selectedList;
      var selectedText = options.selectedText;
      var $inputs = self.$inputs;
      var inputCount = $inputs.length;
      var $checked = $inputs.filter(':checked');
      var numChecked = $checked.length;
      var value;

      if (numChecked) {
        if (typeof selectedText === 'function') {
          value = selectedText.call(self, numChecked, inputCount, $checked.get());
        }
        else if (/\d/.test(selectedList) && selectedList > 0 && numChecked <= selectedList) {
          value = $checked.map(function() { return $(this).next().text().replace(/\n$/, '') })
                          .get().join(options.selectedListSeparator);
        }
        else {
          value = selectedText.replace('#', numChecked).replace('#', inputCount);
        }
      }
      else {
        value = options.noneSelectedText;
      }

      self._setButtonValue(value, isDefault);

      if ( options.wrapText.indexOf('button') === -1 ) {
         this._setButtonWidth(true);
      }

      
      if (self._isOpen && self._savedButtonHeight != self.$button.outerHeight(false)) {
         self.position();
      }
    },

    
    _setButtonValue: function(value, isDefault) {
      this.$buttonlabel[this.options.htmlText.indexOf('button') > -1 ? 'html' : 'text'](value);

      if (!!isDefault) {
        this.$button[0].defaultValue = value;
      }
    },

    
    _bindButtonEvents: function() {
      var self = this;
      var $button = this.$button;
      function clickHandler() {
         self[ self._isOpen ? 'close' : 'open' ]();
         return false;
      }

      $button
        .on({
          click: clickHandler,
          keydown: $.proxy(self._handleButtonKeyboardNav, self),
          mouseenter: function() {
            if (!this.classList.contains('ui-state-disabled')) {
              this.classList.add('ui-state-hover');
            }
          },
          mouseleave: function() {
            this.classList.remove('ui-state-hover');
          },
          focus: function() {
            if (!this.classList.contains('ui-state-disabled')) {
              this.classList.add('ui-state-focus');
            }
          },
          blur: function() {
            this.classList.remove('ui-state-focus');
          }
        })
        
        .find('span')
        .on('click.multiselect,click', clickHandler);
    },

    
    _handleButtonKeyboardNav: function(e) {
       var self = this;

       
       if (!self._isOpen && !self.element[0].multiple && (e.which === 38 || e.which === 40) ) {
         var $inputs = self.$inputs;
         var index = $inputs.index( $inputs.filter(':checked') );
         if (e.which === 38 && index) {
            $inputs.eq(index - 1).trigger('click');
         }
         else if (e.which === 40 && index < $inputs.length - 1) {
            $inputs.eq(index + 1).trigger('click');
         }
         return;
      }

      switch(e.which) {
         case 27: 
         case 37: 
         case 38: 
            self.close();
            break;
         case 40: 
         case 39: 
            self.open();
            break;
      }
    },

    
    _bindCheckboxEvents: function() {
      var self = this;

      
      self.$checkboxes.on('click.multiselect', '.ui-multiselect-grouplabel', function(e) {
        e.preventDefault();

        if (!self.options.groupsSelectable) {
           return false;
        }

        var $this = $(this);
        var $inputs = $this.next('ul').children(':not(.ui-multiselect-excluded)').find('input').not(':disabled');
        var nodes = $inputs.get();
        var label = this.textContent;

        
        if (self._trigger('beforeoptgrouptoggle', e, { inputs:nodes, label:label }) === false) {
          return;
        }

        
        var maxSelected = self.options.maxSelected;
        if (maxSelected && (self.$inputs.filter(':checked').length + $inputs.length > maxSelected) ) {
          return;
        }

        
        self._toggleChecked(
          $inputs.filter(':checked').length !== $inputs.length,
          $inputs
        );

        self._trigger('optgrouptoggle', e, {
          inputs: nodes,
          label: label,
          checked: nodes.length ? nodes[0].checked : null
        });
      })
      
      .on('click.multiselect', '.ui-multiselect-collapser', function(e) {
        var $this = $(this),
              $parent = $this.parent(),
              optgroupLabel = $parent.find('.ui-multiselect-grouplabel').first().html(),
              linkInfo = self.linkInfo,
              collapsedClass = 'ui-multiselect-collapsed',
              isCollapsed = $parent.hasClass(collapsedClass);

        if (self._trigger('beforecollapsetoggle', e, { label: optgroupLabel , collapsed: isCollapsed }) === false) {
          return;
        }
        $parent.toggleClass(collapsedClass);

        $this.attr('title', isCollapsed ? linkInfo.collapse.title : linkInfo.expand.title)
               .html(isCollapsed ? linkInfo.collapse.icon : linkInfo.expand.icon );

        if (!self.options.listbox) {
           self._setMenuHeight(true);
        }

        self._trigger('collapsetoggle', e, { label: optgroupLabel, collapsed: !isCollapsed });
      })
      
      .on('mouseenter.multiselect', '.ui-multiselect-collapser', function(e) {
         this.classList.add('ui-state-hover');
      })
      
      .on('mouseleave.multiselect', '.ui-multiselect-collapser', function(e) {
         this.classList.remove('ui-state-hover');
      })
      
      .on('mouseenter.multiselect', 'label', function(e, param) {
        if (!this.classList.contains('ui-state-disabled')) {
          var checkboxes = self.$checkboxes[0];
          var scrollLeft = checkboxes.scrollLeft;
          var scrollTop = checkboxes.scrollTop;
          var scrollX = window.pageXOffset;
          var scrollY = window.pageYOffset;

          self.$labels.removeClass('ui-state-hover');
          $(this).addClass('ui-state-hover').find('input').focus();

          
          if ( !param || !param.allowScroll ) {
            checkboxes.scrollLeft = scrollLeft;
            checkboxes.scrollTop = scrollTop;
            window.scrollTo(scrollX, scrollY);
          }
        }
      })
      
      .on('keydown.multiselect', 'label', function(e) {
        
        if (e.which === 82) {
          return; 
        }

        if (e.which > 111 && e.which < 124) {
          return; 
        }

        e.preventDefault();
        switch(e.which) {
          case 9: 
            if (e.shiftKey) {
              self.$menu.find(".ui-state-hover").removeClass("ui-state-hover");
              self.$header.find("li").last().find("a").focus();
            }
            else {
              self.close();
            }
            break;
          case 27: 
            self.close();
            break;
          case 38: 
          case 40: 
          case 37: 
          case 39: 
            self._traverse(e.which, this);
            break;
          case 13: 
          case 32: 
            $(this).find('input')[0].click();
            break;
          case 65:   
            if (e.altKey) {
              self.checkAll();
            }
            break;
          case 70:   
            if (e.altKey) {
              self.flipAll();
            }
            break;
          case 85:   
            if (e.altKey) {
              self.uncheckAll();
            }
            break;
        }
      })
      .on('click.multiselect', 'input', function(e) {
        
        var input = this;
        var $input = $(input);
        var val = input.value;
        var checked = input.checked;
        
        var $element = self.element;
        var $tags = $element.find('option');
        var isMultiple = $element[0].multiple;
        var $allInputs = self.$inputs;
        var numChecked = $allInputs.filter(":checked").length;
        var options = self.options;
        var textFxn = options.htmlText.indexOf('options') > -1 ? 'html' : 'text';
        var optionText = $input.parent().find("span")[textFxn]();
        var maxSelected = $element.data("max");

        
        if (input.disabled || self._trigger('click', e, { value: val, text: optionText, checked: checked }) === false) {
          e.preventDefault();
          return;
        }

        if ( maxSelected && checked && numChecked > maxSelected) {
         if ( self._trigger('maxselected', e, { labels: self.$labels, inputs: $allInputs }) !== false ) {
            self.buttonMessage("<center><b>" + $element.data("limit_exceeded") + "</b></center>");
         }
          input.checked = false;
          e.preventDefault();
          return false;
        }

        
        
        input.focus();

        
        $input.prop('aria-selected', checked);

        
        $tags.each( function() {
          this.selected = (this.value === val ? checked : isMultiple && this.selected);
        });

        
        if (!isMultiple) {
          self.$labels.removeClass('ui-state-active');
          $input.closest('label').toggleClass('ui-state-active', checked);

          
          self.close();
        }

        
        $element.trigger("change");

        
        
        setTimeout($.proxy(self.update, self), 10);
      });
    },

    
    _bindHeaderEvents: function() {
      var self = this;

      
      self.$header
      .on('click.multiselect', 'a', function(e) {
        var headerLinks = {
          'ui-multiselect-close' : 'close',
          'ui-multiselect-all' : 'checkAll',
          'ui-multiselect-none' : 'uncheckAll',
          'ui-multiselect-flip' : 'flipAll',
          'ui-multiselect-collapseall' : 'collapseAll',
          'ui-multiselect-expandall' : 'expandAll'
        };
        for (hdgClass in headerLinks) {
          if ( this.classList.contains(hdgClass) ) {
            
              self[ headerLinks[hdgClass] ]();
              e.preventDefault();
              return false;
          }
        }
      }).
      on('keydown.multiselect', 'a', function(e) {
        switch(e.which) {
          case 27:
            self.close();
            break;
          case 9:
            var $target = $(e.target);
            if ((e.shiftKey
                && !$target.parent().prev().length
                && !self.$header.find(".ui-multiselect-filter").length)
               || (!$target.parent().next().length && !self.$labels.length && !e.shiftKey)) {
              self.close();
              e.preventDefault();
            }
            break;
        }
      });
    },

    
    _bindEvents: function() {
      var self = this;

      if (!self.options.listbox) {
         self._bindButtonEvents();
      }
      self._bindHeaderEvents();
      self._bindCheckboxEvents();

      
      if (!!self.options.resizableMenu && $.ui && 'resizable' in $.ui) {
         self.$menu.show();
         self.$menu.resizable({
            containment: 'parent',
            handles: 's',
            helper: 'ui-multiselect-resize',
            stop: function(e, ui) {
               
               ui.size.width = ui.originalSize.width;
               $(this).outerWidth(ui.originalSize.width);
               if (self._trigger('resize', e, ui) !== false) {
                  self.options.menuHeight = ui.size.height;
               }
               self._setMenuHeight(true);
            }
         });
         self.$menu.hide();
      }

      
      
      self.document.on('mousedown' + self._namespaceID
                       + ' wheel' + self._namespaceID
                       + ' mousewheel' + self._namespaceID, function(event) {
        var target = event.target;

        if ( self._isOpen
            && (!!self.$button ? target !== self.$button[0] && !$.contains(self.$button[0], target) : true)
            && target !== self.$menu[0] && !$.contains(self.$menu[0], target) ) {
          self.close();
        }
      });

      
      
      
      
      $(self.element[0].form).on('reset' + self._namespaceID, function() {
        setTimeout($.proxy(self.refresh, self), 10);
      });
    },

    
    _parse2px: function(dimText, $elem, isHeight) {
      if (typeof dimText !== 'string') {
         return {px: dimText, minimax: 0};
      }

      var parts = dimText.match(/([<>])?=?\s*([.\d]+)\s*([eimnptx%]*)s?/i);
      var minimax = parts[1];
      var value = parseFloat(parts[2]);
      var unit = parts[3].toLowerCase();
      var pixels = -1;
      switch (unit) {
         case 'pt':
         case 'in':
         case 'cm':
         case 'mm':
            pixels = {'pt': 4.0 / 3.0, 'in': 96.0, 'cm': 96.0 / 2.54, 'mm': 96.0 / 25.4}[unit] * value;
            break;
         case 'em':
            var bodyFontSize = ( window.getComputedStyle
                                          ? getComputedStyle(document.body).fontSize
                                          : document.body.currentStyle.fontSize ) || '16px';
            pixels = parseFloat(bodyFontSize) * value;
            break;
         case '%':
            if ( !!$elem ) {
               if (typeof $elem === 'string' || !$elem.jquery) {
                  $elem = $($elem);
               }
               pixels = ( !!isHeight ? $elem.parent().height() : $elem.parent().width() ) * (value / 100.0);
            } 
            break;
         default:
            pixels = value;
      }
      
      return {px: pixels, minimax: minimax == '>' ? -1 : ( minimax == '<' ? 1 : 0 ) };
    },

    
    _setButtonWidth: function(recalc) {
      if (this._savedButtonWidth && !recalc) {
         return;
      }

      
      var width = this._selectWidth || this._getBCRWidth( this.element );
      var buttonWidth = this.options.buttonWidth || '';
      if (/\d/.test(buttonWidth)) {
         var parsed = this._parse2px(buttonWidth, this.element);
         var pixels = parsed.px;
         var minimax = parsed.minimax;
         width = minimax < 0 ? Math.max(width, pixels) : ( minimax > 0 ? Math.min(width, pixels) : pixels );
      }
      else  { 
         buttonWidth = buttonWidth.toLowerCase();
      }

      
      
      if (buttonWidth !== 'auto') {
         this.$button.outerWidth(width);
      }
      this._savedButtonWidth = width;
    },

    
    _setMenuWidth: function(recalc) {
      if (this._savedMenuWidth && !recalc) {
         return;
      }

      
      var width = !!this.options.listbox ? this._selectWidth : ( this._getBCRWidth( this.$button ) || this._savedButtonWidth );

      var menuWidth = this.options.menuWidth || '';
      if ( /\d/.test(menuWidth) ) {
         var parsed = this._parse2px(menuWidth, this.element);
         var pixels = parsed.px;
         var minimax = parsed.minimax;
         width = minimax < 0 ? Math.max(width, pixels) : ( minimax > 0 ? Math.min(width, pixels) : pixels );
      }
      else { 
         menuWidth = menuWidth.toLowerCase();
      }

      
      if (menuWidth !== 'auto') {
         this.$menu.outerWidth(width);
         this._savedMenuWidth = width;
         return;
      }

      
      
      
      this.$menu.addClass('ui-multiselect-measure');
      var headerWidth = this.$header.outerWidth(true) + this._jqWidthFix(this.$header);
      var cbWidth = this.$checkboxes.outerWidth(true) + this._jqWidthFix(this.$checkboxes);
      this.$menu.removeClass('ui-multiselect-measure');

      var contentWidth = Math.max(this.options.wrapText.indexOf('header') > -1 ? 0 : headerWidth, cbWidth);

      
      this.$menu.width(contentWidth);
      
      this._savedMenuWidth = this.$menu.outerWidth(false);
    },

    
    _setMenuHeight: function(recalc) {
      var self = this;
      if (self._savedMenuHeight && !recalc) {
         return;
      }

      var maxHeight = $(window).height();
      var optionHeight = self.options.menuHeight || '';
      var useSelectSize = false;
      var elSelectSize = 4;

      if ( /\d/.test(optionHeight) ) {
         
         var $header = self.$header.filter(':visible');
         var headerHeight = $header.outerHeight(true);
         var menuBorderPaddingHt = this.$menu.outerHeight(false) - this.$menu.height();
         var cbBorderPaddingHt = this.$checkboxes.outerHeight(false) - this.$checkboxes.height();

         optionHeight = self._parse2px(optionHeight, self.element, true).px;
         maxHeight = Math.min(optionHeight, maxHeight) - headerHeight - menuBorderPaddingHt - cbBorderPaddingHt;
      }
      else if (optionHeight.toLowerCase() === 'size') {
         
         useSelectSize = true;
         
         elSelectSize = self.element[0].size || elSelectSize;
      }

      var overflowSetting = 'hidden';
      var itemCount = 0;
      var hoverAdjust = 4;  
      var ulHeight = hoverAdjust;
      var ulTop = -1;

      
      
      
      
      self.$checkboxes.find('li:not(.ui-multiselect-optgroup),a').filter(':visible').each( function() {
        if (ulTop < 0) {
           ulTop = this.offsetTop;
        }
        ulHeight =  this.offsetTop + this.offsetHeight - ulTop + hoverAdjust;
        if (useSelectSize && ++itemCount >= elSelectSize || ulHeight > maxHeight) {
          overflowSetting = 'auto';
          if (!useSelectSize) {
            ulHeight = maxHeight;
          }
          return false;
        }
      });

      
      
      self.$checkboxes.css('overflow', overflowSetting).height(ulHeight);
      self._savedMenuHeight = this.$menu.outerHeight(false);
    },

    
   _getBCRWidth: function(elem) {
      if (!elem || !!elem.jquery && !elem[0]) {
         return null;
      }
      var domRect = !!elem.jquery ? elem[0].getBoundingClientRect() : elem.getBoundingClientRect();
      return domRect.right - domRect.left;
    },

    
    _jqWidthFix: function(elem) {
      if (!elem || !!elem.jquery && !elem[0]) {
         return null;
      }
      return !!elem.jquery
                  ? this._getBCRWidth(elem[0]) - elem.outerWidth(false)
                  :  this._getBCRWidth(elem) - $(elem).outerWidth(false);
    },

    
    _traverse: function(which, start) {
      var $start = $(start);
      var moveToLast = which === 38 || which === 37;

      
      var $next = $start.parent()[moveToLast ? 'prevAll' : 'nextAll']('li:not(:disabled, .ui-multiselect-optgroup):visible').first();
      
      if (!$next.length) {
        $next = $start.parents(".ui-multiselect-optgroup")[moveToLast ? "prev" : "next" ]();
      }

      
      if (!$next.length) {
        var $container = this.$checkboxes;

        
        $container.find('label').filter(':visible')[ moveToLast ? 'last' : 'first' ]().trigger('mouseover', {allowScroll: true});

        
        $container.scrollTop(moveToLast ? $container.height() : 0);
      }
      else {
        $next.find('label').filter(':visible')[ moveToLast ? "last" : "first" ]().trigger('mouseover', {allowScroll: true});
      }
    },

    
    _toggleState: function(prop, flag) {
      return function() {
         var state = (flag === '!') ? !this[prop] : flag;

         if ( !this.disabled ) {
          this[ prop ] = state;
         }

        if (state) {
          this.setAttribute('aria-' + prop, true);
        }
        else {
          this.removeAttribute('aria-' + prop);
        }
      };
    },

    
    _toggleChecked: function(flag, group, filteredInputs) {
      var self = this;
      var $element = self.element;
      var $inputs = (group && group.length) ? group : self.$inputs;

      if (filteredInputs) {
         $inputs = self._isOpen
                     ? $inputs.closest('li').not('.ui-multiselect-excluded').find('input').not(':disabled')
                     : $inputs.not(':disabled');
      }

      
      $inputs.each(self._toggleState('checked', flag));

      
      $inputs.eq(0).focus();

      
      self.update();

      
      var inputValues = {};
      $inputs.each( function() {
        inputValues[ this.value ] = true;
      });

      
      $element.find('option')
              .each( function() {
                if (!this.disabled && inputValues[this.value]) {
                  self._toggleState('selected', flag).call(this);
                }
              });

      
      if ($inputs.length) {
        $element.trigger("change");
      }
    },

   
    _toggleDisabled: function(flag, groupID) {
      var disabledClass = 'ui-state-disabled';  

      this.$button.prop({ 'disabled':flag, 'aria-disabled':flag })[ flag ? 'addClass' : 'removeClass' ](disabledClass);

      if (this.options.disableInputsOnToggle) {
         
         
         
         var $inputs = (typeof groupID === 'undefined') ? this.$inputs : this._multiselectOptgroupFilter(groupID).find('input'),
               msDisabledClass = 'ui-multiselect-disabled';
         if (flag) {
            var matchedInputs = $inputs.filter(':enabled').get();
            for (var x = 0, len = matchedInputs.length; x < len; x++) {
               matchedInputs[x].setAttribute('disabled', 'disabled');
               matchedInputs[x].setAttribute('aria-disabled', 'disabled');
               matchedInputs[x].classList.add(msDisabledClass);
               matchedInputs[x].parentNode.classList.add(disabledClass);
             }
         }
         else {
            var matchedInputs = $inputs.filter('.' + msDisabledClass + ':disabled').get();
            for (var x = 0, len = matchedInputs.length; x < len; x++) {
              matchedInputs[x].removeAttribute("disabled");
              matchedInputs[x].removeAttribute("aria-disabled");
              matchedInputs[x].classList.remove(msDisabledClass);
              matchedInputs[x].parentNode.classList.remove(disabledClass);
            }
         }
      }

      var $select = (typeof groupID === 'undefined') ? this.element : this._nativeOptgroupFilter(groupID).find('option');
      $select.prop({
        'disabled': flag,
        'aria-disabled': flag
      });
    },

    
    open: function() {
      var $button = this.$button;

      
      if (this._trigger('beforeopen') === false || $button.hasClass('ui-state-disabled') || this._isOpen || !!this.options.listbox) {
        return;
      }

      var $menu = this.$menu;
      var $header = this.$header;
      var $labels = this.$labels;
      var $inputs = this.$inputs.filter(':checked:not(.ui-state-disabled)');
      var options = this.options;
      var effect = options.openEffect;
      var scrollX = window.pageXOffset;
      var scrollY = window.pageYOffset;

      
      this.$checkboxes.scrollTop(0);

      
      $menu.css('display','block');
      this._setMenuWidth();
      this._setMenuHeight();
      this.position();

      
      if (!!effect) {
         
         $menu.css('display','none');
         if (typeof effect == 'string') {
            $menu.show(effect, this.speed);
         }
         else if (typeof effect == 'object' && effect.constructor == Array) {
            $menu.show(effect[0], effect[1] || this.speed);
         }
         else if (typeof effect == 'object' && effect.constructor == Object) {
            $menu.show(effect);
         }
      }

      
      var filter = $header.find(".ui-multiselect-filter");
      if (filter.length) {
        filter.first().find('input').trigger('focus');
      }
      else if ($inputs.length) {
         $inputs.eq(0).trigger('focus').parent('label').eq(0).trigger('mouseover').trigger('mouseenter');
      }
      else if ($labels.length) {
        $labels.filter(':not(.ui-state-disabled)').eq(0).trigger('mouseover').trigger('mouseenter').find('input').trigger('focus');
      }
      else {
        $header.find('a').first().trigger('focus');
      }

      
      window.scrollTo(scrollX, scrollY);

      $button.addClass('ui-state-active');
	  this.menu = this.$menu;
	  this.btn = this.$button;
      this._isOpen = true;
      this._trigger('open',null,this);
    },

    
    close: function() {
      
      if (this._trigger('beforeclose') === false || !!this.options.listbox) {
        return;
      }

      var $menu = this.$menu;
      var options = this.options;
      var effect = options.closeEffect;
      var $button = this.$button;

      
      if (!!effect) {
         if (typeof effect == 'string') {
            $menu.hide(effect, this.speed);
         }
         else if (typeof effect == 'object' && effect.constructor == Array) {
            $menu.hide(effect[0], effect[1] || this.speed);
         }
         else if (typeof effect == 'object' && effect.constructor == Object) {
            $menu.hide(effect);
         }
      }
      else {
         $menu.css('display','none');
      }

      $button.removeClass('ui-state-active').trigger('blur').trigger('mouseleave');
      this.element.trigger('blur');    
      this._isOpen = false;
      this._trigger('close');
      
    },

    
    position: function() {
      var $button = this.$button;

      
      this._savedButtonHeight = $button.outerHeight(false);

      if ($.ui && $.ui.position) {
        this.$menu.position(this.options.position);
      }
      else {
        var pos = $button.position();
        pos.top += this._savedButtonHeight;
        this.$menu.offset(pos);
      }
    },

    
    enable: function(groupID) {
      this._toggleDisabled(false, groupID);
    },

    
    disable: function(groupID) {
      this._toggleDisabled(true, groupID);
    },

    
    checkAll: function(groupID) {
      this._trigger('beforeCheckAll');

      if (this.options.maxSelected) {
         return;
      }

      if (typeof groupID === 'undefined') {  
         this._toggleChecked(true);
      }
      else {
         this._toggleChecked(true, this._multiselectOptgroupFilter(groupID).find('input'));
      }

      this._trigger('checkAll');
    },

    
    uncheckAll: function(groupID) {
      this._trigger('beforeUncheckAll');

      if (typeof groupID === 'undefined') {  
         this._toggleChecked(false);
      }
      else {
         this._toggleChecked(false, this._multiselectOptgroupFilter(groupID).find('input'));
      }
      if ( !this.element[0].multiple && !this.$inputs.filter(':checked').length) {
        
        this.element[0].selectedIndex = -1;
      }

      this._trigger('uncheckAll');
    },

    
    flipAll: function(groupID) {
      this._trigger('beforeFlipAll');

      var gotID = (typeof groupID !== 'undefined'),  
            maxSelected = this.options.maxSelected,
            inputCount = this.$inputs.length,
            checkedCount = this.$inputs.filter(':checked').length,
            $filteredOptgroupInputs = gotID ? this._multiselectOptgroupFilter(groupID).find('input') : null,
            gInputCount = gotID ? $filteredOptgroupInputs.length : 0,
            gCheckedCount = gotID ? $filteredOptgroupInputs.filter(':checked').length : 0;

      if (!maxSelected
          || maxSelected >= (gotID ? checkedCount - gCheckedCount + gInputCount - gCheckedCount : inputCount - checkedCount ) ) {
         if (gotID) {
            this._toggleChecked('!', $filteredOptgroupInputs);
         }
         else {
            this._toggleChecked('!');
         }
         this._trigger('flipAll');
      }
      else {
         this.buttonMessage("<center><b>Flip All Not Permitted.</b></center>");
      }
    },

    
    collapseAll: function(groupID) {
      this._trigger('beforeCollapseAll');

      var $optgroups = (typeof groupID === 'undefined')  
                              ? this.$checkboxes.find('.ui-multiselect-optgroup')
                              : this._multiselectOptgroupFilter(groupID);

      $optgroups.addClass('ui-multiselect-collapsed')
                     .children('.ui-multiselect-collapser').attr('title', this.linkInfo.expand.title ).html( this.linkInfo.expand.icon );

      this._trigger('collapseAll');
    },

    
    expandAll: function(groupID) {
      this._trigger('beforeExpandAll');

      var $optgroups = (typeof groupID === 'undefined')  
                              ? this.$checkboxes.find('.ui-multiselect-optgroup')
                              : this._multiselectOptgroupFilter(groupID);

      $optgroups.removeClass('ui-multiselect-collapsed')
                     .children('.ui-multiselect-collapser').attr('title', this.linkInfo.collapse.title ).html( this.linkInfo.collapse.icon );

      this._trigger('expandAll');
    },

    
    buttonMessage: function(message) {
       var self = this;
       self.$buttonlabel.html(message);
       setTimeout( function() {
         self.update();
       }, 1000 );
    },

    
    getChecked: function() {
      return this.$menu.find('input:checked');
    },

    
    getUnchecked: function() {
      return this.$menu.find('input:not(:checked)');
    },

    
    destroy: function() {
      
      $.Widget.prototype.destroy.call(this);

      
      this.document.off(this._namespaceID);
      $(this.element[0].form).off(this._namespaceID);

      if (!this.options.listbox) {
         this.$button.remove();
      }
      this.$menu.remove();
      this.element.show();

      return this;
    },

    
    isOpen: function() {
      return this._isOpen;
    },

    
    widget: function() {
      return this.$menu;
    },

    
    getNamespaceID: function() {
      return this._namespaceID;
    },

    
    getButton: function() {
      return this.$button;
    },

    
    getMenu: function() {
      return this.$menu;
    },

    
    getLabels: function() {
      return this.$labels;
    },

    
    getCollapsed: function() {
       return this.$checkboxes.find('.ui-multiselect-collapsed');
    },

    
    value: function(newValue) {
      if (typeof newValue !== 'undefined') {
         this.element.val(newValue);
         this.resync();
         return this.element;
      }
      else {
         return this.element.val();
      }
    },

    
    addOption: function(attributes, text, groupID) {
      var self = this;
      var textFxn = self.options.htmlText.indexOf('options') > -1 ? 'html' : 'text';
      var $option = $( document.createElement('option') ).attr(attributes)[textFxn](text);
      var optionNode = $option.get(0);

      if (typeof groupID === 'undefined') {  
         self.element.append($option);
         self.$checkboxes.append(self._makeOption(optionNode));
      }
      else {
         self._nativeOptgroupFilter(groupID).append($option);
         self._multiselectOptgroupFilter(groupID).append(self._makeOption(optionNode));
      }

      self._updateCache();
    },

    
    _nativeOptgroupFilter: function(groupID) {
       return this.element.children("OPTGROUP").filter( function(index) {
          return (typeof groupID === 'number' ? index === groupID : this.getAttribute('label') === groupID);
       });
    },

    
    _multiselectOptgroupFilter: function(groupID) {
       return this.$menu.find(".ui-multiselect-optgroup").filter( function(index) {
          return (typeof groupID === 'number' ? index === groupID : this.getElementsByClassName('ui-multiselect-grouplabel')[0].textContent === groupID);
       });
    },

    
    removeOption: function(value) {
      if (!value) {
        return;
      }
      this.element.find("option[value=" + value + "]").remove();
      this.$labels.find("input[value=" + value + "]").parents("li").remove();

      this._updateCache();
    },

    
    _setOption: function(key, value) {
      var $header = this.$header,
            $menu = this.$menu;

      switch(key) {
        case 'header':
          if (typeof value === 'boolean') {
            $header.toggle( value );
          }
          else if (typeof value === 'string') {
            this.$headerLinkContainer.children('li:not(:last-child)').remove();
            this.$headerLinkContainer.prepend('<li>' + value + '</li>');
          }
          break;
        case 'checkAllText':
        case 'uncheckAllText':
        case 'flipAllText':
        case 'collapseAllText':
        case 'expandAllText':
          if (key !== 'checkAllText' || !this.options.maxSelected) {
            
            $header.find('a.' + this.linkInfo[key.replace('Text','')].class + ' span').eq(-1).html(value);
          }
          break;
        case 'checkAllIcon':
        case 'uncheckAllIcon':
        case 'flipAllIcon':
        case 'collapseAllIcon':
        case 'expandAllIcon':
          if (key !== 'checkAllIcon' || !this.options.maxSelected) {
            
            $header.find('a.' + this.linkInfo[key.replace('Icon','')].class + ' span').eq(0).replaceWith(value);
          }
          break;
        case 'openIcon':
          $menu.find('span.ui-multiselect-open').html(value);
          break;
        case 'closeIcon':
          $menu.find('a.ui-multiselect-close').html(value);
          break;
        case 'buttonWidth':
        case 'menuWidth':
          this.options[key] = value;
          this._setButtonWidth(true);        
          this._setMenuWidth(true);          
          break;
        case 'menuHeight':
          this.options[key] = value;
          this._setMenuHeight(true);         
          break;
        case 'selectedText':
        case 'selectedList':
        case 'maxSelected':
        case 'noneSelectedText':
        case 'selectedListSeparator':
          this.options[key] = value;            
          this.update(true);
          break;
        case 'classes':
          $menu.add(this.$button).removeClass(this.options.classes).addClass(value);
          break;
        case 'multiple':
          var $element = this.element;
          if (!!$element[0].multiple !== value) {
             $menu.toggleClass('ui-multiselect-multiple', value).toggleClass('ui-multiselect-single', !value);
             $element[0].multiple = value;
             this.uncheckAll();
             this.refresh();
          }
          break;
       case 'position':
         if (value !== null && !$.isEmptyObject(value) ) {
            this.options.position = value;
         }
         this.position();
         break;
       case 'zIndex':
         this.options.zIndex = value;
         this.$menu.css('z-index', value);
         break;
      default:
         this.options[key] = value;
     }
     $.Widget.prototype._setOption.apply(this, arguments);
   },

  });

   
   
   
   if ($.ui && 'dialog' in $.ui) {
      $.widget( "ui.dialog", $.ui.dialog, {
         _allowInteraction: function( event ) {
             if ( this._super( event ) || $( event.target ).closest('.ui-multiselect-menu' ).length ) {
               return true;
             }
         }
      });
   }

})(jQuery, _app_);

/*
 * jQuery MultiSelect UI Widget Filtering Plugin 3.0.0
 * Copyright (c) 2012 Eric Hynds
 *
 * http://www.erichynds.com/jquery/jquery-ui-multiselect-widget/
 *
 * Depends:
 *   - jQuery UI MultiSelect widget
 *
 * Dual licensed under the MIT and GPL licenses:
 *   http://www.opensource.org/licenses/mit-license.php
 *   http://www.gnu.org/licenses/gpl.html
 *
 */
(function($) {
  var rEscape = /[\-\[\]{}()*+?.,\\\^$|#\s]/g;

  
  
  var filterRules = {
      contains: '{{term}}',
      beginsWith:  '^{{term}}',
      endsWith:  '{{term}}$',
      exactMatch:  '^{{term}}$',
      containsNumber:  '\d',
      isNumeric:  '^\d+$',
      isNonNumeric:  '^\D+$'
  };

  var headerSelector = '.ui-multiselect-header';
  var hasFilterClass = 'ui-multiselect-hasfilter';
  var filterClass = 'ui-multiselect-filter';
  var optgroupClass = 'ui-multiselect-optgroup';
  var groupLabelClass = 'ui-multiselect-grouplabel';
  var hiddenClass = 'ui-multiselect-excluded';

  
  function debounce(func, wait, immediate) {
    var timeout;
    return function() {
      var context = this, args = arguments;
      var later = function() {
        timeout = null;
        if (!immediate) {
          func.apply(context, args);
        }
      };
      var callNow = immediate && !timeout;
      clearTimeout(timeout);
      timeout = setTimeout(later, wait);
      if (callNow) {
        func.apply(context, args);
      }
    };
  }

  $.widget('ech.multiselectfilter', {

    options: {
      label: 'Filter:',                
      placeholder: 'Enter keywords',   
      filterRule: 'contains',          
      searchGroups: false,             
      autoReset: false,                
      width: null,                     
      debounceMS: 250                  
    },

   
    _create: function() {
      var opts = this.options;
      var $element = this.element;

      
      this.instance = $element.data('ech-multiselect');

      
      this.$header = this.instance.$menu.find(headerSelector).addClass(hasFilterClass);

      
      this.$input = $(document.createElement('input'))
        .attr({
          placeholder: opts.placeholder,
          type: "search"
        })
        .css({  width: (typeof opts.width === 'string')
                       ? this.instance._parse2px(opts.width, this.$header).px + 'px'
                       : (/\d/.test(opts.width) ? opts.width + 'px' : null)
             });
      this._bindInputEvents();
      
      if (this.options.autoReset) {
        $element.on('multiselectclose', $.proxy(this._reset, this));
      }        

      var $label = $(document.createElement('label')).text(opts.label).append(this.$input);
      this.$wrapper = $(document.createElement('div'))
                                .addClass(filterClass)
                                .append($label)
                                .prependTo(this.$header);

      
      
      if (!!this.instance._isOpen) {
         this.instance._setMenuHeight(true);
      }

      
      this.updateCache();

      
      
      var instance = this.instance;
      var filter = this.$input[0];
      instance._oldToggleChecked = instance._toggleChecked;
      instance._toggleChecked = function(flag, group) {
         instance._oldToggleChecked(flag, group, !!filter.value);
      };
    },

    
    _bindInputEvents: function() {
      this.$input.on({
        keydown: function(e) {
          
          if(e.which === 13)
            e.preventDefault();
          else if(e.which === 27) {
            $element.multiselect('close');
            e.preventDefault();
          }
          else if(e.which === 9 && e.shiftKey) {
            $element.multiselect('close');
            e.preventDefault();
          }
          else if(e.altKey) {
            switch(e.which) {
              case 82:
                e.preventDefault();
                $(this).val('').trigger('input', '');
                break;
              case 65:
                $element.multiselect('checkAll');
                break;
              case 85:
                $element.multiselect('uncheckAll');
                break;
              case 70:
                $element.multiselect('flipAll');
                break;
              case 76:
                $element.multiselect('instance').$labels.first().trigger("mouseenter");
                break;
            }
          }
        },
        input: $.proxy(debounce(this._handler, this.options.debounceMS), this),
        search: $.proxy(this._handler, this)
      });
    },

   
    _handler: function(e) {
      var term = this.$input[0].value.toLowerCase().replace(/^\s+|\s+$/g,'');
      var filterRule = this.options.filterRule || 'contains';
      var regex = new RegExp( ( filterRules[filterRule] || filterRule ).replace('{{term}}', term.replace(rEscape, "\\$&")), 'i');
      var searchGroups = !!this.options.searchGroups;
      var $checkboxes = this.instance.$checkboxes;
      var cache = this.cache;   

      this.$rows.toggleClass(hiddenClass, !!term);
      var filteredInputs = $checkboxes.children().map(function(x) {
        var elem = this;
        var $groupItems = $(elem);
        var groupShown = false;

         
         
         
        if (elem.classList.contains(optgroupClass)) {
          var $groupItems = $groupItems.find('li');
          if (searchGroups && regex.test( cache[x] ) ) {
             elem.classList.remove(hiddenClass);
             $groupItems.removeClass(hiddenClass);
             return $groupItems.find('input').get();
          }
        }

        return $groupItems.map(function(y) {
          if ( regex.test( cache[x + '.' + y] ) ) {
            
            if (!groupShown) {
               elem.classList.remove(hiddenClass);
               groupShown = true;
            }
            this.classList.remove(hiddenClass);
            return this.getElementsByTagName('input')[0];
          }
          return null;
        });

      });
      if (term) {
         this._trigger('filter', e, filteredInputs);
      }
      if (!this.instance.options.listbox && this.instance._isOpen) {
         this.instance._setMenuHeight(true);
         this.instance.position();
      }
      return;
    },

    _reset: function() {
      this.$input.val('').trigger('input', '');
    },

   
    updateCache: function(alsoRefresh) {
      var cache = {};  
      this.instance.$checkboxes.children().each(function(x) {
         var $element = $(this);
         
         if (this.classList.contains(optgroupClass)) {
            
            cache[x] = this.getElementsByClassName(groupLabelClass)[0].textContent;
            $element = $element.find('li');
         }
         $element.each(function(y) {
            cache[x + '.' + y] = this.textContent;
         });
      });
      this.cache = cache;
      this.$rows = this.instance.$checkboxes.find('li');
      if (!!alsoRefresh) {
         this._handler();
      }
    },

   
    widget: function() {
      return this.$wrapper;
    },

   
    destroy: function() {
      $.Widget.prototype.destroy.call(this);
      this.$input.val('').trigger("keyup").off('keydown input search');
      this.instance.$menu.find(headerSelector).removeClass(hasFilterClass);
      this.$wrapper.remove();
    }
  });

})(jQuery);