/*jslint browser: true, devel: true, for:true, this:true */
/*global jQuery, window, _app_, pagenow, CodeMirror, wp, wpWidgets, tinyMCE, wpColorPicker */

/**
 * WP BASE Admin scripts
 *
 * @author		Hakan Ozevin
 * @package     WP BASE
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @version		3.4.4
 * @since       3.0
 */

jQuery(document).ready(function ($) {
    "use strict";
    /**
     * General admin messages and actions
     */
    var WPB_Admin = {

        init: function () {
            this.pagenow = (typeof pagenow === "string") ? pagenow.replace("wc-base", "wp-base") : "";
			if (parseInt(_app_.bp_displayed_user_id) > 0) {
				this.pagenow = "bp";
			} else if ( _app_.is.account ) {
				this.pagenow = "account";
			}

            this.doBind();
            this.doTabs();
            this.settingsPage();
            this.multiselectAll();
            this.navigateAway();

            if (this.pagenow) {
                this.codeMirror();
            }

            if (_app_.is.welcome) {
                this.openWelcome();
            }

            if (jQuery.ui.sortable !== undefined) {
                this.doSortable();
            }

            $("#delete_removed, #delete_test, #delete_all, #delete_onhold").click(function () {
                return confirm(_app_.confirmDelete);
            });

            $("#generate_test").click(function () {
                return confirm(_app_.confirmTest);
            });

            /* Display a hidden div on load */
            var hash = $.readHash();
            if (hash) {
                $(hash).show("slow");
            }

        },
        doBind: function () {
            var me = this;
            $('#restore_defaults_button').click(function (e) {
                me.restore(e);
            });

            $('#reset_db_button').click(function (e) {
                me.resetDB(e);
            });

            $('#log_clear_button').click(function () {
                me.deleteLog();
            });

            $(".check-empty").click(function (e) {
                me.checkEmpty(e);
            });

            $("a.notice-dismiss").click(function (e) {
                me.dismiss(e);
            });

            $(".app-change-status-btn").click(function (e) {
                me.bulkStatusChange(e);
            });

            $("#app-search-form select[name='stype']").change(function (e) {
                me.searchDatePicker(e);
            });

            $("#app_support_button").click(function (e) {
                me.support(e);
            });

            $("a.info-button").click(function (e) {
                var $this = $(e.currentTarget);
                var cName = $this.data("boxname") ? $this.data("boxname") : "app-instructions";
                $("." + cName).toggle('fast');
            });

            $(document).on("click", ".app-wrap-admin table td.free:not(.app_select_wh)," +
				".app-monthly-account td.free,.app-weekly-account td.free,.app-bp-profile td.free", function () {
					var lnk = $(this).find(".app-new-link").val();
					if ( lnk ) {
						window.location.href = lnk;
					}
            });
        },

        /**
         * Call scripts for settings pages
         */
        settingsPage: function () {
            var me = this;
            // Bookings Page
            if (me.pagenow.indexOf("app_bookings") > -1) {
                me.hideCheckBox();

                me.qTipTotalPaid();
            }

            // Display Settings Page
            if (me.pagenow.indexOf("app_display") > -1 || me.pagenow === "event-bookings_page_app_settings") {

                $('select[name="color_set"]').change(function (e) {
                    me.changeColor(e);
                });

                me.dataTables();

                $(".app_custom_texts_submit").click(function (e) {
                    me.customTextsSubmit(e);
                });
            }

            // Help Page
            if (me.pagenow.indexOf("app_help") > -1) {
                me.dataTables();
            }

            // Business/BP Profile/Account Page
            if (me.pagenow.indexOf("app_business") > -1 || me.pagenow === "bp" || me.pagenow === "account") {
                $(document).on("click", "table .app-lts-more-all", function (e) {
                    me.toggleAll(e);
                });
                $(document).on("click", "table .app-lts-more", function (e) {
                    me.toggle(e);
                });
            }

            // Global Settings Page
            if (me.pagenow.indexOf("app_settings") > -1) {
                $("input[name='list_of_bookings']").change(function () {
                    var refresh = $("input[name='set_refresh_url']");
                    if (!$(this).is(":checked")) {
                        refresh.attr("checked", false).attr("disabled", true);
                    } else {
                        refresh.attr("disabled", false);
                    }
                });

                $('input[name="send_test_email_btn"]').click(function () {
                    $('input[name="send_test_email"]').val(1);
                    $("#app_email_settings_form").submit();
                });
            }

            // Tools Page
            if (me.pagenow.indexOf("app_tools") > -1) {
                $(".app-license-actions button.activate").button({
                    icons: {primary: "ui-icon-play"}
                });
                $(".app-license-actions button.deactivate").button({
                    icons: {primary: "ui-icon-pause"}
                });
            }

            // Any WPB Page except bookings page_app_bookings
            if (me.pagenow.indexOf("wp-base") === 0 || me.pagenow.indexOf("event-bookings_page") === 0) {
				me.qTip();
				if (me.pagenow.indexOf("app_bookings") === -1) {
					$("table").on("focus", ".datepicker", function (e) {
						me.datePicker(e);
					});
				}
            }

			// Reports
			$("#app-graphs-date-options").change( function () {
				var $this = $(this),
					date_range_options = $("#app-date-range-options");

				if ("custom" === $this.val()) {
					date_range_options.show();
				} else {
					date_range_options.hide();
				}
			});

			$("select.error").click( function () {
				$(this).removeClass("error");
			});

            me.colorPicker();
        },

        /**
         * Use qtip to display total paid summary
         */
        qTipTotalPaid: function () {
            $("table").find("th#price, th#deposit, th#total_paid, th#balance").each(function (ignore, val) {
                var id = $(val).attr("id");
                var ttext = $("#" + id + "-tt").html();
                $(val).qtip({
                    content: {
                        text: ttext
                    },
                    style: _app_.qtipYellow,
                    hide: _app_.qtipHide,
                    position: _app_.qtipPos
                });
            });
        },

        /**
         * Use qtip
         */
        qTip: function () {
            $(".app-page").find("[title][title!='']").each(function (ignore, val) {
                var $this = $(val);
				if ($this.hasClass("app-all")) {
					return false;
				}
                $this.qtip({
                    overwrite: false,
                    content: {
                        text: $this.attr("title").split("●").join("<br/>")
                    },
                    style: _app_.qtipYellow,
                    hide: _app_.qtipHide,
                    position: _app_.qtipPos
                });
            });
        },

        /**
         * Ask confirm before restoring to defaults
         */
        restore: function (e) {
            e.preventDefault();
            var r = confirm(_app_.confirmRestore);

            if (r) {
                $("#restore_defaults_form").submit();
            } else {
                return false;
            }
        },

        /**
         * Ask confirm before deleting Database
         */
        resetDB: function (e) {
            e.preventDefault();

            var r = confirm(_app_.confirmReset);
            if (r) {
                r = confirm(_app_.confirmResetAgain);
                if (r) {
                    $("#reset_db_form").submit();
                }
            }
            return false;
        },

        /**
         * Ask confirm before sending an empty field (meaning delete)
         */
        checkEmpty: function (e) {
            var $this = $(e.target);
            var par = $this.parents("form");
            var emptied = false;
            $.each(par.find(".empty-means-delete"), function () {
                var el = $(this);
                if (!el.is("input") && !el.is("select")) {
                    return true;
                }
                if ($.trim(el.val()) === "") {
                    emptied = true;
                }
            });
            if (emptied) {
                e.preventDefault();
                var r = confirm(_app_.confirmEmpty);

                if (r) {
                    par.submit();
                } else {
                    return false;
                }
            }
        },

        /**
         * Ask confirm before sending support form
         */
        support: function (e) {
            if ($("#app_support_include").is(":checked")) {
                e.preventDefault();
                var r = confirm(_app_.supportInfo);
                if (r) {
                    var form = $("#app_support_request_form");
                    var focus = "";
                    if (!$.trim(form.find("#app_support_content textarea").val())) {
                        focus = "#app_support_content";
                    } else if (!$.trim(form.find("#app_support_client_email input").val())) {
                        focus = "#app_support_client_email";
                    } else if (!$.trim(form.find("#app_support_client_name input").val())) {
                        focus = "#app_support_client_name";
                    } else if (!$.trim(form.find("#app_support_subject input").val())) {
                        focus = "#app_support_subject";
                    }
                    var cur_action = form.attr("action");
                    var index = cur_action.indexOf("#");
                    if (index > 0) {
                        cur_action = cur_action.substring(0, index);
                    }
                    form.attr("action", cur_action + focus);
                    form.submit();
                } else {
                    return false;
                }
            }
        },

        /**
         * Ask confirm before deleting log
         */
        deleteLog: function () {
            var r = confirm(_app_.confirmDeleteLog);
            if (r) {
                $('.add-new-waiting').show();
                var data = {action: 'delete_log', ajax_nonce: _app_.deleteLogNonce};
                $.post(_app_.ajax_url, data, function (r) {
                    $('.add-new-waiting').hide();
                    if (r.error) {
                        alert(r.error);
                    } else {
                        $("#app_log").html(_app_.logFileCleared);
                    }
                }, "json");
            }
            return false;
        },

        /**
         * Dismiss admin notices
         */
        dismiss: function (e) {
            var $this = $(e.target);
            var what = $this.data("what");
            if (!what) {
                return false;
            }
            if ("general" === what) {
                $this.parents("div.is-dismissable").hide("slow");
                return false;
            }

            $.post(_app_.ajax_url, {action: "dismiss", what: $this.data("what")}, function (r) {
                if (r.data && what === r.data) {
                    $this.parents("div.is-dismissable").hide("slow");
                }
            }, "json");
        },

        /**
         * Submit all checked checkboxes in bulk status change
         */
        bulkStatusChange: function (e) {
            var btn = $(e.target);
            e.preventDefault();
            $("td.column-delete input:checkbox:checked").each(function () {
                btn.after('<input type="hidden" name="app[]" value="' + $(this).val() + '"/>');
            });
            $('#app-bulk-change-form').submit();
        },

        /**
         * Configure multiselect widget
         */
        multiselectAll: function () {
			var filter_ops = {label:_app_.filterLabel || _app_.search,
								placeholder: _app_.filterPholder
							};			
            $.each($("select.app_ms:visible,select.app_ms_tab"), function () {
                var $this = $(this);
				var bWidth = $this.data("buttonwidth") || "100%";
				var sList = $this.data("selectedlist") || "3";
                if ($this.data().hasOwnProperty("echMultiselect")) {
					$this.multiselect("option", "menuWidth", bWidth);
					$this.multiselect("option", "selectedList", sList);
                    return true;
                }
                $this.multiselect({
                    noneSelectedText: $this.data("noneselectedtext") || "Select",
                    buttonWidth: bWidth,
					selectedList: sList,
                    classes: $this.attr("class") || "",
					open: function () {
						$(document).trigger("app-ms-opened", $this);
					},
					close: function () {
						$(document).trigger("app-ms-closed", $this);
					}
                });
				if (_app_.is.useFilter) {
					$this.multiselectfilter(filter_ops);
				}				
            });
        },

        /**
         * Configure Color Picker for picking legend colors and diplaying samples
         */
        colorPicker: function () {
			if (typeof $.wp !== "object" || typeof $.wp.wpColorPicker !== "function") {
				return false;
			}

            $(".colorpicker_input").wpColorPicker({
                defaultColor: false,
                hide: true,
                palettes: true
            });
        },

        /**
         * Change sample colors as selection changes
         */
        changeColor: function (e) {
            var $this = $(e.target);
            var selSet = String($this.val());
            if (selSet === "0") {
                $(".app_custom_color_row").show();
                $(".app-preset-samples").hide();
            } else {
                $(".app_custom_color_row").hide();
                $(".app-preset-samples").show();

				$.each(_app_.legendItems, function (i) {
					var legend = i;
					var presets = _app_.colorPresets;
					var color = presets[selSet][legend] || "aaaaaa";
					if (color) {
						$(".app-preset-samples")
							.find("a." + legend)
							.css("background-color", "#" + color);
					}
				});
			}
        },

        /**
         * Set datatables parameters and initiate
         */
        dataTables: function () {
            var sstring = decodeURIComponent($.urlParam("app_s"));
			$.extend( $.fn.dataTableExt.oStdClasses, {
				"sFilterInput": "app-no-save-alert",
				"sLengthSelect": "app-no-save-alert"
			});

            this.dt_api = $(".app-custom-texts, .app-settings-list").DataTable({
                "oSearch": {"sSearch": sstring},
                "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, _app_.all]],
                "autoWidth": true,
                "bAutoWidth": true,
                "responsive": true
            });
        },

        /**
         * Let hidden fields to be submitted + Remember search term
         */
        customTextsSubmit: function (e) {
            e.preventDefault();
            var $this = $(e.target);
            var par = $this.parents("form");
            var search = par.find("input[type=search]").val();
            var action = par.attr("action");
            par.attr("action", action + "&app_s=" + search);

            // Submit hidden fields
            // https://datatables.net/plug-ins/api/fnGetHiddenNodes
            var nodes;
            var display = par.find('tbody tr');
            nodes = this.dt_api.rows().nodes().toArray();
            /* Remove nodes which are being displayed */
            var i = 0;
            var iIndex = 0;
            for (i = 0; i < display.length; i = i + 1) {
                iIndex = $.inArray(display[i], nodes);

                if (iIndex !== -1) {
                    nodes.splice(iIndex, 1);
                }
            }
            par.find(".app_custom_texts_hidden").append(nodes);
            par.submit();
        },

        /**
         * Open welcome dialog
         */
        openWelcome: function () {
            var w = window.innerWidth;
            var dwidth = 0;
            if (w > 600) {
                dwidth = 600;
            } else {
                dwidth = w - 30;
            }

			var divW = $("#app-welcome");
            var $dialog = divW.dialog({
                title: divW.data("title"),
                modal: true,
                width: dwidth,
                position: {my: "center", at: "center", of: window},
                show: {effect: "drop", direction: "up", duration: 800},
                hide: {effect: "drop", direction: "down", duration: 800},
                dialogClass: "app-welcome",
				open: function() {
					$(".ui-widget-overlay").bind("click", function() {
						$(this).siblings('.ui-dialog').find('.ui-dialog-content').dialog("close");
					});
				}
            });

			$dialog
			.parent(".ui-dialog")
            .css({"border-radius": "10px 10px 10px 10px", "box-shadow": "0 0 25px 5px #999"});

            $(".app_close_welcome").click(function () {
                $dialog.dialog("close");
            });
        },

        /**
         * Display codemirror on selected textareas
         */
        codeMirror: function () {
            $('.app-codemirror').each(function (ignore, els) {
                var $this = $(this);
                CodeMirror.fromTextArea(els, {
                    lineNumbers: true,
                    mode: $this.data("mode") ? $this.data("mode") : "css",
                    direction: _app_.is.rtl ? "rtl" : "ltr",
                    readOnly: !!$this.attr("readonly"),
                    autoRefresh: true,
                    matchBrackets: true,
                    styleActiveLine: true
                });
            });
        },

        /**
         * Display DPicker when date is selected in search
         */
        searchDatePicker: function (e) {
            var $this = $(e.target) || $("select[name='stype']");
            var field = $this.parents("form").find("input[name='app_s']");
            if ($this.val() === "app_date") {
                field.addClass("datepicker").datepicker({
                    dateFormat: 'yy-mm-dd',
                    firstDay: _app_.start_of_week
                });
            } else {
                field.removeClass("datepicker").datepicker("destroy");
            }
        },

        /**
         * Display DPicker on any field having datepicker class
         */
        datePicker: function (e) {
            if ($(e.target).data("focused") !== "yes") {
                $(".datepicker").datepicker({
                    dateFormat: _app_.js_date_format,
                    firstDay: _app_.start_of_week
				});
            }
             $(e.target).data("focused", "yes");
        },

        /**
         * Hides unused checkboxes in Screen Options
         * This is needed because there is no hook for this purpose
         */
        hideCheckBox: function () {
            var table = $("table.app-manage");

            var data = table.data("hide_boxes");
            if (data) {
                var boxes = data.toString();
                if (parseInt(boxes.length) === 0) {
                    return false;
                }
                var hideBoxes = boxes.split(",");
                if (!hideBoxes) {
                    return false;
                }
                $.each(hideBoxes, function (ignore, val) {
                    $("input[name='" + val + "-hide']").parent("label").hide();
                });
                $("input[name='delete-hide']").parent("label").hide();
            }
        },

        /**
         * Navigate away warning
         */
        navigateAway: function () {
            $(document).data({
                "inputChanged": false,
                "submitClicked": false
            });
            $(".app-form, .app-manage").on("change",
                "input.app-copy-wh,input:not(.app-no-save-alert),select:not(.app-no-save-alert),textarea",
                function () {
                $(document).data({
                    "inputChanged": true,
                    "submitClicked": false
                });
            });

            $(".app-form, .app-manage").on("click",
                "button.app-copy-wh, td.app_select_wh:not(.wh_dummy)" +
                "table.app-wh th, table.app-wh td.app-weekly-hours-mins", function () {
                $(document).data({
                    "inputChanged": true,
                    "submitClicked": false
                });
            });
			$(".app-form").submit( function () {
				var btn = $(this).find("input[type=submit]:focus");
				if (btn.hasClass("create_page_btn")) {
					var curAction = $(this).attr("action");
					var index = curAction.indexOf("#");
					if (index > 0) {
						$(this).attr("action", curAction.substring(0, index));
					}
				}

				$(document).data({
					"submitClicked": true
				});
			});
            $("table.app-manage, table.app-vendors, table.app-clients, table.app-services").on("click", ".save", function () {
                $(document).data({
                    "submitClicked": true
                });
            });

			function readData(what){
				return $(document).data(what);
			}

            window.onbeforeunload = function () {
                if (!readData("submitClicked") && readData("inputChanged")) {
                    return true;
                }
            };
        },

        /**
         * Open a tab if selected by hash
         */
        selectTab: function ($this) {
            var hash = $.readHash();
            if (!hash) {
                return false;
            }
            var tabID = $(document).find(hash).parents(".ui-tabs-panel").attr("id");
            if (tabID) {
                var index = tabID.replace("tabs-", "");
                $this.tabs("option", "active", index);
            }
        },

        /**
         * jQuery Tabs
         */
        doTabs: function () {
            var me = this;

            // Tabs in Shortcode help
            var scHead = $("div#app-tabs").find("li.app_help_sc_title");
            $.each(scHead, function () {
                var $this = $(this);
                var head_text = $this.find("span.app_help_sc_title_txt").text();
                var par_id = $this.parents("div.app_help_sc").attr("id");
                $("div#app-tabs ul").first().append('<li><a href="#' + par_id + '">' + head_text + '</a></li>');
            });
            $("div#app-tabs").tabs().removeClass("ui-widget");

            $.each($(".app-tabs"), function (ignore, vp) {
                var tabsWrap = $(vp);
                var head = tabsWrap.find("h3.hndle");
                var tabID = tabsWrap.attr("id");
                if (!head.length) {
                    tabsWrap.hide();
                    return false;
                }
                $.each(head, function (i, val) {
                    var curHead = $(val);
                    var head_text = curHead.find("span").text();
                    var dashicon = curHead.find("span.dashicons").first().prop('outerHTML');
                    if (!dashicon) {
                        dashicon = "";
                    }
                    curHead.parent(".postbox").attr("id", tabID + "-" + i);
                    tabsWrap.find("ul").first().append('<li><a href="#' + tabID + '-' + i + '">' +
                                                        dashicon + head_text + '</a></li>');
                });
                tabsWrap.tabs({
                    create: function (ignore, ui) {
                        var $this = $(this);
                        var href = ui.tab.find("a").attr("href");
                        var form = ui.tab.parents("form.app-form");
                        var curAction = form.attr("action");
                        var index = curAction.indexOf("#");
                        if (index > 0) {
                            curAction = curAction.substring(0, index);
                        }
                        form.attr("action", curAction + href);
                        me.selectTab($this);
                    },
                    activate: function (ignore, ui) {
                        var href = ui.newTab.find("a").attr("href");
                        var form = ui.newTab.parents("form.app-form");
                        var curAction = form.attr("action");
                        var index = curAction.indexOf("#");
                        if (index > 0) {
                            curAction = curAction.substring(0, index);
                        }
                        form.attr("action", curAction + href);
						me.multiselectAll();
						form.find(".disabled-when-hidden").attr("disabled", true);
						var id = ui.newTab.find("a").first().attr("id").replace(/[^0-9]/gi, '');
						id = id - 1;
						form.find("#tabs-"+ id +" .disabled-when-hidden").attr("disabled", false);
                    }
                }).removeClass("ui-widget ui-corner-all");
            });

            if ($(document).find(".service-tabs-container").length > 0) {
                $(".service-tabs-container").tabs({
                    activate: function () {
                        me.multiselectAll();
                    }
                }).removeClass("ui-widget ui-widget-content");
            }
        },

        /**
         * Keep sortable item size during sorting
         */
        fixHelper: function (ignore, $this) {
            var $originals = $this.children();
            var $helper = $this.clone();
            var kids = $helper.children();
            kids.each(function (i, val) {
                $(val).width($originals.eq(i).width());
            });
            return $helper;
        },

        /**
         * Triggers change upon sort for navigate away warning
         */
        onSort: function () {
            $(document).data({
                "inputChanged": true,
                "submitClicked": false
            });
        },

        /**
         * makes items sortable
         */
        doSortable: function () {
            var me = this;
            $("#locations-table tbody").sortable({
                items: ".app-location-tr",
                change: me.onSort,
                helper: me.fixHelper
            });
            $("#services-table tr.app-time-dur").sortable({
                items: ".app-time-dur-rule",
                change: me.onSort,
                helper: me.fixHelper
            });
            $("#categories-table").sortable({
                items: ".app-category-tr",
                change: me.onSort,
                helper: me.fixHelper
            });
            $("#worker-table tbody").sortable({
                items: ".app-worker-tr",
                change: me.onSort,
                helper: me.fixHelper
            });
            $("#udf-table tbody").sortable({
                items: ".app-udf-tr",
                change: me.onSort,
                helper: me.fixHelper
            });
            $("#app-wh").sortable({
                items: ".app-wrap",
                change: me.onSort
            });
            $("#variations-table tbody").sortable({
                items: ".app_variation_tr",
                change: me.onSort,
                helper: me.fixHelper
            });
            $("#extras-table tbody").sortable({
                items: ".app-extra-tr",
                change: me.onSort,
                helper: me.fixHelper
            });
            $("#services-table tr.app-packages").sortable({
                items: ".app-package-seq",
                change: me.onSort,
                helper: me.fixHelper
            });
        },

        /**
         * Toggle all more/less panels in Services List
         */
        toggleAll: function (e) {
            var $this = $(e.target);
            var tr = $("#services-table tbody").find("tr").not(".app-service-tr");
            var dashAll = $this.parents("table").find(".dashicons");
            tr.toggle();
            if (tr.css("display") !== "none") {
                $("a.app-lts-more-all, a.app-lts-more").text(_app_.less);
                dashAll.removeClass("dashicons-arrow-down").addClass("dashicons-arrow-up");
                $(document).trigger("service-settings-opened");
            } else {
                $("a.app-lts-more-all, a.app-lts-more").text(_app_.more);
                dashAll.removeClass("dashicons-arrow-up").addClass("dashicons-arrow-down");
                $(document).trigger("service-settings-closed");
            }
        },

        /**
         * Toggle more/less panels in Services List
         */
        toggle: function (e) {
            var $this = $(e.target);
            var tbody = $this.parents("tbody").next("tbody.service-tabs-container");
            var dash = $this.parents("tr.app-service-tr").find(".dashicons");
            tbody.toggle();
            if (tbody.css('display') !== 'none') {
                $this.parent().find("a.app-lts-more").text(_app_.less);
                dash.removeClass("dashicons-arrow-down").addClass("dashicons-arrow-up");
                $(document).trigger("service-settings-opened");
            } else {
                $this.parent().find("a.app-lts-more").text(_app_.more);
                dash.removeClass("dashicons-arrow-up").addClass("dashicons-arrow-down");
                $(document).trigger("service-settings-closed");
            }
        }

    };

    WPB_Admin.init();

    /**
     * Addon settings and actions
     */
    var WPB_Addons = {

        init: function () {
            this.doBind();
            this.testBookings();
            this.timeSelection();
            this.annual();
            this.exim();
            this.gcal();
			if (_app_.is.lockEnabled) {
				this.serviceLock();
				this.workerLock();
			}
        },
        doBind: function () {
            // SMS
            $("input[name='send_test_sms_btn']").click(function () {
                $("input[name='send_test_sms']").val(1);
                $("#app_sms_settings_form").submit();
            });

            // Timezones
            $(document).on("submit", ".app-form:not(.app_wh_annual_form)", function () {
                var sel = $("select.app_wh_timezone");
                if (sel.length && sel.val() && "server_timezone" !== sel.val() && $(".app_server_timezone_string").val() !== sel.val()) {
                    return confirm(_app_.timeZone);
                }
                return true;
            });

			// Event bookings
			$(".wpb_event_bookings button.app-add-row").button({
				icons: {primary: "ui-icon-plusthick"}
            });
        },

        /**
         * In test bookings, filter workers
         */
        testBookings: function () {
            $(document).on("change", ".app_select_test_services", function () {
                var services = $(this);
                var worker_dropdown = services.siblings(".app_select_test_workers");
                worker_dropdown.attr("disabled", true);
                $.infoPanel();
                var _data = {
                    action: "test_service_changed",
                    test_service: services.val(),
                    edit_nonce: _app_.iedit_nonce
                };
                $.post(_app_.ajax_url, _data, function (response) {
                    worker_dropdown.attr("disabled", false);
                    if (response && response.error) {
                        alert(response.error);
                    } else if (response) {
                        worker_dropdown.replaceWith(response.workers);
                    } else {
                        alert(_app_.con_error);
                    }
                }, "json");
            });
        },

        /**
         * Control time selections: All day and visibility
         */
        timeSelection: function () {
            $("table.app-addon-table").on("change", ".app-freq", function (e) {
                var $this = $(e.target);
                var tr = $this.closest("tr");
                var val = $this.val();
                if (val === "always" || val === "special_days") {
                    tr.find(".datepicker").hide();
                    tr.find(".app-time-selection").hide();
                } else if (val === "once") {
                    tr.find(".datepicker").show();
                    tr.find(".app-time-selection").show();
                } else {
                    tr.find(".datepicker").hide();
                    tr.find(".app-time-selection").show();
                }
            });

            $(".app-addon-table").on("change", ".app-start-time, .app-end-time", function (e) {
                var $this = $(e.target);
                var par = $this.closest("tr, fieldset");
                if ($this.val() === "all_day") {
                    par.find(".app-end-time").not($this).val("all_day");
                    par.find(".app-start-time").not($this).val("all_day");
                }
            });
        },

        /**
         * When seasonal schedule changed, bring selected schedule mockup
         */
        annual: function () {
            $(document).on("click", ".app_select_wh", function () {
                if ($(this).hasClass("wh_dummy")) {
                    alert(_app_.scheduleClick);
                    return false;
                }
            });
            $(document).on("change", "select.app_annual_alt", function () {
                var $this = $(this);

				if ($this.val() === "new_alt_schedule") {
					return false;
				}

                var par = $this.parents(".app-wrap-admin");
                var form = $this.parents("form.app_wh_annual_form");
                $.infoPanel();
                $.post(_app_.ajax_url, {
                    action: "update_alt_single",
                    who: form.find("input[name=who]").val(),
                    subject: form.find("input[name=subject]").val(),
                    year: par.find("input[name=year]").val(),
                    week_no: par.find("input[name=week_no]").val(),
					app_location_id: form.find("input[name=app_location_id]").val(),
                    selected_alt: $this.val()
                }, function (response) {
                    if (response.data) {
                        par.replaceWith(response.data);
                    }
                }, "json");
            });
        },

        /**
         * Confirm requests during import
         */
        exim: function () {
            $("#app_export_csv_button").click(function (e) {
                var btn_parent = $(this).parents("form");
                e.preventDefault();
                if (!btn_parent.find("input:checkbox:checked").length) {
                    alert(_app_.eximNoColumn);
                    btn_parent.find("input:checkbox:first").focus();
                } else {
                    btn_parent.submit();
                }
                return false;
            });

            $("#import_settings_button").click(function (e) {
                e.preventDefault();
                if (!$("#import_file").val()) {
                    alert(_app_.eximNoFile);
                    $("#import_file").focus();
                    return false;
                }
                var r = confirm(_app_.eximSettings);
                if (r) {
                    $("#import_settings_form").submit();
                } else {
                    return false;
                }
            });

            $("#import_db_button").click(function (e) {
                e.preventDefault();
                if (!$("#import_db_file").val()) {
                    alert(_app_.eximNoFile);
                    $("#import_db_file").focus();
                    return false;
                }
                var r = confirm(_app_.eximDB);
                if (r) {
                    $("#import_db_form").submit();
                } else {
                    return false;
                }
            });

            $("#import_a_plus_button").click(function (e) {
                e.preventDefault();
                var r = confirm(_app_.eximAPlus);
                if (r) {
                    $("#import_a_plus_form").submit();
                } else {
                    return false;
                }
            });
        },
        gcal: function () {
            $(".app_gcal_reset").click(function (e) {
                e.preventDefault();
                var msg = $(this).hasClass("app_gcal_auth") ? _app_.gcalAuth : _app_.gcalReset;
                var r = confirm(msg);
                if (r) {
                   window.location = $(this).attr("href");
                } else {
                    return false;
                }
            });
        },
		serviceLock: function () {
			var table = $("#services-table");
			if (!table.length) {
			   return false;
			}

		   $(document).on('heartbeat-tick', function (ignore, data) {
				var locked = data['app-check-locked-service'] || {};

				table.find("tr.app-service-tr").each( function(ignore, el) {
					var key = el.id.replace("app-service-tr-", ""), row = $(el), lock_data, avatar;

					if ( locked.hasOwnProperty( key ) ) {
						if ( !row.hasClass('app-locked') ) {
							lock_data = locked[key];
							row.find(".app-lock-column .locked-text").text(lock_data.text);

							if ( lock_data.avatar_src ) {
								avatar = $( '<img class="avatar avatar-18 photo" width="18" height="18" alt="" />' ).attr( 'src', lock_data.avatar_src.replace( /&amp;/g, '&' ) );
								row.find(".app-lock-column .locked-avatar").empty().append( avatar );
							}
							if (lock_data.text) {
								row.addClass("app-locked ui-state-error").attr("title", _app_.maybeEdited);
							}
						} else {
							row.addClass("ui-state-error").attr("title", _app_.maybeEdited);
						}
					} else if ( row.hasClass("app-locked") ) {
						row.removeClass("app-locked").find(".locked-info span").empty();
					}
				});
			}).on("heartbeat-send", function (ignore, data) {
				var check = [];
				var refresh = [];

				table.find("tr.app-service-tr").each( function(ignore, el) {
					if (el.id) {
						check.push(el.id);

						if ($(el).hasClass("editing")) {
							refresh.push(el.id);
						}
					}
				});

				if ( check.length ) {
					data["app-check-locked-service"] = check;
				}
				if ( refresh.length ) {
					data["app-refresh-locked-service"] = refresh;
				}
			}).ready( function() {
				// Set the heartbeat interval to 15 sec.
				if ( wp !== "undefined" && wp.heartbeat ) {
					wp.heartbeat.interval( 15 );
				}
			});

			$(document).on("change", table.find("input, select"), function(e){
				var $this = $(e.target);
				var par = $this.parents("tr.app-service-tr").first();
				if ( !par.length ) {
					par = $this.parents("tbody").prev("tbody").first().find("tr.app-service-tr");
				}

				var id = par.attr("id");

				if (!id) {
					return false;
				}

				var wid = id.replace("app-service-tr-", "");
				if (!wid) {
					return false;
				}

				par.addClass("editing");

				var data = {
					action: "app_start_lock_service",
					service_id: wid,
					edit_nonce: _app_.iedit_nonce
				};
				$.post(_app_.ajax_url, data, function (r) {
					if (r.error) {
						alert(r.error);
					}
				}, "json");
			});
		},
		workerLock: function () {
			var table = $("#worker-table");
			if (!table.length) {
				return false;
			}

			$(document).on('heartbeat-tick', function (ignore, data) {
				var locked = data['app-check-locked-worker'] || {};

				table.find("tr").each( function(ignore, el) {
					var key = el.id.replace("app-worker-tr-", ""), row = $(el), lock_data, avatar;

					if ( locked.hasOwnProperty( key ) ) {
						if ( !row.hasClass('app-locked') ) {
							lock_data = locked[key];
							row.find(".app-lock-column .locked-text").text(lock_data.text);

							if ( lock_data.avatar_src ) {
								avatar = $( '<img class="avatar avatar-18 photo" width="18" height="18" alt="" />' ).attr( 'src', lock_data.avatar_src.replace( /&amp;/g, '&' ) );
								row.find(".app-lock-column .locked-avatar").empty().append( avatar );
							}
							if (lock_data.text) {
								row.addClass("app-locked ui-state-error").attr("title", _app_.maybeEdited);
							}
						} else {
							row.addClass("ui-state-error").attr("title", _app_.maybeEdited);
						}
					} else if ( row.hasClass("app-locked") ) {
						row.removeClass("app-locked").find(".locked-info span").empty();
					}
				});
			}).on("heartbeat-send", function (ignore, data) {
				var check = [];
				var refresh = [];

				table.find("tr").each( function(ignore, el) {
					if (el.id) {
						check.push(el.id);

						if ($(el).hasClass("editing")) {
							refresh.push(el.id);
						}
					}
				});

				if ( check.length ) {
					data["app-check-locked-worker"] = check;
				}
				if ( refresh.length ) {
					data["app-refresh-locked-worker"] = refresh;
				}
			});

			$(document).on("change", table.find("input, select"), function(e){
				var $this = $(e.target);
				var par = $this.parents("tr").first();
				if (par.hasClass("editing")) {
					return false;
				}
				var id = par.attr("id");

				if (!id) {
					return false;
				}
				var wid = id.replace("app-worker-tr-", "");
				if (!wid) {
					return false;
				}

				par.addClass("editing");

				var data = {
					action: "app_start_lock_worker",
					wid: wid,
					edit_nonce: _app_.iedit_nonce
				};
				$.post(_app_.ajax_url, data, function (r) {
					if (r.error) {
						alert(r.error);
					}
				}, "json");
			});
 		}
    };

    WPB_Addons.init();

    /**
     * Add/edit/save bookings
     */
    var WPB_Bookings = {

        init: function () {
            var me = this;
            this.doBind();

            if (parseInt($.readGet("add_new")) === 1) {
                me.addNew();
            }
        },

        doBind: function () {
            var me = this;
            var table = $("table.app-manage");
			var navbar = $(document).find("#app-navbar");
			var openNavbar = $(document).find("#app-open-navbar");

			$("#app-open-navbar button").click(function(e){
				e.preventDefault();
				openNavbar.hide();
				navbar.show( "fast" );
				me.saveNavbar( false, $(this) );
			});

			$("#app-close-navbar button").click(function(e){
				e.preventDefault();
				navbar.hide( "fast" );
				openNavbar.show();
				me.saveNavbar( true, $(this) );
			});
			
            $(".add-new-h2").on("click", function () {
                me.addNew($(this));
            });

            $(document).on("click", ".rebook-button", function() {
                var href = $(this).data("href");
                if (href) {
                    window.location.href = href;
                }
            });

            table.on("click", ".app-inline-edit", function (e) {
				var r = true;
				if ($(this).hasClass("app-takeover") || $(this).parents("tr").hasClass("app-locked")) {
					r = confirm(_app_.takeover);
				}
                if (r) {
                    me.edit(e);
                } else {
                    return false;
                }
            });

            table.on("click", ".save", function (e) {
				e.preventDefault();
                me.save(e);
            });

            table.on("keyup", $("input[name='price'],input[name='deposit']"), function (e) {
                me.recalculate($(e.target));
            });

            table.on("change", "select.app_extras,.app-admin-lsw,select[name='start_time'],select.app_duration,.app-special-select", function (e) {
                me.updateEdit($(e.target));
            });

			var cursorTimer;
            table.on("keyup", "input[name='app_seats'],.app-special-text", function (e) {
				clearTimeout(cursorTimer);
				cursorTimer = setTimeout(function () {
					me.updateEdit($(e.target));
				}, 500);
            });

            table.on("focus", ".datepicker", function (e) {
                me.datePicker(e);
            });

            $(".wpb_event_bookings").on("focus", ".datepicker", function (e) {
                me.datePicker(e);
            });

            table.on("change", "input[name='locked']", function (e) {
                me.lockPrice(e);
            });

            table.on("change", "select[name='status']", function (e) {
                me.checkBoxes(e);
            });

            table.on("change", ".app-iedit-email-actions input:checkbox", function (e) {
                me.limitBoxes(e);
            });

            table.on("keyup", "input[name='app_seats']", function (e) {
                me.guestList(e);
            });
			
			$(document).on("app-admin-edit-booking", function(ignore, par) {
				me.guestList(null, par);
			});

			/* Cancel */
            table.on("click", ".cancel", function (e) {
                me.collapseRecord($(e.target));
            });
			
			/* Hide/Show columns */
			var dispColumns = $(".app_displayed_columns");
			var targetTable = dispColumns.data("table") ? $("." + dispColumns.data("table") ) : table;
			var scope = dispColumns.data("scope") || "service";
			var $this, col;

			dispColumns.multiselect({
				selectedList: 1,
				noneSelectedText: dispColumns.data("selectedtext") || "Columns",
				selectedText: dispColumns.data("selectedtext") || "Columns",
				buttonWidth: "120px",
				menuHeight: "size",
				classes: "app-ms-small app-no-header app-disp-cols",
				close: function() {
					var $opts = dispColumns.children();
					var hidden = $opts.not(':selected').map(function() {
						  return this.value;
					   }).get();
					var data = {
						wpb_ajax: true,
						action: "app_save_hidden_columns_" + scope,
						hidden: hidden,
						ajax_nonce: _app_.iedit_nonce
					};
					$.post(_app_.ajax_url, data, function (r) {
						if (r && r.error) {
							window.alert(r.error);
						} else if (r) {
						} else {
							window.alert(_app_.con_error);
						}
					}, "json");
				}
			});

			dispColumns.on("change", function() {
				var cols = $(this).val();
				var visible = [];
				$.each(cols, function(i, v) {
					visible[i] = v;
				});

				$.each(targetTable.find("th"), function() {
					$this = $(this);
					col = $this.attr("id");
					if (col === "delete") {
						return true;
					}
					if ($.inArray(col, visible) === -1 ) {
						targetTable.find(".column-" + col).addClass("hidden");
					} else {
						targetTable.find(".column-" + col).removeClass("hidden");
					}
				});
			});
			
            /* Redraw multiselect */
            $(window).resize(function () {
                $.each($(".app_users,.app_extras"), function (ignore, val) {
                    $this = $(val);
                    if ($this.data().hasOwnProperty("echMultiselect")) {
                        $this.multiselect("refresh");
                    }
                });
            });

			if (!table.length) {
				return false;
			}

            /* Receive locked response from server */
			$(document).on("heartbeat-tick", function (ignore, data) {
				var locked = data["app-check-locked"] || {};
				var changed = data["app-changed"] || {};
				var changedData = ""; // status, date_time, etc

				table.find("tr").each( function(ignore, el) {
					var key = el.id.replace("app-tr-", ""), row = $(el), lock_data, avatar, span;

					if (changed && changed.hasOwnProperty( key )) {
						changedData = changed[key];

						$.each(changedData, function(i, val) {
							span = row.find(".column-"+ i +" span");

							if (span.text() !== val) {
								span.addClass("app-b");
							} else {
								span.removeClass("app-b");
							}

							span.text(val);
						});

						row.addClass("ui-state-highlight highlighted");
                        setTimeout(function () {
                            row.removeClass("ui-state-highlight");
                        }, 10000);
					}

					if ( locked.hasOwnProperty( key ) ) {
						if ( !row.hasClass('app-locked') ) {
							lock_data = locked[key];
							row.find(".column-client .locked-text").text(lock_data.text);
							row.find(".check-column checkbox").prop("checked", false);

							if ( lock_data.avatar_src ) {
								avatar = $( '<img class="avatar avatar-18 photo" width="18" height="18" alt="" />' ).attr( 'src', lock_data.avatar_src.replace( /&amp;/g, '&' ) );
								row.find(".column-client .locked-avatar").empty().append( avatar );
							}
							row.addClass("app-locked");
						}
					} else if ( row.hasClass("app-locked") ) {
						row.removeClass("app-locked").find(".locked-info span").empty();
						row.find(".app-inline-edit").removeClass("app-takeover");
					}
				});
			}).on("heartbeat-send", function (ignore, data) {   /* Send all bookings to be checked to server */
				var check = [];
				var refresh = [];

				table.find("tr").each( function(ignore, el) {
					if (el.id) {
						check.push(el.id);

						if ($(el).next().hasClass("inline-edit-row")) {
							refresh.push(el.id);
						}
					}
				});

				if ( check.length ) {
					data["app-check-locked"] = check;
				}
				if ( refresh.length ) {
					data["app-refresh-locked"] = refresh;
				}
			}).ready( function() {
				if ( wp !== "undefined" && wp.heartbeat ) {
					wp.heartbeat.interval( 15 );
				}
			});
        },

        /**
         * Save navbar position
         */
        saveNavbar: function (hidden, elm) {
			var scope = elm.data("scope") || "service";
			var data = {
				wpb_ajax: true,
				action: "app_save_navbar_" + scope,
				hidden: hidden ? 1 :0,
				ajax_nonce: _app_.iedit_nonce
			};
			$.post(_app_.ajax_url, data, function (r) {
				if (r && r.error) {
					window.alert(r.error);
				} else if (r) {
				} else {
					window.alert(_app_.con_error);
				}
			}, "json");
		},
		
        /**
         * Read all field values of a row (par)
         * @param par   object  Possibly a row in the table under which fields will be read
         */
        readData: function (par) {
            var table = par.parents("table.app-manage");
            var extras = par.find(".app_extras").val();

            var app_user_data = {};
            $.each(_app_.user_fields, function (ignore, v) {
                app_user_data[v] = par.find("input[name='" + v + "']").val();
            });

            var postData = {
				wpb_ajax: true,
				admin_edit: true,
				user: par.find("select[name='user'] option:selected").val(),
				name: par.find("input[name='cname']").val(),
				app_user_data: JSON.stringify(app_user_data),
				location: par.find("select[name='location'] option:selected").val() || 0,
				service: par.find("select[name='service'] option:selected").val(),
				worker: par.find("select[name='worker'] option:selected").val() || 0,
				locked: par.find("input[name='locked']").is(":checked") ? 1 : 0,
				locked_check: par.find("input[name='locked_check']").val(),
				price: par.find("input[name='price']").val() || 0,
				deposit: par.find("input[name='deposit']").val() || 0,
				created_by: par.find("select[name='created_by'] option:selected").val(),
				event_start: par.find("select[name='event_start'] option:selected").val(),
				start_date: par.find("input[name='start_date']").val(),
				start_time: par.find("select[name='start_time'] option:selected").val(),
				end_date: par.find("input[name='end_date']").val(),
				end_time: par.find("select[name='end_time'] option:selected").val(),
				parent_id: par.find("input[name='parent_id']").val(),
				note: par.find("textarea[name='note']").val(),
				admin_note: par.find("textarea[name='admin_note']").val(),
				status: par.find("select[name='status'] option:selected").val(),
				resend: par.find("input[name='resend']").is(":checked") ? 1 : 0,
				send_pending: par.find("input[name='send_pending']").is(":checked") ? 1 : 0,
				send_cancel: par.find("input[name='send_cancel']").is(":checked") ? 1 : 0,
				send_completed: par.find("input[name='send_completed']").is(":checked") ? 1 : 0,
				app_id: par.find("input[name='app_id']").val(),
				ajax_nonce: _app_.iedit_nonce,
				sel_location: table.data("location"),
				only_own: table.data("only_own"),
				override: table.data("override"),
				app_seats: par.find(".app_seats").val(),
				app_extras: $.isArray(extras) ? extras.join(",") : extras,
				app_extras_check: par.find("input[name='app_extras_check']").val(),
				app_multilang: par.find("select[name='app_multilang'] option:selected").val(),
				app_multilang_check: par.find("input[name='app_multilang_check']").val(),
				app_duration: par.find("select[name='app_duration'] option:selected").val(),
				taken_over_at: par.find("input[name='taken_over_at']").val()
            };

            var parti = {};
			var lop = _app_.lop_fields || ["nop", "mop", "pop", "aop"];
            $.each(lop, function (ignore, v) {
                var k = 0;
                for (k = 1; k <= 30; k = k + 1) {
                    parti[v + "_" + k] = par.find(".app-" + v + "-field-entry-" + k).val();
                }
            });
            postData = $.extend(postData, {
						parti_data: JSON.stringify(parti)
                    });

            var udfs = {};
            $.each(_app_.udf_ids, function (ignore, v) {
                var field = par.find(".app-udf-field-entry-" + v);
                if (parseInt(field.length) > 0) {
                    if (field.hasClass("app-udf-checkbox")) {
                        udfs["udf_" + v] = field.is(":checked") ? 1 : 0;
                    } else {
                        udfs["udf_" + v] = field.val();
                    }
                }
            });
            postData = $.extend(postData, {
						udf_data: JSON.stringify(udfs)
                    });

			/* Add special values to post data */
			var postSpecialData = {};
			
			par.find("input[class*=app-special-text], select[class*=app-special-select]").each( function(){
				var sp_name = $(this).attr("name");
				var sp_value = $(this).attr("type") === "checkbox" ? ((this).checked ? 1 : 0) : $(this).val();
				postSpecialData[sp_name] = sp_value;
			});
			
			$.extend(postData, postSpecialData);

            return postData;
        },

        /**
         * Add a new booking record/row
         */
        addNew: function ($this) {
            var me = this;
            $(".add-new-waiting").show();
            $.infoPanel("reading");
            var table = $("table.app-manage").first();
            var data = {
                wpb_ajax: true,
                action: "inline_edit",
                add_new: $.readGet("add_new"),
				add_new_event: ($this && $this.hasClass("add-new-event")) ? 1 :0,
                cpy_from: $.readGet("cpy_from"),
                worker: $.readGet("app_worker"),
                app_timestamp: $.readGet("app_timestamp"),
                col_len: parseInt(table.find("tr:first th:visible").length),
                app_id: 0,
                ajax_nonce: _app_.iedit_nonce,
                sel_location: table.data("location"),
                only_own: table.data("only_own"),
                override: table.data("override")
            };
            $.post(_app_.ajax_url, data, function (r) {
                $(".add-new-waiting").hide();
                if (r && r.error) {
                    window.alert(r.error);
                } else if (r) {
                    var row = table.prepend(r.result);
                    me.configureMS(r.id);
                    me.configQtip(r.id);
					row.find("[tabindex=0]").first().focus();
                } else {
                    window.alert(_app_.con_error);
                }
            }, "json");
        },

        /**
         * Edit a booking
         */
        edit: function (e) {
            var me = this;
            var $this = $(e.target);
            var par = $this.parents(".app-tr");
            var table = par.parents("table.app-manage");
            var app_id = par.find(".span_app_ID").html();
            $.infoPanel("reading");
            $this.addClass("app-disabled-button");
            par.find(".waiting").css("visibility", "visible");
            var data = {
                wpb_ajax: true,
                action: "inline_edit",
                col_len: parseInt(table.find("tr:first th:visible").length),
                app_id: app_id,
                ajax_nonce: _app_.iedit_nonce,
                sel_location: table.data("location"),
                only_own: table.data("only_own"),
                override: table.data("override"),
				taken_over: par.hasClass("app-locked")
            };
            $.post(_app_.ajax_url, data, function (r) {
                par.find(".waiting").css("visibility", "hidden");
                if (r && r.error) {
                    window.alert(r.error);
                } else if (r) {
                    par.hide();
                    var iedit_row = r.result;
                    var insertedRow = $(iedit_row).insertAfter(par);
                    insertedRow.find(".inline-edit-col .blocked-days")
                                .val(r.blocked_days).data("blocked", r.blocked_days);
                    var dpicker_id = insertedRow.find(".datepicker").attr("id");
                    $("#" + dpicker_id).datepicker("refresh");
                    if (parseInt(r.locked) > 0) {
                        insertedRow.data("locked", true);
                    }
                    me.configureMS(r.id);
                    me.configQtip(r.id);
					$(document).trigger("app-admin-edit-booking", par);
                } else {
                    window.alert(_app_.con_error);
                }
            }, "json");
        },

        /**
         * Updates fields during edit if lsw or date/time fields changed
         */
        updateEdit: function (obj) {
            var me = this;
            var par = obj.parents("tr.inline-edit-row");
            if (obj.hasClass("app_seats") && !obj.val()) {
                return false;
            }
            if (obj.hasClass("app_extras") && par.data("locked")) {
                return false;
            }

            $.infoPanel();

            if ($.inArray(parseInt(obj.val()), _app_.daily_services) === -1) {
                $(".app-is-daily").text("");
                par.find(".app-admin-time,input[name='end_date']")
                .css("text-decoration", "none")
                .attr("disabled", false);
            } else {
                // Daily
                $(".app-is-daily").text(_app_.daily_text);
                par.find(".app-admin-time,input[name='end_date']")
                .css("text-decoration", "line-through")
                .attr("disabled", true);
            }

            par.find(".app-admin-lsw").attr("disabled", "disabled");
            var locSel = par.find("select[name='location']");
            var serviceSel = par.find("select[name='service']");
            var workerSel = par.find("select[name='worker']");
            var priceSel = par.find("input[name='price']");
            var depositSel = par.find("input[name='deposit']");
            var startTimeSel = par.find("select[name='start_time']");
            var endTimeSel = par.find("select[name='end_time']");

			var durationLabel = par.find(".app_iedit_duration");
			var durationSel = durationLabel.find(".input-text-wrap");
			var repeatUnitLabel = par.find(".app_iedit_repeat_unit");
			var repeatUnitSel = repeatUnitLabel.find(".input-text-wrap");
			var repeatNumberLabel = par.find(".app_iedit_repeat_count");
			var repeatNumberSel = repeatNumberLabel.find(".input-text-wrap");
			
            var postData = me.readData(par);
            postData.action = "update_inline_edit";
			if (parseInt(par.find(".is_event").val()) > 0 ) {
				postData.is_event = true;
			}

            $.post(_app_.ajax_url, postData, function (r) {

                par.find(".app-admin-lsw").attr("disabled", false);

                if (r && r.error) {
                    window.alert(r.error);
                } else if (r) {
					if (r.event_start) {
						par.find("[name='event_start']").replaceWith(r.event_start);
					}
					if (r.event_end) {
						par.find("[name='event_end']").replaceWith(r.event_end);
					}
                    if (r.end_date) {
                        var end_date_fld = par.find("input[name='end_date']");
                        end_date_fld.attr("readonly", false);
                        end_date_fld.val(r.end_date);
                        end_date_fld.attr("readonly", true);
                    }
                    if (r.start_time_sel) {
                        startTimeSel.replaceWith(r.start_time_sel);
                    }
                    if (r.end_time_sel) {
                        endTimeSel.replaceWith(r.end_time_sel);
                    }
                    if (r.locations_sel) {
                        locSel.replaceWith(r.locations_sel);
                    }
                    if (r.services_sel) {
                        serviceSel.replaceWith(r.services_sel);
                    }
					if (r.durations_sel) {
                        durationSel.html(r.durations_sel);
						durationLabel.show();
                    } else {
						durationLabel.hide();
					}
					if (r.repeat_unit_sel) {
						repeatUnitSel.html(r.repeat_unit_sel);
						repeatUnitLabel.show();
                    } else {
						repeatUnitLabel.hide();
					}
					if (r.repeat_count_sel) {
						repeatNumberSel.html(r.repeat_count_sel);
						repeatNumberLabel.show();
                    } else {
						repeatNumberLabel.hide();
					}					
                    if (r.workers_sel) {
                        workerSel.replaceWith(r.workers_sel);
                    }
                    if (r.price) {
                        priceSel.val($.numFormat(r.price));
                    }
                    if (r.deposit) {
                        depositSel.val($.numFormat(r.deposit));
                    }

                    par.find(".blocked-days").val(r.blocked_days).data("blocked", r.blocked_days);
                    var dpicker_id = par.find(".datepicker").attr("id");
                    $("#" + dpicker_id).datepicker("refresh");

					$.each(r, function(i, v ) {
						if (i.indexOf("udf_") > -1 ) {
							par.find(".app_iedit_" + i + " .input-text-wrap").html(v);
						}
					});

                    me.recalculate(priceSel);
                } else {
                    window.alert(_app_.con_error);
                }
            }, "json");
        },

        /**
         * Manage LoP fields
         */
        guestList: function (e, par) {
            var $this = e ? $(e.target) : $(par).next(".inline-edit-row").find("input[name='app_seats']");
            var sPar = $this.parents(".inline-edit-row");
			var lopLabels = sPar.find(".app_iedit_lop");
			var label;
			var pax = $this.val();
			var pax_max = $this.siblings("input[name='app_pax_max']").val();
			var max = Math.max(pax, pax_max);

			if (!max) {
				return false;
			}

			$.each(lopLabels, function(){
				label = $(this);
				if ( max >= label.data("guestno") ) {
					label.show();
				} else {
					label.hide();
				}
			});
		},

        /**
         * Save a booking
         */
        save: function (e) {
            var me = this;
            var $this = $(e.target);
            var sPar = $this.parents(".inline-edit-row");
            $this.attr("disabled", true);
            $.infoPanel("saving");
            sPar.find(".waiting").show();

            var postData = me.readData(sPar);
            postData.action = "inline_edit_save";
			if (parseInt(sPar.find(".is_event").val()) > 0 ) {
				postData.is_event = true;
			}

            $.post(_app_.ajax_url, postData, function (r) {
                $this.attr("disabled", false);
                sPar.find(".waiting").hide();

                if (!r) {
                    window.alert(_app_.con_error);
                    return false;
                }
                var emailMsg = r.emailMsg ? " " + r.emailMsg : "";
                if (r.error) {
                    sPar.find(".error")
                    .html("<span class='app-error'>" + r.error + emailMsg + "</span>")
                    .show().delay(10000).fadeOut("slow");
                } else if (r.no_change) {
                    sPar.find(".error")
                    .html("<span class='app-b'>" + r.no_change + emailMsg + "</span>")
                    .show().delay(10000).fadeOut("slow");
                } else if (r.result) {
					r.target = $this;
					$(document).trigger("app-admin-booking-saved", r);
					me.sendSuccess(r, sPar, emailMsg, $this);
                } else if (emailMsg) {
                    sPar.find(".error")
                    .html("<span class='app-success'>" + emailMsg + "</span>")
                    .show().delay(10000).fadeOut("slow");
				}
            }, "json");
        },

        /**
         * Send success message
         */
		sendSuccess: function(r, sPar, emailMsg, $this) {
			var me = this;
            var appID = sPar.find("input[name='app_id']").val();
			sPar.find(".error")
			.html("<span class='app-success'>" + r.result + emailMsg + "</span>")
			.show().delay(10000).fadeOut("slow");

			var prevRow = sPar.prev(".app-tr");
			if (r.result_app_id) {
				var nid = r.result_app_id;
				sPar.find("input[name='app_id']").val(nid);
				if (nid !== appID) {
					sPar.find(".app_iedit_app_h").append(" (ID:" + nid + ")");
				}
				if (nid) {
					sPar.find("a.save").text(_app_.update_text);
				}
			}

			if (r.user) {
				prevRow.find(".user-inner .app-client-name").html(r.user);
			}

			var col = {};
			var p = "";
			var lbl = "";
			$.each(r, function (i, v) {
				col = prevRow.find(".column-" + i);
				if (col.length > 0) {
					if (i === "price" || i === "deposit" || i === "total_paid" || i === "balance") {
						col.text(function () {
							p = v.indexOf("-") > -1 ? "-" : "";
							return p + col.text().replace("-", "").replace(/[0-9\.,]+/, v.replace("-", ""));
						});
					} else {
						col.html(v);
					}
				}
				if (i.indexOf("zoom") > -1 ) {
					sPar.find(".app_iedit_" + i + " .input-text-wrap").html(v);
				}
				lbl = sPar.find(".show-with-new-booking.app_iedit_" + i);
				if (lbl.length) {
					lbl.replaceWith(v);
				}
				if (i === "client_name") {
					prevRow.find(".app-client-name").html(v);
				}
				if (i.indexOf("udf_") > -1 ) {
					prevRow.find(".column-" + i).html(v);
					sPar.find(".app_iedit_" + i + " .input-text-wrap").html(v);
				}
			});

			prevRow.addClass("ui-state-highlight");
			setTimeout(function () {
				prevRow.removeClass("ui-state-highlight");
			}, 10000);

			if (r.refresh) {
				setTimeout(function () {
					window.location.href = r.refresh;
				}, 3000);
			}

			if (parseInt(r.collapse) > 0) {
				setTimeout(function () {
					me.collapseRecord($this, r);
				}, 1500);
			}
		},

        /**
         * Populate userdata upon user selection
         */
        populateUser: function (me) {
            var sel_user = parseInt(me.val());
            var par = me.parents(".inline-edit-col");
            if (sel_user === 0) {
                // Clear fields for unregistered user
                $.each(_app_.user_fields, function (ignore, v) {
                    par.find(".app_iedit_" + v + " input").val("");
                });
                return false;
            }
            $.infoPanel("reading");
            var data = {
                action: "app_populate_user",
                user_id: sel_user,
                ajax_nonce: _app_.iedit_nonce
            };
            $.post(_app_.ajax_url, data, function (r) {
                if (r && r.error) {
                    window.alert(r.error);
                } else if (r) {
                    $.each(r, function (i, v) {
                        par.find(".app_iedit_" + i + " :input").val(v);
                    });
                } else {
                    window.alert(_app_.con_error);
                }
            }, "json");
        },

        /**
         * Initiates Multiselect for users and extras
         */
        configureMS: function (id) {
            var me = this;
            var $this = $("#app_users_" + id);
            
            $("#app_extras_" + id).multiselect({
                selectedList: 3,
                buttonWidth: "80%",
                classes: "app_extras app-ms-small"
            }).multiselectfilter();
			
			if ( _app_.is.msUsers ) {
				$this.multiselect({
					selectedList: 1,
					buttonWidth: "80%",
					classes: "app_users app-ms-small",
					close: function () {
						me.populateUser($this);
					}
				}).multiselectfilter();				
			}
			
			$(document).trigger("app-configure-ms", id);
        },

        /**
         * Initiate datepicker upon focus
         */
        datePicker: function (e) {
            var me = this;
            var $this = $(e.target);
            if ($this.data("focused") !== "yes") {
                $this.datepicker({
                    dateFormat: _app_.js_date_format,
                    firstDay: _app_.start_of_week,
                    onSelect: function (dateText) {
                        if ($this.attr("name") === "start_date") {
                            $this.parents(".inline-edit-col")
                            .find("input[name='end_date']")
                            .datepicker("setDate", dateText);
                            me.updateEdit($this);
                        }
                    },
                    beforeShowDay: function (date) {
                        var string = $.datepicker.formatDate("yy-mm-dd", date);
                        var datelist = $this.parents(".inline-edit-col").find(".blocked-days").data("blocked");
                        if (datelist) {
                            return [$.inArray(string, datelist) === -1];
                        } else {
                            return [true];
                        }
                    }
                });
            }
            $this.data("focused", "yes");
        },

        /**
         * Lock price and deposit fields
         */
        lockPrice: function (e) {
            var $this = $(e.target);
            var par = $this.parents("tr.inline-edit-row");
            var price = par.find("input[name='price']");
            var deposit = par.find("input[name='deposit']");
            if ($this.is(":checked")) {
                price.attr("readonly", "readonly");
                deposit.attr("readonly", "readonly");
                par.data("locked", true);
            } else {
                price.attr("readonly", false);
                deposit.attr("readonly", false);
                par.data("locked", false);
            }
        },

        /**
         * Change balance and total due as a variable changes
         */
        recalculate: function (obj) {
            var par = obj.parents("tr.inline-edit-row");
            var deposit = parseFloat(par.find("input[name='deposit']").val()) || 0;
            var price = parseFloat(par.find("input[name='price']").val()) || 0;
            var payment = parseFloat(par.find("input[name='payment']").val()) || 0;
			var extra = 0;
			par.find(".wc_extra_price").each( function(){
				extra += parseFloat($(this).val());
			});
            var balance = payment - price - deposit - extra;
            var total_due = price + deposit + extra;
            par.find("input[name='balance']").val($.numFormat(balance));
            par.find("input[name='total_due']").val($.numFormat(total_due));
        },

        /**
         * Limit checkboxes based on selected status
         */
        checkBoxes: function (e) {
            var $this = $(e.target);
            var val = $this.val();
            var pars = $this.parents("tr.inline-edit-row");
            var resend = pars.find("input[name='resend']");
            var pend = pars.find("input[name='send_pending']");
            var comp = pars.find("input[name='send_completed']");
            var cancel = pars.find("input[name='send_cancel']");
            var alls = pars.find(".app-iedit-email-actions input:checkbox");
            alls.attr({
                "checked": false,
                "disabled": true
            });
            if (val === "paid" || val === "confirmed") {
                resend.attr("disabled", false);
            } else if (val === "pending") {
                pend.attr("disabled", false);
            } else if (val === "removed") {
                cancel.attr("disabled", false);
            } else if (val === "completed") {
                comp.attr("disabled", false);
            } else {
                alls.attr("disabled", false);
            }
        },

        /**
         * Do not allow checking of more than one checkbox
         */
        limitBoxes: function (e) {
            var $this = $(e.target);
            if ($this.is(":checked")) {
                $this.parents(".inline-edit-row")
                .find("input")
                .not($this)
                .attr("checked", false);
            }
        },

        /**
         * Collapses record after cancel/save
         */
        collapseRecord: function (el, r) {
            var row = el.parents(".inline-edit-row");
			var app_id = row.find("input[name='app_id']").val();
            $(".app-inline-edit").removeClass("app-disabled-button");
            row.fadeOut(700, function () {
                row.remove();
            });
            row.prev(".app-tr").removeClass("app-locked").show("slow");

			if (!app_id) {
				if (r && r.new_booking) {
					window.location.href = window.location.href;
				} else {
					return;
				}
			}

            var data = {
                action: "app_delete_lock",
				app_id: app_id,
                ajax_nonce: _app_.iedit_nonce
            };
            $.post(_app_.ajax_url, data, function (res) {
                if (res && res.error) {
                    window.alert(res.error);
                } else if (r && r.new_booking) {
					window.location.href = window.location.href;
				}

            }, "json");
        },

        /**
         * Initiates qtip
         */
        configQtip: function (id) {
            var edit_row = $(".inline-edit-row");
            edit_row.find("[title][title!='']").each(function (ignore, val) {
                var $this = $(val);
                var title = $this.attr("title");
                var ttip = title ? title.replace(/●/g, "<br />").replace("/|/", "<br/>") : "";

                $this.qtip({
                    content: {
                        text: ttip
                    },
                    hide: _app_.qtipHide,
                    position: _app_.qtipPos,
                    style: _app_.qtipYellow
                });
            });

            var cacheCl = "app-payment-cache-" + id;
            var cache = $("<div class='" + cacheCl + "' />");
            var abbrPayment = $("#app-payment-ttip-" + id);

            abbrPayment.qtip({
                overwrite: true,
                content: {
                    text: function (ignore, api) {
                        if (parseInt($(document).find("." + cacheCl).length) > 0) {
                            return $(document).find("." + cacheCl).html();
                        }
                        api.elements.content.html(_app_.loading);
                        return $.ajax({
                            url: _app_.ajax_url,
                            type: "POST",
                            dataType: "json",
                            data: {
                                app_id: abbrPayment.parents(".inline-edit-row")
                                .find("input[name='app_id']").val(),
                                action: "app_show_payment_in_tooltip"
                            }
                        })
                        .then(function (res) {
                            var content = res.result;
                            if (content) {
                                cache.html(content).appendTo($(document.body)).hide();
                            }
                            return content;
                        }, function (ignore, status, error) {
                            api.set("content.text", status + ": " + error);
                        });
                    }
                },
                hide: _app_.qtipHide,
                position: _app_.qtipPos,
                style: _app_.qtipSmall
            });
        }
    };
    WPB_Bookings.init();

    /**
     * Adds a row template of fields in settings list for locations, services, workers
     * Extras, Easy Custom Pricing, Coupons, Variable Durations
     */
    var WPB_Add_Row = {

        exec: function () {
            var me = this;
            $(document).on("click", ".app-add-row", function (e) {
                e.preventDefault();
                var btn = $(this);
                var what = btn.data("what");
                if (!what) {
                    return false;
                }
                btn.attr("disabled", "disabled");
                var wForm = btn.parents("form.app-form, div.wpb_event_bookings");
                wForm.find(".no-entry-defined").hide();
                var row = $(document).find(".app-template-for-" + what);
                var id = row.data("id");
                var maxField = what === "job" ? btn.parents(".app-package-seq").find(".max-id-for-job") :
                                                 wForm.find(".max-id-for-" + what);
                var max = parseInt(maxField.val()) + 1;
                maxField.val(max);
                var appendto = "";
                var html = "";
                var sid = 0;
                if (what === "time-rule" || what === "sequence") {
                    appendto = btn.parents("tr.app-addon-tr").find("td");
                    sid = btn.siblings(".service-id").val();
                    html = $(row.clone().html().split(id).join(max).split("SERVICEID").join(sid))
                               .appendTo(appendto);
                } else if (what === "job") {
                    var sNo = btn.siblings(".seq-no").val();
                    appendto = btn.parents(".app-package-seq");
                    sid = btn.siblings(".service-id").val();
                    html = $(row.clone().html().split(id).join(max).split("SEQNO").join(sNo).split("SERVICEID").join(sid))
                               .appendTo(appendto);
                } else {
                    appendto = $(row.data("appendto"));
                    html = $(row.clone().html().split(id).join(max))
                               .appendTo(appendto);
                }
                me.adjust(html);
                WPB_Admin.multiselectAll();
                btn.attr("disabled", false);
                html.find("input").first().focus();
                $(document).trigger("app-" + what + "-row-added");
                $(document).trigger("app-row-added");
            });
        },

        /**
         * Adjust input and select values to the previous siblings' values
         */
        adjust: function (html) {
            var prev = html.prevAll("div, tbody, tr").first();
            $.each(html.find("input[type=text], input[type=checkbox], select"), function () {
                var $this = $(this);
				var cls = $.trim($this.attr("class"));
                if (!cls) {
                    return;
                }
                var prevVal = prev.find("." + cls.split(" ").join(".")).val();
                if (prevVal) {
                    $this.val(prevVal);
                }
            });
        }
    };
    WPB_Add_Row.exec();

    /**
     * Manual Payments Dialog
     */
    var WPB_MP = {

        /**
         * Object of arrays for selected dialog
         */
        dialogs: {},

        /**
         * Start
         */
        init: function () {
            this.doBind();
        },

        /**
         * Bind button clicks
         */
        doBind: function () {
            var me = this;
            $(document).on("click", "a.app-add-mp, .app-trans-edit", function (e) {
                me.open(e);
            });
            $(document).on("keyup", ".app-dialog-entry", function (e) {
                me.update(e, true);
            });
            $(document).on("click", ".app-mp-button", function (e) {
                me.update(e, false);
            });
            $(document).on("click",
            ".app-mp-cancel-button, .inline-edit-save a.cancel, .ui-dialog-titlebar-close", function (e) {
                me.cancel(e);
            });
            $(document).on("click", ".app-mp-button", function (e) {
                me.save(e);
            });
			$(document).on("app-admin-booking-saved", function(ignore, r) {
				if (!r.new_booking) {
					return false;
				}

				var btn = r.target.parents(".inline-edit-row").find(".app-add-mp");
				btn.data("app_id", r.result_app_id).show();
			});
        },

        /**
         * Read booking ID
         * This is used to check on which page/form dialog is opened
         */
        readAppID: function ($this) {
            return ($this.parents(".app-mp-dialog").find(".app-id").val() ||
                    $this.parents(".inline-edit-save").find("input[name='app_id']").val());
        },

        /**
         * Mark changed or clear changed
         */
        update: function (e, changed) {
            var me = this;
            var $this = $(e.target);
            var appID = me.readAppID($this);
            me.dialogs[appID].isChanged = changed;
        },

        /**
         * Open dialog
         */
        open: function (e) {
            var me = this;
            var clickedElm = $(e.target),
                appID = clickedElm.data("app_id"),
                dbIB = 0,
                db_text = _app_.dialogTrNo,
                app_text = _app_.dialogAppNo,
                title = _app_.dialogTitle + " - " + app_text + appID,
                amount = "",
                ref = "",
                note = "",
                editPar = "",
                gateway = "",
                w = window.innerWidth,
                dwidth = 500;

            if (w < 500) {
                dwidth = w - 30;
            }

            me.dialogs[appID] = $("<div class='app-mp-dlg-wrapper-" + appID + "' />").html($(".app-mp-dialog").clone());

            if (me.dialogs[appID].isOpen) {
                return false;
            }

            me.dialogs[appID].isChanged = false;
            me.dialogs[appID].isOpen = true;
            me.dialogs[appID].isEdit = clickedElm.hasClass("app-trans-edit");
            me.dialogs[appID].find(".app-id").val(appID);

            if (me.dialogs[appID].isEdit) {
                editPar = clickedElm.parents(".app-trans-tr");
                gateway = editPar.find(".app-trans-gateway").val() || clickedElm.data("gateway");
                if ('manual-payments' !== gateway) {
                    return;
                }
                dbIB = $.trim(editPar.find(".column-payment_id").text());
                me.dialogs[appID].find(".db-id").val(dbIB);
                title = _app_.dialogEdit + " - " + db_text + dbIB + " - " + app_text + appID;
                amount = editPar.find(".app-trans-amount-net").val();
                ref = $.trim(editPar.find(".column-transid").text());
                note = $.trim(editPar.find(".column-note").text());
                me.dialogs[appID].find(".app-mp-amount input").val($.numFormat(amount));
                me.dialogs[appID].find(".app-mp-ref input").val(ref);
                me.dialogs[appID].find(".app-mp-note textarea").val(note);
                me.dialogs[appID].find(".app-mp-button").text(_app_.dialogUpdate);
            }

            me.dialogs[appID].dialog({
                autoOpen: false,
                closeOnEscape: false,
                width: dwidth,
                open: function (ignore, ui) {$(".ui-dialog-titlebar-close", ui.dialog || ui).hide();},
                title: title,
                position: {my: "center", at: "center", of: window},
                draggable: true,
                dialogClass: "no-close"
            }).dialog("open");

			me.dialogs[appID].find(".app-mp-amount input").focus();
        },

        /**
         * Close dialog
         */
        cancel: function (e) {
            var me = this;
            var $this = $(e.target);
            var appID = me.readAppID($this);

            if (me.dialogs[appID] === undefined) {
                return false;
            }

            if (me.dialogs[appID].isChanged) {
                var r = confirm(_app_.dialogCancel);
                if (r) {
                    me.destroy(me.dialogs[appID]);
                } else {
                    return false;
                }
            } else {
                me.destroy(me.dialogs[appID]);
            }

        },

        /**
         * Destroy
         */
        destroy: function (it) {
            it.isOpen = false;
            it.isChanged = false;
            it.dialog("destroy");
        },

        /**
         * Save
         */
        save: function (e) {
            var me = this;
            var $this = $(e.target);
            var par = $this.parents(".app-mp-dialog");
            var selAmount = par.find(".app-mp-amount input").val();
            var selRef = par.find(".app-mp-ref input").val();
            var dbID = par.find(".db-id").val();
            var highLight = _app_.highLight || 5000;
            var appID = me.readAppID($this);
            var editPar = $('tr .column-payment_id a[data-db_id="' + dbID + '"]').parents("tr.app-trans-tr");
			if (!editPar.length) {
				editPar = $("tr#app-tr-" + appID);
			}
            var mp_data = {action: "save_manual_payment",
                app_id: appID,
                db_id: dbID,
                amount: selAmount,
                ref: selRef,
                note: par.find(".app-mp-note textarea").val(),
                ajax_nonce: _app_.iedit_nonce};

            $this.attr("disabled", true);
            $.infoPanel("saving");

            $.post(_app_.ajax_url, mp_data, function (r) {
                $(".app-mp-button").attr("disabled", false);
                if (r && r.error) {
                    alert(r.error);
                } else if (r && r.success) {
                    if (me.dialogs[appID].isEdit) {
                        editPar.find(".app-trans-amount-net").val(selAmount);
                        editPar.find(".column-amount span").text(
                            function (ignore, txt) {
                                return txt.replace(/-?[0-9]*\.?[0-9]+/, selAmount);
                       });

                        editPar.find(".column-transid").text(selRef);
                        editPar.addClass("ui-state-highlight");
                        setTimeout(function () {
                            editPar.removeClass("ui-state-highlight");
                        }, highLight);

						editPar.find(".column-total_paid").text(
                            function (ignore, txt) {
                                return txt.replace(/-?[0-9]*\.?[0-9]+/, r.total_payment);
                       });

						editPar.find(".column-balance").text(
                            function (ignore, txt) {
                                return txt.replace(/-?[0-9]*\.?[0-9]+/, r.balance);
                       });

                    }

                    $(document).find(".inline-edit-save input[name='app_id']").each(function () {
                        if ($(this).length > 0 && $(this).val() === appID) {
                            var rowPar = $(this).parents(".inline-edit-row");
                            var balance = rowPar.find("input[name='balance']");
                            var total = rowPar.find("input[name='payment']");
                            var both = balance.add(total);

                            balance.val(r.balance);
                            total.val(r.total_payment);
                            both.addClass("ui-state-highlight");
                            setTimeout(function () {
                                both.removeClass("ui-state-highlight");
                            }, highLight);
                            return false;
                        }
                    });

                    me.dialogs[appID].find(".app-mp-dialog-msg").text(r.success).show().delay(2000).fadeOut("slow");

					setTimeout(function(){
						me.destroy(me.dialogs[appID]);
					 }, 3000);

                } else {
                    alert(_app_.con_error);
                }
            });
        }

    };
    WPB_MP.init();

    /**
     * Attach multidatespicker to element
     */
    var WPB_MultiDatesPicker = {
        init: function () {
			var me = this;
			me.bind();
			me.exec();
		},
		bind: function () {
			var me = this;
			$(window).resize(function () {
				$("#full-year").multiDatesPicker( "destroy" );
				me.exec();
			});
		},
		calc: function (elm) {
			var w = elm.parents("form").width();
			var no = [3, 4];
			if (w < 500) {
				no = [12, 1];
			} else if (w < 750) {
				no = [6, 2];
			} else if (w < 1000) {
				no = [4, 3];
			}
			return no;
		},
		exec: function () {
            var self = this;
			var elm = $("#full-year");
            var today = new Date();
            var y = today.getFullYear();
            var dpc = Math.max(1, parseInt($(".app-days-picked").val()) || 0);
            var settings = {
                addDates: elm.data("add_dates"),
                dateFormat: "yy-mm-dd",
                firstDay: _app_.start_of_week,
                defaultDate: y + "-01-01",
                altField: "#altField",
                onSelect: function () {
                    $(document).data("inputChanged", true);
                },
                stepMonths: 12,
				mode: 'daysRange',
                autoselectRange: [0, dpc],
                numberOfMonths: self.calc(elm)
            };
            var mdp = elm.multiDatesPicker(settings);

            $(document).on("blur", ".app-days-picked", function () {
                dpc = Math.max(1, parseInt($(this).val()) || 0);
                settings.autoselectRange = [0, dpc];
                mdp.multiDatesPicker("setMode", settings);
            });

            // $(".app-open-special-days").click(function () {
                // var target = $("#special_days");
                // self.openTab(target);
                // $.scrollTo(target, {duration: 1000, axis: "y", offset: -100});
            // });
        },

        /**
         * Open tab by an element inside the tab
         */
        openTab: function (el) {
            var tab_id = $(document).find(el).parents(".ui-tabs-panel").attr("id");
            if (tab_id) {
                var index = tab_id.replace("tabs-", "");
                $(".app-tabs").tabs("option", "active", index);
            }
        }
    };
    WPB_MultiDatesPicker.init();

    /**
     * Handle working hour tables copy/paste and binary coding
     */
    var WPB_WH = {
        init: function () {
            var self = this;
            $(document).on("click", ".app_select_wh", function () {
                if ($(this).hasClass("free")) {
                    $(this).removeClass("free").addClass("notpossible");
                    $(this).find(".app_wh_value").val(0);
                } else {
                    $(this).removeClass("notpossible").addClass("free");
                    $(this).find(".app_wh_value").val(1);
                }
                self.update_coded($(this));
            });

            $(document).on("click", "table.app-wh th", function () {
                var me = $(this);
                var par = me.parents("table.app-wh");
                me.toggleClass("free");
                var cl = me.attr("class").replace("free", "");
                var target = par.find("td." + cl);
                if (me.hasClass("hourmin_column")) {
					par.find("tr").show();
                    target = par.find("td").not(".app-weekly-hours-mins");
                    par.find(".app-weekly-hours-mins").toggleClass("free-s");
                    par.find("th").not(me).toggleClass("free");
                }
                $.each(target, function () {
                    if (me.hasClass("free")) {
                        $(this).addClass("free").removeClass("notpossible");
                        $(this).find(".app_wh_value").val(1);
                    } else {
                        $(this).addClass("notpossible").removeClass("free");
                        $(this).find(".app_wh_value").val(0);
                    }
                });
                self.update_coded(me);
            });

            $(document).on("click", "table.app-wh td.app-weekly-hours-mins", function () {
                var me = $(this);
                me.toggleClass("free-s");
                var par = me.parents("table.app-wh");
                var cl = me.attr("class").replace("free-s", "");
                $.each(cl.split(" "), function (ignore, v) {
                    if (v.substr(0, 7) === "app_row") {
                        cl = v;
                        return false;
                    }
                });
                var target = par.find("td." + cl).not(me);
                $.each(target, function () {
                    if (me.hasClass("free-s")) {
                        $(this).addClass("free").removeClass("notpossible");
                        $(this).find(".app_wh_value").val(1);
                    } else {
                        $(this).addClass("notpossible").removeClass("free");
                        $(this).find(".app_wh_value").val(0);
                    }
                });
                self.update_coded(me);
            });

            $(document).on("click", ".app-copy-wh", function (e) {
                e.preventDefault();
                var whVal = {};
                var whOldVal = {};
                var status = $(this).data("status");
                var par = $(this).parents(".app-schedule-wrapper");
                var others = $(document).find(".app-copy-wh").not(this);
                var slotInputs = par.find(".app_wh_value");
                if ("copy_ready" === status) {
                    $.each(slotInputs, function () {
                        var no = $(this).data("no");
                        var val = $(this).val();
                        whVal[no] = val;
                    });
                    $(document).data("whVal", whVal);
                    $(this).data("status", "copied").text(_app_.whCopied);
                    var whWhose = $(this).parents(".app-wrap")
                                         .find(".app-title").text() || _app_.whWhose;
                    others.data("status", "paste_ready").text(_app_.whPaste.replace("WHOSE", whWhose));
                } else if ("copied" === status) {
                    $(".app-copy-wh").data("status", "copy_ready").text(_app_.whCopy);
                } else if ("paste_ready" === status) {
                    $.each(slotInputs, function () {
                        var no = $(this).data("no");
                        var oldVal = $(this).val();
                        whOldVal[no] = oldVal;
                        $(this).data("whOldVal", whOldVal);
                        if ($(document).data("whVal") !== undefined) {
                            whVal = $(document).data("whVal");
                            var new_val = whVal[no];
                            $(this).val(new_val);
                            var td = $(this).parent(".app_select_wh");
                            if (1 === parseInt(new_val)) {
                                td.removeClass("notpossible").addClass("free");
                            } else {
                                td.removeClass("free").addClass("notpossible");
                            }
                        }
                    });
                    $(this).data("status", "pasted").text(_app_.whPasted);
                    self.update_coded(slotInputs);
                } else if ("pasted" === status) {
                    $.each(slotInputs, function () {
                        var no = $(this).data("no");
                        if ($(this).data("whOldVal") !== undefined) {
                            whOldVal = $(this).data("whOldVal");
                            var oldVal = whOldVal[no];
                            $(this).val(oldVal);
                            var td = $(this).parent(".app_select_wh");
                            if (1 === parseInt(oldVal)) {
                                td.removeClass("notpossible").addClass("free");
                            } else {
                                td.removeClass("free").addClass("notpossible");
                            }
                        }
                    });
                    $(this).data("status", "paste_ready")
                           .text(_app_.whPaste.replace("WHOSE", _app_.whWhose));
                    self.update_coded(slotInputs);
                }
            });
        },

        /**
         * Walk thru and binary code all cells into one field
         */
        update_coded: function (me) {
            var step = parseInt(_app_.step) || 1;
            var par = me.parents("table.app-wh");
            var target = par.find("td").not(".app-weekly-hours-mins");
            var codedField = par.find(".app_coded_val");
            var codedVal = codedField.val();
            $.each(target, function () {
                var inp = $(this).find(".app_wh_value");
                var val = inp.val();
                var repeat = val;
                if (step > 1) {
                    var temp = [];
                    temp.length = step + 1;
                    repeat = temp.join(val);
                }
                var no = inp.data("no");
                codedVal = codedVal.substr(0, no) + repeat + codedVal.substr(no + step);
            });
            codedField.val(codedVal);
        }

    };
    WPB_WH.init();
	


});