<?php
/**
 * WPB Terms & Conditions Settings & Control
 *
 * @author		Hakan Ozevin
 * @package     WP BASE
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       2.0
 */

if ( ! defined( 'ABSPATH' ) ) exit;

if ( ! class_exists( 'WpBTermsConditions' ) ) {

class WpBTermsConditions{

	/**
     * WP BASE Core + Front [+Admin] instance
     */
	protected $a = null;

	/**
     * Constructor
     */
	public function __construct(){
		$this->a = BASE();
	}

	/**
     * Add admin actions
     */
	public function add_hooks() {
		add_action( 'plugins_loaded', array( $this, 'plugins_loaded' ) );
	}

	/**
     * Check if an older version of Advanced Features addon is active
     */
	public function plugins_loaded() {
		if ( ! wpb_check_advanced_features() ) {
			return;
		}

		add_filter( 'app_confirmation_before_buttons', array( $this, 'terms' ), 10, 2 );
		add_filter( 'appointments_display_tabs', array( $this, 'add_tab' ), 13 );
		add_action( 'app_display_terms_tab', array( $this, 'terms_settings' ), 13 );
		add_action( 'app_save_settings', array( $this, 'save_settings' ) );
	}

	/**
	 * Terms and Conditions lable, title and text
	 */
	public function get_terms_lable(){
		return apply_filters( 'app_terms_conditions', wpb_setting('terms_label'), 'terms_label' );
	}
	public function get_terms_title(){
		return apply_filters( 'app_terms_conditions', wpb_setting('terms_title'), 'terms_title' );
	}
	public function get_terms_text(){
		return apply_filters( 'app_terms_conditions', wpb_setting('terms_text'), 'terms_text' );
	}

	/**
	 * Adds Terms and Conditions field to the confirmation form
	 */
	public function terms( $ret = '', $app_id = 0 ) {
		if ( $app_id || 'yes' != wpb_setting('ask_terms') ) {
			return $ret;
		}

		$ret .= '<div class="app-terms-field"><label for="app-terms">';
		$ret .= '<em class="app-terms-check">';
		$ret .= '<input type="hidden" name="signup-privacy-policy-check" value="1">';
		$ret .= '<input id="app-terms" data-mini="true" type="checkbox" class="app-terms-field-entry app-required app-udf-checkbox" value="1" name="signup-privacy-policy-accept" /></em>';
		$ret .= '<sup> *</sup><em>';
		$ret .= preg_replace( '%\{(.*?)\}%', '<a href="javascript:void(0)" class="app-open-terms">$1</a>', $this->get_terms_lable() );
		$ret .= '</em></label></div>';

		# Add dialog content
		wpb_add_action_footer( $this );

		return $ret;
	}

	/**
	 * Adds dialog text which shows Terms & Conditions
	 */
	public function footer() {
	?>
<script type="text/html" class="app-terms-title"><?php	echo $this->get_terms_title(); ?></script>
<script type="text/html" class="app-terms-text" style="display:none"><?php
	echo wpautop( wptexturize ( str_replace( array( 'HOME_URL', 'SITE_NAME' ), array( home_url(), wp_specialchars_decode(get_option('blogname'), ENT_QUOTES) ), $this->get_terms_text() ) ) );
?></script>
	<?php
	}

	/**
	 *	Add "Advanced Features" tab
	 */
	public function add_tab( $tabs ) {
		$tabs['terms'] = __('Terms & Conditions', 'wp-base');
		return $tabs;
	}

	/**
	 * Save settings
	 */
	public function save_settings() {

		if ( 'save_terms' != $_POST['action_app'] ) {
			return;
		}

		$options = wpb_setting();

		$options['ask_terms']		= stripslashes( $_POST['ask_terms'] );
		$options['terms_label']		= stripslashes( $_POST['terms_label'] );
		$options['terms_text']		= stripslashes( $_POST['terms_text'] );
		$options['terms_title']		= stripslashes( $_POST['terms_title'] );

		do_action( 'app_advanced_features_maybe_updated', 'terms' );

		if ( $this->a->update_options( $options ) ) {
			wpb_notice( 'saved' );
		}
	}

	/**
	 * Admin Terms & Conditions settings HTML code
	 */
	public function terms_settings() {

		wpb_admin_access_check( 'manage_display_settings' );

		# Display terms & conditions label sample
		wpb_add_action_footer( $this );
?>
	<div id="poststuff" class="metabox-holder">
	
		<?php wpb_infobox( __( 'With this option, you can add a Terms & Conditions checkbox to the booking form. If enabled, client needs to check the checkbox (accept terms) to continue to checkout or purchase the booking.', 'wp-base' ) ); ?>

		<?php do_action( 'app_advanced_features_after_info', 'terms' ); ?>

		<form class="app-form" method="post" action="<?php echo wpb_add_query_arg( null, null ) ?>">
			<div class="postbox">
				<div class="postbox-header">
					<h3 class="hndle"><span><?php _e('Terms & Conditions', 'wp-base') ?></span></h3>
				</div>
				<div class="inside">
					<table class="form-table">

						<?php wpb_setting_yn( 'ask_terms' ) ?>

						<tr>
							<th scope="row" ><?php WpBConstant::echo_setting_name('terms_label') ?></th>
							<td>
								<input value="<?php echo esc_attr( wpb_setting('terms_label') ) ?>" class="app-1" name="terms_label" type="text" />
								<?php do_action( 'app_advanced_features_title', 'terms_label' ) ?>
								<span class="description app-btm"><?php WpBConstant::echo_setting_desc('terms_label') ?></span>
							</td>
						</tr>

						<tr id="terms-title">
							<th scope="row" ><?php WpBConstant::echo_setting_name('terms_title') ?></th>
							<td>
								<input value="<?php echo esc_attr( wpb_setting('terms_title') ) ?>" class="app-1" name="terms_title" type="text" />
								<?php do_action( 'app_advanced_features_title', 'terms_title' ) ?>
								<span class="description app-btm"><?php WpBConstant::echo_setting_desc('terms_title') ?></span>
							</td>
						</tr>

						<tr id="terms-content">
							<th scope="row" ><?php WpBConstant::echo_setting_name('terms_text') ?></th>
							<td>
								<?php
								wp_editor( wpb_setting('terms_text'), 'terms_text', wpb_editor_settings( __CLASS__ ) );
								?>
								<?php do_action( 'app_advanced_features_text', 'terms_text' ) ?>
								<span class="description app-btm"><?php WpBConstant::echo_setting_desc('terms_text') ?></span>
							</td>
						</tr>

					</table>
				</div>
			</div>
			<?php
			wp_nonce_field( 'update_app_settings', 'app_nonce', true, true );
			?>
			<p class="submit">
				<input type="hidden" value="save_terms" name="action_app" />
				<input type="submit" class="button-primary" value="<?php _e('Save Settings','wp-base'); ?>" />
			</p>
		</form>
	</div>
	<?php
	}

}

	BASE('TermsConditions')->add_hooks();

}