<?php
/**
 * Default filters and constants
 *
 *
 * @since		3.0
 * @package 	WP BASe
 * @author  	Hakan Ozevin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

define( 'WPB_DEMO_WEBSITE', 'https://demo.wp-base.com/' );
define( 'WPB_WOOCOMMERCE_DEMO_WEBSITE', 'https://wc.wp-base.com/' );
define( 'WPB_EDD_DEMO_WEBSITE', 'https://edd.wp-base.com/' );
define( 'WPB_ADDON_DEMO_WEBSITE', 'https://addons.wp-base.com/' );
define( 'WPB_NAME', WPB_DEV ? __('WP BASE Dev', 'wp-base') : __('WP BASE', 'wp-base') ); 	# Name that will be used on admin side.
define( 'WPB_ADDON_DIR', WPBASE_PLUGIN_DIR .'/includes/addons' );

do_action( 'app_defaults_before' );

if ( ! defined( 'WPB_GCAL_SERVICE_ID' ) ){
	define( 'WPB_GCAL_SERVICE_ID', -1 );
}

if ( ! defined( 'WPB_ADMIN_CAP' ) ){
	define( 'WPB_ADMIN_CAP', 'manage_options' );
}

if ( ! defined( 'WPB_TUTORIAL_CAP' ) ){
	define( 'WPB_TUTORIAL_CAP', 'manage_options' );
}

if ( ! defined( 'WPB_HARD_LIMIT' ) ){								# Hard limit set to 10 sec
	define( 'WPB_HARD_LIMIT', 10.0 );
}

if ( ! defined( 'WPB_HUGE_NUMBER' ) ){
	define( 'WPB_HUGE_NUMBER', 473000000 );							# This allows strtotime calculations for next 15 years (32 bit PHP can calculate upto year 2038)
}

if ( ! defined( 'WPB_PRELOAD_TIMEOUT' ) ){
	define( 'WPB_PRELOAD_TIMEOUT', 20 );							# Timeout set to 20 seconds
}

if ( ! defined( 'WPB_DB_DOMINANT_EDGE' ) ){
	define( 'WPB_DB_DOMINANT_EDGE', 50 );							# After this number of services/providers, WP BASE uses mysql dominantly
}

if ( ! defined( 'WPB_DEFAULT_LSW_PRIORITY' ) ){
	define( 'WPB_DEFAULT_LSW_PRIORITY', 'SLW' );					# How menus will be displayed, e.g. SLW means: Service > Location > Worker
}
																	# See class.controller.php
if ( ! defined( 'WPB_PRICE_MISMATCH_ACTIVE' ) ){
	define( 'WPB_PRICE_MISMATCH_ACTIVE', false );					# For future
}

if ( ! defined( 'WPB_EDITOR_HEIGHT' ) ){							# Height of WP Editor used in settings
	define( 'WPB_EDITOR_HEIGHT', '200px' );
}

if ( ! defined( 'WPB_PACKAGE_MAX_NESTING_LEVEL' ) ){				# Packages nesting depth: Depth of packages that can be set as a job of the main one
	define( 'WPB_PACKAGE_MAX_NESTING_LEVEL', 2 );
}

if ( ! defined( 'WPB_TEST_BOOKINGS_UPPER_LIMIT' ) ){				# Maximum scanned number of days for test bookings
	define( 'WPB_TEST_BOOKINGS_UPPER_LIMIT', 90 );
}

if ( ! defined( 'WPB_CUSTOM_FUNCTIONS_PRIORITY' ) ){				# This should be greater than 1
	define( 'WPB_CUSTOM_FUNCTIONS_PRIORITY', 6 );
}

if ( ! defined( 'WPB_MAX_SEATS' ) ){								# Max selectable seats if there is no limit and no capacity is defined
	define( 'WPB_MAX_SEATS', 100 );
}

if ( ! defined( 'WPB_UDF_DELIMITER' ) ){							# If UDF is select/option, delimiter for options is comma
	define( 'WPB_UDF_DELIMITER', ',' );
}

if ( ! defined( 'WPB_MAX_SERVICE_DURATION_SELECTION' ) ){			# Maximum service duration selection, in days
	define( 'WPB_MAX_SERVICE_DURATION_SELECTION', 30 );
}

if ( ! defined( 'WPB_SIGNUP_EMAIL_REPEAT' ) ){						# How many times to retry sending validation email
	define( 'WPB_SIGNUP_EMAIL_REPEAT', 3 );
}

if ( ! defined( 'WPB_MAX_CREDIT_PLANS' ) ){							# Number of selectable plans
	define( 'WPB_MAX_CREDIT_PLANS', 10 );
}

if ( ! defined( 'WPB_MAX_COMMISSION_RATES' ) ){						# Number of selectable role rules
	define( 'WPB_MAX_COMMISSION_RATES', 20 );
}

if ( ! defined( 'WPB_TT_SEPARATOR' ) ){								# Tooltip New Line Separator
	define( 'WPB_TT_SEPARATOR', ' ● ' );
}

if ( ! defined( 'WPB_CAPTION_COLOR' ) ){							# Default caption background color
	define( 'WPB_CAPTION_COLOR', '007cff' );
}

if ( ! defined( 'WPB_CAPTION_FONT_COLOR' ) ){						# Default caption font color
	define( 'WPB_CAPTION_FONT_COLOR', 'ffffff' );
}

add_action( 'update_option_gmt_offset', 'wpb_flush_cache' );
add_action( 'update_option_start_of_week', 'wpb_flush_cache' );
add_action( 'update_option_timezone_string', 'wpb_flush_cache' );
add_action( 'app_time_base_tick', 'wpb_flush_cache' );				# Clear cache at every time base tick
add_action( 'admin_footer', 'wpb_info_panel' );						# Spinner info panel
add_action( 'wp_footer', 'wpb_info_panel' );

do_action( 'app_defaults_after' );
