<?php
/**
 * WPB Special Days
 *
 * Handles display and saving of Special Days
 * @author		Hakan Ozevin
 * @package     WP BASE
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       3.8.0
 */

if ( ! defined( 'ABSPATH' ) ) exit;

if ( ! class_exists( 'WpBSpecialDays' ) ) {

class WpBSpecialDays {

	/**
     * Name of the tab/title
     */
	private static $name;

	/**
     * Constructor
     */
	public function __construct() {
		$this->a = BASE();
		self::$name = array( 'special_days' => __('Special Days', 'wp-base') );
	}

	/**
     * Add actions and filters
     */
	public function add_hooks() {
		add_filter( 'admin_title', array( $this, 'admin_title' ), 10, 2 );
		add_filter( 'appointments_business_tabs', array( $this, 'add_tab' ), 13 );
		add_action( 'app_business_special_days_tab', array( $this, 'render_tab' ) );
		add_action( 'app_save_settings', array( $this, 'save_settings' ), 22 );
	}

	/**
	 * Change admin SEO title
	 * @since 3.8.0
	 */
	public function admin_title( $admin_title, $title ) {
		if ( ! empty( $_GET['tab'] ) && key( self::$name ) == $_GET['tab'] ) {
			return str_replace( $title, current( self::$name ), $admin_title );
		} else {
			return $admin_title;
		}
	}
	
	/**
	 *	Add tab
	 */
	public function add_tab( $tabs ) {
		if ( wpb_admin_access_check( 'manage_working_hours', false ) ) {
			$tabs['special_days'] = __('Special Days', 'wp-base');
			$tabs = array_merge( $tabs, self::$name );
		}

		return $tabs;
	}

	/**
	 * Display HTML codes
	 * @param $profileuser_id: If this is called by a user from his profile
	 */
	public function render_tab( $profileuser_id = false, $bp = false ) {

		if ( $profileuser_id ) {
			return;
		}

		wpb_admin_access_check( 'manage_working_hours' );

		$options 	= $this->a->get_business_options();
		$s_days 	= isset( $options['special_days'] ) ? $options['special_days']: '';
		$h 			= $s_days ? htmlspecialchars( wp_json_encode( array_filter( explode( ',', $s_days ) ) ) ) : '';

		?>
		<div id="poststuff" class="metabox-holder">

		<?php wpb_infobox( __('Not to be confused with Holidays. Special days are used by Custom Pricing, Extras, Quotas and Extended Service Features addons to apply special prices and/or special rules. Special Days are valid globally; there are not separate settings for different services or providers.', 'wp-base') ); ?>

			<form class="app-form app_special_days_form" method="post" action="<?php echo wpb_add_query_arg( null, null ) ?>">
				<div class="postbox app-special-days-box">
					<h3 class="hndle"><span><?php printf( __('Special Days for %s','wp-base'), wp_specialchars_decode(get_option('blogname'), ENT_QUOTES) ) ?></span></h3>
					<div class="inside">
						<div id="full-year" class="box" data-add_dates="<?php echo $h ?>"></div>
						<input type="hidden" name="special_days" id="altField" value="<?php echo $s_days ?>">
					</div>
				</div>
				<p class="submit">
					<input type="hidden" name="action_app" value="save_special_days" />
					<input type="submit" class="button-primary" value="<?php  _e('Save Special Days', 'wp-base') ?>" />
				</p>
			</form>	
		</div>
	<?php
	}

	/**
	 *	Save admin settings
	 */
	public function save_settings() {

		if ( isset( $_POST['special_days'] ) ) {
			$options					= $this->a->get_business_options();
			$options['special_days']	= wpb_sanitize_commas( $_POST['special_days'] );

			if ( $this->a->update_business_options( $options ) ) {
				wpb_notice( 'saved' );
			}
		}
	}
}

	BASE('SpecialDays')->add_hooks();
}