<?php
/**
 * WPB Admin Monetary Settings
 *
 * @author		Hakan Ozevin
 * @package     WP BASE
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       2.0
 */

if ( ! defined( 'ABSPATH' ) ) exit;

if ( ! class_exists( 'WpBMonetarySettings' ) ) {

class WpBMonetarySettings{

	/**
     * WP BASE Core + Front [+Admin] instance
     */
	protected $a = null;

	/**
     * Constructor
     */
	public function __construct(){
		$this->a = BASE();
	}

	/**
     * Add admin actions
     */
	public function add_hooks() {
		add_action( 'app_submenu_after_business', array( $this, 'add_submenu' ) );
		add_action( 'app_save_settings', array( $this, 'save_settings' ), 12 );
	}

	/**
     * Add submenu page to main admin menu
     */
	public function add_submenu(){
		wpb_add_submenu_page('appointments', __('Monetary Settings','wp-base'), __('Monetary Settings','wp-base'), array(WPB_ADMIN_CAP,'manage_monetary_settings'), "app_monetary", array($this,'settings'));
	}

	/**
     * Save admin settings
     */
	public function save_settings() {

		if ( isset( $_POST['app_nonce'] ) && !wp_verify_nonce( $_POST['app_nonce'], 'update_app_settings' ) ) {
			wpb_notice( 'unauthorised', 'error' );
			return;
		}

		$options = wpb_setting();
		$changed = false;

		if ( 'save_payment' == $_POST["action_app"] ) {
			$changed = true;

			$options['payment_required']			= $_POST['payment_required'];
			$options['currency'] 					= $_POST['currency'];
			$options['curr_symbol_position']		= isset( $_POST['curr_symbol_position'] ) ? $_POST['curr_symbol_position'] : 1;
			$options['curr_decimal']				= $_POST['curr_decimal'];
			$options['decimal_separator']			= $_POST['decimal_separator'];
			$options['thousands_separator']			= $_POST['thousands_separator'];
			$options['tax']							= wpb_sanitize_price( $_POST['tax'] );

			$options['percent_downpayment']			= wpb_sanitize_price( $_POST['percent_downpayment'] );
			$options['fixed_downpayment']			= wpb_sanitize_price( $_POST['fixed_downpayment'] );
			$options['add_deposit']					= $_POST['add_deposit'];
			$options['deposit_cumulative']			= $_POST['deposit_cumulative'];
			$options['members_no_payment'] 			= isset( $_POST['members_no_payment'] );
			$options["members"]						= isset($_POST["members"]) ? maybe_serialize( $_POST["members"] ) :'';
			if ( isset( $_POST['return'] ) )
				$options['return'] 					= $_POST['return'];		// PayPal Return page
			if ( isset( $_POST['item_name'] ) )
				$options['item_name'] 				= $_POST['item_name'];	// PayPal Item name

		} else if ( 'save_gateway' == $_POST["action_app"] ) {
			$changed = true;
			if ( isset( $_POST['mp'] ) ) {
				global $app_gateway_plugins;
				foreach ( (array)$app_gateway_plugins as $name => $plugin ) {
					if ( isset( $_POST['mp']['gateways'][$name] ) ) {
						$options['gateways'][$name] = wp_unslash( $_POST['mp']['gateways'][$name] );
					}
				}
			}

			if ( isset( $_POST['mp']['gateways']['allowed'] ) ) {
				$options['gateways']['allowed'] = $_POST['mp']['gateways']['allowed'];
			} else {
				$options['gateways']['allowed'] = array();
			}
		}

		if ( $changed && $this->a->update_options( $options ) ) {

			do_action( 'app_flush_cache' );

			wpb_notice( 'saved' );

			if ( wpb_is_gateway_active( 'pay-later' ) && ! wpb_can_use_cc() ) {
				wpb_notice( __( 'Pay Later method is enabled, but no online payment gateway like Stripe or PayPal is active. Pay Later requires at least one such processor. Manual Payments can be a better method for you.', 'wp-base' ), 'error' );
			}

			if ( wpb_can_use_cc() && 'yes' != wpb_setting( 'payment_required' ) ) {
				wpb_notice( sprintf( __( 'At least one online payment processor method is active, but %s setting is set as "No". Please note that with these settings, clients can book without making any payment.', 'wp-base' ), '<a href="'.admin_url('admin.php?page=app_monetary&tab=general#payment-required').'">'.WpBConstant::get_setting_name('payment_required'). '</a>' ), 'error' );
			}
		}
	}

	/**
	 * Admin Global Settings HTML code
	 */
	public function settings() {

		wpb_admin_access_check( 'manage_monetary_settings' );
	?>
	<div class="wrap app-page app-monetary-settings">
		<h2 class="app-dashicons-before dashicons-admin-settings"><?php echo __('Monetary Settings','wp-base'); ?></h2>
		<h3 class="nav-tab-wrapper"><?php
			$tab		= !empty( $_GET['tab'] ) ? wpb_clean( $_GET['tab'] ) : 'general';
			$tabhtml	= array();

			foreach ( wpb_admin_tabs( 'monetary' ) as $stub => $title ) {
				$class = ( $stub == $tab ) ? ' nav-tab-active' : '';
				$tabhtml[] = '	<a href="' . admin_url( 'admin.php?page=app_monetary&amp;tab=' . $stub ) . '" class="nav-tab'.$class.'" id="app_tab_'.$stub.'">'.$title.'</a>';
			}

			echo implode( "\n", $tabhtml );

			?>
		</h3>
		<div class="clear"></div>

		<?php switch( $tab ) {

		case 'general': ?>

<div id="poststuff" class="metabox-holder meta-box-sortables">
	<form id="app-payment-form" class="app-form" method="post" action="<?php echo wpb_add_query_arg(null, null) ?>">
		<div id="wpb-general-monetary-settings" class="postbox">
			<div class="postbox-header">
				<h3 class="hndle"><span><?php _e('Payment & Currency', 'wp-base'); ?></span></h3>
			</div>
			<div class="inside">
				<table class="form-table">

					<?php wpb_setting_yn( 'payment_required' ) ?>

					<tr>
						<th scope="row"><?php WpBConstant::echo_setting_name('currency') ?></th>
						<td>
							<select name="currency">
							<?php
							$sel_currency = wpb_setting( 'currency', 'USD' );

							foreach ( WpBConstant::currencies() as $k => $v ) {
								echo '<option value="' . $k . '"' . ($k == $sel_currency ? ' selected' : '') . '>' .
									esc_html( $v[0], true ) .' - '. wpb_format_currency( '', $k )  . '</option>' . "\n";
							}
							?>
							</select>
						</td>
					</tr>

					<tr>
						<th scope="row"><?php WpBConstant::echo_setting_name('curr_symbol_position') ?></th>
						<td>
						<?php
							$csp	= wpb_setting( 'curr_symbol_position', 0 );
							$cd 	= wpb_setting( 'curr_decimal', 0 );
							$sign 	= wpb_format_currency( );
						?>
							<label><input value="1" name="curr_symbol_position" type="radio"<?php checked( $csp, 1 ); ?>>
							<?php echo $sign ?>100</label>&nbsp;&nbsp;&nbsp;&nbsp;
							<label><input value="2" name="curr_symbol_position" type="radio"<?php checked( $csp, 2 ); ?>>
							<?php echo $sign ?> 100</label>&nbsp;&nbsp;&nbsp;&nbsp;
							<label><input value="3" name="curr_symbol_position" type="radio"<?php checked( $csp, 3 ); ?>>
							100<?php echo $sign ?></label>&nbsp;&nbsp;&nbsp;&nbsp;
							<label><input value="4" name="curr_symbol_position" type="radio"<?php checked( $csp, 4 ); ?>>
							100 <?php echo $sign ?></label>
						</td>
					</tr>

					<tr>
						<th scope="row"><?php WpBConstant::echo_setting_name('curr_decimal') ?></th>
						<td>
							<label><input value="1" name="curr_decimal" type="radio"<?php checked( $cd, 1 ); ?>>
							<?php _e('Yes', 'wp-base' ) ?></label>&nbsp;&nbsp;&nbsp;&nbsp;
							<label><input value="0" name="curr_decimal" type="radio"<?php !checked( $cd, 0 ); ?>>
							<?php _e('No', 'wp-base' ) ?></label>
						</td>
					</tr>

					<?php wpb_setting_text( 'decimal_separator' ) ?>
					<?php wpb_setting_text( 'thousands_separator' ) ?>
					<?php wpb_setting_text( 'tax' ) ?>
					<?php do_action( 'app_payment_general_settings' ) ?>

				</table>
			</div>
		</div>

		<div id="wpb-prepayment-settings" class="postbox">
			<div class="postbox-header">
				<h3 class="hndle"><span><?php _e('Prepayment', 'wp-base'); ?></span></h3>
			</div>	
			<div class="inside">
				<table class="form-table">

					<?php wpb_setting_text( 'percent_downpayment' ) ?>
					<?php $val = wpb_setting('fixed_downpayment') ?>

					<tr>
						<th scope="row"><?php WpBConstant::echo_setting_name('fixed_downpayment'); echo ' ('. wpb_format_currency(). ')'; ?></th>
						<td>
						<input value="<?php if ( $val ) echo esc_attr( $val ) ?>" class="app-50" name="fixed_downpayment" type="text" />
						<span class="description app-btm"><?php WpBConstant::echo_setting_desc('fixed_downpayment') ?></span>
						</td>
					</tr><?php
						wpb_setting_yn( 'add_deposit' );
						wpb_setting_yn( 'deposit_cumulative' );
					?>

					<tr>
						<th scope="row"><?php WpBConstant::echo_setting_name('members_no_payment') ?></th>
						<td>
						<input type="checkbox" name="members_no_payment" <?php if ( wpb_setting("members_no_payment") ) echo 'checked="checked"' ?> />
						<span class="description app-btm"><?php WpBConstant::echo_setting_desc('members_no_payment') ?></span>
						</td>
					</tr>

					<tr>
						<th scope="row"><?php WpBConstant::echo_setting_name('members') ?></th>
						<td>
						<?php
							$meta = (array)maybe_unserialize( wpb_setting("members") );
							$members = isset( $meta["level"] ) ? $meta["level"] : array();
							echo '<select data-buttonWidth="225" data-noneSelectedText="'.esc_attr( __('Select roles', 'wp-base' ) ).'"
									class="add_roles_multiple app_ms" multiple name="members[level][]" >';
							echo wpb_role_selection( $members );

							echo '</select>';

						?>
						<span class="description app-btm"><?php WpBConstant::echo_setting_desc('members') ?></span>
						</div>
						</td>
					</tr>

				</table>
			</div>
		</div>

		<input type="hidden" name="action_app" value="save_payment" />
		<?php wp_nonce_field( 'update_app_settings', 'app_nonce' ); ?>
		<p class="submit">
		<input class="button-primary app-save-payment-btn" type="submit" name="submit_settings" value="<?php _e('Save Settings', 'wp-base' ) ?>" />
		</p>
	</form>
</div>

		<?php break;

		case 'gateways': ?>

<div id="poststuff" class="metabox-holder meta-box-sortables">

	<?php do_action( 'app_gateway_settings_before' ); ?>

	<form id="app-payment-form" class="app-form" method="post" action="<?php echo wpb_add_query_arg( null, null )?>">
		<input type="hidden" name="gateway_settings" value="1" />

         <div id="mp_gateways" class="postbox">
            <h3 class="hndle"><span><?php _e('Active Payment Methods', 'wp-base' ) ?></span></h3>
            <div class="inside">
			<span class="description app-btm"><?php _e('After you select a payment method and save, its settings will be revealed below.','wp-base') ?></span>
              <table class="form-table">
				<tr>
					<th scope="row"><?php
					global $app_gateway_plugins;
					if ( !empty( $app_gateway_plugins ) ) {
						_e('Select Payment Method(s)', 'wp-base');
					} else {
						_e('No Payment Addon Found', 'wp-base');
						$app_gateway_plugins = array();
					}
					?>
					</th>
					<td>
					<?php
					$gateways = wpb_setting( 'gateways' );
					$allowed = !empty( $gateways['allowed'] ) ? (array)$gateways['allowed'] : array();

					foreach ( $app_gateway_plugins as $code => $plugin ) {
					?><label>
						<input type="checkbox" <?php checked( in_array( $code, $allowed ), true )?> name="mp[gateways][allowed][]" value="<?php echo $code; ?>" class="app_allowed_gateways app-no-save-alert" />
						<?php echo esc_attr($plugin[1]); ?>
					</label>
					<br />
					<?php } ?>
					</td>
				</tr>
              </table>
            </div>
          </div>

		<div id="tabs" class="app-tabs">
			<ul></ul>

          <?php do_action( 'app_gateway_settings', wpb_setting() ); ?>
		</div>

		<input type="hidden" name="action_app" value="save_gateway" />
		<?php wp_nonce_field( 'update_app_settings', 'app_nonce' ); ?>
		<p class="submit">
		<input class="button-primary app-save-payment-btn" type="submit" name="submit_settings" value="<?php _e('Save Settings', 'wp-base' ) ?>" />
	  </p>
	</form>
</div>
		<?php break;

		case $tab:	do_action( 'app_monetary_'.$tab.'_tab' ); break;

		} ?>
		</div><!-- Wrap -->

	<?php
	}
}

	BASE('MonetarySettings')->add_hooks();
}