<?php
/**
 * WPB Admin Help
 *
 * @author		Hakan Ozevin
 * @package     WP BASE
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       3.0
 */

if ( ! defined( 'ABSPATH' ) ) exit;

if ( ! class_exists( 'WpBHelp' ) ) {

class WpBHelp {

	const wpb_uploads_url = 'https://wp-base.com/uploads';
	const support_email = "support@wp-base.com";

	private $support_form_error;

	/**
     * WP BASE Core + Front [+Admin] instance
     */
	protected $a = null;

	/**
     * Constructor
     */
	public function __construct(){
		$this->a = BASE();
	}

	/**
     * Add actions
     */
	public function add_hooks() {

		add_action( 'app_submenu_after_tools', array( $this, 'add_submenu' ), 12 );

		// Support email
		add_action( 'admin_init', array( $this, 'send_support_email') );					// Handle support email
		add_action( 'admin_notices', array( $this, 'support_form_error' ) );				// Display errors
	}

	/*******************************
	* Support Email
	********************************
	*/

	/**
     * send support email
     */
	public function send_support_email() {
		if ( ! isset($_POST['app_support_email']) ) {
			return;
		}

		foreach( array( 'app_support_client_email', 'app_support_subject', 'app_support_content' ) as $req ) {
			if ( ! isset( $_POST[ $req ] ) || ! trim( $_POST[ $req ] ) ) {
				$this->support_form_error = 'field_missing';
				return;
			}
		}

		if ( ! is_email( $_POST['app_support_client_email'] ) ) {
				$this->support_form_error = 'wrong_email';
				return;
		}

		if ( ! isset( $_POST['app_support_client_name'] ) || !trim( $_POST['app_support_client_name'] ) ) {
				$this->support_form_error = 'field_missing';
				return;
		}

		if ( stripos( $_POST['app_support_subject'], 'license problem' ) === false ) {
			$found = false;
			foreach( get_plugins( ) as $path => $info ) {

				if ( strpos( $info['Name'], 'WP BASE' ) === false ) {
					continue;
				}

				$data = get_file_data( WP_PLUGIN_DIR.'/'.$path, wpb_default_headers(), 'plugin' );
				$stat = ! empty( $data['ID'] ) ? (string)get_option( 'wpb_license_status_' . $data['ID'] ) : '';
				if ( 'valid' === $stat ) {
					$found = true;
					break;
				}
			}

			if ( ! $found ) {
				$this->support_form_error = 'no_valid_license';
				return;
			}
		}

		$attach = array();
		$blog_name = sanitize_file_name( get_bloginfo( 'name' ) );
		$filename_zip = $this->a->uploads_dir . "/wp_base_all_". $blog_name. "_". date('F')."_".date('d')."_".date('Y').".zip";

		if ( ! empty( $_POST['app_support_include'] ) && BASE('EXIM') ) {

			if ( class_exists( 'ZipArchive' ) ) {
				$zip = new ZipArchive();

				// Delete previous zip file if it exists
				if ( file_exists( $filename_zip ) ) {
					unlink( $filename_zip );
				}

				if ( $zip->open( $filename_zip, ZIPARCHIVE::CREATE ) === true ) {

					if ( $filename_db = BASE('EXIM')->export_db( true, true ) ) { // Exclude transaction table
						if ( file_exists( $this->a->uploads_dir . "/". $filename_db ) ) {
							$zip->addFile( $this->a->uploads_dir . "/". $filename_db, $filename_db );
						}
					}

					if ( $filename_set = BASE('EXIM')->export_settings( true ) ) {
						if ( file_exists( $this->a->uploads_dir . "/". $filename_set ) ) {
							$zip->addFile( $this->a->uploads_dir . "/". $filename_set, $filename_set );
						}
					}

					if ( file_exists( $this->a->log_file ) ) {
						$zip->addFile( $this->a->log_file, 'appointments-log.txt' );
					}

					$attach[] = $filename_zip;
				}

				// Compress and save changes
				$zip->close();

			} else {
				if ( $filename_db = BASE('EXIM')->export_db( true, true ) ) { // Exclude transaction table
					if ( file_exists( $this->a->uploads_dir . "/". $filename_db ) ) {
						$attach[] = $this->a->uploads_dir . "/". $filename_db;
					}
				}

				if ( $filename_set = BASE('EXIM')->export_settings( true ) ) {
					if ( file_exists( $this->a->uploads_dir . "/". $filename_set ) ) {
						$attach[] = $this->a->uploads_dir . "/". $filename_set;
					}
				}

				if ( file_exists( $this->a->log_file ) ) {
					$attach[] = $this->a->log_file;
				}
			}
		}

		global $wp_version, $wp_db_version, $wp_locale;

		$c = wp_unslash( $_POST['app_support_content'] );
		$c .= "\r\n";
		$c .= "-------------------------------------------\r\n";
		$c .= "\r\n";
		$c .= __('Name:','wp-base');
		$c .= " " . $_POST['app_support_client_name'];
		$c .= "\r\n";
		$c .= __('email:','wp-base');
		$c .= " " . $_POST['app_support_client_email'];
		$c .= "\r\n";
		$c .= __('URL:','wp-base');
		$c .= " " . get_bloginfo('url');
		$c .= "\r\n";
		$c .= __('WP BASE Version:','wp-base');
		$c .= " " . $this->a->version;
		$c .= "\r\n";
		$c .= __('WP BASE DB Version:','wp-base');
		$c .= " " . $this->a->get_db_version();
		$c .= "\r\n";
		$c .= __('WordPress Version:','wp-base');
		$c .= " " . $wp_version;
		$c .= "\r\n";
		$c .= __('WordPress Database Version:','wp-base');
		$c .= " " . $wp_db_version;
		$c .= "\r\n";
		$c .= __('PHP Version:','wp-base');
		$c .= " " . PHP_VERSION;
		$c .= "\r\n";
		$c .= __('PHP Max Input Variables:','wp-base');
		$c .= " " . ini_get( 'max_input_vars' );
		$c .= "\r\n";
		$c .= __('Date/time format:','wp-base');
		$c .= " " . $this->a->dt_format;
		$c .= "\r\n";
		$c .= __('Week starts on:','wp-base');
		$c .= " " . $wp_locale->get_weekday( $this->a->start_of_week );
		$c .= "\r\n";
		$c .= __('Local time:','wp-base');
		$c .= " " . date( 'Y-m-d H:i:s', $this->a->_time );
		$c .= "\r\n";
		$c .= __('GMT time:','wp-base');
		$c .= " " . date( 'Y-m-d H:i:s');
		$c .= "\r\n";
		$c .= __('Timezone offset:','wp-base');
		$c .= " " . get_option('gmt_offset');
		$c .= "\r\n";
		$c .= __('Timezone string:','wp-base');
		$c .= " " . get_option('timezone_string');
		$c .= "\r\n";
		$c .= __('Locale:','wp-base');
		$c .= " " . $this->a->get_locale();
		$c .= "\r\n";
		$c .= __('Number of locations:','wp-base');
		$c .= " " . $this->a->get_nof_locations();
		$c .= "\r\n";
		$c .= __('Number of services:','wp-base');
		$c .= " " . $this->a->get_nof_services();
		$c .= "\r\n";
		$c .= __('Number of providers:','wp-base');
		$c .= " " . $this->a->get_nof_workers();
		$c .= "\r\n";
		if ( $make_pages = wpb_setting('make_page') ) {
			$c .= __('First booking page:','wp-base') .' ';
			$c .=  ! empty( $make_pages[0] ) ? get_permalink( $make_pages[0] ) : '';
			$c .= "\r\n";
		}
		$c .= "\r\n";

		include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

		if ( BASE('Addons') ) {
			$c .= __('Active Addons:', 'wp-base' ) . "\r\n";
			foreach ( BASE('Addons')->get_all_addons( ) as $plugin ){
				if ( BASE('Addons')->is_active( $plugin ) ) {
					$info = BASE('Addons')->get_addon_info( $plugin );
					$c .= str_replace( 'WP BASE Addon: ', '', $info['Name'] ) . " ". $info['Version'] . "\r\n";
				}
			}
			$c .=  "\r\n";
		}

		$c .= __('WP Plugins:', 'wp-base' ) . "\r\n";
		foreach ( get_plugins( ) as $path=>$info ){
			$data = get_file_data( WP_PLUGIN_DIR.'/'.$path, wpb_default_headers(), 'plugin' );
			$license = ! empty( $data['ID'] ) ? (string)get_option( 'wpb_license_key_' . $data['ID'] ) : '';
			$active = is_plugin_active( $path ) ? ' Active' : '';
			$c .= $info['Name'] . " ". $info['Version'] . $active. " ". $license ."\r\n";
		}

		if ( 'yes' == wpb_setting('use_html') ) {
			$c = str_replace( "\r\n", "<br />", $c );
		}

		$to = array( self::support_email );

		if ( isset ( $_POST['app_support_copy'] ) ) {
			$to[] = $_POST['app_support_client_email'];
		}

		if ( wp_mail( $to, wp_unslash( $_POST['app_support_subject'] ), $c, $this->a->message_headers(), $attach ) ) {
			wpb_notice( __('Your support request email has been successfully sent.','wp-base') );
			unset( $_POST['app_support_client_email'] );
			unset( $_POST['app_support_content'] );
			unset( $_POST['app_support_subject'] );
		} else {
			wpb_notice( __('Sending the support request email has failed. Please check if you can actually send any emails from this website. For example, logout and try to receive an email using "Lost your password?" link of WordPress admin login page.','wp-base') );
		}

		// Delete zip file
		if ( file_exists( $filename_zip ) ) {
			unlink( $filename_zip );
		}
	}

	/**
	 * Prints error message on top of Admin page
	 */
	public function support_form_error( ) {
		if ( empty( $this->support_form_error ) ) {
			return;
		}

		$error = $this->support_form_error;

		if ( 'field_missing' === $error ) {
			echo '<div class="error"><p><b>[WP BASE]</b> '. __('Please fill in the empty field. All fields are required.','wp-base').'</p></div>';
		} else if ( 'wrong_email' === $error ) {
			echo '<div class="error"><p><b>[WP BASE]</b> '. __('Submitted email is not correct.','wp-base').'</p></div>';
		} else if ( 'no_valid_license' === $error ) {
			echo '<div class="error"><p><b>[WP BASE]</b> '. sprintf( __('We are sorry, but it looks like you do not have any active licenses. If your issue is about activating a license, please write "License Problem" in the email subject field and try again. If you do not have a license, use wordpress.org forums for technical issues. For other requests please use %s.', 'wp-base' ), '<a target="_blank" href="'.WPBASE_URL.'contact-us/">'.__('our contact form','wp-base').'</a>').'</p></div>';
		} else {
			echo '<div class="error"><p><b>[WP BASE]</b> '. __('An error occurred. Please try again','wp-base').'</p></div>';
		}
	}

	/**
     * Add submenu page to main admin menu
     */
	public function add_submenu(){
		add_submenu_page( 'appointments', __('Help','wp-base'), __('Help','wp-base'), WPB_ADMIN_CAP, "app_help", array($this,'help') );
	}

	/**
	 * Makes a text translatable by defining translation folder
	 * @param text: text to be translated
	 * @since 2.0
	 * @return string
	 */
	public function _t( $text ) {
		return __( $text, 'wp-base' );
	}

	/**
	 * Returns an admin anchor link
	 * @param href: href of the anchor
	 * @param title: title of the anchor (already translated)
	 * @param text: text of the anchor (already translated)
	 * @since 2.0
	 * @return string
	 */
	public function _a( $text, $href='', $title='' ) {
		$t = $title ? ' title="'. $title.'"' : '';
		$h = $href ? admin_url($href) : 'javascript:void(0)';
		return '<a href="'.$h.'"'.$t.' target="_blank">' . $text . '</a>';
	}

	/**
	 * Help tabs
	 * @param echo: If true send to browser. If false return the html.
	 */
	public function help( $echo = true ) {

		?>
	<div class="wrap app-help-page">
		<h2 class="app-dashicons-before dashicons-welcome-learn-more"><?php echo __('Help','wp-base'); ?></h2>
		<h3 class="nav-tab-wrapper">
			<?php
			$tab = ( ! empty($_GET['tab']) ) ? wpb_clean( $_GET['tab'] ) : 'general';
			$tabhtml = array();

			foreach ( wpb_admin_tabs( 'help' ) as $stub => $title ) {
				$class = ( $stub == $tab ) ? ' nav-tab-active' : '';
				$tabhtml[] = '	<a href="' . admin_url( 'admin.php?page=app_help&amp;tab=' . $stub ) . '" class="nav-tab'.$class.'" id="app_tab_'.$stub.'">'.$title.'</a>';
			}

			echo implode( "\n", $tabhtml );
			?>
		</h3>
		<div class="clear"></div>
		<?php switch( $tab ) {

		case 'general':	?>
			<div id="poststuff" class="metabox-holder">
				<div class="postbox">
					<div class="inside">
						<?php $this->general_help(); ?>
					</div>
				</div>
			</div>

		<?php break;

		case 'settings':	?>
			<div id="poststuff" class="metabox-holder">
			<?php wpb_infobox( __('Help texts here are identical to the texts beside each setting on several setting pages. They are collected here just for convenience. Addon which uses that setting is also shown. You can sort columns and search for a term.','wp-base') ) ?>
				<div class="postbox">
					<div class="inside">
						<?php $this->settings_help(); ?>
					</div>
				</div>
			</div>
		<?php break;

		case 'shortcodes':	?>
			<div id="poststuff" class="metabox-holder">
			<?php wpb_infobox( __( 'WP BASE uses shortcodes to generate output on the front end. This gives you the flexibility to customize your appointment pages using the WordPress post editor without the need for php coding. There are several parameters of the shortcodes by which your customizations can be highly flexible. On the other hand, if you don\'t set these parameters, WP BASE will still function properly. Thus, setting parameters is fully optional. For historical reasons, all WP BASE shortcodes start with <b>app_</b> prefix.', 'wp-base' ) ); ?>
				<div class="postbox app-shortcodes-help">
					<div class="inside">
						<?php $this->shortcodes_help(); ?>
					</div>
				</div>
			</div>
		<?php break;

		case 'support':

	?>
<div id="poststuff" class="metabox-holder">
	<?php wpb_infobox( sprintf( __( 'If you have a valid license for one of our %1$s, you can use this form to send an email about the issue to our support team. If you do not have a license please use %2$s for technical issues and %3$s for other requests.', 'wp-base' ), '<a target="_blank" href="'.WPBASE_URL.'addons/">'.__('Premium Addons','wp-base').'</a>', '<a target="_blank" href="https://wordpress.org/support/plugin/wp-base-booking-of-appointments-services-and-events/">'.__('wordpress.org forums','wp-base').'</a>', '<a target="_blank" href="'.WPBASE_URL.'contact-us/">'.__('our contact form','wp-base').'</a>' ) ) ?>
	<form id="app_support_request_form" class="app-form" method="post" action="<?php echo wpb_add_query_arg(null, null) ?>">
		<div class="postbox">
			<h3 class="hndle"><span><?php _e('Support Request Form', 'wp-base' ) ?></span></h3>
			<div class="inside">
				<table class="form-table">
					<tr id="app_support_client_email">
						<th scope="row" ><?php _e('Your email', 'wp-base' ) ?></th>
						<td>
						<input placeholder="<?php _e('Required','wp-base') ?>" type="text" name="app_support_client_email" value="<?php if (isset($_POST['app_support_client_email'])) echo wpb_clean( $_POST['app_support_client_email'] ); else echo BASE('User')->get_admin_email( true ); ?>" />
						</td>
					</tr>
					<tr id="app_support_client_name">
						<th scope="row" ><?php _e('Your name', 'wp-base' ) ?></th>
						<td>
						<input placeholder="<?php _e('Required','wp-base') ?>" type="text" name="app_support_client_name" value="<?php if (isset($_POST['app_support_client_name'])) echo wpb_clean( $_POST['app_support_client_name'] ); ?>" />
						</td>
					</tr>
					<tr id="app_support_subject">
						<th scope="row" ><?php _e('Subject', 'wp-base' ) ?></th>
						<td>
						<input placeholder="<?php _e('Required','wp-base') ?>" type="text" name="app_support_subject" value="<?php if (isset($_POST['app_support_subject'])) echo wpb_clean( $_POST['app_support_subject'] ); else printf( __('Support Request from %s','wp-base'), wp_specialchars_decode( get_option('blogname'), ENT_QUOTES ) ); ?>" />
						</td>
					</tr>
					<tr id="app_support_content">
						<th scope="row" ><?php _e('Your Message', 'wp-base' ) ?></th>
						<td>
						<textarea placeholder="<?php _e('Required','wp-base') ?>" name="app_support_content" ><?php if (isset($_POST['app_support_content'])) echo wpb_clean( $_POST['app_support_content'] );?></textarea>
						</td>
					</tr>

					<tr>
						<td colspan="2">
						<input id="app_support_copy" name="app_support_copy" value="1" type="checkbox" <?php checked( isset($_POST['app_support_copy']),1, true ) ?> />&nbsp;
						<span class="app-btm"><?php _e("Click to receive a copy of this form submission to your email.",'wp-base') ?>
						</span>
						</td>
					</tr>

					<tr>
						<td colspan="2">
					<?php if ( BASE('EXIM') ) { ?>
						<input id="app_support_include" name="app_support_include" value="1" type="checkbox" checked="checked"/>&nbsp;
						<span class="app-btm"><?php _e("Automatically attach current settings and plugin related database tables, plus data of the users who are related to the plugin (service providers and clients).",'wp-base') ?>
					<?php } else {
						printf( __( '<strong>In order to be able to add your website settings to this form, please download, install and activate free %s.</strong>', 'wp-base' ), '<a href="'.WPBASE_URL.'downloads/export-import/" target="_blank">'. __( 'Export & Import Addon', 'wp-base' ) .'</a>' );
					} ?>
						</span>
						</td>
					</tr>

				</table>
			</div>
		</div>
		<input name="app_support_email" type="hidden" />
		<input id="app_support_button" type="submit" class="button-primary" value="<?php _e('Send Support Request Email','wp-base') ?>" />
	</form>
</div>
		<?php
		break;

		case 'about':
			global $wp_version, $wp_db_version;
		?>
		<div id="poststuff" class="metabox-holder">
			<div class="postbox">
				<div class="inside">
				<h4><?php _e( 'Version Info:', 'wp-base' ) ?></h4>
					<p>
					<?php
					_e('PHP Version:','wp-base');
					echo " " . PHP_VERSION;
					?>
					</p>
					<p>
					<?php
					_e('PHP Max Input Variables:','wp-base');
					echo " " . ini_get( 'max_input_vars' );
					?>
					</p>
					<p>
					<?php
					_e('WP BASE Version:','wp-base');
					echo " " . $this->a->version;
					?>
					</p>
					<p>
					<?php
					_e('WordPress Version:','wp-base');
					echo " " . $wp_version;
					?>
					</p>
					<p>
					<?php
					_e('WordPress Database Version:','wp-base');
					echo " " . $wp_db_version;
					?>
					</p>
					<p>
					<?php
					_e('Latest WP BASE DB Version:','wp-base');
					echo " " . WPB_LATEST_DB_VERSION;
					?>
					</p>
					<p>
					<?php
					_e('Installed WP BASE DB Version:','wp-base');
					echo " " . get_option( 'wp_base_db_version' );
					?>
					</p>
					<?php
					echo '<h4>';
					_e('Cron Command:','wp-base');
					echo '</h4><p>';
					echo " <code>curl -sS ". admin_url( 'admin-ajax.php?action=app_cron' ) .'</code> '. __( '(Without log)', 'wp-base' );
					echo '<br>OR<br>';
					echo " <code>curl -sS ". admin_url( 'admin-ajax.php?action=app_cron_log' ) .'</code> '.__( '(With log)', 'wp-base' );
					echo '<br>OR<br>';
					echo '<code>wget -q -O - '. site_url( 'wp-cron.php' ) .'</code> '. __( '(Without log)', 'wp-base' );
					echo '</p>';
					?>
					<?php
					if ( BASE('Addons') ) {
						echo "<h4>". __('Installed Addons:', 'wp-base' ) . "</h4>";

						foreach ( BASE('Addons')->get_all_addons( ) as $plugin ){
							$info = BASE('Addons')->get_addon_info( $plugin );
							$active = BASE('Addons')->is_active( $plugin ) ? __('(Active)','wp-base') : __('(Inactive)','wp-base');
							echo str_replace( 'WP BASE Addon: ', '', $info['Name'] ) . " ". $info['Version'] . ' '. $active. "<br />";
						}
					}

					echo "<h4>". __('Addons as WP Plugin:', 'wp-base' ) . "</h4>";
					foreach ( get_plugins( ) as $path=>$info ){
						if ( 'WP BASE Addon:' == substr( $info['Name'], 0, 14 ) ) {
							$active = is_plugin_active( $path ) ? __('(Active)','wp-base') : __('(Inactive)','wp-base');
							echo str_replace( 'WP BASE Addon: ', '', $info['Name'] ) . " ". $info['Version'] . ' '. $active. "<br />";
						}
					}
					?>

				</div>
			</div>
		</div>
		<?php break;

		} // End of switch
	?></div>
	<?php
	}

	/**
	 * General Help Content
	 */
	public function general_help( $return = false ) {
		ob_start();
		?>
			<h3><?php _e( 'INTRODUCTION', 'wp-base' ) ?></h3>

			<p><span class="description">
			<?php _e('Booking of Appointments, Services and Events WordPress plugin (in short, WP BASE) is a complete solution to accept appointments and schedule based bookings on your WordPress website. It is created as a WordPress plugin starting from the development stage, therefore its codes are optimized for WordPress.','wp-base') ?>
			</span></p>

			<p><span class="description">
			<?php _e('With WP BASE, your clients can make an appointment based on your available times, if set so, pay full price or deposit of the cost, edit and cancel their appointment by themselves without the need for your intervention. You and/or your employees can also add a new appointment or make corrections on an existing one.','wp-base') ?>
			</span></p>

			<p><span class="description">
			<?php _e('WP BASE has been developed to cover all functions related to make an appointment from a person in the first place, however, in some cases it can also be used to book resources (technical material, equipment, etc), locations (meeting or function rooms, etc), vehicles with driver (hourly or daily tour, airport transfer, etc), or shared facilities (Tennis court, barbeque pit, etc).','wp-base') ?>
			</span></p>

			<p><span class="description">
			<?php printf( __('On our %s you can view some of the possible applications.','wp-base'), '<a href="'.WPB_DEMO_WEBSITE.'" target="_blank">'.__('demo website','wp-base').'</a>' ) ?>
			</span></p>

			<h3><?php _e( 'ADDONS', 'wp-base' ) ?></h3>

			<p><span class="description">
			<?php printf( __('While covering many needs of the businesses, WP BASE functionality can be further extended and expanded using %s. Addons are WordPress plugins tailored to cover needs for certain applications. There are several Free and Premium addons which makes WP BASE a complete ecosystem.','wp-base'), '<a href="'.WPBASE_URL.'addons/" target="_blank">'.__('Addons','wp-base').'</a>' ) ?>
			</span></p>

			<p><span class="description">
			<?php printf( __('Usage examples can be seen on our %s','wp-base'), '<a href="'.WPB_ADDON_DEMO_WEBSITE.'" target="_blank">'.__('addons demo website','wp-base').'</a>' ) ?>
			</span></p>

			<h3><?php _e( 'FURTHER HELP', 'wp-base' ) ?></h3>

			<p><span class="description">
			<?php printf( __('Documentation over various aspects of WP BASE and addons can be found on %s','wp-base'), '<a href="'.WPBASE_URL.'knowledge-base/" target="_blank">'.__('Knowledge Base','wp-base').'</a>' ) ?>
			</span></p>

			<p><span class="description">
			<?php printf( __('If you own a valid license, you can send an email to our support team using %s','wp-base'), '<a href="'.admin_url('admin.php?page=app_help&tab=support').'" target="_blank">'.__('WP BASE support form','wp-base').'</a>' ) ?>
			</span></p>

			<p><span class="description">
			<?php printf( __('You can open a support topic on %s','wp-base'), '<a href="https://wordpress.org/support/plugin/wp-base-booking-of-appointments-services-and-events/" target="_blank">'.__('WordPress Community forums','wp-base').'</a>' ) ?>
			</span></p>

			<h3><?php _e( 'DEFINITIONS', 'wp-base' ) ?></h3>
			<p><span class="description">
			<?php _e('These are some of the terminology used throughout WP BASE:','wp-base') ?>
			</span></p>

			<p><span class="description">
			<?php _e('<b>Admin:</b> A user who has the WordPress "manage_options" capability. More than one admins are allowed in WP BASE; e.g. each of them will get notification email messages.','wp-base') ?>
			</span></p>

			<p><span class="description">
			<?php _e('<b>Location:</b> settings can be used a) to show the address of the service when they are served at more than one place b) to group and categorise services especially when there are numerous services.','wp-base') ?>
			</span></p>

			<p id="service"><span class="description">
			<?php _e('<b>Service:</b> The action of doing help or work for the client. WP BASE is basically about booking of services with or without nominated service providers and with or without a predetermined price. Services can be hourly or daily, free or paid, may be requiring down payment or not. Hourly services can be from 10 minutes up to 24 hours. Services longer than 24 hours is also possible with Advanced Features addon.','wp-base') ?>
			</span></p>

			<p id="service-provider"><span class="description">
			<?php printf( __('<b>Provider:</b> The person who is providing the service client is applying and booking for. A provider may give a single or multiple services. Providers are optional, i.e. you can be the sole provider giving the services. If no service providers are defined, WP BASE assumes that there is a single provider giving all of the services. This sole provider can be selected using %s setting. Only members of the website can be assigned as providers.','wp-base'), '<a href="'.admin_url('admin.php?page=app_settings&tab=login#default-worker').'">'. WpBConstant::get_setting_name( 'default_worker' ) .'</a>' ) ?>
			</span></p>

			<p id="dummy"><span class="description">
			<?php _e('<b>Dummy Service Provider:</b> is a "fake" service provider for whom emails will be forwarded to another (real) user, selected on Advanced Settings page. You can use dummy option to enrich your service provider alternatives and variate your working schedules. For example, suppose that you are giving Service A only on weekdays, and Service B only on weekends. Then you can define Provider 1 to give Service A working on weekdays, and Provider 2 to give Service B working on weekends. Note that using dummies is not a direct alternative of setting service capacity. Both options have its advantages and different area of application.','wp-base') ?>
			</span></p>

			<p><span class="description">
			<?php _e('<b>Working Hours:</b> Define in which hours and days service providers are available and  as a result, in which hours and days services are bookable. Working hours are related to service providers with the exception of "Unassigned Provider" which defines business working hours. Service providers\' working hours can be outside working hours of the business.','wp-base') ?>
			</span></p>

			<p><span class="description">
			<?php _e('<b>Security Deposit:</b> Deposit is, by definition, a sum of money or equivalent given as security for an item acquired for temporary use. For example if you are renting some facilities and these facilities include some items that can be damaged by the client, you can ask a deposit in advance and refund it after client return the facility and you check and see that there was no harm. Since deposits are almost always delivered as manual payments (cash, check, or other valuables) and kept in special accounts, deposit amount is NOT added to the one that client pays via online payment gateways, e.g. Paypal. However, they are added to the total due and affect the balance of the booking. ','wp-base') ?>
			</span></p>

			<p><span class="description">
			<?php _e('<b>Down Payment:</b> Down Payment is a percentage or portion of the service price and it is again for security, but in this case, to cover any indirect losses in case client cancels the booking or does not show up at all. When payment is required to confirm a booking, this is the amount that client needs to pay through online payment gateways.','wp-base') ?>
			</span></p>

			<p><span class="description">
			<?php _e('<b>Status:</b> is the latest state of an appointment. Statuses can be automatically (for example a pending appointment automatically becomes "removed" after a preset time) or manually changed, i.e. using admin side Appointments page or front end page having Manage Bookings Addon shortcode. These are statuses used in WP BASE:','wp-base') ?>
			</span></p>


			<ul style="list-style-type:disc;padding-left:30px;">
			<?php
			foreach ( WpBConstant::app_desc() as $key => $line ) {
				echo "<li>". $line . "</li>";
			}
			?>
			</ul>

			<p id="time-slot"><span class="description">
			<?php _e('<b>Time slot:</b> An interval of time with an exact start and end value which defines the appointment start and end date/time. Unless it is a break time or holiday, each time slot can turn into an appointment, when booked. WP BASE produces time slots based on duration of the service to be booked and working hours of the service provider. For example, for a service of one hour duration and a service provider working from 9 to 5 and having a break between 12pm-1pm, time slots will be: 9am, 10am, 11am, 1pm, 2pm, 3pm, 4pm. Time slots can be presented on the front end in list view, monthly calendar view or weekly calendar view, depending on the shortcode used.','wp-base') ?>
			</span></p>

			<p id="capacity"><span class="description">
			<?php _e('<b>Service Capacity:</b> is the number of clients that can be served at a given time slot. Normally service capacity is determined by the number of service providers. For example if you employ 4 hairdressers for a hairstyling salon, you have a capacity of 4 for hair cut service, for any time slot that these providers are working. This means any time slot can be booked 4 times by different clients. There are cases, however, that you need to increase the service capacity. You can do this by entering the required number inside the capacity field of the related service. For example, if you are organizing city tours, and you have a minibus for 10 passengers, you can simply enter 10 as the capacity value. Then 10 different clients can book for the city tour. Note: Service capacity cannot be decreased below number of providers. If you do need it, consider assigning service to a location and set Location Capacity.','wp-base') ?>
			</span></p>

			<p id="location-capacity"><span class="description">
			<?php _e('<b>Location Capacity:</b> is the number of services that can be given at a given time slot for the selected location. Location capacity cannot be increased. Usage example: A "Hairdresser" location has "Gents\' Haircut" and "Ladies\' Haircut" services. There are 7 hairdressers who can work in both of the services (or some can work only in one of the services, which will not make any difference for this example), but there are only 5 barber chairs. If chairs can be used for both services, then set location capacity as 5 which will limit total bookable slots as 5 at any given time. However if 3 of the chairs are for Gents\' and 2 of them are for Ladies\', set service capacities as 3 and 2, respectively.','wp-base') ?>
			</span></p>

			<p id="parent-child-bookings"><span class="description">
			<?php _e('<b>Parent & Child Bookings:</b> WP BASE has several Addons which can create multiple bookings at a single checkout. Examples of such Addons are Shopping Cart, WooCommerce, Packages, Recurring Appointments, Extras. When bookings are written to the database, one of them (usually the one which will start last) is automatically selected to lead the others. This one is called parent booking and the rest are called child bookings. Each child booking is called a sibling relative to the other children.','wp-base') ?>
			</span></p>

			<?php
		$c = ob_get_contents();
		ob_end_clean();

		if ( $return ) {
			return $c;
		} else {
			echo $c;
		}
	}

	/**
	 * Settings Help Content
	 */
	public function settings_help( $return = false ) {
		ob_start();

		  ?>
		<div class="app-mt"></div>
		<table style="width:99.9%" class="widefat striped app-settings-list">
			<thead>
				<tr>
					<th style="width:25%; text-align:left;"><?php _e( 'Name [Internal Name]', 'wp-base' ) ?></th>
					<th style="width:58%; text-align:left;"><?php _e( 'Description', 'wp-base' ) ?></th>
					<th style="width:16.9%; text-align:left;"><?php _e( 'Addon', 'wp-base' ) ?></th>
				</tr>
			</thead>
		<?php
			$defaults = WpBConstant::defaults(true,'all');
			$titles = array();
			foreach ( $defaults as $def ) {
				$titles[] = $def[1];
			}

			array_multisort( $titles, SORT_ASC, $defaults );

			foreach ( $defaults as $key => $val ) {

				if ( ! $val[1] || ! $val[2] ) {
					continue;
				}

				$cl = ! empty( $val[3] ) ? 'data-addon="'.esc_attr($val[3]).'" title="'.esc_attr( sprintf( __('Requires %s addon','wp-base'), $val[3] ) ).'"' : '';

				echo '<tr '.$cl.'><td>';
				echo $val[1] . '<br/>['. $key. ']';
				echo '</td><td>';
				echo $val[2];
				echo '</td><td>';
				echo ! empty( $val[3] ) ? $val[3] : '';
				echo '</td></tr>';
			}
		?>
		</table>
		<?php

		$c = ob_get_contents();
		ob_end_clean();

		if ( $return ) {
			return $c;
		} else {
			echo $c;
		}
	}

	/**
	 * Shortcodes Help Content
	 */
	public function shortcodes_help( ) {
		?>
		<div id="app-tabs">
			<ul></ul>
				<?php
				$shortcodes = WpBConstant::shortcode_desc();
				ksort( $shortcodes );
				$k = 0;
				foreach ( $shortcodes as $shortcode => $data ) {

					$cl = ( $k % 2 != 0 ) ? 'class="odd"' : '';
					echo '<div class="app_help_sc" id="'.str_replace( '_', '-', $shortcode ).'-shortcode" '.$cl.'>';
					echo '<ul>';
					echo '<li class="app_help_sc_title"><span class="app-help-t1">' . __('Name:', 'wp-base'). ' </span><span class="app_help_sc_title_txt">' . $data['name'] . '</span></li>';
					echo '<li><span class="app-help-t1">' . __('Shortcode: ', 'wp-base'). ' </span><code>['. $shortcode . ']</code></li>';
					echo '<li><span class="app-help-t1">' . __('Description:', 'wp-base'). ' </span> ' . $data['description'] . '</li>';

					echo '<li><span class="app-help-t1">'. __('Attributes:', 'wp-base' ) . '</span>';
					echo '<ul>';

					if ( ! empty( $data['parameters'] ) ) {

						$parameters = $data['parameters'];
						ksort( $parameters  );

						foreach ( $parameters as $par_name => $par_desc ) {
							echo '<li><span class="app-help-t2">'. $par_name . ': </span>' .$par_desc . '</li>';
						}

					} else {
						echo '<li>'. __( 'This shortcode does not have any attributes', 'wp-base' ) . '</li>';
					}

					echo '</ul>';
					echo '</li>';
					echo '</ul>';
					echo '</div>';
					$k++;
				}
			?>
		</div>
	<?php
	}

}

	BASE('Help')->add_hooks();
}
