<?php
/**
 * WPB Admin Display Settings
 *
 * @author		Hakan Ozevin
 * @package     WP BASE
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       2.0
 */

if ( ! defined( 'ABSPATH' ) ) exit;

if ( ! class_exists( 'WpBDisplaySettings' ) ) {

class WpBDisplaySettings{

	/**
     * WP BASE Core + Front [+Admin] instance
     */
	protected $a = null;

	/**
     * Constructor
     */
	public function __construct(){
		$this->a = BASE();
	}

	/**
     * Add admin actions
     */
	public function add_hooks() {
		add_action( 'app_submenu_after_business', array( $this, 'add_submenu' ), 12 );
		add_action( 'app_save_settings', array( $this, 'save_settings' ), 12 );
	}

	/**
     * Add submenu page to main admin menu
     */
	public function add_submenu(){
		wpb_add_submenu_page('appointments', __('Display Settings','wp-base'), __('Display Settings','wp-base'), array(WPB_ADMIN_CAP,'manage_display_settings'), "app_display", array($this,'settings'));
	}

	/**
     * Save admin settings
     */
	public function save_settings() {

		if ( isset( $_POST['app_nonce'] ) && !wp_verify_nonce( $_POST['app_nonce'], 'update_app_settings' ) ) {
			wpb_notice( 'unauthorised' );
			return;
		}

		$settings_changed = $saved = false;

		$options = wpb_setting();

		if ( 'save_display_general' == $_POST['action_app'] ) {

			$options['duration_format']				= $_POST['duration_format'];
			$options['disable_tooltips']			= $_POST['disable_tooltips'];
			$options['calendar_design']				= $_POST['calendar_design'];
			$options['caption_color']				= str_replace( '#', '', $_POST['caption_color'] );
			$options['caption_font_color']			= str_replace( '#', '', $_POST['caption_font_color'] );
			$options['show_legend']					= $_POST['show_legend'];
			$options['hide_busy']					= $_POST['hide_busy'];
			$options['theme']						= $_POST['theme'];
			$options['color_set']					= $_POST['color_set'];
			foreach ( $this->a->get_legend_items() as $class => $name ) {
				$options[$class.'_color']			= str_replace( '#', '', $_POST[$class.'_color']);
			}
			/* Which user fields will be required */
			foreach ( $this->a->get_user_fields() as $f ) {
				$options['ask_'.$f]					= isset( $_POST['ask_'.$f] );
			}
			$options['ask_note']					= isset( $_POST['ask_note'] );
			$options['ask_remember']				= isset( $_POST['ask_remember'] );
			$options['slider']						= $_POST['slider'];
			$options['slider_mobile']				= $_POST['slider_mobile'];
			$options['slider_count']				= $_POST['slider_count'];
			$options['slider_count_mobile']			= $_POST['slider_count_mobile'];
			$options['slider_margin']				= $_POST['slider_margin'];
			$options['slider_width']				= $_POST['slider_width'];

			if ( $this->a->update_options( $options ) ) {
				wpb_notice( 'saved' );
			}
		}
	}

	/**
	 * Admin display settings HTML code
	 * @since 2.0
	 */
	public function settings() {

		wpb_admin_access_check( 'manage_display_settings' );
	?>
<div class="wrap app-page app-display-settings">
	<h2 class="app-dashicons-before dashicons-welcome-view-site"><?php echo __('Display Settings','wp-base'); ?></h2>
	<h3 class="nav-tab-wrapper"><?php

		$tab 		= ! empty( $_GET['tab'] )? wpb_clean( $_GET['tab'] ) : 'general';
		$tabhtml 	= array();

		foreach ( wpb_admin_tabs( 'display' ) as $stub => $title ) {
			$class = ( $stub == $tab ) ? ' nav-tab-active' : '';
			$tabhtml[] = '	<a href="' . admin_url( 'admin.php?page=app_display&amp;tab=' . $stub ) . '" class="nav-tab'.$class.'" id="app_tab_'.$stub.'">'.$title.'</a>';
		}

		echo implode( "\n", $tabhtml );
		?>
	</h3>
	<div class="clear"></div>

		<?php switch( $tab ) {

			case 'general':
	?>
	<div id="poststuff" class="metabox-holder">
		<form class="app-form" method="post" action="<?php echo wpb_add_query_arg( null, null )?>">
			<div class="postbox">
				<div class="postbox-header">
					<h3 class="hndle"><span><?php _e('General Display Settings', 'wp-base' ) ?></span></h3>
				</div>	
				<div class="inside">
					<table class="form-table">
						<tr>
						<th scope="row" ><?php WpBConstant::echo_setting_name('duration_format') ?></th>
						<td>
							<?php $format = wpb_setting('duration_format') ?>
							<select name="duration_format">
								<option value="minutes" <?php selected( $format, 'minutes' ) ?>><?php _e('Minutes, e.g. 90 minutes', 'wp-base')?></option>
								<option value="hours_minutes" <?php selected( $format, 'hours_minutes' ) ?>><?php _e('Hours-minutes, e.g. 1 hour 30 minutes', 'wp-base')?></option>
								<option value="top_hours" <?php selected( $format, 'top_hours' ) ?>><?php _e('Top Hours, e.g. 2 hours when 90 mins', 'wp-base')?></option>
								<option value="hours" <?php selected( $format, 'hours' ) ?>><?php _e('Exact Hours, e.g. 1.5 hour', 'wp-base')?></option>
							</select>
							<span class="description app-btm"><?php WpBConstant::echo_setting_desc('duration_format') ?></span>
						</td>
						</tr>

						<?php wpb_setting_yn( 'disable_tooltips' ); ?>

						<tr id="calendar-design">
						<th scope="row" ><?php WpBConstant::echo_setting_name('calendar_design') ?></th>
						<td>
							<?php $set = wpb_setting( 'calendar_design', 'legacy' ) ?>
							<select name="calendar_design">
								<option value="compact" <?php selected( $set, 'compact' ) ?>><?php _e('Compact', 'wp-base')?></option>
								<option value="legacy" <?php selected( $set, 'legacy' ) ?>><?php _e('Legacy', 'wp-base')?></option>
							</select>
							<span class="description app-btm"><?php WpBConstant::echo_setting_desc('calendar_design') ?></span>
						</td>
						</tr>

						<tr class="app_caption_color_row">
							<th scope="row" ><?php WpBConstant::echo_setting_name('caption_color') ?></th>
							<td>
							<div class="app-caption-color-wrap">
							<?php
							$arr = array(
								'caption_font_color' => array(
									0 => __( 'Font', 'wp-base' ),
									1 => WPB_CAPTION_FONT_COLOR ),
								'caption_color' => array(
									0 => __( 'Background', 'wp-base' ),
									1 => WPB_CAPTION_COLOR ),
							);
							foreach ( $arr as $key => $val ) { ?>
								<div class="app-colorpicker-item">
									<div class="app-small"><?php echo esc_html( $val[0] ) ?></div>
									<div>
										<input type="text" class="colorpicker_input" maxlength="7" name="<?php echo $key; ?>" id="<?php echo $key; ?>" value="<?php echo '#' . wpb_setting( $key, $val[1] ) ?>" />
									</div>
								</div>
							<?php } ?>
							</div>
								<span class="description app-btm"><?php WpBConstant::echo_setting_desc('caption_color') ?></span>
							</td>
						</tr>

						<?php wpb_setting_yn( 'show_legend' ); ?>

						<tr>
						<th scope="row" ><?php WpBConstant::echo_setting_name('theme') ?></th>
						<td>
							<select name="theme">
							<?php
							$sel_theme = wpb_setting('theme');
							foreach ( $this->a->get_themes() as $theme ) {
								echo '<option '.selected( $sel_theme, $theme, false ).' value="'.$theme.'">'. ucfirst( str_replace( "-", " ", $theme ) ) . '</option>';
							}
							?>
							</select>
							<span class="description app-btm"><?php WpBConstant::echo_setting_desc('theme') ?></span>
							<span class="description app-btm"><?php printf( __(' Tip: To include your customized jquery-ui theme, prepare and download the custom theme using jquery-ui themeroller on its website. Upload the "theme_name" folder to %s. Rename the main css file as "style.css" or "jquery-ui.css". You can create your own theme file (independent of jquery-ui) in the same manner. Then the theme will be selectable in this pulldown menu under "theme_name" name. Time slot color setting should be set as "Custom" and you can pick the colors you want.','wp-base'), $this->a->custom_folder().'css/') ?></span>
						</td>
						</tr>

						<tr>
							<th scope="row" ><?php WpBConstant::echo_setting_name('color_set') ?></th>
							<td>
							<div class="alignleft app-mr">
								<?php $cset = wpb_setting('color_set'); ?>
								<select name="color_set">
									<option value="0" <?php selected( $cset, 0 ) ?>><?php _e('Custom', 'wp-base')?></option>
									<option value="legacy1" <?php selected( $cset, 'legacy1' ) ?>><?php _e('Legacy 1', 'wp-base')?></option>
									<option value="legacy2" <?php selected( $cset, 'legacy2' ) ?>><?php _e('Legacy 2', 'wp-base')?></option>
									<option value="legacy3" <?php selected( $cset, 'legacy3' ) ?>><?php _e('Legacy 3', 'wp-base')?></option>
								<optgroup label="<?php _e('Theme colors','wp-base') ?>" >
								<?php
								foreach ( $this->a->get_themes() as $theme ) {
									echo '<option value="'.$theme.'" '. selected( $cset, $theme, false ) . '>' . ucfirst( str_replace( "-", " ", $theme ) ) . '</option>';
								}
								?>
								</optgroup>
								</select>
							</div>
							<div class="alignleft">
								<div class="app-preset-samples wp-clearfix" <?php if ( (string)$cset === (string)0 ) echo 'style="display:none"' ?>>
									<label class="app-mr">
									<?php _e('Sample:', 'wp-base' ) ?>
									</label>
									<?php foreach ( $this->a->get_legend_items() as $class => $name ) { ?>
									<label>
										<span>
											<?php echo $name ?>:
										</span>
										<span class="app-mrl">
											<a href="javascript:void(0)" class="pickcolor <?php echo $class?> hide-if-no-js" <?php if ( (string)$cset !== (string)0 ) echo 'style="background-color:#'. wpb_get_preset($class, wpb_setting('color_set')). '"' ?>></a>
										</span>
									</label>
								<?php } ?>
								</div>
							</div>
							<div style="clear:both"></div>
							<span class="description app-btm"><?php WpBConstant::echo_setting_desc('color_set') ?></span>
							</td>
						</tr>

						<tr class="app_custom_color_row" <?php if ( (string)$cset !== "0" ) echo 'style="display:none"'?>>
							<th scope="row" ><?php _e('Custom Color Set', 'wp-base')?></th>
							<td>
							<div class="app-custom-color-wrap">
							<?php foreach ( $this->a->get_legend_items() as $class => $name ) { ?>
								<div class="app-colorpicker-item">
									<div class="app-small"><?php echo $name ?></div>
									<div>
										<input type="text" class="colorpicker_input" maxlength="7" name="<?php echo $class?>_color" id="<?php echo $class?>_color" value="<?php if( wpb_setting($class."_color") ) echo '#' . wpb_setting($class."_color") ?>" />
									</div>
								</div>
							<?php } ?>
							</div>
								<span class="description app-btm"><?php _e('If you have selected Custom color set, for each cell enter 6-digit Hex code of the color manually or use the colorpicker which will be displayed as you click on the field. Note: "Partly busy" is for admin side and account page only.', 'wp-base' ) ?></span>
							</td>
						</tr>

						<?php wpb_setting_yn( 'hide_busy' ) ?>

						<tr id="conf-form-fields">
							<th scope="row" ><?php _e('Default User Info Fields in the confirmation form', 'wp-base')?></th>
							<td class="has-checkbox">
							<?php
							foreach ( $this->a->get_user_fields() as $f ) { ?>
								<label>
									<input type="checkbox" name="ask_<?php echo $f?>" <?php if ( wpb_setting("ask_".$f) ) echo 'checked="checked"' ?> /><span><?php echo wpb_get_field_name($f) ?></span></label>
								<?php
							} ?>
							<label>
								<input type="checkbox" name="ask_note" <?php if ( wpb_setting("ask_note") ) echo 'checked="checked"' ?> /><span><?php echo wpb_get_field_name('note') ?></span>
							</label>
							<label>
								<input type="checkbox" name="ask_remember" <?php if ( wpb_setting("ask_remember") ) echo 'checked="checked"' ?> /><span><?php echo wpb_get_field_name('remember') ?></span>
							</label>
							<?php
							do_action( 'app_admin_select_fields' );
							?>
							<br />
							<span class="description app-btm"><?php _e('The selected fields will be available in the confirmation area and client will be required to fill them. If selected, entering value for name, first name, last name, email, phone, address, city, postcode fields is mandatory. Note on Remember Me field: When checked, on the front end non-logged in client can select whether their form data will be saved in a cookie. It is not displayed for logged in users.', 'wp-base' ) ?>
							<?php
							if ( class_exists( 'WpBUDF' ) ) { ?>
								<br />
								<?php printf( __( 'Note: You can also add unlimited number of UDFs (user defined fields) using the %s tab. These fields can be overriden by user_fields attribute of the Confirmation shortcode. Therefore, different user fields can be asked from the client on different pages. By that attribute you can also change the display order of the fields on the confirmation form.', 'wp-base' ), '<a href="'.admin_url('admin.php?page=app_display&tab=udf').'">UDFs</a>')  ?>
								<?php
							} ?>
							</span>
							</td>
						</tr>
						<?php
							wpb_setting_yn( 'slider' );
							wpb_setting_yn( 'slider_mobile' );
							wpb_setting_text( 'slider_count' );
							wpb_setting_text( 'slider_count_mobile' );
							wpb_setting_text( 'slider_margin' );
							wpb_setting_text( 'slider_width' );
						?>
					</table>
				</div>
			</div>
			<p class="submit">
				<input type="hidden" name="action_app" value="save_display_general" />
				<?php wp_nonce_field( 'update_app_settings', 'app_nonce', true, true ); ?>
				<input type="submit" class="button-primary" value="<?php _e('Save Settings', 'wp-base' ) ?>" />
			</p>
		</form>
	</div>
		<?php
		break;

		case $tab:	do_action( 'app_display_'.$tab.'_tab' ); break;
		} // End of switch
	?>
</div><!-- Wrap -->
	<?php
	}

}

	BASE('DisplaySettings')->add_hooks();
}
