(()=>{var __webpack_modules__={"./assets/src/frontend/main.js":
/*!*************************************!*\
  !*** ./assets/src/frontend/main.js ***!
  \*************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _App_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./App.vue */ \"./assets/src/frontend/App.vue\");\n/* harmony import */ var _router__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./router */ \"./assets/src/frontend/router/index.js\");\n/* harmony import */ var _utils_store___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/utils/store/ */ \"./assets/src/utils/store/index.js\");\n// import Vue from 'vue'\n\n\n\nlet Vue = wepos_get_lib('Vue');\nVue.config.productionTip = false;\n/* eslint-disable no-new */\n\nnew Vue({\n  el: '#vue-frontend-app',\n  router: _router__WEBPACK_IMPORTED_MODULE_1__[\"default\"],\n  store: _utils_store___WEBPACK_IMPORTED_MODULE_2__[\"default\"],\n  render: h => h(_App_vue__WEBPACK_IMPORTED_MODULE_0__[\"default\"]),\n\n  created() {\n    this.setLocaleData(wepos.i18n['wepos']);\n\n    if (wepos.i18n['wepos-pro']) {\n      this.setLocaleData(wepos.i18n['wepos-pro']);\n    }\n  }\n\n});\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/main.js?")},"./assets/src/frontend/router/index.js":
/*!*********************************************!*\
  !*** ./assets/src/frontend/router/index.js ***!
  \*********************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var frontend_components_Home_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! frontend/components/Home.vue */ \"./assets/src/frontend/components/Home.vue\");\n\nlet Vue = wepos_get_lib('Vue');\nlet Router = wepos_get_lib('Router');\nVue.use(Router);\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (new Router({\n  routes: wepos.hooks.applyFilters('wepos_frontend_routes', [{\n    path: '/',\n    name: 'Home',\n    component: frontend_components_Home_vue__WEBPACK_IMPORTED_MODULE_0__[\"default\"]\n  }])\n}));\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/router/index.js?")},"./assets/src/utils/store/helper.js":
/*!******************************************!*\
  !*** ./assets/src/utils/store/helper.js ***!
  \******************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  hasStock(product) {\n    let productCartQty = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;\n\n    if (!product.manage_stock) {\n      return 'outofstock' == product.stock_status ? false : true;\n    } else {\n      if (product.backorders_allowed) {\n        return true;\n      } else {\n        return product.stock_quantity > productCartQty;\n      }\n    }\n  }\n\n});\n\n//# sourceURL=webpack://wepos/./assets/src/utils/store/helper.js?")},"./assets/src/utils/store/index.js":
/*!*****************************************!*\
  !*** ./assets/src/utils/store/index.js ***!
  \*****************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _modules_Cart_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./modules/Cart.module */ "./assets/src/utils/store/modules/Cart.module.js");\n/* harmony import */ var _modules_Order_module__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./modules/Order.module */ "./assets/src/utils/store/modules/Order.module.js");\nlet Vue = wepos_get_lib(\'Vue\');\nlet Vuex = wepos_get_lib(\'Vuex\');\nVue.use(Vuex);\n\n\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (new Vuex.Store({\n  modules: {\n    Cart: _modules_Cart_module__WEBPACK_IMPORTED_MODULE_0__["default"],\n    Order: _modules_Order_module__WEBPACK_IMPORTED_MODULE_1__["default"]\n  }\n}));\n\n//# sourceURL=webpack://wepos/./assets/src/utils/store/index.js?')},"./assets/src/utils/store/modules/Cart.module.js":
/*!*******************************************************!*\
  !*** ./assets/src/utils/store/modules/Cart.module.js ***!
  \*******************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _helper__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../helper */ \"./assets/src/utils/store/helper.js\");\n\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  namespaced: true,\n  state: {\n    settings: {},\n    availableTax: {},\n    cartdata: {\n      line_items: [],\n      fee_lines: []\n    }\n  },\n  getters: {\n    getSubtotal(state) {\n      var subtotal = 0;\n      weLo_.forEach(state.cartdata.line_items, function (item, key) {\n        if (item.on_sale) {\n          subtotal += item.quantity * item.sale_price;\n        } else {\n          subtotal += item.quantity * item.regular_price;\n        }\n      });\n      return subtotal;\n    },\n\n    getTotalFee(state) {\n      var fee = 0;\n      weLo_.forEach(state.cartdata.fee_lines, function (item, key) {\n        if (item.type == 'fee') {\n          fee += Math.abs(item.total);\n        }\n      });\n      return fee;\n    },\n\n    getTotalDiscount(state) {\n      var discount = 0;\n      weLo_.forEach(state.cartdata.fee_lines, function (item, key) {\n        if (item.type == 'discount') {\n          discount += Number(Math.abs(item.total));\n        }\n      });\n      return discount;\n    },\n\n    getTotalLineTax(state) {\n      var self = this,\n          taxLineTotal = 0;\n      weLo_.forEach(state.cartdata.line_items, function (item, key) {\n        taxLineTotal += Math.abs(item.tax_amount * item.quantity);\n      });\n      return taxLineTotal;\n    },\n\n    getTotalTax(state) {\n      var self = this,\n          taxLineTotal = 0,\n          taxFeeTotal = 0;\n      weLo_.forEach(state.cartdata.line_items, function (item, key) {\n        taxLineTotal += Math.abs(item.tax_amount * item.quantity);\n      });\n\n      if (state.settings.woo_tax != undefined && state.settings.woo_tax.wc_tax_display_cart == 'incl') {\n        taxLineTotal = 0;\n      }\n\n      weLo_.forEach(state.cartdata.fee_lines, function (item, key) {\n        if (item.type == 'fee') {\n          if (item.tax_status == 'taxable') {\n            var itemTaxClass = item.tax_class === '' ? 'standard' : item.tax_class;\n            var taxClass = weLo_.find(state.availableTax, {\n              'class': itemTaxClass.toString()\n            });\n\n            if (taxClass !== undefined) {\n              taxFeeTotal += Math.abs(item.total) * Math.abs(taxClass.rate) / 100;\n            }\n          }\n        }\n      });\n      return taxLineTotal + taxFeeTotal;\n    },\n\n    getOrderTotal(state, getters) {\n      return getters.getSubtotal + getters.getTotalFee + getters.getTotalTax;\n    },\n\n    getTotal(state, getters) {\n      return getters.getOrderTotal - getters.getTotalDiscount;\n    },\n\n    getSettings(state, getters) {\n      return state.settings;\n    }\n\n  },\n  mutations: {\n    setSettings(state, settings) {\n      state.settings = settings;\n    },\n\n    setAvailableTax(state, availableTax) {\n      state.availableTax = availableTax;\n    },\n\n    setCartData(state, cartdata) {\n      if (weLo_.isEmpty(cartdata)) {\n        state.cartdata = {\n          line_items: [],\n          fee_lines: []\n        };\n      } else {\n        state.cartdata = Object.assign({}, cartdata);\n      }\n    },\n\n    addToCartItem(state, product) {\n      var cartObject = {};\n      cartObject.product_id = product.parent_id === 0 ? product.id : product.parent_id;\n      cartObject.name = product.name;\n      cartObject.quantity = 1;\n      cartObject.regular_price = product.regular_display_price;\n      cartObject.sale_price = product.sales_display_price;\n      cartObject.on_sale = product.on_sale;\n      cartObject.attribute = product.attributes;\n      cartObject.variation_id = product.parent_id !== 0 ? product.id : 0;\n      cartObject.editQuantity = false;\n      cartObject.type = product.type;\n      cartObject.tax_amount = product.tax_amount;\n      cartObject.manage_stock = product.manage_stock;\n      cartObject.stock_status = product.stock_status;\n      cartObject.backorders_allowed = product.backorders_allowed;\n      cartObject.stock_quantity = product.stock_quantity;\n      var index = weLo_.findIndex(state.cartdata.line_items, {\n        product_id: cartObject.product_id,\n        variation_id: cartObject.variation_id\n      });\n\n      if (index < 0) {\n        if (_helper__WEBPACK_IMPORTED_MODULE_0__[\"default\"].hasStock(product)) {\n          state.cartdata.line_items.push(cartObject);\n        }\n      } else {\n        if (_helper__WEBPACK_IMPORTED_MODULE_0__[\"default\"].hasStock(product, state.cartdata.line_items[index].quantity)) {\n          state.cartdata.line_items[index].quantity += 1;\n        }\n      }\n    },\n\n    removeCartItem(state, itemKey) {\n      state.cartdata.line_items.splice(itemKey, 1);\n    },\n\n    addCartItemQuantity(state, itemKey) {\n      var item = state.cartdata.line_items[itemKey];\n\n      if (_helper__WEBPACK_IMPORTED_MODULE_0__[\"default\"].hasStock(item, item.quantity)) {\n        state.cartdata.line_items[itemKey].quantity++;\n      }\n    },\n\n    removeCartItemQuantity(state, itemKey) {\n      var item = state.cartdata.line_items[itemKey];\n\n      if (item.quantity <= 1) {\n        state.cartdata.line_items[itemKey].quantity = 1;\n      } else {\n        state.cartdata.line_items[itemKey].quantity--;\n      }\n    },\n\n    toggleEditQuantity(state, itemKey) {\n      state.cartdata.line_items[itemKey].editQuantity = !state.cartdata.line_items[itemKey].editQuantity;\n    },\n\n    addDiscount(state, discountData) {\n      state.cartdata.fee_lines.push({\n        name: discountData.title,\n        type: 'discount',\n        value: discountData.value.toString(),\n        isEdit: false,\n        discount_type: discountData.type,\n        tax_status: 'none',\n        tax_class: '',\n        total: 0\n      });\n    },\n\n    addFee(state, feeData) {\n      state.cartdata.fee_lines.push({\n        name: feeData.title,\n        type: 'fee',\n        value: feeData.value.toString(),\n        isEdit: false,\n        fee_type: feeData.type,\n        tax_status: 'none',\n        tax_class: '',\n        total: 0\n      });\n    },\n\n    saveFeeValue(state, item) {\n      state.cartdata.fee_lines.splice(item.key, 1, item.feeData);\n      state.cartdata.fee_lines[item.key].isEdit = false;\n    },\n\n    editFeeValue(state, itemKey) {\n      state.cartdata.fee_lines[itemKey].isEdit = true;\n    },\n\n    cancelSaveFeeValue(state, itemKey) {\n      state.cartdata.fee_lines[itemKey].isEdit = false;\n    },\n\n    removeFeeLineItems(state, itemKey) {\n      state.cartdata.fee_lines.splice(itemKey, 1);\n    },\n\n    emptyCart(state) {\n      state.cartdata = {\n        line_items: [],\n        fee_lines: []\n      };\n    },\n\n    calculateDiscount(state, payload) {\n      if (state.cartdata.fee_lines.length > 0) {\n        weLo_.forEach(state.cartdata.fee_lines, (item, key) => {\n          if (item.type == \"discount\") {\n            if (item.discount_type == 'percent') {\n              state.cartdata.fee_lines[key].total = '-' + payload.getSubtotal * Math.abs(item.value) / 100;\n            } else {\n              state.cartdata.fee_lines[key].total = '-' + Math.abs(item.value);\n            }\n          }\n        });\n      }\n    },\n\n    calculateFee(state, payload) {\n      if (state.cartdata.fee_lines.length > 0) {\n        weLo_.forEach(state.cartdata.fee_lines, (item, key) => {\n          if (item.type == 'fee') {\n            if (item.fee_type == 'percent') {\n              state.cartdata.fee_lines[key].total = (payload.getSubtotal * Math.abs(item.value) / 100).toString();\n            } else {\n              state.cartdata.fee_lines[key].total = Math.abs(item.value).toString();\n            }\n          }\n        });\n      }\n    }\n\n  },\n  actions: {\n    setSettingsAction(context, settings) {\n      context.commit('setSettings', settings);\n    },\n\n    setAvailableTaxAction(context, availableTax) {\n      context.commit('setAvailableTax', availableTax);\n    },\n\n    setCartDataAction(context, cartdata) {\n      context.commit('setCartData', cartdata);\n      context.commit('calculateDiscount', context.getters);\n      context.commit('calculateFee', context.getters);\n    },\n\n    addToCartAction(context, product) {\n      context.commit('addToCartItem', product);\n      context.commit('calculateDiscount', context.getters);\n      context.commit('calculateFee', context.getters);\n    },\n\n    removeCartItemAction(context, itemKey) {\n      context.commit('removeCartItem', itemKey);\n      context.commit('calculateDiscount', context.getters);\n      context.commit('calculateFee', context.getters);\n    },\n\n    addItemQuantityAction(context, itemKey) {\n      context.commit('addCartItemQuantity', itemKey);\n      context.commit('calculateDiscount', context.getters);\n      context.commit('calculateFee', context.getters);\n    },\n\n    removeItemQuantityAction(context, itemKey) {\n      context.commit('removeCartItemQuantity', itemKey);\n      context.commit('calculateDiscount', context.getters);\n      context.commit('calculateFee', context.getters);\n    },\n\n    toggleEditQuantityAction(context, itemKey) {\n      context.commit('toggleEditQuantity', itemKey);\n    },\n\n    addDiscountAction(context, discountData) {\n      context.commit('addDiscount', discountData);\n      context.commit('calculateDiscount', context.getters);\n      context.commit('calculateFee', context.getters);\n    },\n\n    addFeeAction(context, feeData) {\n      context.commit('addFee', feeData);\n      context.commit('calculateDiscount', context.getters);\n      context.commit('calculateFee', context.getters);\n    },\n\n    removeFeeLineItemsAction(context, itemKey) {\n      context.commit('removeFeeLineItems', itemKey);\n      context.commit('calculateDiscount', context.getters);\n      context.commit('calculateFee', context.getters);\n    },\n\n    saveFeeValueAction(context, feeData) {\n      context.commit('saveFeeValue', feeData);\n      context.commit('calculateDiscount', context.getters);\n      context.commit('calculateFee', context.getters);\n    },\n\n    editFeeValueAction(context, itemKey) {\n      context.commit('editFeeValue', itemKey);\n    },\n\n    cancelSaveFeeValueAction(context, itemKey) {\n      context.commit('cancelSaveFeeValue', itemKey);\n    },\n\n    emptyCartAction(context) {\n      context.commit('emptyCart');\n    },\n\n    calculateDiscount(context) {\n      context.commit('calculateDiscount', context.getters);\n    },\n\n    calculateFee(context) {\n      context.commit('calculateFee', context.getters);\n    }\n\n  }\n});\n\n//# sourceURL=webpack://wepos/./assets/src/utils/store/modules/Cart.module.js?")},"./assets/src/utils/store/modules/Order.module.js":
/*!********************************************************!*\
  !*** ./assets/src/utils/store/modules/Order.module.js ***!
  \********************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  namespaced: true,\n  state: {\n    orderdata: {\n      billing: {},\n      shipping: {},\n      customer_id: 0,\n      customer_note: '',\n      payment_method: '',\n      payment_method_title: ''\n    },\n    canProcessPayment: false\n  },\n  getters: {\n    getCanProcessPayment: state => {\n      return state.canProcessPayment;\n    }\n  },\n  mutations: {\n    setOrderData(state, orderdata) {\n      if (weLo_.isEmpty(orderdata)) {\n        state.orderdata = {\n          billing: {},\n          shipping: {},\n          customer_id: 0,\n          customer_note: '',\n          payment_method: '',\n          payment_method_title: ''\n        };\n      } else {\n        state.orderdata = orderdata;\n      }\n    },\n\n    setCustomer(state, customer) {\n      if (Object.keys(customer).length > 0) {\n        state.orderdata.billing = customer.billing;\n        state.orderdata.shipping = customer.shipping;\n        state.orderdata.customer_id = customer.id;\n      } else {\n        state.orderdata.billing = {};\n        state.orderdata.shipping = {};\n        state.orderdata.customer_id = 0;\n      }\n    },\n\n    emptyOrderdata(state) {\n      state.orderdata = {\n        billing: {},\n        shipping: {},\n        customer_id: 0,\n        customer_note: '',\n        payment_method: '',\n        payment_method_title: ''\n      };\n    },\n\n    setCustomerNote(state, note) {\n      state.orderdata.customer_note = note.trim();\n    },\n\n    removeCustomerNote(state) {\n      state.orderdata.customer_note = '';\n    },\n\n    setGateway(state, gateway) {\n      state.orderdata.payment_method = gateway.id;\n      state.orderdata.payment_method_title = gateway.title;\n    },\n\n    setCanProcessPayment(state, canProcessPayment) {\n      state.canProcessPayment = canProcessPayment;\n    }\n\n  },\n  actions: {\n    setOrderDataAction(context, orderdata) {\n      context.commit('setOrderData', orderdata);\n    },\n\n    setCustomerAction(context, customer) {\n      context.commit('setCustomer', customer);\n    },\n\n    emptyOrderdataAction(context) {\n      context.commit('emptyOrderdata');\n    },\n\n    setCustomerNoteAction(context, note) {\n      context.commit('setCustomerNote', note);\n    },\n\n    removeCustomerNoteAction(context) {\n      context.commit('removeCustomerNote');\n    },\n\n    setGatewayAction(context, gateway) {\n      context.commit('setGateway', gateway);\n    },\n\n    setCanProcessPaymentAction(context, canProcessPayment) {\n      context.commit('setCanProcessPayment', canProcessPayment);\n    }\n\n  }\n});\n\n//# sourceURL=webpack://wepos/./assets/src/utils/store/modules/Order.module.js?")},"./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/App.vue?vue&type=script&lang=js&":
/*!******************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/App.vue?vue&type=script&lang=js& ***!
  \******************************************************************************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  name: 'App'\n});\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/App.vue?./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options")},"./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/CustomerNote.vue?vue&type=script&lang=js&":
/*!**************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/CustomerNote.vue?vue&type=script&lang=js& ***!
  \**************************************************************************************************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  data() {\n    return {\n      viewNotePopover: false,\n      customerNote: ''\n    };\n  },\n\n  computed: {\n    hotkeys() {\n      return {\n        'f6': this.openNote,\n        'esc': this.closeNote\n      };\n    }\n\n  },\n  methods: {\n    openNote(e) {\n      e.preventDefault();\n      this.viewNotePopover = true;\n      setTimeout(() => {\n        jQuery(this.$refs.customernote).focus();\n      }, 500);\n    },\n\n    closeNote() {\n      this.viewNotePopover = false;\n    },\n\n    addCustomerNote() {\n      this.$emit('addnote', this.customerNote);\n      this.viewNotePopover = false;\n      this.customerNote = '';\n    }\n\n  }\n});\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/CustomerNote.vue?./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options")},"./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/CustomerSearch.vue?vue&type=script&lang=js&":
/*!****************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/CustomerSearch.vue?vue&type=script&lang=js& ***!
  \****************************************************************************************************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _KeyboardControl_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./KeyboardControl.vue */ \"./assets/src/frontend/components/KeyboardControl.vue\");\n// import Modal from './Modal.vue';\n\nlet Modal = wepos_get_lib('Modal');\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  name: 'CustomerSearch',\n  components: {\n    Modal,\n    KeyboardControl: _KeyboardControl_vue__WEBPACK_IMPORTED_MODULE_0__[\"default\"]\n  },\n\n  data() {\n    return {\n      submitDisable: false,\n      customers: [],\n      customer: {\n        email: '',\n        first_name: '',\n        last_name: '',\n        address_1: '',\n        address_2: '',\n        country: '',\n        state: '',\n        postcode: '',\n        city: '',\n        phone: ''\n      },\n      showCustomerResults: false,\n      serachInput: '',\n      showNewCustomerModal: false,\n      stateList: [],\n      selectedState: null,\n      selectedCountry: null,\n      isDisabled: true\n    };\n  },\n\n  computed: {\n    hotkeys() {\n      return {\n        'f7': this.focusCustomerSearch,\n        'shift+f7': this.addNewCustomer,\n        'esc': this.searchClose\n      };\n    },\n\n    getCountryList() {\n      return Object.keys(wepos.countries).map(val => {\n        return {\n          code: val,\n          name: wepos.countries[val]\n        };\n      });\n    },\n\n    orderdata() {\n      return this.$store.state.Order.orderdata;\n    }\n\n  },\n  watch: {\n    customer: {\n      handler(val) {\n        this.isDisabled = true;\n\n        if (val.first_name !== undefined && val.first_name.trim() != '' && val.last_name !== undefined && val.last_name.trim() != '' && val.email !== undefined && val.email.trim() != '') {\n          this.isDisabled = false;\n        }\n      },\n\n      deep: true\n    },\n\n    'orderdata.customer_id'(newVal) {\n      this.serachInput = newVal ? this.orderdata.billing.first_name + ' ' + this.orderdata.billing.last_name : '';\n    }\n\n  },\n  methods: {\n    focusCustomerSearch(e) {\n      e.preventDefault();\n      this.$refs.customerSearch.focus();\n    },\n\n    searchClose() {\n      this.showCustomerResults = false;\n      this.serachInput = '';\n      this.showNewCustomerModal = false;\n      this.$refs.customerSearch.blur();\n    },\n\n    addNewCustomer() {\n      this.showNewCustomerModal = true;\n    },\n\n    onKeyDown() {\n      jQuery('.customer-search-item.selected').next().children('a').focus();\n    },\n\n    onKeyUp() {\n      jQuery('.customer-search-item.selected').prev().children('a').focus();\n    },\n\n    triggerFocus() {\n      this.showCustomerResults = true;\n      this.$emit('onfocus');\n    },\n\n    onblur() {\n      this.showCustomerResults = false;\n      this.$emit('onblur');\n    },\n\n    closeNewCustomerModal() {\n      this.customer = {\n        email: '',\n        first_name: '',\n        last_name: '',\n        address_1: '',\n        address_2: '',\n        country: '',\n        state: '',\n        postcode: '',\n        city: '',\n        phone: ''\n      };\n      this.selectedState = null;\n      this.selectedCountry = null;\n      this.showNewCustomerModal = false;\n    },\n\n    searchCustomer() {\n      if (this.serachInput) {\n        wepos.api.get(wepos.rest.root + wepos.rest.posversion + '/customers?search=' + this.serachInput).done(response => {\n          this.customers = response;\n        });\n      } else {\n        this.$emit('onCustomerSelected', {});\n      }\n    },\n\n    selectCustomer(customer) {\n      this.$emit('onCustomerSelected', customer);\n      this.serachInput = customer.first_name + ' ' + customer.last_name;\n      this.showCustomerResults = false;\n    },\n\n    createCustomer() {\n      if (this.customer.email) {\n        var customerData = {\n          email: this.customer.email,\n          first_name: this.customer.first_name,\n          last_name: this.customer.last_name,\n          username: this.customer.email,\n          password: this.generatePassword(20),\n          billing: {\n            first_name: this.customer.first_name,\n            last_name: this.customer.last_name,\n            address_1: this.customer.address_1,\n            address_2: this.customer.address_2,\n            country: this.selectedCountry !== null ? this.selectedCountry.code : '',\n            state: this.selectedState !== null ? this.selectedState.code : this.customer.state,\n            postcode: this.customer.postcode,\n            city: this.customer.city,\n            phone: this.customer.phone,\n            email: this.customer.email\n          }\n        };\n        var $contentWrap = jQuery('.wepos-new-customer-form');\n        $contentWrap.block({\n          message: null,\n          overlayCSS: {\n            background: '#fff url(' + wepos.ajax_loader + ') no-repeat center',\n            opacity: 0.4\n          }\n        });\n        wepos.api.post(wepos.rest.root + wepos.rest.posversion + '/customers', customerData).done(response => {\n          this.serachInput = response.first_name + ' ' + response.last_name;\n          this.$emit('onCustomerSelected', response);\n          $contentWrap.unblock();\n          this.closeNewCustomerModal();\n        }).fail(response => {\n          $contentWrap.unblock();\n          alert(response.responseJSON.message);\n        });\n      } else {\n        alert(this.__('Please enter an email address for customer', 'wepos'));\n      }\n    },\n\n    removeCountrySelect(selectedOption, id) {\n      this.selectedState = null;\n      this.selectedCountry = null;\n      this.stateList = [];\n      this.customer.country = '';\n      this.customer.state = '';\n    },\n\n    removeStateSelect(selectedOption, id) {\n      this.selectedState = null;\n      this.customer.state = '';\n    },\n\n    handleCountrySelect(selectedOption, id) {\n      var state = wepos.states[selectedOption.code] !== undefined ? wepos.states[selectedOption.code] : [];\n      var stateKeys = Object.keys(state);\n\n      if (stateKeys.length > 0) {\n        this.stateList = stateKeys.map(val => {\n          return {\n            code: val,\n            name: state[val]\n          };\n        });\n      } else {\n        this.stateList = state;\n        this.selectedState = null;\n      }\n    },\n\n    generatePassword(length) {\n      var charset = \"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789\",\n          retVal = \"\";\n\n      for (var i = 0, n = charset.length; i < length; ++i) {\n        retVal += charset.charAt(Math.floor(Math.random() * n));\n      }\n\n      return retVal;\n    }\n\n  },\n\n  created() {\n    this.eventBus.$on('emptycart', orderdata => {\n      this.serachInput = '';\n    });\n    var orderdata = JSON.parse(localStorage.getItem('orderdata'));\n\n    if (orderdata.customer_id != 'undefined' && orderdata.customer_id != 0) {\n      this.serachInput = orderdata.billing.first_name + ' ' + orderdata.billing.last_name;\n    }\n  }\n\n});\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/CustomerSearch.vue?./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options")},"./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/FeeKeypad.vue?vue&type=script&lang=js&":
/*!***********************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/FeeKeypad.vue?vue&type=script&lang=js& ***!
  \***********************************************************************************************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _Keyboard_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Keyboard.vue */ \"./assets/src/frontend/components/Keyboard.vue\");\n\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  name: 'FeeKeypad',\n  components: {\n    keyboard: _Keyboard_vue__WEBPACK_IMPORTED_MODULE_0__[\"default\"]\n  },\n  computed: {\n    hotkeys() {\n      var keymap = {\n        discount: {\n          'f4': this.showFeeKeypad,\n          'esc': this.hideFeeKepad\n        },\n        fee: {\n          'f5': this.showFeeKeypad,\n          'esc': this.hideFeeKepad\n        }\n      };\n      return keymap[this.shortKey];\n    }\n\n  },\n  props: {\n    name: {\n      type: String,\n      default: 'Fee'\n    },\n    className: {\n      type: String,\n      default: ''\n    },\n    shortKey: {\n      type: String,\n      default: ''\n    }\n  },\n\n  data() {\n    return {\n      input: '',\n      displayValue: '',\n      viewFeeKeypad: false\n    };\n  },\n\n  watch: {\n    displayValue(newValue, oldValue) {\n      this.inputChange();\n    }\n\n  },\n  methods: {\n    hideFeeKepad(e) {\n      this.viewFeeKeypad = false;\n    },\n\n    layout() {\n      return '123|456|789|{<span class=\"keypord-icon flaticon-backspace\"></span>:backspace}0' + wepos.currency_format_decimal_sep + '|{% ' + this.name + ':percent}{' + wepos.currency_format_symbol + ' ' + this.name + ':flat}';\n    },\n\n    percentFee() {\n      this.$emit('inputfee', this.input, 'percent');\n      this.viewFeeKeypad = false;\n      this.input = '';\n      this.displayValue = '';\n    },\n\n    flatFee() {\n      this.$emit('inputfee', this.input, 'flat');\n      this.viewFeeKeypad = false;\n      this.input = '';\n      this.displayValue = '';\n    },\n\n    inputChange() {\n      if (this.isValidAmount(this.displayValue)) {\n        this.input = this.getFormattedValue(this.displayValue, wepos.currency_format_decimal_sep, \".\");\n      } else {\n        this.displayValue = this.getFormattedValue(this.input, \".\", wepos.currency_format_decimal_sep);\n      }\n\n      jQuery(this.$refs.feeinput).focus();\n    },\n\n    getFormattedValue(value, charFrom, charTo) {\n      let formattedValue = value;\n\n      if (\".\" !== wepos.currency_format_decimal_sep) {\n        formattedValue = value.replace(charFrom, charTo);\n      }\n\n      return formattedValue;\n    },\n\n    isValidAmount(amount) {\n      const decimalSep = wepos.currency_format_decimal_sep;\n      const allowedChars = \"^[0-9]*[\" + decimalSep + \"]{0,1}[0-9]*$\";\n      const regexPattern = new RegExp(allowedChars, \"gi\");\n      return amount.match(regexPattern);\n    },\n\n    showFeeKeypad(e) {\n      e.preventDefault();\n      this.viewFeeKeypad = true;\n      setTimeout(() => {\n        jQuery(this.$refs.feeinput).focus();\n      }, 500);\n    }\n\n  }\n});\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/FeeKeypad.vue?./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options")},"./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/Home.vue?vue&type=script&lang=js&":
/*!******************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/Home.vue?vue&type=script&lang=js& ***!
  \******************************************************************************************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _Overlay_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Overlay.vue */ \"./assets/src/frontend/components/Overlay.vue\");\n/* harmony import */ var _ProductSearch_vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ProductSearch.vue */ \"./assets/src/frontend/components/ProductSearch.vue\");\n/* harmony import */ var _CustomerSearch_vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CustomerSearch.vue */ \"./assets/src/frontend/components/CustomerSearch.vue\");\n/* harmony import */ var _FeeKeypad_vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./FeeKeypad.vue */ \"./assets/src/frontend/components/FeeKeypad.vue\");\n/* harmony import */ var vue_mugen_scroll__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! vue-mugen-scroll */ \"./node_modules/vue-mugen-scroll/dist/vue-mugen-scroll.common.js\");\n/* harmony import */ var vue_mugen_scroll__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(vue_mugen_scroll__WEBPACK_IMPORTED_MODULE_4__);\n/* harmony import */ var _PrintReceipt_vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./PrintReceipt.vue */ \"./assets/src/frontend/components/PrintReceipt.vue\");\n/* harmony import */ var _PrintReceiptHtml_vue__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./PrintReceiptHtml.vue */ \"./assets/src/frontend/components/PrintReceiptHtml.vue\");\n/* harmony import */ var _CustomerNote_vue__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./CustomerNote.vue */ \"./assets/src/frontend/components/CustomerNote.vue\");\n\n\n\n\n\n\n\n\nlet Modal = wepos_get_lib('Modal');\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  name: 'Home',\n  components: {\n    ProductSearch: _ProductSearch_vue__WEBPACK_IMPORTED_MODULE_1__[\"default\"],\n    CustomerSearch: _CustomerSearch_vue__WEBPACK_IMPORTED_MODULE_2__[\"default\"],\n    Overlay: _Overlay_vue__WEBPACK_IMPORTED_MODULE_0__[\"default\"],\n    Modal,\n    MugenScroll: (vue_mugen_scroll__WEBPACK_IMPORTED_MODULE_4___default()),\n    FeeKeypad: _FeeKeypad_vue__WEBPACK_IMPORTED_MODULE_3__[\"default\"],\n    PrintReceipt: _PrintReceipt_vue__WEBPACK_IMPORTED_MODULE_5__[\"default\"],\n    PrintReceiptHtml: _PrintReceiptHtml_vue__WEBPACK_IMPORTED_MODULE_6__[\"default\"],\n    CustomerNote: _CustomerNote_vue__WEBPACK_IMPORTED_MODULE_7__[\"default\"]\n  },\n\n  data() {\n    return {\n      showHelp: false,\n      showQucikMenu: false,\n      productView: 'grid',\n      productLoading: false,\n      viewVariationPopover: false,\n      showModal: false,\n      showPaymentReceipt: false,\n      products: [],\n      filteredProducts: [],\n      totalPages: 1,\n      page: 1,\n      showOverlay: false,\n      selectedVariationProduct: {},\n      attributeDisabled: true,\n      selectedAttribute: {},\n      availableGateways: [],\n      emptyGatewayDiv: 0,\n      cashAmount: '',\n      availableTax: [],\n      settings: {},\n      taxSettings: {},\n      printdata: wepos.hooks.applyFilters('wepos_initial_print_data', {\n        gateway: {\n          id: '',\n          title: ''\n        }\n      }),\n      feeData: {},\n      createprintreceipt: false,\n      selectedCategory: '',\n      selectedGateway: '',\n      categories: [],\n      showReceiptHtml: wepos.hooks.applyFilters('wepos_render_receipt_html', true),\n      quickLinkList: wepos.hooks.applyFilters('wepos_quick_links', []),\n      quickLinkListStart: wepos.hooks.applyFilters('wepos_quick_links_start', []),\n      availableGatewayContent: wepos.hooks.applyFilters('wepos_avaialable_gateway_content', []),\n      afterMainContents: wepos.hooks.applyFilters('wepos_after_main_content', []),\n      beforCartPanels: wepos.hooks.applyFilters('wepos_before_cart_panel', [])\n    };\n  },\n\n  computed: {\n    cartdata() {\n      return this.$store.state.Cart.cartdata;\n    },\n\n    orderdata() {\n      return this.$store.state.Order.orderdata;\n    },\n\n    hotkeys() {\n      return {\n        'f3': this.toggleProductView,\n        'f9': this.initPayment,\n        'f10': this.processPayment,\n        'f8': this.createNewSale,\n        'shift+f8': this.emptyCart,\n        'esc': this.backToSale,\n        'meta+/': this.openHelp,\n        'ctrl+/': this.openHelp\n      };\n    },\n\n    getFilteredProduct() {\n      if (this.$route.query.category !== undefined) {\n        return this.products.filter(product => {\n          var foundCat = weLo_.find(product.categories, {\n            id: parseInt(this.$route.query.category)\n          });\n          return foundCat != undefined && Object.keys(foundCat).length > 0;\n        });\n      } else {\n        return this.products;\n      }\n    },\n\n    changeAmount() {\n      var returnMoney = this.unFormat(this.cashAmount) - this.$store.getters['Cart/getTotal'];\n      return returnMoney > 0 ? returnMoney : 0;\n    },\n\n    getBreadCrums() {\n      if (this.$route.query.category !== undefined) {\n        var categories = jQuery.extend(true, [], this.categories),\n            selectedCat = weLo_.find(this.categories, {\n          id: parseInt(this.$route.query.category)\n        }),\n            selectedCatIndex = weLo_.findIndex(this.categories, selectedCat);\n        var categoriesLoop = categories.splice(0, selectedCatIndex + 1);\n        var choosenCat = [];\n\n        if (categoriesLoop.length > 0) {\n          for (var i = categoriesLoop.length - 1; i >= 0; i--) {\n            if (choosenCat.length > 0) {\n              var foundCat = weLo_.find(categoriesLoop, {\n                id: categoriesLoop[i + 1].parent_id\n              });\n\n              if (foundCat != undefined) {\n                choosenCat.push(foundCat);\n\n                if (foundCat.parent_id == null) {\n                  break;\n                }\n              }\n            } else {\n              choosenCat.push(categoriesLoop[i]);\n            }\n          }\n\n          return choosenCat.slice().reverse();\n        }\n      }\n\n      return [];\n    }\n\n  },\n  watch: {\n    selectedAttribute(newdata, olddata) {\n      if (Object.keys(newdata).length == this.selectedVariationProduct.attributes.length) {\n        this.attributeDisabled = false;\n      }\n    },\n\n    '$route.query.order_key'() {\n      if (this.$route.query.order_key != '' && this.$route.query.payment == 'success') {\n        this.showModal = false;\n        this.showPaymentReceipt = true;\n      }\n\n      ;\n    },\n\n    '$route.query.category'() {\n      this.selectedCategory = {\n        id: -1,\n        level: 0,\n        name: this.__('All categories', 'wepos'),\n        parent_id: null\n      };\n\n      if (this.$route.query.category !== undefined) {\n        this.selectedCategory = weLo_.find(this.categories, {\n          id: parseInt(this.$route.query.category)\n        });\n      }\n    },\n\n    'selectedGateway'(newdata, olddata) {\n      var gateway = weLo_.find(this.availableGateways, {\n        'id': newdata\n      });\n      this.$store.dispatch('Order/setGatewayAction', gateway);\n    },\n\n    cashAmount(newdata, olddata) {\n      this.ableToProcess();\n    }\n\n  },\n  methods: {\n    openQucikMenu() {\n      this.showQucikMenu = true;\n    },\n\n    openHelp(e) {\n      e.preventDefault();\n      this.showHelp = true;\n      this.showQucikMenu = false;\n    },\n\n    closeHelp() {\n      this.showHelp = false;\n    },\n\n    addCustomerNote(note) {\n      this.$store.dispatch('Order/setCustomerNoteAction', note);\n    },\n\n    removeCustomerNote() {\n      this.$store.dispatch('Order/removeCustomerNoteAction');\n    },\n\n    removeBreadcrums() {\n      this.$router.push({\n        name: 'Home'\n      });\n    },\n\n    logout() {\n      wepos.hooks.doAction('wepos_before_logout');\n      window.location.href = wepos.logout_url.toString();\n    },\n\n    emptyCart() {\n      this.$store.dispatch('Cart/emptyCartAction');\n      this.$store.dispatch('Order/emptyOrderdataAction');\n      this.printdata = wepos.hooks.applyFilters('wepos_initial_print_data', {\n        gateway: {\n          id: '',\n          title: ''\n        }\n      });\n      this.showPaymentReceipt = false;\n      this.cashAmount = '';\n      this.eventBus.$emit('emptycart', this.orderdata);\n      this.showQucikMenu = false;\n    },\n\n    toggleProductView(e) {\n      e.preventDefault();\n      this.productView = this.productView == 'grid' ? 'list' : 'grid';\n    },\n\n    createNewSale() {\n      this.$router.push({\n        name: 'Home'\n      });\n      this.emptyCart();\n    },\n\n    ableToProcess() {\n      let canProcess = this.cartdata.line_items.length > 0 && this.isSelectGateway();\n\n      if (this.selectedGateway === 'wepos_cash') {\n        canProcess = this.unFormat(this.cashAmount) >= this.truncateNumber(this.$store.getters['Cart/getTotal']) && canProcess;\n      }\n\n      console.log(canProcess);\n      this.$store.dispatch('Order/setCanProcessPaymentAction', canProcess);\n    },\n\n    processPayment(e) {\n      if (!this.$store.getters['Order/getCanProcessPayment']) {\n        return;\n      }\n\n      var self = this,\n          gateway = weLo_.find(this.availableGateways, {\n        'id': this.orderdata.payment_method\n      }),\n          orderdata = wepos.hooks.applyFilters('wepos_order_form_data', {\n        billing: this.orderdata.billing,\n        shipping: this.orderdata.shipping,\n        line_items: this.cartdata.line_items,\n        fee_lines: this.cartdata.fee_lines,\n        customer_id: this.orderdata.customer_id,\n        customer_note: this.orderdata.customer_note,\n        payment_method: this.orderdata.payment_method,\n        payment_method_title: this.orderdata.payment_method_title,\n        meta_data: [{\n          key: '_wepos_is_pos_order',\n          value: true\n        }, {\n          key: '_wepos_cash_tendered_amount',\n          value: self.cashAmount.toString()\n        }, {\n          key: '_wepos_cash_change_amount',\n          value: self.changeAmount.toString()\n        }]\n      }, this.orderdata, this.cartdata);\n      var $contentWrap = jQuery('.wepos-checkout-wrapper');\n      $contentWrap.block({\n        message: null,\n        overlayCSS: {\n          background: '#fff url(' + wepos.ajax_loader + ') no-repeat center',\n          opacity: 0.4\n        }\n      });\n      wepos.api.post(wepos.rest.root + wepos.rest.wcversion + '/orders', orderdata).done(response => {\n        wepos.api.post(wepos.rest.root + wepos.rest.posversion + '/payment/process', response).done(data => {\n          if (data.result == 'success') {\n            this.$router.push({\n              name: 'Home',\n              query: {\n                order_key: response.order_key,\n                payment: 'success'\n              }\n            });\n            this.printdata = wepos.hooks.applyFilters('wepos_after_payment_print_data', {\n              line_items: this.cartdata.line_items,\n              fee_lines: this.cartdata.fee_lines,\n              subtotal: this.$store.getters['Cart/getSubtotal'],\n              taxtotal: this.$store.getters['Cart/getTotalTax'],\n              ordertotal: this.$store.getters['Cart/getTotal'],\n              gateway: {\n                id: response.payment_method,\n                title: response.payment_method_title\n              },\n              order_id: response.id,\n              order_date: response.date_created,\n              cashamount: this.cashAmount.toString(),\n              changeamount: this.changeAmount.toString()\n            }, orderdata);\n            $contentWrap.unblock();\n          } else {\n            $contentWrap.unblock();\n          }\n        }).fail(data => {\n          $contentWrap.unblock();\n          alert(data.responseJSON.message);\n        });\n      }).fail(response => {\n        $contentWrap.unblock();\n        alert(response.responseJSON.message);\n      });\n    },\n\n    initPayment() {\n      if (this.$store.state.Cart.cartdata.line_items.length <= 0) {\n        return;\n      }\n\n      this.showModal = true;\n      this.$store.dispatch('Order/setGatewayAction', this.availableGateways[0]);\n      this.selectedGateway = this.availableGateways[0].id;\n    },\n\n    backToSale() {\n      this.showModal = false;\n      this.showHelp = false; // Remove gateway selections\n    },\n\n    isSelectGateway() {\n      return !(this.orderdata.payment_method == undefined || this.orderdata.payment_method == '');\n    },\n\n    getProductImage(product) {\n      return product.images.length > 0 ? product.images[0].woocommerce_thumbnail : wepos.placeholder_image;\n    },\n\n    getProductImageName(product) {\n      return product.images.length > 0 ? product.images[0].name : product.name;\n    },\n\n    setDiscount(value, type) {\n      this.$store.dispatch('Cart/addDiscountAction', {\n        title: this.__('Discount', 'wepos'),\n        value: value,\n        type: type\n      });\n    },\n\n    saveFee(key) {\n      this.$store.dispatch('Cart/saveFeeValueAction', {\n        key: key,\n        feeData: this.feeData\n      });\n      this.feeData = {};\n    },\n\n    cancelEditFee(key) {\n      this.$store.dispatch('Cart/cancelSaveFeeValueAction', key);\n      this.feeData = {};\n    },\n\n    editFeeData(key) {\n      this.$store.dispatch('Cart/editFeeValueAction', key);\n      this.feeData = Object.assign({}, this.cartdata.fee_lines[key]);\n      this.$nextTick(() => {\n        jQuery(this.$refs.fee_name).focus();\n      });\n    },\n\n    setFee(value, type) {\n      this.$store.dispatch('Cart/addFeeAction', {\n        title: this.__('Fee', 'wepos'),\n        value: value,\n        type: type\n      });\n    },\n\n    removeFeeLine(key) {\n      this.$store.dispatch('Cart/removeFeeLineItemsAction', key);\n    },\n\n    getDiscountAmount(fee) {\n      return fee.discount_type === 'percent' || fee.fee_type === 'percent' ? this.formatNumber(fee.value) + '%' : this.formatPrice(fee.total);\n    },\n\n    fetchProducts() {\n      if (this.page == 1) {\n        this.productLoading = true;\n      }\n\n      if (this.totalPages >= this.page) {\n        wepos.api.get(wepos.rest.root + wepos.rest.posversion + '/products?status=publish&per_page=30&page=' + this.page).done((response, status, xhr) => {\n          this.appendProducts(response);\n          this.page += 1;\n          this.totalPages = parseInt(xhr.getResponseHeader('X-WP-TotalPages'));\n          this.productLoading = false;\n        }).then((response, status, xhr) => {\n          this.fetchProducts();\n        });\n      } else {\n        this.productLoading = false;\n      }\n    },\n\n    appendProducts(products) {\n      products.forEach(product => {\n        if (\"variable\" === product.type && this.isAllVariationsDisabled(product)) {\n          return;\n        }\n\n        this.products = this.products.concat(product);\n      });\n    },\n\n    isAllVariationsDisabled(product) {\n      let isDisabled = true;\n      product.attributes.forEach(attribute => {\n        if (true === attribute.variation) {\n          isDisabled = false;\n        }\n      });\n      return isDisabled;\n    },\n\n    maybeRemoveDeletedProduct(cartData) {\n      return new Promise((resolve, reject) => {\n        if (!cartData) {\n          return resolve(cartData);\n        }\n\n        if (!cartData.line_items || cartData.line_items.length < 1) {\n          return resolve(cartData);\n        }\n\n        let productIds = cartData.line_items.map(lineItem => {\n          return lineItem.product_id;\n        });\n        wepos.api.get(wepos.rest.root + wepos.rest.posversion + '/products?include=' + productIds.toString()).then(response => {\n          let foundProducts = response.map(product => {\n            return product.id;\n          });\n          cartData.line_items.forEach((product, key) => {\n            if (!foundProducts.includes(product.product_id)) {\n              cartData.line_items.splice(key, 1);\n              localStorage.setItem('cartdata', JSON.stringify(cartData));\n            }\n          });\n          return resolve(cartData);\n        }).fail(() => {\n          return reject(cartData);\n        });\n      });\n    },\n\n    selectCustomer(customer) {\n      this.$store.dispatch('Order/setCustomerAction', customer);\n    },\n\n    selectVariationProduct(product) {\n      this.viewVariationPopover = true;\n      this.selectedVariationProduct = product;\n    },\n\n    addVariationProduct() {\n      let chosenVariationProduct = this.findMatchingVariations(this.selectedVariationProduct.variations, this.selectedAttribute);\n      let variationProduct = chosenVariationProduct[0];\n\n      if (!this.hasStock(variationProduct)) {\n        this.toast({\n          title: this.__('This product is out of stock.', 'wepos'),\n          type: 'error'\n        });\n      }\n\n      variationProduct.parent_id = this.selectedVariationProduct.id;\n      variationProduct.type = this.selectedVariationProduct.type;\n      variationProduct.name = this.selectedVariationProduct.name;\n      variationProduct.type = this.selectedVariationProduct.type;\n      this.selectedAttribute = {};\n      this.attributeDisabled = true;\n      this.$store.dispatch('Cart/addToCartAction', variationProduct);\n    },\n\n    addToCart(product) {\n      if (!this.hasStock(product)) {\n        this.toast({\n          title: this.__('Product is out of stock!', 'wepos-pro'),\n          type: 'error'\n        });\n        return;\n      }\n\n      this.$store.dispatch('Cart/addToCartAction', product);\n    },\n\n    toggleEditQuantity(product, key) {\n      this.$store.dispatch('Cart/toggleEditQuantityAction', key);\n    },\n\n    removeItem(key) {\n      this.$store.dispatch('Cart/removeCartItemAction', key);\n    },\n\n    addQuantity(item, key) {\n      this.$store.dispatch('Cart/addItemQuantityAction', key);\n    },\n\n    removeQuantity(item, key) {\n      this.$store.dispatch('Cart/removeItemQuantityAction', key);\n    },\n\n    fetchGateway() {\n      wepos.api.get(wepos.rest.root + wepos.rest.posversion + '/payment/gateways').done(response => {\n        this.availableGateways = response;\n        this.emptyGatewayDiv = 4 - this.availableGateways.length % 4;\n      });\n    },\n\n    truncateTitle(text, length) {\n      return weLo_.truncate(text, {\n        'length': length\n      });\n    },\n\n    unSanitizeString(str) {\n      return str.split('-').map(function capitalize(part) {\n        return part.charAt(0).toUpperCase() + part.slice(1);\n      }).join(' ');\n    },\n\n    fetchSettings() {\n      wepos.api.get(wepos.rest.root + wepos.rest.posversion + '/settings').done(response => {\n        this.settings = response;\n        this.$store.dispatch('Cart/setSettingsAction', response);\n      });\n    },\n\n    fetchTaxes() {\n      wepos.api.get(wepos.rest.root + wepos.rest.posversion + '/taxes').done(response => {\n        this.availableTax = response;\n        this.$store.dispatch('Cart/setAvailableTaxAction', response);\n      });\n    },\n\n    handleCategorySelect(selectedOption, id) {\n      if (selectedOption.id == '-1') {\n        this.$router.push({\n          name: 'Home'\n        });\n      } else {\n        this.$router.push({\n          name: 'Home',\n          query: {\n            'category': selectedOption.id\n          }\n        });\n      }\n    },\n\n    handleCategoryRemove(selectedOption, id) {\n      this.$router.push({\n        name: 'Home'\n      });\n      this.selectedCategory = {\n        id: -1,\n        level: 0,\n        name: this.__('All categories', 'wepos'),\n        parent_id: null\n      };\n    },\n\n    fetchCategories() {\n      wepos.api.get(wepos.rest.root + wepos.rest.wcversion + '/products/categories?hide_empty=true&_fields=id,name,parent_id&per_page=100').then(response => {\n        response.sort(function (a, b) {\n          return a.name.localeCompare(b.name);\n        });\n\n        var tree = function (response, root) {\n          var r = [],\n              o = {};\n          response.forEach(function (a) {\n            o[a.id] = {\n              response: a,\n              children: o[a.id] && o[a.id].children\n            };\n\n            if (a.parent_id === root) {\n              r.push(o[a.id]);\n            } else {\n              o[a.parent_id] = o[a.parent_id] || {};\n              o[a.parent_id].children = o[a.parent_id].children || [];\n              o[a.parent_id].children.push(o[a.id]);\n            }\n          });\n          return r;\n        }(response, null);\n\n        var selectedCat = {\n          id: -1,\n          level: 0,\n          name: this.__('All categories', 'wepos'),\n          parent_id: null\n        };\n        var sorted = tree.reduce(function traverse(level) {\n          return function (r, a) {\n            a.response.level = level;\n            return r.concat(a.response, (a.children || []).reduce(traverse(level + 1), []));\n          };\n        }(0), []);\n        this.categories = sorted;\n        this.categories.unshift(selectedCat);\n        this.selectedCategory = selectedCat;\n\n        if (this.$route.query.category !== undefined) {\n          this.selectedCategory = weLo_.find(response, {\n            id: parseInt(this.$route.query.category)\n          });\n        }\n      });\n    },\n\n    filterProducts() {\n      this.products = this.products.filter(product => {\n        return weLo_.findIndex(product.categories, {\n          id: this.$route.query.category\n        }) > 0;\n      });\n    },\n\n    fetchTaxSettings() {\n      wepos.api.get(wepos.rest.root + wepos.rest.wcversion + '/settings/tax').done(response => {\n        this.taxSettings = response;\n      });\n    },\n\n    focusCashInput() {\n      let inputCashAmount = document.querySelector('#input-cash-amount');\n      inputCashAmount.focus();\n    }\n\n  },\n\n  async created() {\n    this.fetchSettings();\n    this.fetchTaxes();\n    this.fetchProducts();\n    this.fetchGateway();\n    this.fetchCategories(); // this.fetchTaxSettings();\n\n    if (typeof localStorage != 'undefined') {\n      try {\n        var cartdata = JSON.parse(localStorage.getItem('cartdata'));\n        var orderdata = JSON.parse(localStorage.getItem('orderdata'));\n        cartdata = await this.maybeRemoveDeletedProduct(cartdata);\n        this.$store.dispatch('Cart/setCartDataAction', cartdata);\n        this.$store.dispatch('Order/setOrderDataAction', orderdata);\n      } catch (cartdata) {\n        var orderdata = JSON.parse(localStorage.getItem('orderdata'));\n        this.$store.dispatch('Cart/setCartDataAction', cartdata);\n        this.$store.dispatch('Order/setOrderDataAction', orderdata);\n      }\n    }\n\n    window.addEventListener('beforeunload', () => {\n      if (typeof localStorage != 'undefined') {\n        localStorage.setItem('cartdata', JSON.stringify(this.$store.state.Cart.cartdata));\n        localStorage.setItem('orderdata', JSON.stringify(this.$store.state.Order.orderdata));\n      }\n    }, false);\n  }\n\n});\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/Home.vue?./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options")},"./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/Keyboard.vue?vue&type=script&lang=js&":
/*!**********************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/Keyboard.vue?vue&type=script&lang=js& ***!
  \**********************************************************************************************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\nconst Tokens = {\n  // Sequences that no-one will ever put in their keyboards.\n  PIPE: '7440011c983cf39ae730b1f831e2922ac5a76910',\n  OPEN_BRACE: 'f630c4abcae620278f82e142a526ef325c2a773a',\n  CLOSE_BRACE: 'ad982c66898e02a5dab419ea7568421b03f68ee2'\n};\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  name: 'keyboard',\n  props: {\n    value: {\n      type: String,\n      default: ''\n    },\n    layouts: {\n      type: [String, Array],\n      required: true\n    },\n    maxlength: {\n      type: Number,\n      default: 0,\n      validator: value => value >= 0\n    },\n    pattern: {\n      type: String,\n      default: null\n    }\n  },\n\n  data() {\n    return {\n      layout: 0\n    };\n  },\n\n  computed: {\n    /**\r\n     * Whether or not the keyboard input has hit its maximum length.\r\n     * @returns {Boolean}\r\n     */\n    full() {\n      return this.maxlength > 0 && this.value.length >= this.maxlength;\n    },\n\n    /**\r\n     * Whether or not the keyboard input is empty.\r\n     * @return {Boolean}\r\n     */\n    empty() {\n      return this.value.length === 0;\n    },\n\n    /**\r\n     * Returns the lines that make up a layout.\r\n     * @return {Array}\r\n     */\n    lines() {\n      let layout = (Array.isArray(this.layouts) ? this.layouts : [this.layouts])[this.layout];\n      return layout.replace('||', Tokens.PIPE).replace('{{', Tokens.OPEN_BRACE).replace('}}', Tokens.CLOSE_BRACE).split('|');\n    },\n\n    /**\r\n     * Returns an array of buttons to render in the component.\r\n     * @returns {Array[]}\r\n     */\n    buttons() {\n      return this.lines.map(line => {\n        // TODO: Could potentially rely on Object.values() here instead of being explicit.\n        let stream = line.match(new RegExp(`(${Tokens.OPEN_BRACE}|${Tokens.CLOSE_BRACE}|${Tokens.PIPE}|.)`, 'g'));\n        let buttons = [];\n        let token = null;\n        stream.forEach(char => {\n          if (char === '{') {\n            token = '';\n          } else if (char === '}') {\n            let command = token.split(':');\n            let text = command.length > 1 ? command[0] : '';\n            let action = command.length > 1 ? command[1] : command[0];\n            let args = command.length > 2 ? command[2] : null;\n            let method = null;\n            if (['append', 'backspace', 'space', 'clear', 'goto'].indexOf(action) >= 0) method = this[action].bind(this, args);else method = this.$emit.bind(this, action, this);\n            buttons.push({\n              type: 'action',\n              action: {\n                name: action.replace(/\\s+/g, '-').toLowerCase(),\n                callable: method\n              },\n              value: text,\n              args\n            });\n            token = null;\n          } else {\n            if (token !== null) {\n              token += char;\n            } else {\n              if (char === Tokens.PIPE) char = '|';\n              if (char === Tokens.OPEN_BRACE) char = '{';\n              if (char === Tokens.CLOSE_BRACE) char = '}';\n              buttons.push({\n                type: 'char',\n                action: {\n                  name: null,\n                  callable: this.append.bind(this, char)\n                },\n                value: char,\n                args: null\n              });\n            }\n          }\n        });\n        return buttons;\n      });\n    },\n\n    /**\r\n     * Whether or not the current value matches the regex provided to pattern. Always\r\n     * returns true if no pattern was provided.\r\n     * @returns {Boolean}\r\n     */\n    valid() {\n      return !this.pattern || this.value.match(new RegExp(this.pattern));\n    }\n\n  },\n  methods: {\n    /**\r\n     * Mutates the keyboard value to a new value.\r\n     * @param {String} value The new value.\r\n     */\n    mutate(value) {\n      if (this.maxlength > 0) {\n        value = value.slice(0, this.maxlength);\n      }\n\n      this.$emit('input', value);\n    },\n\n    /**\r\n     * Appends a new value to the end of the current keyboard value.\r\n     * @param {String} char The character(s) to append.\r\n     */\n    append(char) {\n      this.mutate(this.value + char);\n    },\n\n    /**\r\n     * Remove the last character from the current keyboard value.\r\n     */\n    backspace() {\n      this.mutate(this.value.slice(0, this.value.length - 1));\n    },\n\n    /**\r\n     * Add one whitespace character to the current keyboard value.\r\n     */\n    space() {\n      this.append(' ');\n    },\n\n    /**\r\n     * Go to a new layout.\r\n     * @param {Number} The layout index.\r\n     */\n    goto(layout) {\n      if (Array.isArray(this.layouts)) {\n        if (layout >= 0 && layout < this.layouts.length) {\n          this.layout = layout;\n        } else {\n          throw new Error('The requested layout does not exist.');\n        }\n      } else {\n        throw new Error('A single non-array layout was provided.');\n      }\n    },\n\n    /**\r\n     * Clear the entire keyboard value.\r\n     */\n    clear() {\n      this.mutate('');\n    }\n\n  }\n});\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/Keyboard.vue?./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options")},"./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/KeyboardControl.vue?vue&type=script&lang=js&":
/*!*****************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/KeyboardControl.vue?vue&type=script&lang=js& ***!
  \*****************************************************************************************************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  props: {\n    listLength: Number\n  },\n\n  data() {\n    return {\n      selectedIndex: 0\n    };\n  },\n\n  render(h) {\n    return h("ul", this.$scopedSlots.default({\n      selectedIndex: this.selectedIndex\n    }));\n  },\n\n  methods: {\n    keyHandler(e) {\n      /**\n        38 - up\n        40 - down\n        9 - tab\n        13 - enter\n       */\n      const key = e.which || e.keyCode;\n\n      if (key === 38 || e.shiftKey && key === 9) {\n        this.handleKeyUp(e);\n        this.$emit(\'key-up\');\n      } else if (key === 40 || key === 9) {\n        this.handleKeyDown(e);\n        this.$emit(\'key-down\');\n      }\n    },\n\n    handleKeyUp(e) {\n      e.preventDefault();\n\n      if (this.selectedIndex <= 0) {\n        // If index is less than or equal to zero then set it to the last item index\n        this.selectedIndex = this.listLength - 1;\n      } else if (this.selectedIndex > 0 && this.selectedIndex <= this.listLength - 1) {\n        // If index is larger than zero and smaller or equal to last index then decrement\n        this.selectedIndex--;\n      }\n    },\n\n    handleKeyDown(e) {\n      e.preventDefault(); // Check if index is below 0\n      // This means that we did not start yet\n\n      if (this.selectedIndex < 0 || this.selectedIndex === this.listLength - 1) {\n        // Set the index to the first item\n        this.selectedIndex = 0;\n      } else if (this.selectedIndex >= 0 && this.selectedIndex < this.listLength - 1) {\n        this.selectedIndex++;\n      }\n    },\n\n    addKeyHandler(e) {\n      window.addEventListener("keydown", this.keyHandler);\n    },\n\n    removeKeyHandler() {\n      window.removeEventListener("keydown", this.keyHandler);\n    }\n\n  },\n\n  created() {\n    this.addKeyHandler();\n  },\n\n  destroyed() {\n    this.removeKeyHandler();\n  }\n\n});\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/KeyboardControl.vue?./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options')},"./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/Overlay.vue?vue&type=script&lang=js&":
/*!*********************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/Overlay.vue?vue&type=script&lang=js& ***!
  \*********************************************************************************************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  name: 'Overlay',\n  props: {\n    show: {\n      type: Boolean\n    }\n  }\n});\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/Overlay.vue?./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options")},"./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/PrintReceipt.vue?vue&type=script&lang=js&":
/*!**************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/PrintReceipt.vue?vue&type=script&lang=js& ***!
  \**************************************************************************************************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  name: \'ReceiptPrint\',\n  methods: {\n    printReceipt() {\n      setTimeout(() => {\n        window.print();\n      }, 500);\n    },\n\n    handlePrintingPopup(evt) {\n      let self = this;\n\n      if ("Enter" === evt.code && self.$store.getters[\'Order/getCanProcessPayment\']) {\n        self.printReceipt();\n      }\n    },\n\n    handlePrintReceiptSubmit() {\n      document.addEventListener("keypress", this.handlePrintingPopup);\n    }\n\n  },\n\n  mounted() {\n    this.handlePrintReceiptSubmit();\n  },\n\n  destroyed() {\n    document.removeEventListener("keypress", this.handlePrintingPopup);\n  }\n\n});\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/PrintReceipt.vue?./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options')},"./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/PrintReceiptHtml.vue?vue&type=script&lang=js&":
/*!******************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/PrintReceiptHtml.vue?vue&type=script&lang=js& ***!
  \******************************************************************************************************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  name: 'ReceiptPrintHtml',\n  props: {\n    printdata: {\n      type: Object,\n\n      default() {\n        return {};\n      }\n\n    },\n    settings: {\n      type: Object,\n\n      default() {\n        return {};\n      }\n\n    }\n  },\n  methods: {\n    formatDate(date) {\n      var date = new Date(date);\n      return date.toLocaleString();\n    }\n\n  }\n});\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/PrintReceiptHtml.vue?./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options")},"./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/ProductSearch.vue?vue&type=script&lang=js&":
/*!***************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/ProductSearch.vue?vue&type=script&lang=js& ***!
  \***************************************************************************************************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _KeyboardControl_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./KeyboardControl.vue */ \"./assets/src/frontend/components/KeyboardControl.vue\");\n/* harmony import */ var v_hotkey__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! v-hotkey */ \"./node_modules/v-hotkey/dist/v-hotkey.common.js\");\n/* harmony import */ var v_hotkey__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(v_hotkey__WEBPACK_IMPORTED_MODULE_1__);\n// import Modal from './Modal.vue';\n\n\nlet Modal = wepos_get_lib('Modal');\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  name: 'ProductInlineSearch',\n  props: {\n    products: {\n      type: Array,\n\n      default() {\n        return [];\n      }\n\n    },\n    settings: {\n      type: Object,\n\n      default() {\n        return {};\n      }\n\n    }\n  },\n  components: {\n    Modal,\n    KeyboardControl: _KeyboardControl_vue__WEBPACK_IMPORTED_MODULE_0__[\"default\"]\n  },\n\n  data() {\n    return {\n      showResults: false,\n      showVariationModal: false,\n      mode: 'scan',\n      serachInput: '',\n      searchableProduct: [],\n      selectedVariationProduct: {},\n      attributeDisabled: true,\n      chosenAttribute: {}\n    };\n  },\n\n  computed: {\n    placeholder() {\n      return this.mode == 'scan' ? this.__('Scan your product', 'wepos') : this.__('Search product by typing', 'wepos');\n    },\n\n    hotkeys() {\n      return {\n        'f1': this.changeProductSearch,\n        'f2': this.changeScan,\n        'esc': this.searchClose\n      };\n    }\n\n  },\n  watch: {\n    chosenAttribute(newdata, olddata) {\n      if (Object.keys(newdata).length == this.selectedVariationProduct.attributes.length) {\n        this.attributeDisabled = false;\n      }\n    }\n\n  },\n  methods: {\n    changeScan(e) {\n      e.preventDefault();\n      this.changeMode('scan');\n    },\n\n    changeProductSearch(e) {\n      e.preventDefault();\n      this.changeMode('product');\n    },\n\n    searchClose() {\n      this.showResults = false;\n      this.showVariationModal = false;\n      this.changeMode('scan');\n      this.$refs.productSearch.blur();\n    },\n\n    onKeyDown() {\n      jQuery('.product-search-item.selected').next().children('a').focus();\n    },\n\n    onKeyUp() {\n      jQuery('.product-search-item.selected').prev().children('a').focus();\n    },\n\n    triggerFocus() {\n      this.showResults = true;\n      this.$emit('onfocus');\n    },\n\n    outside() {\n      this.showResults = false;\n      this.$emit('onblur');\n    },\n\n    changeMode(mode) {\n      this.mode = mode;\n\n      if (this.mode == 'scan') {\n        this.searchableProduct = [];\n        this.showResults = false;\n      }\n\n      this.$refs.productSearch.focus();\n    },\n\n    handleProductScan() {\n      if (this.mode == 'product') {\n        return;\n      }\n\n      var generalSettings = this.settings.wepos_general,\n          field = generalSettings.barcode_scanner_field == 'custom' ? 'barcode' : generalSettings.barcode_scanner_field,\n          selectedProduct = {},\n          filterProduct = this.products.filter(product => {\n        if (product.type == 'simple') {\n          if (product[field].toString() == this.serachInput) {\n            return true;\n          }\n        }\n\n        if (product.type == 'variable') {\n          var ifFound = false;\n\n          if (product.variations.length > 0) {\n            weLo_.forEach(product.variations, (item, key) => {\n              if (item[field].toString() == this.serachInput) {\n                ifFound = true;\n              }\n            });\n          }\n\n          if (ifFound) {\n            return true;\n          }\n        }\n\n        return false;\n      });\n\n      if (filterProduct.length > 0) {\n        filterProduct = filterProduct[0];\n\n        if (filterProduct.type == 'variable') {\n          var variations = filterProduct.variations;\n          var selectedVariationProduct = variations.filter(item => {\n            if (item[field].toString() == this.serachInput) {\n              return true;\n            }\n\n            return false;\n          });\n          selectedProduct = selectedVariationProduct[0];\n          selectedProduct.parent_id = filterProduct.id;\n          selectedProduct.type = filterProduct.type;\n          selectedProduct.name = filterProduct.name;\n          this.$emit('onProductAdded', selectedProduct);\n        } else {\n          this.$emit('onProductAdded', filterProduct);\n        }\n      }\n\n      this.serachInput = '';\n    },\n\n    searchProduct(e) {\n      if (this.serachInput) {\n        if (this.mode == 'product') {\n          this.searchableProduct = this.products.filter(product => {\n            if (product.id.toString().indexOf(this.serachInput) != -1) {\n              return true;\n            } else if (product.name.toString().toLowerCase().indexOf(this.serachInput.toLowerCase()) != -1) {\n              return true;\n            } else if (product.sku.indexOf(this.serachInput) != -1) {\n              return true;\n            } else {\n              return false;\n            }\n          });\n        }\n      }\n    },\n\n    selectVariation(product) {\n      this.selectedVariationProduct = product;\n      this.showVariationModal = true;\n    },\n\n    addVariationProduct() {\n      var chosenVariationProduct = this.findMatchingVariations(this.selectedVariationProduct.variations, this.chosenAttribute);\n      var variationProduct = chosenVariationProduct[0];\n      variationProduct.parent_id = this.selectedVariationProduct.id;\n      variationProduct.type = this.selectedVariationProduct.type;\n      variationProduct.name = this.selectedVariationProduct.name;\n      this.$emit('onProductAdded', variationProduct);\n      this.showVariationModal = false;\n      this.chosenAttribute = {};\n    },\n\n    addToCartAction(product) {\n      this.$emit('onProductAdded', product);\n    }\n\n  },\n\n  mounted() {\n    this.$refs.productSearch.focus();\n  }\n\n});\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/ProductSearch.vue?./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options")},"./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/App.vue?vue&type=template&id=152fd186&":
/*!*****************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/App.vue?vue&type=template&id=152fd186& ***!
  \*****************************************************************************************************************************************************************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "render": () => (/* binding */ render),\n/* harmony export */   "staticRenderFns": () => (/* binding */ staticRenderFns)\n/* harmony export */ });\nvar render = function render() {\n  var _vm = this,\n      _c = _vm._self._c;\n\n  return _c("div", {\n    attrs: {\n      id: "vue-frontend-app"\n    }\n  }, [_c("router-view")], 1);\n};\n\nvar staticRenderFns = [];\nrender._withStripped = true;\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/App.vue?./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet%5B1%5D.rules%5B2%5D!./node_modules/vue-loader/lib/index.js??vue-loader-options')},"./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/CustomerNote.vue?vue&type=template&id=4073e2a5&":
/*!*************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/CustomerNote.vue?vue&type=template&id=4073e2a5& ***!
  \*************************************************************************************************************************************************************************************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "render": () => (/* binding */ render),\n/* harmony export */   "staticRenderFns": () => (/* binding */ staticRenderFns)\n/* harmony export */ });\nvar render = function render() {\n  var _vm = this,\n      _c = _vm._self._c;\n\n  return _c("div", {\n    directives: [{\n      name: "hotkey",\n      rawName: "v-hotkey",\n      value: _vm.hotkeys,\n      expression: "hotkeys"\n    }],\n    staticClass: "wepos-custom-note-wrap"\n  }, [_c("v-popover", {\n    attrs: {\n      offset: "5",\n      "popover-base-class": "customer-note tooltip popover",\n      placement: "top",\n      open: _vm.viewNotePopover\n    }\n  }, [_c("a", {\n    attrs: {\n      href: "#"\n    },\n    on: {\n      click: function ($event) {\n        $event.preventDefault();\n        return _vm.openNote.apply(null, arguments);\n      }\n    }\n  }, [_vm._v(_vm._s(_vm.__("Add Note", "wepos")))]), _vm._v(" "), _c("template", {\n    slot: "popover"\n  }, [_c("form", {\n    on: {\n      submit: function ($event) {\n        $event.preventDefault();\n        return _vm.addCustomerNote.apply(null, arguments);\n      }\n    }\n  }, [_c("textarea", {\n    directives: [{\n      name: "model",\n      rawName: "v-model",\n      value: _vm.customerNote,\n      expression: "customerNote"\n    }],\n    ref: "customernote",\n    attrs: {\n      id: "",\n      cols: "30",\n      rows: "5"\n    },\n    domProps: {\n      value: _vm.customerNote\n    },\n    on: {\n      input: function ($event) {\n        if ($event.target.composing) return;\n        _vm.customerNote = $event.target.value;\n      }\n    }\n  }), _vm._v(" "), _c("button", {\n    staticClass: "add-note-btn",\n    attrs: {\n      type: "submit",\n      disabled: _vm.customerNote == ""\n    }\n  }, [_vm._v(_vm._s(_vm.__("Add Note", "wepos")))])])])], 2)], 1);\n};\n\nvar staticRenderFns = [];\nrender._withStripped = true;\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/CustomerNote.vue?./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet%5B1%5D.rules%5B2%5D!./node_modules/vue-loader/lib/index.js??vue-loader-options')},"./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/CustomerSearch.vue?vue&type=template&id=414ef29b&":
/*!***************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/CustomerSearch.vue?vue&type=template&id=414ef29b& ***!
  \***************************************************************************************************************************************************************************************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "render": () => (/* binding */ render),\n/* harmony export */   "staticRenderFns": () => (/* binding */ staticRenderFns)\n/* harmony export */ });\nvar render = function render() {\n  var _vm = this,\n      _c = _vm._self._c;\n\n  return _c("div", {\n    directives: [{\n      name: "click-outside",\n      rawName: "v-click-outside",\n      value: _vm.onblur,\n      expression: "onblur"\n    }, {\n      name: "hotkey",\n      rawName: "v-hotkey",\n      value: _vm.hotkeys,\n      expression: "hotkeys"\n    }],\n    staticClass: "customer-search-box"\n  }, [_c("form", {\n    attrs: {\n      action: "",\n      autocomplete: "off"\n    }\n  }, [_c("svg", {\n    staticClass: "customer-icon",\n    attrs: {\n      width: "19px",\n      height: "19px",\n      viewBox: "0 0 19 19",\n      version: "1.1",\n      xmlns: "http://www.w3.org/2000/svg",\n      "xmlns:xlink": "http://www.w3.org/1999/xlink"\n    }\n  }, [_c("defs", [_c("linearGradient", {\n    attrs: {\n      x1: "14.5524094%",\n      y1: "14.6909544%",\n      x2: "82.7722259%",\n      y2: "85.2519444%",\n      id: "linearGradient-1"\n    }\n  }, [_c("stop", {\n    attrs: {\n      "stop-color": "#C444FB",\n      offset: "0%"\n    }\n  }), _vm._v(" "), _c("stop", {\n    attrs: {\n      "stop-color": "#5B56D7",\n      offset: "100%"\n    }\n  })], 1)], 1), _vm._v(" "), _c("g", {\n    attrs: {\n      id: "Page-1",\n      stroke: "none",\n      "stroke-width": "1",\n      fill: "none",\n      "fill-rule": "evenodd"\n    }\n  }, [_c("g", {\n    attrs: {\n      id: "POS-Design---Dokan-P2",\n      transform: "translate(-759.000000, -27.000000)"\n    }\n  }, [_c("g", {\n    attrs: {\n      id: "Group",\n      transform: "translate(759.000000, 27.000000)"\n    }\n  }, [_c("circle", {\n    attrs: {\n      id: "Oval",\n      fill: "url(#linearGradient-1)",\n      "fill-rule": "nonzero",\n      cx: "9.5",\n      cy: "9.5",\n      r: "9.5"\n    }\n  }), _vm._v(" "), _c("g", {\n    attrs: {\n      id: "flaticon1543304699-svg-2",\n      transform: "translate(9.500000, 9.500000) scale(-1, 1) translate(-9.500000, -9.500000) translate(6.000000, 5.000000)"\n    }\n  }, [_c("g", {\n    attrs: {\n      id: "flaticon1543304699-svg"\n    }\n  }, [_c("path", {\n    attrs: {\n      d: "M3.31578947,4.40159143 C4.27870463,4.40159143 5.0593751,3.41627143 5.0593751,2.20080857 C5.0593751,0.98532 4.80306952,0 3.31578947,0 C1.82850943,0 1.57215436,0.98532 1.57215436,2.20080857 C1.57215436,3.41627143 2.35282482,4.40159143 3.31578947,4.40159143 Z",\n      id: "Path",\n      fill: "#FFFFFF"\n    }\n  }), _vm._v(" "), _c("path", {\n    attrs: {\n      d: "M0.0616980658,7.82884897 C0.0604730658,7.62453402 0.0592480658,7.77128348 0.0616980658,7.82884897 Z",\n      id: "Path",\n      fill: "#000000"\n    }\n  }), _vm._v(" "), _c("path", {\n    attrs: {\n      d: "M6.64682715,7.85749962 C6.65070632,7.82585407 6.64815424,7.63794608 6.64682715,7.85749962 Z",\n      id: "Path",\n      fill: "#000000"\n    }\n  }), _vm._v(" "), _c("path", {\n    attrs: {\n      d: "M6.60522584,7.67306571 C6.57293401,5.5557 6.30682954,4.95236571 4.27051414,4.57045714 C4.27051414,4.57045714 3.98387156,4.95002571 3.31576473,4.95002571 C2.64765789,4.95002571 2.36096583,4.57045714 2.36096583,4.57045714 C0.34687117,4.9482 0.0645836606,5.54258571 0.0274666143,7.60428 C0.0244230165,7.77263143 0.0230125687,7.78147714 0.0224681854,7.76193429 C0.0225919089,7.79855143 0.0227403771,7.86628286 0.0227403771,7.98438857 C0.0227403771,7.98438857 0.507538492,9 3.31576473,9 C6.12394148,9 6.60878908,7.98438857 6.60878908,7.98438857 C6.60878908,7.90850571 6.60883857,7.85574 6.6089128,7.81984286 C6.60836842,7.83192857 6.60727965,7.80850286 6.60522584,7.67306571 Z",\n      id: "Path",\n      fill: "#FFFFFF"\n    }\n  })])])])])])]), _vm._v(" "), _c("input", {\n    directives: [{\n      name: "model",\n      rawName: "v-model",\n      value: _vm.serachInput,\n      expression: "serachInput"\n    }],\n    ref: "customerSearch",\n    attrs: {\n      type: "text",\n      name: "customer_search",\n      id: "customer-search",\n      placeholder: _vm.__("Search customer", "wepos")\n    },\n    domProps: {\n      value: _vm.serachInput\n    },\n    on: {\n      focus: function ($event) {\n        $event.preventDefault();\n        return _vm.triggerFocus.apply(null, arguments);\n      },\n      keyup: _vm.searchCustomer,\n      input: function ($event) {\n        if ($event.target.composing) return;\n        _vm.serachInput = $event.target.value;\n      }\n    }\n  }), _vm._v(" "), _c("span", {\n    staticClass: "add-new-customer flaticon-add",\n    on: {\n      click: function ($event) {\n        $event.preventDefault();\n        return _vm.addNewCustomer();\n      }\n    }\n  }), _vm._v(" "), _c("div", {\n    directives: [{\n      name: "show",\n      rawName: "v-show",\n      value: _vm.showCustomerResults,\n      expression: "showCustomerResults"\n    }],\n    staticClass: "search-result"\n  }, [_vm.customers.length ? _c("div", [_c("keyboard-control", {\n    attrs: {\n      listLength: _vm.customers.length\n    },\n    on: {\n      "key-down": _vm.onKeyDown,\n      "key-up": _vm.onKeyUp\n    },\n    scopedSlots: _vm._u([{\n      key: "default",\n      fn: function (_ref) {\n        let {\n          selectedIndex\n        } = _ref;\n        return _vm._l(_vm.customers, function (customer, index) {\n          return _c("li", {\n            key: index,\n            staticClass: "customer-search-item",\n            class: {\n              selected: index === selectedIndex\n            }\n          }, [_c("a", {\n            staticClass: "wepos-clearfix",\n            attrs: {\n              href: "#"\n            },\n            on: {\n              click: function ($event) {\n                return _vm.selectCustomer(customer);\n              }\n            }\n          }, [_c("span", {\n            staticClass: "avatar wepos-left"\n          }, [_c("img", {\n            attrs: {\n              src: customer.avatar_url,\n              alt: customer.first_name + " " + customer.last_name\n            }\n          })]), _vm._v(" "), _c("span", {\n            staticClass: "name wepos-left"\n          }, [_vm._v(_vm._s(customer.first_name + " " + customer.last_name)), _c("span", {\n            staticClass: "metadata"\n          }, [_vm._v(_vm._s(customer.email))])]), _vm._v(" "), _c("span", {\n            staticClass: "action flaticon-enter-arrow wepos-right"\n          })])]);\n        });\n      }\n    }], null, false, 1035729388)\n  })], 1) : _c("div", {\n    staticClass: "no-data-found"\n  }, [_vm._v("\\n                " + _vm._s(_vm.__("No customer found", "wepos")) + "\\n            ")]), _vm._v(" "), _c("div", {\n    staticClass: "suggession"\n  }, [_c("span", {\n    staticClass: "term"\n  }, [_c("span", {\n    staticClass: "flaticon-swap"\n  }), _vm._v(" " + _vm._s(_vm.__("to navigate", "wepos")) + "\\n                ")]), _vm._v(" "), _c("span", {\n    staticClass: "term"\n  }, [_c("span", {\n    staticClass: "flaticon-enter-arrow"\n  }), _vm._v(" " + _vm._s(_vm.__("to select", "wepos")) + "\\n                ")]), _vm._v(" "), _c("span", {\n    staticClass: "term"\n  }, [_c("strong", [_vm._v("esc")]), _vm._v(" " + _vm._s(_vm.__("to dismiss", "wepos")) + "\\n                ")])])])]), _vm._v(" "), _vm.showNewCustomerModal ? _c("modal", {\n    attrs: {\n      title: _vm.__("Add New Customer", "wepos"),\n      width: "700px",\n      footer: true,\n      header: true\n    },\n    on: {\n      close: _vm.closeNewCustomerModal\n    }\n  }, [_c("template", {\n    slot: "body"\n  }, [_c("div", {\n    staticClass: "wepos-new-customer-form"\n  }, [_c("form", {\n    staticClass: "wepos-form",\n    attrs: {\n      action: "",\n      autocomplete: "off"\n    }\n  }, [_c("div", {\n    staticClass: "form-row col-2"\n  }, [_c("input", {\n    directives: [{\n      name: "model",\n      rawName: "v-model",\n      value: _vm.customer.first_name,\n      expression: "customer.first_name"\n    }],\n    attrs: {\n      type: "text",\n      placeholder: _vm.__("First Name", "wepos")\n    },\n    domProps: {\n      value: _vm.customer.first_name\n    },\n    on: {\n      input: function ($event) {\n        if ($event.target.composing) return;\n\n        _vm.$set(_vm.customer, "first_name", $event.target.value);\n      }\n    }\n  }), _vm._v(" "), _c("input", {\n    directives: [{\n      name: "model",\n      rawName: "v-model",\n      value: _vm.customer.last_name,\n      expression: "customer.last_name"\n    }],\n    attrs: {\n      type: "text",\n      placeholder: _vm.__("Last Name", "wepos")\n    },\n    domProps: {\n      value: _vm.customer.last_name\n    },\n    on: {\n      input: function ($event) {\n        if ($event.target.composing) return;\n\n        _vm.$set(_vm.customer, "last_name", $event.target.value);\n      }\n    }\n  })]), _vm._v(" "), _c("div", {\n    staticClass: "form-row"\n  }, [_c("input", {\n    directives: [{\n      name: "model",\n      rawName: "v-model",\n      value: _vm.customer.email,\n      expression: "customer.email"\n    }],\n    attrs: {\n      type: "email",\n      placeholder: _vm.__("Email", "wepos")\n    },\n    domProps: {\n      value: _vm.customer.email\n    },\n    on: {\n      input: function ($event) {\n        if ($event.target.composing) return;\n\n        _vm.$set(_vm.customer, "email", $event.target.value);\n      }\n    }\n  })]), _vm._v(" "), _c("div", {\n    staticClass: "form-row col-2"\n  }, [_c("input", {\n    directives: [{\n      name: "model",\n      rawName: "v-model",\n      value: _vm.customer.address_1,\n      expression: "customer.address_1"\n    }],\n    attrs: {\n      type: "text",\n      placeholder: _vm.__("Address 1", "wepos")\n    },\n    domProps: {\n      value: _vm.customer.address_1\n    },\n    on: {\n      input: function ($event) {\n        if ($event.target.composing) return;\n\n        _vm.$set(_vm.customer, "address_1", $event.target.value);\n      }\n    }\n  }), _vm._v(" "), _c("input", {\n    directives: [{\n      name: "model",\n      rawName: "v-model",\n      value: _vm.customer.address_2,\n      expression: "customer.address_2"\n    }],\n    attrs: {\n      type: "text",\n      placeholder: _vm.__("Address 2 (optional)", "wepos")\n    },\n    domProps: {\n      value: _vm.customer.address_2\n    },\n    on: {\n      input: function ($event) {\n        if ($event.target.composing) return;\n\n        _vm.$set(_vm.customer, "address_2", $event.target.value);\n      }\n    }\n  })]), _vm._v(" "), _c("div", {\n    staticClass: "form-row col-2"\n  }, [_c("multiselect", {\n    staticClass: "wepos-multiselect customer-country",\n    staticStyle: {\n      width: "48.5%",\n      "margin-right": "20px"\n    },\n    attrs: {\n      options: _vm.getCountryList,\n      selectLabel: "",\n      deselectLabel: "",\n      selectedLabel: "",\n      placeholder: _vm.__("Select a country", "wepos"),\n      "track-by": "code",\n      label: "name"\n    },\n    on: {\n      select: _vm.handleCountrySelect,\n      remove: _vm.removeCountrySelect\n    },\n    scopedSlots: _vm._u([{\n      key: "singleLabel",\n      fn: function (props) {\n        return [_c("span", {\n          domProps: {\n            innerHTML: _vm._s(props.option.name)\n          }\n        })];\n      }\n    }, {\n      key: "option",\n      fn: function (props) {\n        return [_c("span", {\n          domProps: {\n            innerHTML: _vm._s(props.option.name)\n          }\n        })];\n      }\n    }], null, false, 568765526),\n    model: {\n      value: _vm.selectedCountry,\n      callback: function ($$v) {\n        _vm.selectedCountry = $$v;\n      },\n      expression: "selectedCountry"\n    }\n  }, [_vm._v(" "), _vm._v(" "), _c("template", {\n    slot: "noResult"\n  }, [_c("div", {\n    staticClass: "no-data-found"\n  }, [_vm._v(_vm._s(_vm.__("No country found", "wepos")))])])], 2), _vm._v(" "), _vm.stateList.length > 0 ? [_c("multiselect", {\n    staticClass: "wepos-multiselect customer-state",\n    staticStyle: {\n      width: "48.5%"\n    },\n    attrs: {\n      options: _vm.stateList,\n      selectLabel: "",\n      deselectLabel: "",\n      selectedLabel: "",\n      placeholder: _vm.__("Select a state", "wepos"),\n      "track-by": "code",\n      label: "name"\n    },\n    on: {\n      remove: _vm.removeStateSelect\n    },\n    scopedSlots: _vm._u([{\n      key: "singleLabel",\n      fn: function (props) {\n        return [_c("span", {\n          domProps: {\n            innerHTML: _vm._s(props.option.name)\n          }\n        })];\n      }\n    }, {\n      key: "option",\n      fn: function (props) {\n        return [_c("span", {\n          domProps: {\n            innerHTML: _vm._s(props.option.name)\n          }\n        })];\n      }\n    }], null, false, 568765526),\n    model: {\n      value: _vm.selectedState,\n      callback: function ($$v) {\n        _vm.selectedState = $$v;\n      },\n      expression: "selectedState"\n    }\n  }, [_vm._v(" "), _vm._v(" "), _c("template", {\n    slot: "noResult"\n  }, [_c("div", {\n    staticClass: "no-data-found"\n  }, [_vm._v(_vm._s(_vm.__("No country found", "wepos")))])])], 2)] : [_c("input", {\n    directives: [{\n      name: "model",\n      rawName: "v-model",\n      value: _vm.customer.state,\n      expression: "customer.state"\n    }],\n    attrs: {\n      type: "text",\n      placeholder: _vm.__("States (optional)", "wepos")\n    },\n    domProps: {\n      value: _vm.customer.state\n    },\n    on: {\n      input: function ($event) {\n        if ($event.target.composing) return;\n\n        _vm.$set(_vm.customer, "state", $event.target.value);\n      }\n    }\n  })]], 2), _vm._v(" "), _c("div", {\n    staticClass: "form-row col-2"\n  }, [_c("input", {\n    directives: [{\n      name: "model",\n      rawName: "v-model",\n      value: _vm.customer.city,\n      expression: "customer.city"\n    }],\n    attrs: {\n      type: "text",\n      placeholder: _vm.__("City (optional)", "wepos")\n    },\n    domProps: {\n      value: _vm.customer.city\n    },\n    on: {\n      input: function ($event) {\n        if ($event.target.composing) return;\n\n        _vm.$set(_vm.customer, "city", $event.target.value);\n      }\n    }\n  }), _vm._v(" "), _c("input", {\n    directives: [{\n      name: "model",\n      rawName: "v-model",\n      value: _vm.customer.postcode,\n      expression: "customer.postcode"\n    }],\n    attrs: {\n      type: "text",\n      placeholder: _vm.__("Zip/Postal Code (optional)", "wepos")\n    },\n    domProps: {\n      value: _vm.customer.postcode\n    },\n    on: {\n      input: function ($event) {\n        if ($event.target.composing) return;\n\n        _vm.$set(_vm.customer, "postcode", $event.target.value);\n      }\n    }\n  })]), _vm._v(" "), _c("div", {\n    staticClass: "form-row"\n  }, [_c("input", {\n    directives: [{\n      name: "model",\n      rawName: "v-model",\n      value: _vm.customer.phone,\n      expression: "customer.phone"\n    }],\n    attrs: {\n      type: "text",\n      placeholder: _vm.__("Phone (optional)", "wepos")\n    },\n    domProps: {\n      value: _vm.customer.phone\n    },\n    on: {\n      input: function ($event) {\n        if ($event.target.composing) return;\n\n        _vm.$set(_vm.customer, "phone", $event.target.value);\n      }\n    }\n  })])])])]), _vm._v(" "), _c("template", {\n    slot: "footer"\n  }, [_c("button", {\n    staticClass: "add-new-customer-btn add-variation-btn",\n    attrs: {\n      disabled: _vm.isDisabled\n    },\n    on: {\n      click: function ($event) {\n        return _vm.createCustomer();\n      }\n    }\n  }, [_vm._v(_vm._s(_vm.__("Add Customer", "wepos")))])])], 2) : _vm._e()], 1);\n};\n\nvar staticRenderFns = [];\nrender._withStripped = true;\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/CustomerSearch.vue?./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet%5B1%5D.rules%5B2%5D!./node_modules/vue-loader/lib/index.js??vue-loader-options')},"./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/FeeKeypad.vue?vue&type=template&id=0bc4dc95&":
/*!**********************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/FeeKeypad.vue?vue&type=template&id=0bc4dc95& ***!
  \**********************************************************************************************************************************************************************************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "render": () => (/* binding */ render),\n/* harmony export */   "staticRenderFns": () => (/* binding */ staticRenderFns)\n/* harmony export */ });\nvar render = function render() {\n  var _vm = this,\n      _c = _vm._self._c;\n\n  return _c("div", {\n    directives: [{\n      name: "hotkey",\n      rawName: "v-hotkey",\n      value: _vm.hotkeys,\n      expression: "hotkeys"\n    }],\n    staticClass: "wepos-fee-keypad-wrap",\n    class: _vm.className\n  }, [_c("v-popover", {\n    attrs: {\n      offset: "5",\n      "popover-base-class": "fee-keypad tooltip popover",\n      placement: "top",\n      open: _vm.viewFeeKeypad\n    }\n  }, [_c("a", {\n    attrs: {\n      href: "#"\n    },\n    on: {\n      click: _vm.showFeeKeypad\n    }\n  }, [_vm._v(_vm._s(_vm.__("Add", "wepos")) + " " + _vm._s(_vm.name))]), _vm._v(" "), _c("template", {\n    slot: "popover"\n  }, [_c("form", [_c("input", {\n    directives: [{\n      name: "model",\n      rawName: "v-model",\n      value: _vm.displayValue,\n      expression: "displayValue"\n    }],\n    ref: "feeinput",\n    attrs: {\n      type: "text"\n    },\n    domProps: {\n      value: _vm.displayValue\n    },\n    on: {\n      input: function ($event) {\n        if ($event.target.composing) return;\n        _vm.displayValue = $event.target.value;\n      }\n    }\n  })]), _vm._v(" "), _c("keyboard", {\n    attrs: {\n      layouts: _vm.layout()\n    },\n    on: {\n      percent: _vm.percentFee,\n      flat: _vm.flatFee\n    },\n    model: {\n      value: _vm.displayValue,\n      callback: function ($$v) {\n        _vm.displayValue = $$v;\n      },\n      expression: "displayValue"\n    }\n  })], 1)], 2)], 1);\n};\n\nvar staticRenderFns = [];\nrender._withStripped = true;\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/FeeKeypad.vue?./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet%5B1%5D.rules%5B2%5D!./node_modules/vue-loader/lib/index.js??vue-loader-options')},"./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/Home.vue?vue&type=template&id=76253014&":
/*!*****************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/Home.vue?vue&type=template&id=76253014& ***!
  \*****************************************************************************************************************************************************************************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "render": () => (/* binding */ render),\n/* harmony export */   "staticRenderFns": () => (/* binding */ staticRenderFns)\n/* harmony export */ });\nvar render = function render() {\n  var _vm = this,\n      _c = _vm._self._c;\n\n  return _c("div", {\n    directives: [{\n      name: "hotkey",\n      rawName: "v-hotkey",\n      value: _vm.hotkeys,\n      expression: "hotkeys"\n    }],\n    attrs: {\n      id: "wepos-main"\n    }\n  }, [_c("div", {\n    staticClass: "content-product"\n  }, [_c("div", {\n    staticClass: "top-panel wepos-clearfix"\n  }, [_c("div", {\n    staticClass: "search-bar"\n  }, [_c("product-search", {\n    attrs: {\n      products: _vm.products,\n      settings: _vm.settings\n    },\n    on: {\n      onProductAdded: _vm.addToCart\n    }\n  })], 1), _vm._v(" "), _c("div", {\n    staticClass: "category"\n  }, [_c("multiselect", {\n    staticClass: "wepos-multiselect",\n    attrs: {\n      options: _vm.categories,\n      selectLabel: "",\n      deselectLabel: "",\n      selectedLabel: "",\n      placeholder: _vm.__("Select a category", "wepos")\n    },\n    on: {\n      select: _vm.handleCategorySelect,\n      remove: _vm.handleCategoryRemove\n    },\n    scopedSlots: _vm._u([{\n      key: "singleLabel",\n      fn: function (props) {\n        return [_vm._v("\\n                        " + _vm._s(props.option.name) + "\\n                    ")];\n      }\n    }, {\n      key: "option",\n      fn: function (props) {\n        return [_c("span", [_vm._l(props.option.level, function (pad) {\n          return [_vm._v("\\n                                 \\n                            ")];\n        }), _vm._v("\\n                            " + _vm._s(props.option.name) + "\\n                        ")], 2)];\n      }\n    }]),\n    model: {\n      value: _vm.selectedCategory,\n      callback: function ($$v) {\n        _vm.selectedCategory = $$v;\n      },\n      expression: "selectedCategory"\n    }\n  }, [_vm._v(" "), _vm._v(" "), _c("template", {\n    slot: "noResult"\n  }, [_c("div", {\n    staticClass: "no-data-found"\n  }, [_vm._v(_vm._s(_vm.__("Not found", "wepos")))])])], 2)], 1), _vm._v(" "), _c("div", {\n    staticClass: "toggle-view"\n  }, [_c("div", {\n    staticClass: "product-toggle"\n  }, [_c("span", {\n    staticClass: "toggle-icon list-view flaticon-menu-button-of-three-horizontal-lines",\n    class: {\n      active: _vm.productView == "list"\n    },\n    on: {\n      click: function ($event) {\n        _vm.productView = "list";\n      }\n    }\n  }), _vm._v(" "), _c("span", {\n    staticClass: "toggle-icon grid-view flaticon-menu",\n    class: {\n      active: _vm.productView == "grid"\n    },\n    on: {\n      click: function ($event) {\n        _vm.productView = "grid";\n      }\n    }\n  })])])]), _vm._v(" "), _vm.getBreadCrums.length > 0 ? _c("div", {\n    staticClass: "breadcrumb"\n  }, [_c("ul", [_vm._l(_vm.getBreadCrums, function (breadcrumb) {\n    return [_c("router-link", {\n      attrs: {\n        tag: "li",\n        to: {\n          name: "Home",\n          query: {\n            category: breadcrumb.id\n          }\n        }\n      }\n    }, [_c("a", [_vm._v(_vm._s(breadcrumb.name))])])];\n  })], 2), _vm._v(" "), _c("span", {\n    staticClass: "close-breadcrumb flaticon-cancel-music",\n    on: {\n      click: function ($event) {\n        $event.preventDefault();\n        return _vm.removeBreadcrums.apply(null, arguments);\n      }\n    }\n  })]) : _vm._e(), _vm._v(" "), _c("div", {\n    ref: "items-wrapper",\n    staticClass: "items-wrapper",\n    class: _vm.productView\n  }, [!_vm.productLoading ? [_vm._l(_vm.getFilteredProduct, function (product) {\n    return _vm.getFilteredProduct.length > 0 ? _c("div", {\n      staticClass: "item"\n    }, [product.type === "simple" ? [_c("div", {\n      staticClass: "item-wrap",\n      class: {\n        disabled: !_vm.hasStock(product)\n      },\n      on: {\n        click: function ($event) {\n          $event.preventDefault();\n          return _vm.addToCart(product);\n        }\n      }\n    }, [_c("div", {\n      staticClass: "img"\n    }, [_c("img", {\n      attrs: {\n        src: _vm.getProductImage(product),\n        alt: _vm.getProductImageName(product)\n      }\n    })]), _vm._v(" "), _vm.productView === "grid" ? _c("div", {\n      staticClass: "title"\n    }, [_vm._v("\\n                                " + _vm._s(_vm.truncateTitle(product.name, 20)) + "\\n                            ")]) : _c("div", {\n      staticClass: "title"\n    }, [_c("div", {\n      staticClass: "product-name"\n    }, [_vm._v(_vm._s(product.name))]), _vm._v(" "), _c("ul", {\n      staticClass: "meta"\n    }, [product.sku ? _c("li", [_c("span", {\n      staticClass: "label"\n    }, [_vm._v(_vm._s(_vm.__("Sku :", "wepos")))]), _vm._v(" "), _c("span", {\n      staticClass: "value"\n    }, [_vm._v(_vm._s(product.sku))])]) : _vm._e(), _vm._v(" "), _c("li", [_c("span", {\n      staticClass: "label"\n    }, [_vm._v(_vm._s(_vm.__("Price :", "wepos")))]), _vm._v(" "), _c("span", {\n      staticClass: "value",\n      domProps: {\n        innerHTML: _vm._s(product.price_html)\n      }\n    })])])]), _vm._v(" "), _c("span", {\n      staticClass: "add-product-icon flaticon-add",\n      class: _vm.productView\n    })])] : _vm._e(), _vm._v(" "), product.type === "variable" ? [_c("v-popover", {\n      attrs: {\n        offset: "10",\n        "popover-base-class": "product-variation tooltip popover",\n        placement: "left-end"\n      }\n    }, [_c("div", {\n      staticClass: "item-wrap",\n      on: {\n        click: function ($event) {\n          return _vm.selectVariationProduct(product);\n        }\n      }\n    }, [_c("div", {\n      staticClass: "img"\n    }, [_c("img", {\n      attrs: {\n        src: _vm.getProductImage(product),\n        alt: _vm.getProductImageName(product)\n      }\n    })]), _vm._v(" "), _vm.productView === "grid" ? _c("div", {\n      staticClass: "title"\n    }, [_vm._v("\\n                                    " + _vm._s(_vm.truncateTitle(product.name, 20)) + "\\n                                ")]) : _c("div", {\n      staticClass: "title"\n    }, [_c("div", {\n      staticClass: "product-name"\n    }, [_vm._v(_vm._s(product.name))]), _vm._v(" "), _c("ul", {\n      staticClass: "meta"\n    }, [_c("li", [_c("span", {\n      staticClass: "label"\n    }, [_vm._v(_vm._s(_vm.__("Price :", "wepos")))]), _vm._v(" "), _c("span", {\n      staticClass: "value",\n      domProps: {\n        innerHTML: _vm._s(product.price_html)\n      }\n    })])])]), _vm._v(" "), _c("span", {\n      staticClass: "add-product-icon flaticon-add",\n      class: _vm.productView\n    })]), _vm._v(" "), _c("template", {\n      slot: "popover"\n    }, [_c("div", {\n      staticClass: "variation-header"\n    }, [_vm._v("\\n                                    " + _vm._s(_vm.__("Select Variations", "wepos")) + "\\n                                ")]), _vm._v(" "), _c("div", {\n      staticClass: "variation-body"\n    }, [_vm._l(product.attributes, function (attribute) {\n      return [_c("div", {\n        staticClass: "attribute"\n      }, [_c("p", [_vm._v(_vm._s(attribute.name))]), _vm._v(" "), _c("div", {\n        staticClass: "options"\n      }, [_vm._l(attribute.options, function (option) {\n        return [_c("label", [_c("input", {\n          directives: [{\n            name: "model",\n            rawName: "v-model",\n            value: _vm.selectedAttribute[attribute.name],\n            expression: "selectedAttribute[attribute.name]"\n          }],\n          attrs: {\n            type: "radio"\n          },\n          domProps: {\n            value: option,\n            checked: _vm._q(_vm.selectedAttribute[attribute.name], option)\n          },\n          on: {\n            change: function ($event) {\n              return _vm.$set(_vm.selectedAttribute, attribute.name, option);\n            }\n          }\n        }), _vm._v(" "), _c("div", {\n          staticClass: "box"\n        }, [_vm._v("\\n                                                            " + _vm._s(option) + "\\n                                                        ")])])];\n      })], 2)])];\n    })], 2), _vm._v(" "), _c("div", {\n      staticClass: "variation-footer"\n    }, [_c("button", {\n      attrs: {\n        disabled: _vm.attributeDisabled\n      },\n      on: {\n        click: function ($event) {\n          $event.preventDefault();\n          return _vm.addVariationProduct.apply(null, arguments);\n        }\n      }\n    }, [_vm._v(_vm._s(_vm.__("Add Product", "wepos")))])])])], 2)] : _vm._e()], 2) : _vm._e();\n  }), _vm._v(" "), _vm.getFilteredProduct.length <= 0 ? _c("div", {\n    staticClass: "no-product-found"\n  }, [_c("img", {\n    attrs: {\n      src: _vm.wepos.assets_url + "/images/no-product.png",\n      alt: "",\n      width: "120px"\n    }\n  }), _vm._v(" "), _c("p", [_vm._v(_vm._s(_vm.__("No Product Found", "wepos")))])]) : _vm._e()] : _vm._e(), _vm._v(" "), _vm.productLoading ? _c("div", {\n    staticClass: "product-loading"\n  }, [_c("div", {\n    staticClass: "spinner spinner-loading"\n  })]) : _vm._e()], 2)]), _vm._v(" "), _c("div", {\n    staticClass: "content-cart"\n  }, [_c("div", {\n    staticClass: "top-panel"\n  }, [_c("customer-search", {\n    on: {\n      onCustomerSelected: _vm.selectCustomer\n    }\n  }), _vm._v(" "), _c("div", {\n    staticClass: "action"\n  }, [_c("div", {\n    staticClass: "more-options"\n  }, [_c("v-popover", {\n    attrs: {\n      offset: "5",\n      "popover-base-class": "wepos-dropdown-menu tooltip popover",\n      placement: "bottom-end",\n      open: _vm.showQucikMenu\n    }\n  }, [_c("button", {\n    staticClass: "wepos-button",\n    on: {\n      click: function ($event) {\n        $event.preventDefault();\n        return _vm.openQucikMenu();\n      }\n    }\n  }, [_c("span", {\n    staticClass: "more-icon flaticon-more"\n  })]), _vm._v(" "), _c("template", {\n    slot: "popover"\n  }, [_c("ul", [_vm._l(_vm.quickLinkListStart, function (quickLinkListStartComponent, key) {\n    return _c(quickLinkListStartComponent, {\n      key: key - `1`,\n      tag: "component"\n    });\n  }), _vm._v(" "), _c("li", [_c("a", {\n    attrs: {\n      href: "#"\n    },\n    on: {\n      click: function ($event) {\n        $event.preventDefault();\n        return _vm.emptyCart.apply(null, arguments);\n      }\n    }\n  }, [_c("span", {\n    staticClass: "flaticon-empty-cart quick-menu-icon"\n  }), _vm._v(_vm._s(_vm.__("Empty Cart", "wepos")))])]), _vm._v(" "), _c("li", [_c("a", {\n    attrs: {\n      href: "#"\n    },\n    on: {\n      click: function ($event) {\n        $event.preventDefault();\n        return _vm.openHelp.apply(null, arguments);\n      }\n    }\n  }, [_c("span", {\n    staticClass: "flaticon-information quick-menu-icon"\n  }), _vm._v(_vm._s(_vm.__("Help", "wepos")))])]), _vm._v(" "), _c("li", {\n    staticClass: "divider"\n  }), _vm._v(" "), _vm._l(_vm.quickLinkList, function (component, index) {\n    return _c(component, {\n      key: index,\n      tag: "component"\n    });\n  }), _vm._v(" "), _c("li", [_c("a", {\n    attrs: {\n      href: "#"\n    },\n    on: {\n      click: function ($event) {\n        $event.preventDefault();\n        return _vm.logout.apply(null, arguments);\n      }\n    }\n  }, [_c("span", {\n    staticClass: "flaticon-logout quick-menu-icon"\n  }), _vm._v(_vm._s(_vm.__("Logout", "wepos")))])])], 2)])], 2)], 1)])], 1), _vm._v(" "), _vm._l(_vm.beforCartPanels, function (beforCartPanel, key) {\n    return _c(beforCartPanel, {\n      key: key,\n      tag: "component"\n    });\n  }), _vm._v(" "), _vm.settings.wepos_general ? _c("div", {\n    staticClass: "cart-panel"\n  }, [_c("div", {\n    staticClass: "cart-content"\n  }, [_c("table", {\n    staticClass: "cart-table"\n  }, [_c("thead", [_c("tr", [_c("th", {\n    attrs: {\n      width: "65%"\n    }\n  }, [_vm._v(_vm._s(_vm.__("Product", "wepos")))]), _vm._v(" "), _c("th", {\n    attrs: {\n      width: "15%"\n    }\n  }, [_vm._v(_vm._s(_vm.__("Qty", "wepos")))]), _vm._v(" "), _c("th", {\n    attrs: {\n      width: "30%"\n    }\n  }, [_vm._v(_vm._s(_vm.__("Price", "wepos")))]), _vm._v(" "), _c("th"), _vm._v(" "), _c("th")])]), _vm._v(" "), _c("tbody", [_vm.cartdata.line_items.length > 0 ? [_vm._l(_vm.cartdata.line_items, function (item, key) {\n    return [_c("tr", [_c("td", {\n      staticClass: "name",\n      on: {\n        click: function ($event) {\n          return _vm.toggleEditQuantity(item, key);\n        }\n      }\n    }, [_vm._v("\\n                                        " + _vm._s(item.name) + "\\n                                        "), item.attribute.length > 0 && item.type === "variable" ? _c("div", {\n      staticClass: "attribute"\n    }, [_c("ul", _vm._l(item.attribute, function (attribute_item) {\n      return _c("li", [_c("span", {\n        staticClass: "attr_name"\n      }, [_vm._v(_vm._s(attribute_item.name))]), _vm._v(": "), _c("span", {\n        staticClass: "attr_value"\n      }, [_vm._v(_vm._s(attribute_item.option))])]);\n    }), 0)]) : _vm._e()]), _vm._v(" "), _c("td", {\n      staticClass: "qty",\n      on: {\n        click: function ($event) {\n          return _vm.toggleEditQuantity(item, key);\n        }\n      }\n    }, [_vm._v(_vm._s(item.quantity))]), _vm._v(" "), _c("td", {\n      staticClass: "price",\n      on: {\n        click: function ($event) {\n          return _vm.toggleEditQuantity(item, key);\n        }\n      }\n    }, [item.on_sale ? [_c("span", {\n      staticClass: "sale-price"\n    }, [_vm._v(_vm._s(_vm.formatPrice(item.quantity * item.sale_price)))]), _vm._v(" "), _c("span", {\n      staticClass: "regular-price"\n    }, [_vm._v(_vm._s(_vm.formatPrice(item.quantity * item.regular_price)))])] : [_c("span", {\n      staticClass: "sale-price"\n    }, [_vm._v(_vm._s(_vm.formatPrice(item.quantity * item.regular_price)))])]], 2), _vm._v(" "), _c("td", {\n      staticClass: "action"\n    }, [_c("span", {\n      staticClass: "flaticon-right-arrow",\n      class: {\n        open: item.editQuantity\n      },\n      on: {\n        click: function ($event) {\n          $event.preventDefault();\n          return _vm.toggleEditQuantity(item, key);\n        }\n      }\n    })]), _vm._v(" "), _c("td", {\n      staticClass: "remove"\n    }, [_c("span", {\n      staticClass: "flaticon-cancel-music",\n      on: {\n        click: function ($event) {\n          $event.preventDefault();\n          return _vm.removeItem(key);\n        }\n      }\n    })])]), _vm._v(" "), item.editQuantity ? _c("tr", {\n      staticClass: "update-quantity-wrap"\n    }, [_c("td", {\n      attrs: {\n        colspan: "5"\n      }\n    }, [_c("span", {\n      staticClass: "qty"\n    }, [_vm._v(_vm._s(_vm.__("Quantity", "wepos")))]), _vm._v(" "), _c("span", {\n      staticClass: "qty-number"\n    }, [_c("input", {\n      directives: [{\n        name: "model",\n        rawName: "v-model",\n        value: item.quantity,\n        expression: "item.quantity"\n      }],\n      attrs: {\n        type: "number",\n        min: "1",\n        step: "1"\n      },\n      domProps: {\n        value: item.quantity\n      },\n      on: {\n        input: function ($event) {\n          if ($event.target.composing) return;\n\n          _vm.$set(item, "quantity", $event.target.value);\n        }\n      }\n    })]), _vm._v(" "), _c("span", {\n      staticClass: "qty-action"\n    }, [_c("a", {\n      staticClass: "add",\n      attrs: {\n        href: "#"\n      },\n      on: {\n        click: function ($event) {\n          $event.preventDefault();\n          return _vm.addQuantity(item, key);\n        }\n      }\n    }, [_vm._v("+")]), _vm._v(" "), _c("a", {\n      staticClass: "minus",\n      attrs: {\n        href: "#"\n      },\n      on: {\n        click: function ($event) {\n          $event.preventDefault();\n          return _vm.removeQuantity(item, key);\n        }\n      }\n    }, [_vm._v("-")])])])]) : _vm._e()];\n  })] : [_c("tr", {\n    staticClass: "no-item"\n  }, [_c("td", {\n    attrs: {\n      colspan: "5"\n    }\n  }, [_c("img", {\n    attrs: {\n      src: _vm.wepos.assets_url + "/images/empty-cart.png",\n      alt: "",\n      width: "120px"\n    }\n  }), _vm._v(" "), _c("p", [_vm._v(_vm._s(_vm.__("Empty Cart", "wepos")))])])])]], 2)])]), _vm._v(" "), _c("div", {\n    staticClass: "cart-calculation"\n  }, [_c("form", {\n    attrs: {\n      autocomplete: "off"\n    }\n  }, [_c("table", {\n    staticClass: "cart-total-table"\n  }, [_c("tbody", [_c("tr", {\n    staticClass: "cart-meta-data"\n  }, [_c("td", {\n    staticClass: "label"\n  }, [_vm._v("\\n                                    " + _vm._s(_vm.__("Subtotal", "wepos")) + "\\n                                    "), _vm.settings.woo_tax.wc_tax_display_cart == "incl" && _vm.$store.getters["Cart/getTotalLineTax"] > 0 ? _c("span", {\n    staticClass: "name"\n  }, [_vm._v("\\n                                        " + _vm._s(_vm.__("Includes Tax", "wepos")) + " " + _vm._s(_vm.formatPrice(_vm.$store.getters["Cart/getTotalLineTax"])) + "\\n                                    ")]) : _vm._e()]), _vm._v(" "), _c("td", {\n    staticClass: "price"\n  }, [_vm._v(_vm._s(_vm.formatPrice(_vm.$store.getters["Cart/getSubtotal"])))]), _vm._v(" "), _c("td", {\n    staticClass: "action"\n  })]), _vm._v(" "), _vm.cartdata.fee_lines.length > 0 ? _vm._l(_vm.cartdata.fee_lines, function (fee, key) {\n    return _c("tr", {\n      staticClass: "cart-meta-data"\n    }, [fee.type == "discount" ? [_c("td", {\n      staticClass: "label"\n    }, [_vm._v(_vm._s(_vm.__("Discount", "wepos")) + " "), _c("span", {\n      staticClass: "name"\n    }, [_vm._v(_vm._s(_vm.getDiscountAmount(fee)))])]), _vm._v(" "), _c("td", {\n      staticClass: "price"\n    }, [_vm._v("−" + _vm._s(_vm.formatPrice(Math.abs(fee.total))))]), _vm._v(" "), _c("td", {\n      staticClass: "action"\n    }, [_c("span", {\n      staticClass: "flaticon-cancel-music",\n      on: {\n        click: function ($event) {\n          return _vm.removeFeeLine(key);\n        }\n      }\n    })])] : [_vm.cartdata.fee_lines[key].isEdit ? [_c("td", {\n      staticClass: "label",\n      attrs: {\n        colspan: "2"\n      }\n    }, [_c("input", {\n      directives: [{\n        name: "model",\n        rawName: "v-model",\n        value: _vm.feeData.name,\n        expression: "feeData.name"\n      }],\n      ref: "fee_name",\n      refInFor: true,\n      staticClass: "fee-name",\n      attrs: {\n        type: "text",\n        placeholder: _vm.__("Fee Name", "wepos")\n      },\n      domProps: {\n        value: _vm.feeData.name\n      },\n      on: {\n        input: function ($event) {\n          if ($event.target.composing) return;\n\n          _vm.$set(_vm.feeData, "name", $event.target.value);\n        }\n      }\n    }), _vm._v(" "), _c("input", {\n      directives: [{\n        name: "model",\n        rawName: "v-model",\n        value: _vm.feeData.value,\n        expression: "feeData.value"\n      }],\n      ref: "fee_total",\n      refInFor: true,\n      staticClass: "fee-amount",\n      attrs: {\n        type: "number",\n        min: "0",\n        step: "any",\n        placeholder: _vm.__("Total", "wepos")\n      },\n      domProps: {\n        value: _vm.feeData.value\n      },\n      on: {\n        input: function ($event) {\n          if ($event.target.composing) return;\n\n          _vm.$set(_vm.feeData, "value", $event.target.value);\n        }\n      }\n    }), _vm._v(" "), _vm.settings.wepos_general.enable_fee_tax == "yes" ? [_c("label", {\n      attrs: {\n        for: "fee-tax-status"\n      }\n    }, [_c("input", {\n      directives: [{\n        name: "model",\n        rawName: "v-model",\n        value: _vm.feeData.tax_status,\n        expression: "feeData.tax_status"\n      }],\n      staticClass: "fee-tax-status",\n      attrs: {\n        type: "checkbox",\n        id: "fee-tax-status",\n        "true-value": "taxable",\n        "false-value": "none"\n      },\n      domProps: {\n        checked: Array.isArray(_vm.feeData.tax_status) ? _vm._i(_vm.feeData.tax_status, null) > -1 : _vm._q(_vm.feeData.tax_status, "taxable")\n      },\n      on: {\n        change: function ($event) {\n          var $$a = _vm.feeData.tax_status,\n              $$el = $event.target,\n              $$c = $$el.checked ? "taxable" : "none";\n\n          if (Array.isArray($$a)) {\n            var $$v = null,\n                $$i = _vm._i($$a, $$v);\n\n            if ($$el.checked) {\n              $$i < 0 && _vm.$set(_vm.feeData, "tax_status", $$a.concat([$$v]));\n            } else {\n              $$i > -1 && _vm.$set(_vm.feeData, "tax_status", $$a.slice(0, $$i).concat($$a.slice($$i + 1)));\n            }\n          } else {\n            _vm.$set(_vm.feeData, "tax_status", $$c);\n          }\n        }\n      }\n    }), _vm._v(" " + _vm._s(_vm.__("Taxable", "wepos")))]), _vm._v(" "), _vm.feeData.tax_status == "taxable" ? _c("select", {\n      directives: [{\n        name: "model",\n        rawName: "v-model",\n        value: _vm.feeData.tax_class,\n        expression: "feeData.tax_class"\n      }],\n      staticClass: "fee-tax-class",\n      on: {\n        change: function ($event) {\n          var $$selectedVal = Array.prototype.filter.call($event.target.options, function (o) {\n            return o.selected;\n          }).map(function (o) {\n            var val = "_value" in o ? o._value : o.value;\n            return val;\n          });\n\n          _vm.$set(_vm.feeData, "tax_class", $event.target.multiple ? $$selectedVal : $$selectedVal[0]);\n        }\n      }\n    }, _vm._l(_vm.availableTax, function (feeTax) {\n      return _c("option", {\n        domProps: {\n          value: feeTax.class == "standard" ? "" : feeTax.class\n        }\n      }, [_vm._v(_vm._s(_vm.unSanitizeString(feeTax.class)) + " - " + _vm._s(feeTax.percentage_rate))]);\n    }), 0) : _vm._e()] : _vm._e(), _vm._v(" "), _c("button", {\n      attrs: {\n        disabled: _vm.feeData.name == ""\n      },\n      on: {\n        click: function ($event) {\n          $event.preventDefault();\n          return _vm.saveFee(key);\n        }\n      }\n    }, [_vm._v(_vm._s(_vm.__("Apply", "wepos")))]), _vm._v(" "), _c("button", {\n      staticClass: "cancel",\n      on: {\n        click: function ($event) {\n          $event.preventDefault();\n          return _vm.cancelEditFee(key);\n        }\n      }\n    }, [_vm._v(_vm._s(_vm.__("Cancel", "wepos")))])], 2), _vm._v(" "), _c("td", {\n      staticClass: "action"\n    }, [_c("span", {\n      staticClass: "flaticon-cancel-music",\n      on: {\n        click: function ($event) {\n          return _vm.removeFeeLine(key);\n        }\n      }\n    })])] : [_c("td", {\n      staticClass: "label",\n      on: {\n        dblclick: function ($event) {\n          $event.preventDefault();\n          return _vm.editFeeData(key);\n        }\n      }\n    }, [_vm._v(_vm._s(_vm.__("Fee", "wepos")) + " "), _c("span", {\n      staticClass: "name"\n    }, [_vm._v(_vm._s(fee.name) + " " + _vm._s(_vm.getDiscountAmount(fee)))])]), _vm._v(" "), _c("td", {\n      staticClass: "price"\n    }, [_vm._v(_vm._s(_vm.formatPrice(Math.abs(fee.total))))]), _vm._v(" "), _c("td", {\n      staticClass: "action"\n    }, [_c("span", {\n      staticClass: "flaticon-cancel-music",\n      on: {\n        click: function ($event) {\n          return _vm.removeFeeLine(key);\n        }\n      }\n    })])]]], 2);\n  }) : _vm._e(), _vm._v(" "), _vm.$store.getters["Cart/getTotalTax"] ? _c("tr", {\n    staticClass: "tax"\n  }, [_c("td", {\n    staticClass: "label"\n  }, [_vm._v(_vm._s(_vm.__("Tax", "wepos")))]), _vm._v(" "), _c("td", {\n    staticClass: "price"\n  }, [_vm._v(_vm._s(_vm.formatPrice(_vm.$store.getters["Cart/getTotalTax"])))]), _vm._v(" "), _c("td", {\n    staticClass: "action"\n  })]) : _vm._e(), _vm._v(" "), _c("tr", {\n    staticClass: "cart-action"\n  }, [_c("td", {\n    attrs: {\n      colspan: "3"\n    }\n  }, [_c("fee-keypad", {\n    attrs: {\n      name: _vm.__("Discount", "wepos"),\n      "short-key": "discount"\n    },\n    on: {\n      inputfee: _vm.setDiscount\n    }\n  }), _vm._v(" "), _c("fee-keypad", {\n    attrs: {\n      name: _vm.__("Fee", "wepos"),\n      "short-key": "fee"\n    },\n    on: {\n      inputfee: _vm.setFee\n    }\n  }), _vm._v(" "), _vm.orderdata.customer_note == "" ? _c("customer-note", {\n    on: {\n      addnote: _vm.addCustomerNote\n    }\n  }) : _vm._e()], 1)]), _vm._v(" "), _vm.orderdata.customer_note ? _c("tr", {\n    staticClass: "note"\n  }, [_c("td", {\n    staticClass: "note-text",\n    attrs: {\n      colspan: "2"\n    }\n  }, [_vm._v("\\n                                    " + _vm._s(_vm.orderdata.customer_note) + "\\n                                ")]), _vm._v(" "), _c("td", {\n    staticClass: "action"\n  }, [_c("span", {\n    staticClass: "flaticon-cancel-music",\n    on: {\n      click: function ($event) {\n        $event.preventDefault();\n        return _vm.removeCustomerNote.apply(null, arguments);\n      }\n    }\n  })])]) : _vm._e(), _vm._v(" "), _c("tr", {\n    staticClass: "pay-now",\n    on: {\n      click: function ($event) {\n        return _vm.initPayment();\n      }\n    }\n  }, [_c("td", [_vm._v(_vm._s(_vm.__("Pay Now", "wepos")))]), _vm._v(" "), _c("td", {\n    staticClass: "amount"\n  }, [_vm._v(_vm._s(_vm.formatPrice(_vm.$store.getters["Cart/getTotal"])))]), _vm._v(" "), _vm._m(0)])], 2)])])])]) : _vm._e()], 2), _vm._v(" "), _vm.showPaymentReceipt ? _c("modal", {\n    attrs: {\n      width: "600px",\n      height: "400px"\n    },\n    on: {\n      close: function ($event) {\n        return _vm.createNewSale();\n      }\n    }\n  }, [_c("template", {\n    slot: "body"\n  }, [_c("div", {\n    staticClass: "wepos-payment-receipt"\n  }, [_c("div", {\n    staticClass: "sale-completed"\n  }, [_c("img", {\n    attrs: {\n      src: _vm.wepos.assets_url + "/images/sale-completed.png",\n      alt: "",\n      width: "120px"\n    }\n  }), _vm._v(" "), _c("h2", [_vm._v(_vm._s(_vm.__("Sale Completed", "wepos")))])]), _vm._v(" "), _c("div", {\n    staticClass: "print-section"\n  }, [_c("print-receipt"), _vm._v(" "), _c("button", {\n    staticClass: "new-sale-btn",\n    on: {\n      click: function ($event) {\n        $event.preventDefault();\n        return _vm.createNewSale();\n      }\n    }\n  }, [_c("span", {\n    staticClass: "icon flaticon-add"\n  }), _vm._v(" "), _c("span", {\n    staticClass: "label"\n  }, [_vm._v(_vm._s(_vm.__("New Sale", "wepos")))])])], 1)])])], 2) : _vm._e(), _vm._v(" "), _vm.showHelp ? _c("modal", {\n    attrs: {\n      width: "700px",\n      height: "500px"\n    },\n    on: {\n      close: function ($event) {\n        return _vm.closeHelp();\n      }\n    }\n  }, [_c("template", {\n    slot: "body"\n  }, [_c("div", {\n    staticClass: "wepos-help-wrapper"\n  }, [_c("h2", [_vm._v(_vm._s(_vm.__("Shortcut Keys", "wepos")))]), _vm._v(" "), _c("ul", [_c("li", [_c("span", {\n    staticClass: "code"\n  }, [_c("code", [_vm._v("f1")])]), _vm._v(" "), _c("span", {\n    staticClass: "title"\n  }, [_vm._v(_vm._s(_vm.__("Search Product", "wepos")))])]), _vm._v(" "), _c("li", [_c("span", {\n    staticClass: "code"\n  }, [_c("code", [_vm._v("f2")])]), _vm._v(" "), _c("span", {\n    staticClass: "title"\n  }, [_vm._v(_vm._s(_vm.__("Scan Product", "wepos")))])]), _vm._v(" "), _c("li", [_c("span", {\n    staticClass: "code"\n  }, [_c("code", [_vm._v("f3")])]), _vm._v(" "), _c("span", {\n    staticClass: "title"\n  }, [_vm._v(_vm._s(_vm.__("Toggle Product View", "wepos")))])]), _vm._v(" "), _c("li", [_c("span", {\n    staticClass: "code"\n  }, [_c("code", [_vm._v("f4")])]), _vm._v(" "), _c("span", {\n    staticClass: "title"\n  }, [_vm._v(_vm._s(_vm.__("Add Fee in cart", "wepos")))])]), _vm._v(" "), _c("li", [_c("span", {\n    staticClass: "code"\n  }, [_c("code", [_vm._v("f5")])]), _vm._v(" "), _c("span", {\n    staticClass: "title"\n  }, [_vm._v(_vm._s(_vm.__("Add Discount in cart", "wepos")))])]), _vm._v(" "), _c("li", [_c("span", {\n    staticClass: "code"\n  }, [_c("code", [_vm._v("f6")])]), _vm._v(" "), _c("span", {\n    staticClass: "title"\n  }, [_vm._v(_vm._s(_vm.__("Add Customer note", "wepos")))])]), _vm._v(" "), _c("li", [_c("span", {\n    staticClass: "code"\n  }, [_c("code", [_vm._v("f7")])]), _vm._v(" "), _c("span", {\n    staticClass: "title"\n  }, [_vm._v(_vm._s(_vm.__("Customer Search", "wepos")))])]), _vm._v(" "), _c("li", [_c("span", {\n    staticClass: "code"\n  }, [_c("code", [_vm._v("shift+f7")])]), _vm._v(" "), _c("span", {\n    staticClass: "title"\n  }, [_vm._v(_vm._s(_vm.__("Add new Customer", "wepos")))])]), _vm._v(" "), _c("li", [_c("span", {\n    staticClass: "code"\n  }, [_c("code", [_vm._v("f8")])]), _vm._v(" "), _c("span", {\n    staticClass: "title"\n  }, [_vm._v(_vm._s(_vm.__("Create New Sale", "wepos")))])]), _vm._v(" "), _c("li", [_c("span", {\n    staticClass: "code"\n  }, [_c("code", [_vm._v("shift+f8")])]), _vm._v(" "), _c("span", {\n    staticClass: "title"\n  }, [_vm._v(_vm._s(_vm.__("Empty your cart", "wepos")))])]), _vm._v(" "), _c("li", [_c("span", {\n    staticClass: "code"\n  }, [_c("code", [_vm._v("f9")])]), _vm._v(" "), _c("span", {\n    staticClass: "title"\n  }, [_vm._v(_vm._s(_vm.__("Go to payment receipt", "wepos")))])]), _vm._v(" "), _c("li", [_c("span", {\n    staticClass: "code"\n  }, [_c("code", [_vm._v("f10")])]), _vm._v(" "), _c("span", {\n    staticClass: "title"\n  }, [_vm._v(_vm._s(_vm.__("Process Payment", "wepos")))])]), _vm._v(" "), _c("li", [_c("span", {\n    staticClass: "code"\n  }, [_c("code", [_vm._v("ctrl/cmd+p")])]), _vm._v(" "), _c("span", {\n    staticClass: "title"\n  }, [_vm._v(_vm._s(_vm.__("Print Receipt", "wepos")))])]), _vm._v(" "), _c("li", [_c("span", {\n    staticClass: "code"\n  }, [_c("code", [_vm._v("ctrl/cmd+?")])]), _vm._v(" "), _c("span", {\n    staticClass: "title"\n  }, [_vm._v(_vm._s(_vm.__("Show/Close(Toggle) Help", "wepos")))])]), _vm._v(" "), _c("li", [_c("span", {\n    staticClass: "code"\n  }, [_c("code", [_vm._v("esc")])]), _vm._v(" "), _c("span", {\n    staticClass: "title"\n  }, [_vm._v(_vm._s(_vm.__("Close anything", "wepos")))])])])])])], 2) : _vm._e(), _vm._v(" "), _vm.showModal ? _c("modal", {\n    attrs: {\n      width: "98%",\n      height: "95vh"\n    },\n    on: {\n      open: function ($event) {\n        return _vm.focusCashInput();\n      },\n      close: function ($event) {\n        return _vm.backToSale();\n      },\n      enterpressed: function ($event) {\n        return _vm.processPayment();\n      }\n    }\n  }, [_c("template", {\n    slot: "body"\n  }, [_c("div", {\n    staticClass: "wepos-checkout-wrapper"\n  }, [_c("div", {\n    staticClass: "left-content"\n  }, [_c("div", {\n    staticClass: "header"\n  }, [_vm._v("\\n                        " + _vm._s(_vm.__("Sale Summary", "wepos")) + "\\n                    ")]), _vm._v(" "), _c("div", {\n    staticClass: "content"\n  }, [_c("table", {\n    staticClass: "sale-summary-cart"\n  }, [_c("tbody", _vm._l(_vm.cartdata.line_items, function (item) {\n    return _c("tr", [_c("td", {\n      staticClass: "name"\n    }, [_vm._v("\\n                                        " + _vm._s(item.name) + "\\n                                        "), item.attribute.length > 0 && item.type === "variable" ? _c("div", {\n      staticClass: "attribute"\n    }, [_c("ul", _vm._l(item.attribute, function (attribute_item) {\n      return _c("li", [_c("span", {\n        staticClass: "attr_name"\n      }, [_vm._v(_vm._s(attribute_item.name))]), _vm._v(": "), _c("span", {\n        staticClass: "attr_value"\n      }, [_vm._v(_vm._s(attribute_item.option))])]);\n    }), 0)]) : _vm._e()]), _vm._v(" "), _c("td", {\n      staticClass: "quantity"\n    }, [_vm._v(_vm._s(item.quantity))]), _vm._v(" "), _c("td", {\n      staticClass: "price"\n    }, [item.on_sale ? [_c("span", {\n      staticClass: "sale-price"\n    }, [_vm._v(_vm._s(_vm.formatPrice(item.quantity * item.sale_price)))]), _vm._v(" "), _c("span", {\n      staticClass: "regular-price"\n    }, [_vm._v(_vm._s(_vm.formatPrice(item.quantity * item.regular_price)))])] : [_c("span", {\n      staticClass: "sale-price"\n    }, [_vm._v(_vm._s(_vm.formatPrice(item.quantity * item.regular_price)))])]], 2)]);\n  }), 0)])]), _vm._v(" "), _c("div", {\n    staticClass: "footer"\n  }, [_c("ul", [_c("li", {\n    staticClass: "wepos-clearfix"\n  }, [_c("span", {\n    staticClass: "wepos-left"\n  }, [_vm._v("\\n                                    " + _vm._s(_vm.__("Subtotal", "wepos")) + "\\n                                    "), _vm.settings.woo_tax.wc_tax_display_cart == "incl" ? _c("span", {\n    staticClass: "metadata"\n  }, [_vm._v("\\n                                        " + _vm._s(_vm.__("Includes Tax", "wepos")) + " " + _vm._s(_vm.formatPrice(_vm.$store.getters["Cart/getTotalLineTax"])) + "\\n                                    ")]) : _vm._e()]), _vm._v(" "), _c("span", {\n    staticClass: "wepos-right"\n  }, [_vm._v(_vm._s(_vm.formatPrice(_vm.$store.getters["Cart/getSubtotal"])))])]), _vm._v(" "), _vm.cartdata.fee_lines.length > 0 ? _vm._l(_vm.cartdata.fee_lines, function (fee, key) {\n    return _c("li", {\n      staticClass: "wepos-clearfix"\n    }, [fee.type == "discount" ? [_c("span", {\n      staticClass: "wepos-left"\n    }, [_vm._v(_vm._s(_vm.__("Discount", "wepos")) + " "), _c("span", {\n      staticClass: "metadata"\n    }, [_vm._v(_vm._s(fee.name) + " " + _vm._s(_vm.getDiscountAmount(fee)))])]), _vm._v(" "), _c("span", {\n      staticClass: "wepos-right"\n    }, [_vm._v("-" + _vm._s(_vm.formatPrice(Math.abs(fee.total))))])] : [_c("span", {\n      staticClass: "wepos-left"\n    }, [_vm._v(_vm._s(_vm.__("Fee", "wepos")) + " "), _c("span", {\n      staticClass: "metadata"\n    }, [_vm._v(_vm._s(fee.name) + " " + _vm._s(_vm.getDiscountAmount(fee)))])]), _vm._v(" "), _c("span", {\n      staticClass: "wepos-right"\n    }, [_vm._v(_vm._s(_vm.formatPrice(fee.total)))])]], 2);\n  }) : _vm._e(), _vm._v(" "), _vm.$store.getters["Cart/getTotalTax"] ? _c("li", {\n    staticClass: "wepos-clearfix"\n  }, [_c("span", {\n    staticClass: "wepos-left"\n  }, [_vm._v(_vm._s(_vm.__("Tax", "wepos")))]), _vm._v(" "), _c("span", {\n    staticClass: "wepos-right"\n  }, [_vm._v(_vm._s(_vm.formatPrice(_vm.$store.getters["Cart/getTotalTax"])))])]) : _vm._e(), _vm._v(" "), _c("li", {\n    staticClass: "wepos-clearfix"\n  }, [_c("span", {\n    staticClass: "wepos-left"\n  }, [_vm._v(_vm._s(_vm.__("Order Total", "wepos")))]), _vm._v(" "), _c("span", {\n    staticClass: "wepos-right"\n  }, [_vm._v(_vm._s(_vm.formatPrice(_vm.$store.getters["Cart/getTotal"])))])]), _vm._v(" "), _c("li", {\n    staticClass: "wepos-clearfix"\n  }, [_c("span", {\n    staticClass: "wepos-left"\n  }, [_vm._v(_vm._s(_vm.__("Pay", "wepos")))]), _vm._v(" "), _c("span", {\n    staticClass: "wepos-right"\n  }, [_vm._v(_vm._s(_vm.formatPrice(_vm.$store.getters["Cart/getTotal"])))])])], 2)])]), _vm._v(" "), _c("div", {\n    staticClass: "right-content"\n  }, [_c("div", {\n    staticClass: "header wepos-clearfix"\n  }, [_c("h2", {\n    staticClass: "wepos-left"\n  }, [_vm._v(_vm._s(_vm.__("Pay", "wepos")))]), _vm._v(" "), _c("span", {\n    staticClass: "pay-amount wepos-right"\n  }, [_vm._v(_vm._s(_vm.formatPrice(_vm.$store.getters["Cart/getTotal"])))])]), _vm._v(" "), _c("div", {\n    staticClass: "content"\n  }, [_c("div", {\n    staticClass: "payment-gateway"\n  }, [_vm.availableGateways.length > 0 ? [_vm._l(_vm.availableGateways, function (gateway) {\n    return _c("label", [_c("input", {\n      directives: [{\n        name: "model",\n        rawName: "v-model",\n        value: _vm.selectedGateway,\n        expression: "selectedGateway"\n      }],\n      attrs: {\n        type: "radio",\n        name: "gateway",\n        checked: ""\n      },\n      domProps: {\n        value: gateway.id,\n        checked: _vm._q(_vm.selectedGateway, gateway.id)\n      },\n      on: {\n        change: function ($event) {\n          _vm.selectedGateway = gateway.id;\n        }\n      }\n    }), _vm._v(" "), _c("span", {\n      staticClass: "gateway",\n      class: `gateway-${gateway.id}`\n    }, [_vm._v("\\n                                        " + _vm._s(gateway.title) + "\\n                                    ")])]);\n  }), _vm._v(" "), _vm.emptyGatewayDiv > 0 ? _vm._l(_vm.emptyGatewayDiv, function (n) {\n    return _c("label", {\n      key: n\n    }, [_c("span", {\n      staticClass: "grid-placeholder"\n    })]);\n  }) : _vm._e()] : [_c("p", [_vm._v(_vm._s(_vm.__("No gateway found", "wepos")))])]], 2), _vm._v(" "), _vm.orderdata.payment_method == "wepos_cash" ? [_c("div", {\n    staticClass: "payment-option"\n  }, [_c("div", {\n    staticClass: "payment-amount"\n  }, [_c("div", {\n    staticClass: "input-part"\n  }, [_c("div", {\n    staticClass: "input-wrap"\n  }, [_c("p", [_vm._v(_vm._s(_vm.__("Cash", "wepos")))]), _vm._v(" "), _c("div", {\n    staticClass: "input-addon"\n  }, [_c("span", {\n    staticClass: "currency"\n  }, [_vm._v(_vm._s(_vm.wepos.currency_format_symbol))]), _vm._v(" "), _c("input", {\n    directives: [{\n      name: "model",\n      rawName: "v-model",\n      value: _vm.cashAmount,\n      expression: "cashAmount"\n    }],\n    ref: "cashamount",\n    attrs: {\n      id: "input-cash-amount",\n      type: "text"\n    },\n    domProps: {\n      value: _vm.cashAmount\n    },\n    on: {\n      input: function ($event) {\n        if ($event.target.composing) return;\n        _vm.cashAmount = $event.target.value;\n      }\n    }\n  })])])]), _vm._v(" "), _c("div", {\n    staticClass: "change-money"\n  }, [_c("p", [_vm._v(_vm._s(_vm.__("Change money", "wepos")) + ": " + _vm._s(_vm.formatPrice(_vm.changeAmount)))])])])])] : _vm._e(), _vm._v(" "), _vm._l(_vm.availableGatewayContent, function (availableGatewayComponent, key) {\n    return _c(availableGatewayComponent, {\n      key: key,\n      tag: "component",\n      attrs: {\n        availablegateways: _vm.availableGateways\n      }\n    });\n  })], 2), _vm._v(" "), _c("div", {\n    staticClass: "footer wepos-clearfix"\n  }, [_c("a", {\n    staticClass: "back-btn wepos-left",\n    attrs: {\n      href: "#"\n    },\n    on: {\n      click: function ($event) {\n        $event.preventDefault();\n        return _vm.backToSale();\n      }\n    }\n  }, [_vm._v(_vm._s(_vm.__("Back to Sale", "wepos")))]), _vm._v(" "), _c("button", {\n    staticClass: "process-checkout-btn wepos-right",\n    attrs: {\n      disabled: !_vm.$store.getters["Order/getCanProcessPayment"]\n    },\n    on: {\n      click: function ($event) {\n        $event.preventDefault();\n        return _vm.processPayment.apply(null, arguments);\n      }\n    }\n  }, [_vm._v(_vm._s(_vm.__("Process Payment", "wepos")))])])])])])], 2) : _vm._e(), _vm._v(" "), _c("overlay", {\n    attrs: {\n      show: _vm.showOverlay\n    }\n  }), _vm._v(" "), _vm.showReceiptHtml ? _c("print-receipt-html", {\n    directives: [{\n      name: "show",\n      rawName: "v-show",\n      value: _vm.createprintreceipt,\n      expression: "createprintreceipt"\n    }],\n    attrs: {\n      printdata: _vm.printdata,\n      settings: _vm.settings\n    }\n  }) : _vm._e(), _vm._v(" "), _vm._l(_vm.afterMainContents, function (afterMainContent, key) {\n    return _c(afterMainContent, {\n      key: key,\n      tag: "component",\n      attrs: {\n        orderdata: _vm.orderdata,\n        printdata: _vm.printdata\n      }\n    });\n  })], 2);\n};\n\nvar staticRenderFns = [function () {\n  var _vm = this,\n      _c = _vm._self._c;\n\n  return _c("td", {\n    staticClass: "icon"\n  }, [_c("span", {\n    staticClass: "flaticon-right-arrow"\n  })]);\n}];\nrender._withStripped = true;\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/Home.vue?./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet%5B1%5D.rules%5B2%5D!./node_modules/vue-loader/lib/index.js??vue-loader-options')},"./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/Keyboard.vue?vue&type=template&id=fbb6d6c8&":
/*!*********************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/Keyboard.vue?vue&type=template&id=fbb6d6c8& ***!
  \*********************************************************************************************************************************************************************************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "render": () => (/* binding */ render),\n/* harmony export */   "staticRenderFns": () => (/* binding */ staticRenderFns)\n/* harmony export */ });\nvar render = function render() {\n  var _vm = this,\n      _c = _vm._self._c;\n\n  return _c("aside", {\n    staticClass: "vue-keyboard",\n    class: {\n      full: _vm.full,\n      empty: _vm.empty,\n      valid: _vm.valid,\n      invalid: !_vm.valid\n    },\n    attrs: {\n      role: "application",\n      "data-value": _vm.value,\n      "data-layout": _vm.layout\n    }\n  }, _vm._l(_vm.buttons, function (row) {\n    return _c("div", {\n      staticClass: "vue-keyboard-row",\n      attrs: {\n        role: "row",\n        "data-keys": row.length\n      }\n    }, _vm._l(row, function (btn) {\n      return _c("button", {\n        staticClass: "vue-keyboard-key",\n        class: btn.type,\n        attrs: {\n          role: "button",\n          "data-args": btn.args,\n          "data-text": btn.value,\n          "data-action": btn.action.name\n        },\n        domProps: {\n          innerHTML: _vm._s(btn.value)\n        },\n        on: {\n          click: function ($event) {\n            $event.preventDefault();\n            return btn.action.callable.apply(null, arguments);\n          }\n        }\n      });\n    }), 0);\n  }), 0);\n};\n\nvar staticRenderFns = [];\nrender._withStripped = true;\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/Keyboard.vue?./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet%5B1%5D.rules%5B2%5D!./node_modules/vue-loader/lib/index.js??vue-loader-options')},"./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/Overlay.vue?vue&type=template&id=7b9b24aa&":
/*!********************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/Overlay.vue?vue&type=template&id=7b9b24aa& ***!
  \********************************************************************************************************************************************************************************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "render": () => (/* binding */ render),\n/* harmony export */   "staticRenderFns": () => (/* binding */ staticRenderFns)\n/* harmony export */ });\nvar render = function render() {\n  var _vm = this,\n      _c = _vm._self._c;\n\n  return _vm.show ? _c("div", {\n    staticClass: "overlay"\n  }) : _vm._e();\n};\n\nvar staticRenderFns = [];\nrender._withStripped = true;\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/Overlay.vue?./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet%5B1%5D.rules%5B2%5D!./node_modules/vue-loader/lib/index.js??vue-loader-options')},"./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/PrintReceipt.vue?vue&type=template&id=11ba6300&":
/*!*************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/PrintReceipt.vue?vue&type=template&id=11ba6300& ***!
  \*************************************************************************************************************************************************************************************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "render": () => (/* binding */ render),\n/* harmony export */   "staticRenderFns": () => (/* binding */ staticRenderFns)\n/* harmony export */ });\nvar render = function render() {\n  var _vm = this,\n      _c = _vm._self._c;\n\n  return _c("div", {\n    attrs: {\n      id: "wepos-print-receipt"\n    }\n  }, [_c("button", {\n    staticClass: "print-btn",\n    on: {\n      click: function ($event) {\n        $event.preventDefault();\n        return _vm.printReceipt();\n      }\n    }\n  }, [_c("span", {\n    staticClass: "icon flaticon-printer"\n  }), _vm._v(" "), _c("span", {\n    staticClass: "label"\n  }, [_vm._v(_vm._s(_vm.__("Print Receipt", "wepos")))])])]);\n};\n\nvar staticRenderFns = [];\nrender._withStripped = true;\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/PrintReceipt.vue?./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet%5B1%5D.rules%5B2%5D!./node_modules/vue-loader/lib/index.js??vue-loader-options')},"./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/PrintReceiptHtml.vue?vue&type=template&id=2db58d4b&":
/*!*****************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/PrintReceiptHtml.vue?vue&type=template&id=2db58d4b& ***!
  \*****************************************************************************************************************************************************************************************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "render": () => (/* binding */ render),\n/* harmony export */   "staticRenderFns": () => (/* binding */ staticRenderFns)\n/* harmony export */ });\nvar render = function render() {\n  var _vm = this,\n      _c = _vm._self._c;\n\n  return _vm.settings.wepos_receipts ? _c("div", {\n    staticClass: "wepos-checkout-print-wrapper"\n  }, [_c("div", {\n    staticClass: "header",\n    domProps: {\n      innerHTML: _vm._s(_vm.settings.wepos_receipts.receipt_header)\n    }\n  }), _vm._v(" "), _c("div", {\n    staticClass: "order-info"\n  }, [_c("span", {\n    staticClass: "wepos-left"\n  }, [_c("strong", [_vm._v(_vm._s(_vm.__("Order ID", "wepos")) + ": #" + _vm._s(_vm.printdata.order_id))])]), _vm._v(" "), _c("span", {\n    staticClass: "wepos-right"\n  }, [_c("strong", [_vm._v(_vm._s(_vm.__("Order Date", "wepos")) + ": " + _vm._s(_vm.formatDate(_vm.printdata.order_date)))])]), _vm._v(" "), _c("div", {\n    staticClass: "wepos-clearfix"\n  })]), _vm._v(" "), _c("div", {\n    staticClass: "content"\n  }, [_c("table", {\n    staticClass: "sale-summary"\n  }, [_c("tbody", [_vm._l(_vm.printdata.line_items, function (item) {\n    return _c("tr", [_c("td", {\n      staticClass: "name"\n    }, [_vm._v("\\n                        " + _vm._s(item.name) + "\\n                        "), item.attribute.length > 0 ? _c("div", {\n      staticClass: "attribute"\n    }, [_c("ul", _vm._l(item.attribute, function (attribute_item) {\n      return _c("li", [_c("span", {\n        staticClass: "attr_name"\n      }, [_vm._v(_vm._s(attribute_item.name))]), _vm._v(": "), _c("span", {\n        staticClass: "attr_value"\n      }, [_vm._v(_vm._s(attribute_item.option))])]);\n    }), 0)]) : _vm._e()]), _vm._v(" "), _c("td", {\n      staticClass: "quantity"\n    }, [_vm._v(_vm._s(item.quantity))]), _vm._v(" "), _c("td", {\n      staticClass: "price"\n    }, [item.on_sale ? [_c("span", {\n      staticClass: "regular-price"\n    }, [_vm._v(_vm._s(_vm.formatPrice(item.quantity * item.regular_price)))]), _vm._v(" "), _c("span", {\n      staticClass: "sale-price"\n    }, [_vm._v(_vm._s(_vm.formatPrice(item.quantity * item.sale_price)))])] : [_c("span", {\n      staticClass: "sale-price"\n    }, [_vm._v(_vm._s(_vm.formatPrice(item.quantity * item.regular_price)))])]], 2)]);\n  }), _vm._v(" "), _c("tr", {\n    staticClass: "cart-meta-data"\n  }, [_c("td", {\n    staticClass: "name",\n    attrs: {\n      colspan: "2"\n    }\n  }, [_vm._v("\\n                        " + _vm._s(_vm.__("Subtotal", "wepos")) + "\\n                        "), _vm.settings.woo_tax.wc_tax_display_cart == "incl" ? _c("span", {\n    staticClass: "metadata"\n  }, [_vm._v("\\n                            " + _vm._s(_vm.__("Includes Tax", "wepos")) + " " + _vm._s(_vm.formatPrice(_vm.$store.getters["Cart/getTotalLineTax"])) + "\\n                        ")]) : _vm._e()]), _vm._v(" "), _c("td", {\n    staticClass: "price"\n  }, [_vm._v(_vm._s(_vm.formatPrice(_vm.printdata.subtotal)))])]), _vm._v(" "), _vm._l(_vm.printdata.fee_lines, function (fee, key) {\n    return _c("tr", {\n      staticClass: "cart-meta-data"\n    }, [fee.type == "discount" ? [_c("td", {\n      staticClass: "name",\n      attrs: {\n        colspan: "2"\n      }\n    }, [_vm._v(_vm._s(_vm.__("Discount", "wepos")) + " "), _c("span", {\n      staticClass: "metadata"\n    }, [_vm._v(_vm._s(fee.discount_type == "percent" ? fee.value + "%" : _vm.formatPrice(fee.value)))])]), _vm._v(" "), _c("td", {\n      staticClass: "price"\n    }, [_vm._v("-" + _vm._s(_vm.formatPrice(Math.abs(fee.total))))])] : [_c("td", {\n      staticClass: "name",\n      attrs: {\n        colspan: "2"\n      }\n    }, [_vm._v(_vm._s(_vm.__("Fee", "wepos")) + " "), _c("span", {\n      staticClass: "metadata"\n    }, [_vm._v(_vm._s(fee.name) + " " + _vm._s(fee.fee_type == "percent" ? fee.value + "%" : _vm.formatPrice(fee.value)))])]), _vm._v(" "), _c("td", {\n      staticClass: "price"\n    }, [_vm._v("-" + _vm._s(_vm.formatPrice(Math.abs(fee.total))))])]], 2);\n  }), _vm._v(" "), _vm.printdata.taxtotal ? _c("tr", [_c("td", {\n    staticClass: "name",\n    attrs: {\n      colspan: "2"\n    }\n  }, [_vm._v(_vm._s(_vm.__("Tax", "wepos")))]), _vm._v(" "), _c("td", {\n    staticClass: "price"\n  }, [_vm._v(_vm._s(_vm.formatPrice(_vm.printdata.taxtotal)))])]) : _vm._e(), _vm._v(" "), _c("tr", [_c("td", {\n    staticClass: "name",\n    attrs: {\n      colspan: "2"\n    }\n  }, [_vm._v(_vm._s(_vm.__("Order Total", "wepos")))]), _vm._v(" "), _c("td", {\n    staticClass: "price"\n  }, [_vm._v(_vm._s(_vm.formatPrice(_vm.printdata.ordertotal)))])]), _vm._v(" "), _vm._m(0), _vm._v(" "), _c("tr", [_c("td", {\n    attrs: {\n      colspan: "2"\n    }\n  }, [_vm._v(_vm._s(_vm.__("Payment method", "wepos")))]), _vm._v(" "), _c("td", {\n    staticClass: "price"\n  }, [_vm._v(_vm._s(_vm.printdata.gateway.title || ""))])]), _vm._v(" "), (_vm.printdata.gateway.id = "wepos_cash") ? [_c("tr", [_c("td", {\n    attrs: {\n      colspan: "2"\n    }\n  }, [_vm._v(_vm._s(_vm.__("Cash Given", "wepos")))]), _vm._v(" "), _c("td", {\n    staticClass: "price"\n  }, [_vm._v(_vm._s(_vm.formatPrice(_vm.printdata.cashamount)))])]), _vm._v(" "), _c("tr", [_c("td", {\n    attrs: {\n      colspan: "2"\n    }\n  }, [_vm._v(_vm._s(_vm.__("Change Money", "wepos")))]), _vm._v(" "), _c("td", {\n    staticClass: "price"\n  }, [_vm._v(_vm._s(_vm.formatPrice(_vm.printdata.changeamount)))])])] : _vm._e()], 2)])]), _vm._v(" "), _c("div", {\n    staticClass: "footer",\n    domProps: {\n      innerHTML: _vm._s(_vm.settings.wepos_receipts.receipt_footer)\n    }\n  })]) : _vm._e();\n};\n\nvar staticRenderFns = [function () {\n  var _vm = this,\n      _c = _vm._self._c;\n\n  return _c("tr", {\n    staticClass: "divider"\n  }, [_c("td", {\n    attrs: {\n      colspan: "3"\n    }\n  })]);\n}];\nrender._withStripped = true;\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/PrintReceiptHtml.vue?./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet%5B1%5D.rules%5B2%5D!./node_modules/vue-loader/lib/index.js??vue-loader-options')},"./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/ProductSearch.vue?vue&type=template&id=64fc4f12&":
/*!**************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/ProductSearch.vue?vue&type=template&id=64fc4f12& ***!
  \**************************************************************************************************************************************************************************************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "render": () => (/* binding */ render),\n/* harmony export */   "staticRenderFns": () => (/* binding */ staticRenderFns)\n/* harmony export */ });\nvar render = function render() {\n  var _vm = this,\n      _c = _vm._self._c;\n\n  return _c("div", {\n    directives: [{\n      name: "click-outside",\n      rawName: "v-click-outside",\n      value: _vm.outside,\n      expression: "outside"\n    }],\n    staticClass: "search-box"\n  }, [_c("form", {\n    attrs: {\n      action: "",\n      autocomplete: "off"\n    },\n    on: {\n      submit: function ($event) {\n        $event.preventDefault();\n        return _vm.handleProductScan.apply(null, arguments);\n      }\n    }\n  }, [_c("input", {\n    directives: [{\n      name: "model",\n      rawName: "v-model",\n      value: _vm.serachInput,\n      expression: "serachInput"\n    }],\n    ref: "productSearch",\n    attrs: {\n      type: "text",\n      name: "search",\n      id: "product-search",\n      placeholder: _vm.placeholder\n    },\n    domProps: {\n      value: _vm.serachInput\n    },\n    on: {\n      focus: function ($event) {\n        $event.preventDefault();\n        return _vm.triggerFocus.apply(null, arguments);\n      },\n      keyup: function ($event) {\n        $event.preventDefault();\n        return _vm.searchProduct.apply(null, arguments);\n      },\n      input: function ($event) {\n        if ($event.target.composing) return;\n        _vm.serachInput = $event.target.value;\n      }\n    }\n  }), _vm._v(" "), _vm.mode == "product" ? _c("span", {\n    staticClass: "search-icon flaticon-musica-searcher"\n  }) : _vm._e(), _vm._v(" "), _vm.mode == "scan" ? _c("span", {\n    staticClass: "search-icon flaticon-supermarket-scanner"\n  }) : _vm._e(), _vm._v(" "), _c("div", {\n    directives: [{\n      name: "hotkey",\n      rawName: "v-hotkey",\n      value: _vm.hotkeys,\n      expression: "hotkeys"\n    }],\n    staticClass: "search-type"\n  }, [_c("a", {\n    class: {\n      active: _vm.mode == "product"\n    },\n    attrs: {\n      href: "#"\n    },\n    on: {\n      click: function ($event) {\n        $event.preventDefault();\n        return _vm.changeMode("product");\n      }\n    }\n  }, [_vm._v(_vm._s(_vm.__("Product", "wepos")))]), _vm._v(" "), _c("a", {\n    class: {\n      active: _vm.mode == "scan"\n    },\n    attrs: {\n      href: "#"\n    },\n    on: {\n      click: function ($event) {\n        $event.preventDefault();\n        return _vm.changeMode("scan");\n      }\n    }\n  }, [_vm._v(_vm._s(_vm.__("Scan", "wepos")))])]), _vm._v(" "), _c("div", {\n    directives: [{\n      name: "show",\n      rawName: "v-show",\n      value: _vm.showResults && _vm.mode == "product",\n      expression: "showResults && mode==\'product\'"\n    }],\n    staticClass: "search-result"\n  }, [_vm.searchableProduct.length ? _c("div", [_c("keyboard-control", {\n    attrs: {\n      listLength: _vm.searchableProduct.length\n    },\n    on: {\n      "key-down": _vm.onKeyDown,\n      "key-up": _vm.onKeyUp\n    },\n    scopedSlots: _vm._u([{\n      key: "default",\n      fn: function (_ref) {\n        let {\n          selectedIndex\n        } = _ref;\n        return _vm._l(_vm.searchableProduct, function (product, index) {\n          return _c("li", {\n            key: index,\n            staticClass: "product-search-item",\n            class: {\n              selected: index === selectedIndex\n            }\n          }, [product.type == "simple" ? [_c("a", {\n            staticClass: "wepos-clearfix",\n            attrs: {\n              href: "#"\n            },\n            on: {\n              click: function ($event) {\n                return _vm.addToCartAction(product);\n              }\n            }\n          }, [_vm._v(_vm._s(product.name) + "\\n                                    "), _c("span", {\n            staticClass: "price"\n          }, [_vm._v(_vm._s(_vm.formatPrice(product.price)))]), _vm._v(" "), product.sku ? _c("span", {\n            staticClass: "sku"\n          }, [_vm._v(_vm._s(product.sku))]) : _vm._e(), _vm._v(" "), _c("span", {\n            staticClass: "action flaticon-enter-arrow wepos-right"\n          })])] : _vm._e(), _vm._v(" "), product.type == "variable" ? [_c("a", {\n            attrs: {\n              href: "#"\n            },\n            on: {\n              click: function ($event) {\n                $event.preventDefault();\n                return _vm.selectVariation(product);\n              }\n            }\n          }, [_vm._v(_vm._s(product.name) + "\\n                                    "), _c("span", {\n            staticClass: "price"\n          }, [_vm._v(_vm._s(_vm.formatPrice(product.price)))]), _vm._v(" "), product.sku ? _c("span", {\n            staticClass: "sku"\n          }, [_vm._v(_vm._s(product.sku))]) : _vm._e(), _vm._v(" "), _c("span", {\n            staticClass: "action flaticon-enter-arrow wepos-right"\n          })])] : _vm._e()], 2);\n        });\n      }\n    }], null, false, 2881840290)\n  })], 1) : _c("div", {\n    staticClass: "no-data-found"\n  }, [_vm._v("\\n                " + _vm._s(_vm.__("No product found", "wepos")) + "\\n            ")]), _vm._v(" "), _c("div", {\n    staticClass: "suggession"\n  }, [_c("span", {\n    staticClass: "term"\n  }, [_c("span", {\n    staticClass: "flaticon-swap"\n  }), _vm._v(" " + _vm._s(_vm.__("to navigate", "wepos")) + "\\n                ")]), _vm._v(" "), _c("span", {\n    staticClass: "term"\n  }, [_c("span", {\n    staticClass: "flaticon-enter-arrow"\n  }), _vm._v(" " + _vm._s(_vm.__("to select", "wepos")) + "\\n                ")]), _vm._v(" "), _c("span", {\n    staticClass: "term"\n  }, [_c("strong", [_vm._v("esc")]), _vm._v(" " + _vm._s(_vm.__("to dismiss", "wepos")) + "\\n                ")])])])]), _vm._v(" "), _vm.showVariationModal ? _c("modal", {\n    attrs: {\n      title: _vm.__("Select Variations", "wepos"),\n      width: "500px",\n      height: "auto",\n      footer: true,\n      header: true\n    },\n    on: {\n      close: function ($event) {\n        _vm.showVariationModal = false;\n      }\n    }\n  }, [_c("template", {\n    slot: "body"\n  }, _vm._l(_vm.selectedVariationProduct.attributes, function (attribute) {\n    return _c("div", {\n      staticClass: "variation-attribute-wrapper"\n    }, [_c("div", {\n      staticClass: "attribute"\n    }, [_c("p", [_vm._v(_vm._s(attribute.name))]), _vm._v(" "), _c("div", {\n      staticClass: "options"\n    }, [_vm._l(attribute.options, function (option) {\n      return [_c("label", [_c("input", {\n        directives: [{\n          name: "model",\n          rawName: "v-model",\n          value: _vm.chosenAttribute[attribute.name],\n          expression: "chosenAttribute[attribute.name]"\n        }],\n        attrs: {\n          type: "radio"\n        },\n        domProps: {\n          value: option,\n          checked: _vm._q(_vm.chosenAttribute[attribute.name], option)\n        },\n        on: {\n          change: function ($event) {\n            return _vm.$set(_vm.chosenAttribute, attribute.name, option);\n          }\n        }\n      }), _vm._v(" "), _c("div", {\n        staticClass: "box"\n      }, [_vm._v("\\n                                    " + _vm._s(option) + "\\n                                ")])])];\n    })], 2)])]);\n  }), 0), _vm._v(" "), _c("template", {\n    slot: "footer"\n  }, [_c("button", {\n    staticClass: "add-variation-btn",\n    attrs: {\n      disabled: _vm.attributeDisabled\n    },\n    on: {\n      click: function ($event) {\n        return _vm.addVariationProduct();\n      }\n    }\n  }, [_vm._v(_vm._s(_vm.__("Add Product", "wepos")))])])], 2) : _vm._e()], 1);\n};\n\nvar staticRenderFns = [];\nrender._withStripped = true;\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/ProductSearch.vue?./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet%5B1%5D.rules%5B2%5D!./node_modules/vue-loader/lib/index.js??vue-loader-options')},"./node_modules/element-in-view/dist/element-in-view.common.js":
/*!*********************************************************************!*\
  !*** ./node_modules/element-in-view/dist/element-in-view.common.js ***!
  \*********************************************************************/module=>{"use strict";eval("\n\nvar index = function (element, ref) {\n  if ( ref === void 0 ) ref = {};\n  var offset = ref.offset; if ( offset === void 0 ) offset = 0;\n  var threshold = ref.threshold; if ( threshold === void 0 ) threshold = 0;\n\n  var ref$1 = element.getBoundingClientRect();\n  var top = ref$1.top;\n  var right = ref$1.right;\n  var bottom = ref$1.bottom;\n  var left = ref$1.left;\n  var width = ref$1.width;\n  var height = ref$1.height;\n\n  var intersection = {\n    t: bottom,\n    r: window.innerWidth - left,\n    b: window.innerHeight - top,\n    l: right\n  };\n\n  var elementThreshold = {\n    x: threshold * width,\n    y: threshold * height\n  };\n\n  return (\n    intersection.t >= (offset.top || offset + elementThreshold.y) &&\n    intersection.r >= (offset.right || offset + elementThreshold.x) &&\n    intersection.b >= (offset.bottom || offset + elementThreshold.y) &&\n    intersection.l >= (offset.left || offset + elementThreshold.x)\n  )\n};\n\nmodule.exports = index;\n\n\n//# sourceURL=webpack://wepos/./node_modules/element-in-view/dist/element-in-view.common.js?")},"./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/CustomerNote.vue?vue&type=style&index=0&id=4073e2a5&lang=less&":
/*!**************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/CustomerNote.vue?vue&type=style&index=0&id=4073e2a5&lang=less& ***!
  \**************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n// extracted by mini-css-extract-plugin\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/CustomerNote.vue?./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options")},"./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/CustomerSearch.vue?vue&type=style&index=0&id=414ef29b&lang=less&":
/*!****************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/CustomerSearch.vue?vue&type=style&index=0&id=414ef29b&lang=less& ***!
  \****************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n// extracted by mini-css-extract-plugin\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/CustomerSearch.vue?./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options")},"./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/FeeKeypad.vue?vue&type=style&index=0&id=0bc4dc95&lang=less&":
/*!***********************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/FeeKeypad.vue?vue&type=style&index=0&id=0bc4dc95&lang=less& ***!
  \***********************************************************************************************************************************************************************************************************************************************************************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n// extracted by mini-css-extract-plugin\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/FeeKeypad.vue?./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options")},"./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/Home.vue?vue&type=style&index=0&id=76253014&lang=less&":
/*!******************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/Home.vue?vue&type=style&index=0&id=76253014&lang=less& ***!
  \******************************************************************************************************************************************************************************************************************************************************************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n// extracted by mini-css-extract-plugin\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/Home.vue?./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options")},"./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/Keyboard.vue?vue&type=style&index=0&id=fbb6d6c8&lang=less&":
/*!**********************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/Keyboard.vue?vue&type=style&index=0&id=fbb6d6c8&lang=less& ***!
  \**********************************************************************************************************************************************************************************************************************************************************************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n// extracted by mini-css-extract-plugin\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/Keyboard.vue?./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options")},"./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/Overlay.vue?vue&type=style&index=0&id=7b9b24aa&lang=css&":
/*!********************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/Overlay.vue?vue&type=style&index=0&id=7b9b24aa&lang=css& ***!
  \********************************************************************************************************************************************************************************************************************************************************************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n// extracted by mini-css-extract-plugin\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/Overlay.vue?./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options")},"./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/PrintReceipt.vue?vue&type=style&index=0&id=11ba6300&lang=less&":
/*!**************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/PrintReceipt.vue?vue&type=style&index=0&id=11ba6300&lang=less& ***!
  \**************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n// extracted by mini-css-extract-plugin\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/PrintReceipt.vue?./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options")},"./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/PrintReceiptHtml.vue?vue&type=style&index=0&id=2db58d4b&lang=less&":
/*!******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/PrintReceiptHtml.vue?vue&type=style&index=0&id=2db58d4b&lang=less& ***!
  \******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n// extracted by mini-css-extract-plugin\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/PrintReceiptHtml.vue?./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options")},"./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/ProductSearch.vue?vue&type=style&index=0&id=64fc4f12&lang=less&":
/*!***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/ProductSearch.vue?vue&type=style&index=0&id=64fc4f12&lang=less& ***!
  \***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n// extracted by mini-css-extract-plugin\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/ProductSearch.vue?./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options")},"./node_modules/throttleit/index.js":
/*!******************************************!*\
  !*** ./node_modules/throttleit/index.js ***!
  \******************************************/module=>{eval("module.exports = throttle;\n\n/**\n * Returns a new function that, when invoked, invokes `func` at most once per `wait` milliseconds.\n *\n * @param {Function} func Function to wrap.\n * @param {Number} wait Number of milliseconds that must elapse between `func` invocations.\n * @return {Function} A new function that wraps the `func` function passed in.\n */\n\nfunction throttle (func, wait) {\n  var ctx, args, rtn, timeoutID; // caching\n  var last = 0;\n\n  return function throttled () {\n    ctx = this;\n    args = arguments;\n    var delta = new Date() - last;\n    if (!timeoutID)\n      if (delta >= wait) call();\n      else timeoutID = setTimeout(call, wait - delta);\n    return rtn;\n  };\n\n  function call () {\n    timeoutID = 0;\n    last = +new Date();\n    rtn = func.apply(ctx, args);\n    ctx = null;\n    args = null;\n  }\n}\n\n\n//# sourceURL=webpack://wepos/./node_modules/throttleit/index.js?")},"./node_modules/v-hotkey/dist/v-hotkey.common.js":
/*!*******************************************************!*\
  !*** ./node_modules/v-hotkey/dist/v-hotkey.common.js ***!
  \*******************************************************/module=>{eval("module.exports =\n/******/ (function(modules) { // webpackBootstrap\n/******/ \t// The module cache\n/******/ \tvar installedModules = {};\n/******/\n/******/ \t// The require function\n/******/ \tfunction __nested_webpack_require_187__(moduleId) {\n/******/\n/******/ \t\t// Check if module is in cache\n/******/ \t\tif(installedModules[moduleId]) {\n/******/ \t\t\treturn installedModules[moduleId].exports;\n/******/ \t\t}\n/******/ \t\t// Create a new module (and put it into the cache)\n/******/ \t\tvar module = installedModules[moduleId] = {\n/******/ \t\t\ti: moduleId,\n/******/ \t\t\tl: false,\n/******/ \t\t\texports: {}\n/******/ \t\t};\n/******/\n/******/ \t\t// Execute the module function\n/******/ \t\tmodules[moduleId].call(module.exports, module, module.exports, __nested_webpack_require_187__);\n/******/\n/******/ \t\t// Flag the module as loaded\n/******/ \t\tmodule.l = true;\n/******/\n/******/ \t\t// Return the exports of the module\n/******/ \t\treturn module.exports;\n/******/ \t}\n/******/\n/******/\n/******/ \t// expose the modules object (__webpack_modules__)\n/******/ \t__nested_webpack_require_187__.m = modules;\n/******/\n/******/ \t// expose the module cache\n/******/ \t__nested_webpack_require_187__.c = installedModules;\n/******/\n/******/ \t// define getter function for harmony exports\n/******/ \t__nested_webpack_require_187__.d = function(exports, name, getter) {\n/******/ \t\tif(!__nested_webpack_require_187__.o(exports, name)) {\n/******/ \t\t\tObject.defineProperty(exports, name, { enumerable: true, get: getter });\n/******/ \t\t}\n/******/ \t};\n/******/\n/******/ \t// define __esModule on exports\n/******/ \t__nested_webpack_require_187__.r = function(exports) {\n/******/ \t\tif(typeof Symbol !== 'undefined' && Symbol.toStringTag) {\n/******/ \t\t\tObject.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });\n/******/ \t\t}\n/******/ \t\tObject.defineProperty(exports, '__esModule', { value: true });\n/******/ \t};\n/******/\n/******/ \t// create a fake namespace object\n/******/ \t// mode & 1: value is a module id, require it\n/******/ \t// mode & 2: merge all properties of value into the ns\n/******/ \t// mode & 4: return value when already ns object\n/******/ \t// mode & 8|1: behave like require\n/******/ \t__nested_webpack_require_187__.t = function(value, mode) {\n/******/ \t\tif(mode & 1) value = __nested_webpack_require_187__(value);\n/******/ \t\tif(mode & 8) return value;\n/******/ \t\tif((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;\n/******/ \t\tvar ns = Object.create(null);\n/******/ \t\t__nested_webpack_require_187__.r(ns);\n/******/ \t\tObject.defineProperty(ns, 'default', { enumerable: true, value: value });\n/******/ \t\tif(mode & 2 && typeof value != 'string') for(var key in value) __nested_webpack_require_187__.d(ns, key, function(key) { return value[key]; }.bind(null, key));\n/******/ \t\treturn ns;\n/******/ \t};\n/******/\n/******/ \t// getDefaultExport function for compatibility with non-harmony modules\n/******/ \t__nested_webpack_require_187__.n = function(module) {\n/******/ \t\tvar getter = module && module.__esModule ?\n/******/ \t\t\tfunction getDefault() { return module['default']; } :\n/******/ \t\t\tfunction getModuleExports() { return module; };\n/******/ \t\t__nested_webpack_require_187__.d(getter, 'a', getter);\n/******/ \t\treturn getter;\n/******/ \t};\n/******/\n/******/ \t// Object.prototype.hasOwnProperty.call\n/******/ \t__nested_webpack_require_187__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };\n/******/\n/******/ \t// __webpack_public_path__\n/******/ \t__nested_webpack_require_187__.p = \"\";\n/******/\n/******/\n/******/ \t// Load entry module and return exports\n/******/ \treturn __nested_webpack_require_187__(__nested_webpack_require_187__.s = \"fb15\");\n/******/ })\n/************************************************************************/\n/******/ ({\n\n/***/ \"f6fd\":\n/***/ (function(module, exports) {\n\n// document.currentScript polyfill by Adam Miller\n\n// MIT license\n\n(function(document){\n  var currentScript = \"currentScript\",\n      scripts = document.getElementsByTagName('script'); // Live NodeList collection\n\n  // If browser needs currentScript polyfill, add get currentScript() to the document object\n  if (!(currentScript in document)) {\n    Object.defineProperty(document, currentScript, {\n      get: function(){\n\n        // IE 6-10 supports script readyState\n        // IE 10+ support stack trace\n        try { throw new Error(); }\n        catch (err) {\n\n          // Find the second match for the \"at\" string to get file src url from stack.\n          // Specifically works with the format of stack traces in IE.\n          var i, res = ((/.*at [^\\(]*\\((.*):.+:.+\\)$/ig).exec(err.stack) || [false])[1];\n\n          // For all scripts on the page, if src matches or if ready state is interactive, return the script tag\n          for(i in scripts){\n            if(scripts[i].src == res || scripts[i].readyState == \"interactive\"){\n              return scripts[i];\n            }\n          }\n\n          // If no match, return null\n          return null;\n        }\n      }\n    });\n  }\n})(document);\n\n\n/***/ }),\n\n/***/ \"fb15\":\n/***/ (function(module, __webpack_exports__, __nested_webpack_require_4937__) {\n\n\"use strict\";\n__nested_webpack_require_4937__.r(__webpack_exports__);\n\n// CONCATENATED MODULE: ./node_modules/@vue/cli-service/lib/commands/build/setPublicPath.js\n// This file is imported into lib/wc client bundles.\n\nif (typeof window !== 'undefined') {\n  if (true) {\n    __nested_webpack_require_4937__(\"f6fd\")\n  }\n\n  var i\n  if ((i = window.document.currentScript) && (i = i.src.match(/(.+\\/)[^/]+\\.js(\\?.*)?$/))) {\n    __nested_webpack_require_4937__.p = i[1] // eslint-disable-line\n  }\n}\n\n// Indicate to webpack that this file can be concatenated\n/* harmony default export */ var setPublicPath = (null);\n\n// CONCATENATED MODULE: ./src/keycodes/aliases.js\n/* harmony default export */ var aliases = ({\n  windows: 91,\n  '⇧': 16,\n  '⌥': 18,\n  '⌃': 17,\n  '⌘': 91,\n  ctl: 17,\n  control: 17,\n  option: 18,\n  pause: 19,\n  \"break\": 19,\n  caps: 20,\n  \"return\": 13,\n  escape: 27,\n  spc: 32,\n  pgup: 33,\n  pgdn: 34,\n  ins: 45,\n  del: 46,\n  cmd: 91\n});\n// CONCATENATED MODULE: ./src/keycodes/functionkeys.js\n/* harmony default export */ var functionkeys = ({\n  f1: 112,\n  f2: 113,\n  f3: 114,\n  f4: 115,\n  f5: 116,\n  f6: 117,\n  f7: 118,\n  f8: 119,\n  f9: 120,\n  f10: 121,\n  f11: 122,\n  f12: 123\n});\n// CONCATENATED MODULE: ./src/keycodes/lowercase.js\n/* harmony default export */ var lowercase = ({\n  a: 65,\n  b: 66,\n  c: 67,\n  d: 68,\n  e: 69,\n  f: 70,\n  g: 71,\n  h: 72,\n  i: 73,\n  j: 74,\n  k: 75,\n  l: 76,\n  m: 77,\n  n: 78,\n  o: 79,\n  p: 80,\n  q: 81,\n  r: 82,\n  s: 83,\n  t: 84,\n  u: 85,\n  v: 86,\n  w: 87,\n  x: 88,\n  y: 89,\n  z: 90\n});\n// CONCATENATED MODULE: ./src/keycodes/numpad.js\n/* harmony default export */ var numpad = ({\n  'numpad*': 106,\n  'numpad+': 43,\n  numpadadd: 43,\n  'numpad-': 109,\n  'numpad.': 110,\n  'numpad/': 111,\n  numlock: 144,\n  numpad0: 96,\n  numpad1: 97,\n  numpad2: 98,\n  numpad3: 99,\n  numpad4: 100,\n  numpad5: 101,\n  numpad6: 102,\n  numpad7: 103,\n  numpad8: 104,\n  numpad9: 105\n});\n// CONCATENATED MODULE: ./src/keycodes/codes.js\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\n\n\n\n\n/* harmony default export */ var codes = (_objectSpread({\n  backspace: 8,\n  tab: 9,\n  enter: 13,\n  shift: 16,\n  ctrl: 17,\n  alt: 18,\n  'pause/break': 19,\n  capslock: 20,\n  esc: 27,\n  space: 32,\n  pageup: 33,\n  pagedown: 34,\n  end: 35,\n  home: 36,\n  left: 37,\n  up: 38,\n  right: 39,\n  down: 40,\n  insert: 45,\n  \"delete\": 46,\n  command: 91,\n  meta: 91,\n  leftcommand: 91,\n  rightcommand: 93,\n  scrolllock: 145,\n  mycomputer: 182,\n  mycalculator: 183,\n  ';': 186,\n  '=': 187,\n  ',': 188,\n  '-': 189,\n  '.': 190,\n  '/': 191,\n  '`': 192,\n  '[': 219,\n  '\\\\': 220,\n  ']': 221,\n  \"'\": 222,\n  ':': 186,\n  '+': 187,\n  '<': 188,\n  _: 189,\n  '>': 190,\n  '?': 191,\n  '~': 192,\n  '{': 219,\n  '|': 220,\n  '}': 221,\n  '\"': 222\n}, lowercase, {}, numpad, {}, functionkeys, {}, aliases));\n// CONCATENATED MODULE: ./src/helpers.js\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === \"[object Arguments]\")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\nvar FORBIDDEN_NODES = ['INPUT', 'TEXTAREA', 'SELECT'];\n/**\n *\n * @param {Object} a\n * @param {Object} b\n * @returns {Boolean}\n */\n\nvar areObjectsEqual = function areObjectsEqual(a, b) {\n  return Object.entries(a).every(function (_ref) {\n    var _ref2 = _slicedToArray(_ref, 2),\n        key = _ref2[0],\n        value = _ref2[1];\n\n    return b[key] === value;\n  });\n};\n/**\n *\n * @param {String} combination\n */\n\n\nvar splitCombination = function splitCombination(combination) {\n  combination = combination.replace(/\\s/g, '');\n  combination = combination.includes('numpad+') ? combination.replace('numpad+', 'numpadadd') : combination;\n  combination = combination.includes('++') ? combination.replace('++', '+=') : combination;\n  return combination.split(/\\+{1}/);\n};\n/**\n *\n * @param {String} key\n * @returns {String|undefined}\n */\n\nvar returnCharCode = function returnCharCode(key) {\n  return key.length === 1 ? key.charCodeAt(0) : undefined;\n};\n/**\n *\n * @param {Array} keyMap\n * @param {Number} keyCode\n * @param {Object} eventKeyModifiers\n * @returns {Function|Boolean}\n */\n\nvar getHotkeyCallback = function getHotkeyCallback(keyMap, keyCode, eventKeyModifiers) {\n  var key = keyMap.find(function (_ref3) {\n    var code = _ref3.code,\n        modifiers = _ref3.modifiers;\n    return code === keyCode && areObjectsEqual(eventKeyModifiers, modifiers);\n  });\n  if (!key) return false;\n  return key.callback;\n};\n/**\n *\n * @param {Event} e\n * @param {Array} keyMap\n * @param {Object} modifiers Vue event modifiers\n */\n\n\nvar assignKeyHandler = function assignKeyHandler(e, keyMap, modifiers) {\n  var keyCode = e.keyCode,\n      ctrlKey = e.ctrlKey,\n      altKey = e.altKey,\n      shiftKey = e.shiftKey,\n      metaKey = e.metaKey;\n  var eventKeyModifiers = {\n    ctrlKey: ctrlKey,\n    altKey: altKey,\n    shiftKey: shiftKey,\n    metaKey: metaKey\n  };\n\n  if (modifiers.prevent) {\n    e.preventDefault();\n  }\n\n  if (modifiers.stop) {\n    e.stopPropagation();\n  }\n\n  var _document$activeEleme = document.activeElement,\n      nodeName = _document$activeEleme.nodeName,\n      isContentEditable = _document$activeEleme.isContentEditable;\n  if (isContentEditable) return;\n  if (FORBIDDEN_NODES.includes(nodeName)) return;\n  var callback = getHotkeyCallback(keyMap, keyCode, eventKeyModifiers);\n  if (!callback) return e;\n  e.preventDefault();\n  callback[e.type](e);\n};\n// CONCATENATED MODULE: ./src/keycodes/index.js\nfunction keycodes_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction keycodes_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { keycodes_ownKeys(source, true).forEach(function (key) { keycodes_defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { keycodes_ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction keycodes_defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\n\n\n\nvar noop = function noop() {};\n\nvar defaultModifiers = {\n  ctrlKey: false,\n  altKey: false,\n  shiftKey: false,\n  metaKey: false\n};\nvar alternativeKeyNames = {\n  option: 'alt',\n  command: 'meta',\n  \"return\": 'enter',\n  escape: 'esc',\n  plus: '+',\n  mod: /Mac|iPod|iPhone|iPad/.test(navigator.platform) ? 'meta' : 'ctrl'\n};\n/**\n *\n * @param {Object} combinations\n * @param {Object} alias\n * @returns {Object}\n */\n\nvar keycodes_getKeyMap = function getKeyMap(combinations, alias) {\n  var result = [];\n  Object.keys(combinations).forEach(function (combination) {\n    var _combinations$combina = combinations[combination],\n        keyup = _combinations$combina.keyup,\n        keydown = _combinations$combina.keydown;\n    var callback = {\n      keydown: keydown || (keyup ? noop : combinations[combination]),\n      keyup: keyup || noop\n    };\n    var keys = splitCombination(combination);\n\n    var _resolveCodesAndModif = resolveCodesAndModifiers(keys, alias),\n        code = _resolveCodesAndModif.code,\n        modifiers = _resolveCodesAndModif.modifiers;\n\n    result.push({\n      code: code,\n      modifiers: modifiers,\n      callback: callback\n    });\n  });\n  return result;\n};\n/**\n *\n * @param {Array} keys\n * @param {Object} alias\n * @returns {Object}\n */\n\nvar resolveCodesAndModifiers = function resolveCodesAndModifiers(keys, alias) {\n  var modifiers = keycodes_objectSpread({}, defaultModifiers);\n\n  if (keys.length > 1) {\n    return keys.reduce(function (acc, key) {\n      key = alternativeKeyNames[key] || key;\n\n      if (defaultModifiers.hasOwnProperty(\"\".concat(key, \"Key\"))) {\n        acc.modifiers = keycodes_objectSpread({}, acc.modifiers, keycodes_defineProperty({}, \"\".concat(key, \"Key\"), true));\n      } else {\n        acc.code = alias[key] || keycodes_searchKeyCode(key);\n      }\n\n      return acc;\n    }, {\n      modifiers: modifiers\n    });\n  }\n\n  var key = alternativeKeyNames[keys[0]] || keys[0];\n\n  if (defaultModifiers.hasOwnProperty(\"\".concat(key, \"Key\"))) {\n    modifiers = keycodes_objectSpread({}, modifiers, keycodes_defineProperty({}, \"\".concat(key, \"Key\"), true));\n  }\n\n  var code = alias[key] || keycodes_searchKeyCode(key);\n  return {\n    modifiers: modifiers,\n    code: code\n  };\n};\n/**\n *\n * @param {String} key\n */\n\n\nvar keycodes_searchKeyCode = function searchKeyCode(key) {\n  return codes[key.toLowerCase()] || returnCharCode(key);\n};\n// CONCATENATED MODULE: ./src/main.js\n\n\n/**\n *\n * @param {Object} el\n * @param {Object} bindings\n * @param {Object} alias\n */\n\nfunction bindEvent(el, _ref, alias) {\n  var value = _ref.value,\n      modifiers = _ref.modifiers;\n  el._keyMap = keycodes_getKeyMap(value, alias);\n\n  el._keyHandler = function (e) {\n    return assignKeyHandler(e, el._keyMap, modifiers);\n  };\n\n  document.addEventListener('keydown', el._keyHandler);\n  document.addEventListener('keyup', el._keyHandler);\n}\n/**\n *\n * @param {Object} el\n */\n\n\nfunction unbindEvent(el) {\n  document.removeEventListener('keydown', el._keyHandler);\n  document.removeEventListener('keyup', el._keyHandler);\n}\n\n\n// CONCATENATED MODULE: ./src/index.js\n\n\nvar src_buildDirective = function buildDirective() {\n  var alias = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};\n  return {\n    bind: function bind(el, binding) {\n      bindEvent(el, binding, alias);\n    },\n    componentUpdated: function componentUpdated(el, binding) {\n      if (binding.value !== binding.oldValue) {\n        unbindEvent(el);\n        bindEvent(el, binding, alias);\n      }\n    },\n    unbind: unbindEvent\n  };\n};\n\nvar src_plugin = {\n  install: function install(Vue) {\n    var alias = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};\n    Vue.directive('hotkey', src_buildDirective(alias));\n  },\n  directive: src_buildDirective()\n};\n/* harmony default export */ var src = (src_plugin);\n// CONCATENATED MODULE: ./node_modules/@vue/cli-service/lib/commands/build/entry-lib.js\n\n\n/* harmony default export */ var entry_lib = __webpack_exports__[\"default\"] = (src);\n\n\n\n/***/ })\n\n/******/ });\n//# sourceMappingURL=v-hotkey.common.js.map\n\n//# sourceURL=webpack://wepos/./node_modules/v-hotkey/dist/v-hotkey.common.js?")},"./assets/src/frontend/App.vue":
/*!*************************************!*\
  !*** ./assets/src/frontend/App.vue ***!
  \*************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _App_vue_vue_type_template_id_152fd186___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./App.vue?vue&type=template&id=152fd186& */ "./assets/src/frontend/App.vue?vue&type=template&id=152fd186&");\n/* harmony import */ var _App_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./App.vue?vue&type=script&lang=js& */ "./assets/src/frontend/App.vue?vue&type=script&lang=js&");\n/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");\n\n\n\n\n\n/* normalize component */\n;\nvar component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__["default"])(\n  _App_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__["default"],\n  _App_vue_vue_type_template_id_152fd186___WEBPACK_IMPORTED_MODULE_0__.render,\n  _App_vue_vue_type_template_id_152fd186___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,\n  false,\n  null,\n  null,\n  null\n  \n)\n\n/* hot reload */\nif (false) { var api; }\ncomponent.options.__file = "assets/src/frontend/App.vue"\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (component.exports);\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/App.vue?')},"./assets/src/frontend/components/CustomerNote.vue":
/*!*********************************************************!*\
  !*** ./assets/src/frontend/components/CustomerNote.vue ***!
  \*********************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _CustomerNote_vue_vue_type_template_id_4073e2a5___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CustomerNote.vue?vue&type=template&id=4073e2a5& */ "./assets/src/frontend/components/CustomerNote.vue?vue&type=template&id=4073e2a5&");\n/* harmony import */ var _CustomerNote_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./CustomerNote.vue?vue&type=script&lang=js& */ "./assets/src/frontend/components/CustomerNote.vue?vue&type=script&lang=js&");\n/* harmony import */ var _CustomerNote_vue_vue_type_style_index_0_id_4073e2a5_lang_less___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CustomerNote.vue?vue&type=style&index=0&id=4073e2a5&lang=less& */ "./assets/src/frontend/components/CustomerNote.vue?vue&type=style&index=0&id=4073e2a5&lang=less&");\n/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");\n\n\n\n;\n\n\n/* normalize component */\n\nvar component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__["default"])(\n  _CustomerNote_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__["default"],\n  _CustomerNote_vue_vue_type_template_id_4073e2a5___WEBPACK_IMPORTED_MODULE_0__.render,\n  _CustomerNote_vue_vue_type_template_id_4073e2a5___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,\n  false,\n  null,\n  null,\n  null\n  \n)\n\n/* hot reload */\nif (false) { var api; }\ncomponent.options.__file = "assets/src/frontend/components/CustomerNote.vue"\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (component.exports);\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/CustomerNote.vue?')},"./assets/src/frontend/components/CustomerSearch.vue":
/*!***********************************************************!*\
  !*** ./assets/src/frontend/components/CustomerSearch.vue ***!
  \***********************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _CustomerSearch_vue_vue_type_template_id_414ef29b___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CustomerSearch.vue?vue&type=template&id=414ef29b& */ "./assets/src/frontend/components/CustomerSearch.vue?vue&type=template&id=414ef29b&");\n/* harmony import */ var _CustomerSearch_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./CustomerSearch.vue?vue&type=script&lang=js& */ "./assets/src/frontend/components/CustomerSearch.vue?vue&type=script&lang=js&");\n/* harmony import */ var _CustomerSearch_vue_vue_type_style_index_0_id_414ef29b_lang_less___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CustomerSearch.vue?vue&type=style&index=0&id=414ef29b&lang=less& */ "./assets/src/frontend/components/CustomerSearch.vue?vue&type=style&index=0&id=414ef29b&lang=less&");\n/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");\n\n\n\n;\n\n\n/* normalize component */\n\nvar component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__["default"])(\n  _CustomerSearch_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__["default"],\n  _CustomerSearch_vue_vue_type_template_id_414ef29b___WEBPACK_IMPORTED_MODULE_0__.render,\n  _CustomerSearch_vue_vue_type_template_id_414ef29b___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,\n  false,\n  null,\n  null,\n  null\n  \n)\n\n/* hot reload */\nif (false) { var api; }\ncomponent.options.__file = "assets/src/frontend/components/CustomerSearch.vue"\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (component.exports);\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/CustomerSearch.vue?')},"./assets/src/frontend/components/FeeKeypad.vue":
/*!******************************************************!*\
  !*** ./assets/src/frontend/components/FeeKeypad.vue ***!
  \******************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _FeeKeypad_vue_vue_type_template_id_0bc4dc95___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./FeeKeypad.vue?vue&type=template&id=0bc4dc95& */ "./assets/src/frontend/components/FeeKeypad.vue?vue&type=template&id=0bc4dc95&");\n/* harmony import */ var _FeeKeypad_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./FeeKeypad.vue?vue&type=script&lang=js& */ "./assets/src/frontend/components/FeeKeypad.vue?vue&type=script&lang=js&");\n/* harmony import */ var _FeeKeypad_vue_vue_type_style_index_0_id_0bc4dc95_lang_less___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./FeeKeypad.vue?vue&type=style&index=0&id=0bc4dc95&lang=less& */ "./assets/src/frontend/components/FeeKeypad.vue?vue&type=style&index=0&id=0bc4dc95&lang=less&");\n/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");\n\n\n\n;\n\n\n/* normalize component */\n\nvar component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__["default"])(\n  _FeeKeypad_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__["default"],\n  _FeeKeypad_vue_vue_type_template_id_0bc4dc95___WEBPACK_IMPORTED_MODULE_0__.render,\n  _FeeKeypad_vue_vue_type_template_id_0bc4dc95___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,\n  false,\n  null,\n  null,\n  null\n  \n)\n\n/* hot reload */\nif (false) { var api; }\ncomponent.options.__file = "assets/src/frontend/components/FeeKeypad.vue"\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (component.exports);\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/FeeKeypad.vue?')},"./assets/src/frontend/components/Home.vue":
/*!*************************************************!*\
  !*** ./assets/src/frontend/components/Home.vue ***!
  \*************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _Home_vue_vue_type_template_id_76253014___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Home.vue?vue&type=template&id=76253014& */ "./assets/src/frontend/components/Home.vue?vue&type=template&id=76253014&");\n/* harmony import */ var _Home_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Home.vue?vue&type=script&lang=js& */ "./assets/src/frontend/components/Home.vue?vue&type=script&lang=js&");\n/* harmony import */ var _Home_vue_vue_type_style_index_0_id_76253014_lang_less___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Home.vue?vue&type=style&index=0&id=76253014&lang=less& */ "./assets/src/frontend/components/Home.vue?vue&type=style&index=0&id=76253014&lang=less&");\n/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");\n\n\n\n;\n\n\n/* normalize component */\n\nvar component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__["default"])(\n  _Home_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__["default"],\n  _Home_vue_vue_type_template_id_76253014___WEBPACK_IMPORTED_MODULE_0__.render,\n  _Home_vue_vue_type_template_id_76253014___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,\n  false,\n  null,\n  null,\n  null\n  \n)\n\n/* hot reload */\nif (false) { var api; }\ncomponent.options.__file = "assets/src/frontend/components/Home.vue"\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (component.exports);\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/Home.vue?')},"./assets/src/frontend/components/Keyboard.vue":
/*!*****************************************************!*\
  !*** ./assets/src/frontend/components/Keyboard.vue ***!
  \*****************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _Keyboard_vue_vue_type_template_id_fbb6d6c8___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Keyboard.vue?vue&type=template&id=fbb6d6c8& */ "./assets/src/frontend/components/Keyboard.vue?vue&type=template&id=fbb6d6c8&");\n/* harmony import */ var _Keyboard_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Keyboard.vue?vue&type=script&lang=js& */ "./assets/src/frontend/components/Keyboard.vue?vue&type=script&lang=js&");\n/* harmony import */ var _Keyboard_vue_vue_type_style_index_0_id_fbb6d6c8_lang_less___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Keyboard.vue?vue&type=style&index=0&id=fbb6d6c8&lang=less& */ "./assets/src/frontend/components/Keyboard.vue?vue&type=style&index=0&id=fbb6d6c8&lang=less&");\n/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");\n\n\n\n;\n\n\n/* normalize component */\n\nvar component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__["default"])(\n  _Keyboard_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__["default"],\n  _Keyboard_vue_vue_type_template_id_fbb6d6c8___WEBPACK_IMPORTED_MODULE_0__.render,\n  _Keyboard_vue_vue_type_template_id_fbb6d6c8___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,\n  false,\n  null,\n  null,\n  null\n  \n)\n\n/* hot reload */\nif (false) { var api; }\ncomponent.options.__file = "assets/src/frontend/components/Keyboard.vue"\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (component.exports);\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/Keyboard.vue?')},"./assets/src/frontend/components/KeyboardControl.vue":
/*!************************************************************!*\
  !*** ./assets/src/frontend/components/KeyboardControl.vue ***!
  \************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _KeyboardControl_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./KeyboardControl.vue?vue&type=script&lang=js& */ "./assets/src/frontend/components/KeyboardControl.vue?vue&type=script&lang=js&");\n/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");\nvar render, staticRenderFns\n;\n\n\n\n/* normalize component */\n;\nvar component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_1__["default"])(\n  _KeyboardControl_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__["default"],\n  render,\n  staticRenderFns,\n  false,\n  null,\n  null,\n  null\n  \n)\n\n/* hot reload */\nif (false) { var api; }\ncomponent.options.__file = "assets/src/frontend/components/KeyboardControl.vue"\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (component.exports);\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/KeyboardControl.vue?')},"./assets/src/frontend/components/Overlay.vue":
/*!****************************************************!*\
  !*** ./assets/src/frontend/components/Overlay.vue ***!
  \****************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _Overlay_vue_vue_type_template_id_7b9b24aa___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Overlay.vue?vue&type=template&id=7b9b24aa& */ "./assets/src/frontend/components/Overlay.vue?vue&type=template&id=7b9b24aa&");\n/* harmony import */ var _Overlay_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Overlay.vue?vue&type=script&lang=js& */ "./assets/src/frontend/components/Overlay.vue?vue&type=script&lang=js&");\n/* harmony import */ var _Overlay_vue_vue_type_style_index_0_id_7b9b24aa_lang_css___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Overlay.vue?vue&type=style&index=0&id=7b9b24aa&lang=css& */ "./assets/src/frontend/components/Overlay.vue?vue&type=style&index=0&id=7b9b24aa&lang=css&");\n/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");\n\n\n\n;\n\n\n/* normalize component */\n\nvar component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__["default"])(\n  _Overlay_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__["default"],\n  _Overlay_vue_vue_type_template_id_7b9b24aa___WEBPACK_IMPORTED_MODULE_0__.render,\n  _Overlay_vue_vue_type_template_id_7b9b24aa___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,\n  false,\n  null,\n  null,\n  null\n  \n)\n\n/* hot reload */\nif (false) { var api; }\ncomponent.options.__file = "assets/src/frontend/components/Overlay.vue"\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (component.exports);\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/Overlay.vue?')},"./assets/src/frontend/components/PrintReceipt.vue":
/*!*********************************************************!*\
  !*** ./assets/src/frontend/components/PrintReceipt.vue ***!
  \*********************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _PrintReceipt_vue_vue_type_template_id_11ba6300___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./PrintReceipt.vue?vue&type=template&id=11ba6300& */ "./assets/src/frontend/components/PrintReceipt.vue?vue&type=template&id=11ba6300&");\n/* harmony import */ var _PrintReceipt_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./PrintReceipt.vue?vue&type=script&lang=js& */ "./assets/src/frontend/components/PrintReceipt.vue?vue&type=script&lang=js&");\n/* harmony import */ var _PrintReceipt_vue_vue_type_style_index_0_id_11ba6300_lang_less___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./PrintReceipt.vue?vue&type=style&index=0&id=11ba6300&lang=less& */ "./assets/src/frontend/components/PrintReceipt.vue?vue&type=style&index=0&id=11ba6300&lang=less&");\n/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");\n\n\n\n;\n\n\n/* normalize component */\n\nvar component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__["default"])(\n  _PrintReceipt_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__["default"],\n  _PrintReceipt_vue_vue_type_template_id_11ba6300___WEBPACK_IMPORTED_MODULE_0__.render,\n  _PrintReceipt_vue_vue_type_template_id_11ba6300___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,\n  false,\n  null,\n  null,\n  null\n  \n)\n\n/* hot reload */\nif (false) { var api; }\ncomponent.options.__file = "assets/src/frontend/components/PrintReceipt.vue"\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (component.exports);\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/PrintReceipt.vue?')},"./assets/src/frontend/components/PrintReceiptHtml.vue":
/*!*************************************************************!*\
  !*** ./assets/src/frontend/components/PrintReceiptHtml.vue ***!
  \*************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _PrintReceiptHtml_vue_vue_type_template_id_2db58d4b___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./PrintReceiptHtml.vue?vue&type=template&id=2db58d4b& */ "./assets/src/frontend/components/PrintReceiptHtml.vue?vue&type=template&id=2db58d4b&");\n/* harmony import */ var _PrintReceiptHtml_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./PrintReceiptHtml.vue?vue&type=script&lang=js& */ "./assets/src/frontend/components/PrintReceiptHtml.vue?vue&type=script&lang=js&");\n/* harmony import */ var _PrintReceiptHtml_vue_vue_type_style_index_0_id_2db58d4b_lang_less___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./PrintReceiptHtml.vue?vue&type=style&index=0&id=2db58d4b&lang=less& */ "./assets/src/frontend/components/PrintReceiptHtml.vue?vue&type=style&index=0&id=2db58d4b&lang=less&");\n/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");\n\n\n\n;\n\n\n/* normalize component */\n\nvar component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__["default"])(\n  _PrintReceiptHtml_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__["default"],\n  _PrintReceiptHtml_vue_vue_type_template_id_2db58d4b___WEBPACK_IMPORTED_MODULE_0__.render,\n  _PrintReceiptHtml_vue_vue_type_template_id_2db58d4b___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,\n  false,\n  null,\n  null,\n  null\n  \n)\n\n/* hot reload */\nif (false) { var api; }\ncomponent.options.__file = "assets/src/frontend/components/PrintReceiptHtml.vue"\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (component.exports);\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/PrintReceiptHtml.vue?')},"./assets/src/frontend/components/ProductSearch.vue":
/*!**********************************************************!*\
  !*** ./assets/src/frontend/components/ProductSearch.vue ***!
  \**********************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _ProductSearch_vue_vue_type_template_id_64fc4f12___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ProductSearch.vue?vue&type=template&id=64fc4f12& */ "./assets/src/frontend/components/ProductSearch.vue?vue&type=template&id=64fc4f12&");\n/* harmony import */ var _ProductSearch_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ProductSearch.vue?vue&type=script&lang=js& */ "./assets/src/frontend/components/ProductSearch.vue?vue&type=script&lang=js&");\n/* harmony import */ var _ProductSearch_vue_vue_type_style_index_0_id_64fc4f12_lang_less___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ProductSearch.vue?vue&type=style&index=0&id=64fc4f12&lang=less& */ "./assets/src/frontend/components/ProductSearch.vue?vue&type=style&index=0&id=64fc4f12&lang=less&");\n/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");\n\n\n\n;\n\n\n/* normalize component */\n\nvar component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__["default"])(\n  _ProductSearch_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__["default"],\n  _ProductSearch_vue_vue_type_template_id_64fc4f12___WEBPACK_IMPORTED_MODULE_0__.render,\n  _ProductSearch_vue_vue_type_template_id_64fc4f12___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,\n  false,\n  null,\n  null,\n  null\n  \n)\n\n/* hot reload */\nif (false) { var api; }\ncomponent.options.__file = "assets/src/frontend/components/ProductSearch.vue"\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (component.exports);\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/ProductSearch.vue?')},"./assets/src/frontend/App.vue?vue&type=script&lang=js&":
/*!**************************************************************!*\
  !*** ./assets/src/frontend/App.vue?vue&type=script&lang=js& ***!
  \**************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_App_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../node_modules/babel-loader/lib/index.js!../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./App.vue?vue&type=script&lang=js& */ "./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/App.vue?vue&type=script&lang=js&");\n /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_App_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__["default"]); \n\n//# sourceURL=webpack://wepos/./assets/src/frontend/App.vue?')},"./assets/src/frontend/components/CustomerNote.vue?vue&type=script&lang=js&":
/*!**********************************************************************************!*\
  !*** ./assets/src/frontend/components/CustomerNote.vue?vue&type=script&lang=js& ***!
  \**********************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_CustomerNote_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/babel-loader/lib/index.js!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./CustomerNote.vue?vue&type=script&lang=js& */ "./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/CustomerNote.vue?vue&type=script&lang=js&");\n /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_CustomerNote_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__["default"]); \n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/CustomerNote.vue?')},"./assets/src/frontend/components/CustomerSearch.vue?vue&type=script&lang=js&":
/*!************************************************************************************!*\
  !*** ./assets/src/frontend/components/CustomerSearch.vue?vue&type=script&lang=js& ***!
  \************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_CustomerSearch_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/babel-loader/lib/index.js!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./CustomerSearch.vue?vue&type=script&lang=js& */ "./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/CustomerSearch.vue?vue&type=script&lang=js&");\n /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_CustomerSearch_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__["default"]); \n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/CustomerSearch.vue?')},"./assets/src/frontend/components/FeeKeypad.vue?vue&type=script&lang=js&":
/*!*******************************************************************************!*\
  !*** ./assets/src/frontend/components/FeeKeypad.vue?vue&type=script&lang=js& ***!
  \*******************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_FeeKeypad_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/babel-loader/lib/index.js!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./FeeKeypad.vue?vue&type=script&lang=js& */ "./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/FeeKeypad.vue?vue&type=script&lang=js&");\n /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_FeeKeypad_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__["default"]); \n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/FeeKeypad.vue?')},"./assets/src/frontend/components/Home.vue?vue&type=script&lang=js&":
/*!**************************************************************************!*\
  !*** ./assets/src/frontend/components/Home.vue?vue&type=script&lang=js& ***!
  \**************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Home_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/babel-loader/lib/index.js!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./Home.vue?vue&type=script&lang=js& */ "./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/Home.vue?vue&type=script&lang=js&");\n /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Home_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__["default"]); \n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/Home.vue?')},"./assets/src/frontend/components/Keyboard.vue?vue&type=script&lang=js&":
/*!******************************************************************************!*\
  !*** ./assets/src/frontend/components/Keyboard.vue?vue&type=script&lang=js& ***!
  \******************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Keyboard_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/babel-loader/lib/index.js!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./Keyboard.vue?vue&type=script&lang=js& */ "./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/Keyboard.vue?vue&type=script&lang=js&");\n /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Keyboard_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__["default"]); \n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/Keyboard.vue?')},"./assets/src/frontend/components/KeyboardControl.vue?vue&type=script&lang=js&":
/*!*************************************************************************************!*\
  !*** ./assets/src/frontend/components/KeyboardControl.vue?vue&type=script&lang=js& ***!
  \*************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_KeyboardControl_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/babel-loader/lib/index.js!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./KeyboardControl.vue?vue&type=script&lang=js& */ "./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/KeyboardControl.vue?vue&type=script&lang=js&");\n /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_KeyboardControl_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__["default"]); \n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/KeyboardControl.vue?')},"./assets/src/frontend/components/Overlay.vue?vue&type=script&lang=js&":
/*!*****************************************************************************!*\
  !*** ./assets/src/frontend/components/Overlay.vue?vue&type=script&lang=js& ***!
  \*****************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Overlay_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/babel-loader/lib/index.js!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./Overlay.vue?vue&type=script&lang=js& */ "./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/Overlay.vue?vue&type=script&lang=js&");\n /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Overlay_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__["default"]); \n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/Overlay.vue?')},"./assets/src/frontend/components/PrintReceipt.vue?vue&type=script&lang=js&":
/*!**********************************************************************************!*\
  !*** ./assets/src/frontend/components/PrintReceipt.vue?vue&type=script&lang=js& ***!
  \**********************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_PrintReceipt_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/babel-loader/lib/index.js!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./PrintReceipt.vue?vue&type=script&lang=js& */ "./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/PrintReceipt.vue?vue&type=script&lang=js&");\n /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_PrintReceipt_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__["default"]); \n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/PrintReceipt.vue?')},"./assets/src/frontend/components/PrintReceiptHtml.vue?vue&type=script&lang=js&":
/*!**************************************************************************************!*\
  !*** ./assets/src/frontend/components/PrintReceiptHtml.vue?vue&type=script&lang=js& ***!
  \**************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_PrintReceiptHtml_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/babel-loader/lib/index.js!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./PrintReceiptHtml.vue?vue&type=script&lang=js& */ "./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/PrintReceiptHtml.vue?vue&type=script&lang=js&");\n /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_PrintReceiptHtml_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__["default"]); \n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/PrintReceiptHtml.vue?')},"./assets/src/frontend/components/ProductSearch.vue?vue&type=script&lang=js&":
/*!***********************************************************************************!*\
  !*** ./assets/src/frontend/components/ProductSearch.vue?vue&type=script&lang=js& ***!
  \***********************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_ProductSearch_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/babel-loader/lib/index.js!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./ProductSearch.vue?vue&type=script&lang=js& */ "./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/ProductSearch.vue?vue&type=script&lang=js&");\n /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_ProductSearch_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__["default"]); \n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/ProductSearch.vue?')},"./assets/src/frontend/App.vue?vue&type=template&id=152fd186&":
/*!********************************************************************!*\
  !*** ./assets/src/frontend/App.vue?vue&type=template&id=152fd186& ***!
  \********************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "render": () => (/* reexport safe */ _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_App_vue_vue_type_template_id_152fd186___WEBPACK_IMPORTED_MODULE_0__.render),\n/* harmony export */   "staticRenderFns": () => (/* reexport safe */ _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_App_vue_vue_type_template_id_152fd186___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns)\n/* harmony export */ });\n/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_App_vue_vue_type_template_id_152fd186___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../node_modules/babel-loader/lib/index.js!../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./App.vue?vue&type=template&id=152fd186& */ "./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/App.vue?vue&type=template&id=152fd186&");\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/App.vue?')},"./assets/src/frontend/components/CustomerNote.vue?vue&type=template&id=4073e2a5&":
/*!****************************************************************************************!*\
  !*** ./assets/src/frontend/components/CustomerNote.vue?vue&type=template&id=4073e2a5& ***!
  \****************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "render": () => (/* reexport safe */ _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_CustomerNote_vue_vue_type_template_id_4073e2a5___WEBPACK_IMPORTED_MODULE_0__.render),\n/* harmony export */   "staticRenderFns": () => (/* reexport safe */ _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_CustomerNote_vue_vue_type_template_id_4073e2a5___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns)\n/* harmony export */ });\n/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_CustomerNote_vue_vue_type_template_id_4073e2a5___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/babel-loader/lib/index.js!../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./CustomerNote.vue?vue&type=template&id=4073e2a5& */ "./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/CustomerNote.vue?vue&type=template&id=4073e2a5&");\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/CustomerNote.vue?')},"./assets/src/frontend/components/CustomerSearch.vue?vue&type=template&id=414ef29b&":
/*!******************************************************************************************!*\
  !*** ./assets/src/frontend/components/CustomerSearch.vue?vue&type=template&id=414ef29b& ***!
  \******************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "render": () => (/* reexport safe */ _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_CustomerSearch_vue_vue_type_template_id_414ef29b___WEBPACK_IMPORTED_MODULE_0__.render),\n/* harmony export */   "staticRenderFns": () => (/* reexport safe */ _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_CustomerSearch_vue_vue_type_template_id_414ef29b___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns)\n/* harmony export */ });\n/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_CustomerSearch_vue_vue_type_template_id_414ef29b___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/babel-loader/lib/index.js!../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./CustomerSearch.vue?vue&type=template&id=414ef29b& */ "./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/CustomerSearch.vue?vue&type=template&id=414ef29b&");\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/CustomerSearch.vue?')},"./assets/src/frontend/components/FeeKeypad.vue?vue&type=template&id=0bc4dc95&":
/*!*************************************************************************************!*\
  !*** ./assets/src/frontend/components/FeeKeypad.vue?vue&type=template&id=0bc4dc95& ***!
  \*************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "render": () => (/* reexport safe */ _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_FeeKeypad_vue_vue_type_template_id_0bc4dc95___WEBPACK_IMPORTED_MODULE_0__.render),\n/* harmony export */   "staticRenderFns": () => (/* reexport safe */ _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_FeeKeypad_vue_vue_type_template_id_0bc4dc95___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns)\n/* harmony export */ });\n/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_FeeKeypad_vue_vue_type_template_id_0bc4dc95___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/babel-loader/lib/index.js!../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./FeeKeypad.vue?vue&type=template&id=0bc4dc95& */ "./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/FeeKeypad.vue?vue&type=template&id=0bc4dc95&");\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/FeeKeypad.vue?')},"./assets/src/frontend/components/Home.vue?vue&type=template&id=76253014&":
/*!********************************************************************************!*\
  !*** ./assets/src/frontend/components/Home.vue?vue&type=template&id=76253014& ***!
  \********************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "render": () => (/* reexport safe */ _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_Home_vue_vue_type_template_id_76253014___WEBPACK_IMPORTED_MODULE_0__.render),\n/* harmony export */   "staticRenderFns": () => (/* reexport safe */ _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_Home_vue_vue_type_template_id_76253014___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns)\n/* harmony export */ });\n/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_Home_vue_vue_type_template_id_76253014___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/babel-loader/lib/index.js!../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./Home.vue?vue&type=template&id=76253014& */ "./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/Home.vue?vue&type=template&id=76253014&");\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/Home.vue?')},"./assets/src/frontend/components/Keyboard.vue?vue&type=template&id=fbb6d6c8&":
/*!************************************************************************************!*\
  !*** ./assets/src/frontend/components/Keyboard.vue?vue&type=template&id=fbb6d6c8& ***!
  \************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "render": () => (/* reexport safe */ _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_Keyboard_vue_vue_type_template_id_fbb6d6c8___WEBPACK_IMPORTED_MODULE_0__.render),\n/* harmony export */   "staticRenderFns": () => (/* reexport safe */ _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_Keyboard_vue_vue_type_template_id_fbb6d6c8___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns)\n/* harmony export */ });\n/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_Keyboard_vue_vue_type_template_id_fbb6d6c8___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/babel-loader/lib/index.js!../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./Keyboard.vue?vue&type=template&id=fbb6d6c8& */ "./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/Keyboard.vue?vue&type=template&id=fbb6d6c8&");\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/Keyboard.vue?')},"./assets/src/frontend/components/Overlay.vue?vue&type=template&id=7b9b24aa&":
/*!***********************************************************************************!*\
  !*** ./assets/src/frontend/components/Overlay.vue?vue&type=template&id=7b9b24aa& ***!
  \***********************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "render": () => (/* reexport safe */ _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_Overlay_vue_vue_type_template_id_7b9b24aa___WEBPACK_IMPORTED_MODULE_0__.render),\n/* harmony export */   "staticRenderFns": () => (/* reexport safe */ _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_Overlay_vue_vue_type_template_id_7b9b24aa___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns)\n/* harmony export */ });\n/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_Overlay_vue_vue_type_template_id_7b9b24aa___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/babel-loader/lib/index.js!../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./Overlay.vue?vue&type=template&id=7b9b24aa& */ "./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/Overlay.vue?vue&type=template&id=7b9b24aa&");\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/Overlay.vue?')},"./assets/src/frontend/components/PrintReceipt.vue?vue&type=template&id=11ba6300&":
/*!****************************************************************************************!*\
  !*** ./assets/src/frontend/components/PrintReceipt.vue?vue&type=template&id=11ba6300& ***!
  \****************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "render": () => (/* reexport safe */ _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_PrintReceipt_vue_vue_type_template_id_11ba6300___WEBPACK_IMPORTED_MODULE_0__.render),\n/* harmony export */   "staticRenderFns": () => (/* reexport safe */ _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_PrintReceipt_vue_vue_type_template_id_11ba6300___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns)\n/* harmony export */ });\n/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_PrintReceipt_vue_vue_type_template_id_11ba6300___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/babel-loader/lib/index.js!../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./PrintReceipt.vue?vue&type=template&id=11ba6300& */ "./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/PrintReceipt.vue?vue&type=template&id=11ba6300&");\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/PrintReceipt.vue?')},"./assets/src/frontend/components/PrintReceiptHtml.vue?vue&type=template&id=2db58d4b&":
/*!********************************************************************************************!*\
  !*** ./assets/src/frontend/components/PrintReceiptHtml.vue?vue&type=template&id=2db58d4b& ***!
  \********************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "render": () => (/* reexport safe */ _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_PrintReceiptHtml_vue_vue_type_template_id_2db58d4b___WEBPACK_IMPORTED_MODULE_0__.render),\n/* harmony export */   "staticRenderFns": () => (/* reexport safe */ _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_PrintReceiptHtml_vue_vue_type_template_id_2db58d4b___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns)\n/* harmony export */ });\n/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_PrintReceiptHtml_vue_vue_type_template_id_2db58d4b___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/babel-loader/lib/index.js!../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./PrintReceiptHtml.vue?vue&type=template&id=2db58d4b& */ "./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/PrintReceiptHtml.vue?vue&type=template&id=2db58d4b&");\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/PrintReceiptHtml.vue?')},"./assets/src/frontend/components/ProductSearch.vue?vue&type=template&id=64fc4f12&":
/*!*****************************************************************************************!*\
  !*** ./assets/src/frontend/components/ProductSearch.vue?vue&type=template&id=64fc4f12& ***!
  \*****************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "render": () => (/* reexport safe */ _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_ProductSearch_vue_vue_type_template_id_64fc4f12___WEBPACK_IMPORTED_MODULE_0__.render),\n/* harmony export */   "staticRenderFns": () => (/* reexport safe */ _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_ProductSearch_vue_vue_type_template_id_64fc4f12___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns)\n/* harmony export */ });\n/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_ProductSearch_vue_vue_type_template_id_64fc4f12___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/babel-loader/lib/index.js!../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./ProductSearch.vue?vue&type=template&id=64fc4f12& */ "./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/ProductSearch.vue?vue&type=template&id=64fc4f12&");\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/ProductSearch.vue?')},"./assets/src/frontend/components/CustomerNote.vue?vue&type=style&index=0&id=4073e2a5&lang=less&":
/*!*******************************************************************************************************!*\
  !*** ./assets/src/frontend/components/CustomerNote.vue?vue&type=style&index=0&id=4073e2a5&lang=less& ***!
  \*******************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _node_modules_mini_css_extract_plugin_dist_loader_js_node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_less_loader_dist_cjs_js_node_modules_vue_loader_lib_index_js_vue_loader_options_CustomerNote_vue_vue_type_style_index_0_id_4073e2a5_lang_less___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/mini-css-extract-plugin/dist/loader.js!../../../../node_modules/css-loader/dist/cjs.js!../../../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../../../node_modules/less-loader/dist/cjs.js!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./CustomerNote.vue?vue&type=style&index=0&id=4073e2a5&lang=less& */ "./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/CustomerNote.vue?vue&type=style&index=0&id=4073e2a5&lang=less&");\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/CustomerNote.vue?')},"./assets/src/frontend/components/CustomerSearch.vue?vue&type=style&index=0&id=414ef29b&lang=less&":
/*!*********************************************************************************************************!*\
  !*** ./assets/src/frontend/components/CustomerSearch.vue?vue&type=style&index=0&id=414ef29b&lang=less& ***!
  \*********************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _node_modules_mini_css_extract_plugin_dist_loader_js_node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_less_loader_dist_cjs_js_node_modules_vue_loader_lib_index_js_vue_loader_options_CustomerSearch_vue_vue_type_style_index_0_id_414ef29b_lang_less___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/mini-css-extract-plugin/dist/loader.js!../../../../node_modules/css-loader/dist/cjs.js!../../../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../../../node_modules/less-loader/dist/cjs.js!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./CustomerSearch.vue?vue&type=style&index=0&id=414ef29b&lang=less& */ "./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/CustomerSearch.vue?vue&type=style&index=0&id=414ef29b&lang=less&");\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/CustomerSearch.vue?')},"./assets/src/frontend/components/FeeKeypad.vue?vue&type=style&index=0&id=0bc4dc95&lang=less&":
/*!****************************************************************************************************!*\
  !*** ./assets/src/frontend/components/FeeKeypad.vue?vue&type=style&index=0&id=0bc4dc95&lang=less& ***!
  \****************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _node_modules_mini_css_extract_plugin_dist_loader_js_node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_less_loader_dist_cjs_js_node_modules_vue_loader_lib_index_js_vue_loader_options_FeeKeypad_vue_vue_type_style_index_0_id_0bc4dc95_lang_less___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/mini-css-extract-plugin/dist/loader.js!../../../../node_modules/css-loader/dist/cjs.js!../../../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../../../node_modules/less-loader/dist/cjs.js!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./FeeKeypad.vue?vue&type=style&index=0&id=0bc4dc95&lang=less& */ "./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/FeeKeypad.vue?vue&type=style&index=0&id=0bc4dc95&lang=less&");\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/FeeKeypad.vue?')},"./assets/src/frontend/components/Home.vue?vue&type=style&index=0&id=76253014&lang=less&":
/*!***********************************************************************************************!*\
  !*** ./assets/src/frontend/components/Home.vue?vue&type=style&index=0&id=76253014&lang=less& ***!
  \***********************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _node_modules_mini_css_extract_plugin_dist_loader_js_node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_less_loader_dist_cjs_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Home_vue_vue_type_style_index_0_id_76253014_lang_less___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/mini-css-extract-plugin/dist/loader.js!../../../../node_modules/css-loader/dist/cjs.js!../../../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../../../node_modules/less-loader/dist/cjs.js!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./Home.vue?vue&type=style&index=0&id=76253014&lang=less& */ "./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/Home.vue?vue&type=style&index=0&id=76253014&lang=less&");\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/Home.vue?')},"./assets/src/frontend/components/Keyboard.vue?vue&type=style&index=0&id=fbb6d6c8&lang=less&":
/*!***************************************************************************************************!*\
  !*** ./assets/src/frontend/components/Keyboard.vue?vue&type=style&index=0&id=fbb6d6c8&lang=less& ***!
  \***************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _node_modules_mini_css_extract_plugin_dist_loader_js_node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_less_loader_dist_cjs_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Keyboard_vue_vue_type_style_index_0_id_fbb6d6c8_lang_less___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/mini-css-extract-plugin/dist/loader.js!../../../../node_modules/css-loader/dist/cjs.js!../../../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../../../node_modules/less-loader/dist/cjs.js!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./Keyboard.vue?vue&type=style&index=0&id=fbb6d6c8&lang=less& */ "./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/Keyboard.vue?vue&type=style&index=0&id=fbb6d6c8&lang=less&");\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/Keyboard.vue?')},"./assets/src/frontend/components/Overlay.vue?vue&type=style&index=0&id=7b9b24aa&lang=css&":
/*!*************************************************************************************************!*\
  !*** ./assets/src/frontend/components/Overlay.vue?vue&type=style&index=0&id=7b9b24aa&lang=css& ***!
  \*************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _node_modules_mini_css_extract_plugin_dist_loader_js_node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_less_loader_dist_cjs_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Overlay_vue_vue_type_style_index_0_id_7b9b24aa_lang_css___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/mini-css-extract-plugin/dist/loader.js!../../../../node_modules/css-loader/dist/cjs.js!../../../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../../../node_modules/less-loader/dist/cjs.js!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./Overlay.vue?vue&type=style&index=0&id=7b9b24aa&lang=css& */ "./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/Overlay.vue?vue&type=style&index=0&id=7b9b24aa&lang=css&");\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/Overlay.vue?')},"./assets/src/frontend/components/PrintReceipt.vue?vue&type=style&index=0&id=11ba6300&lang=less&":
/*!*******************************************************************************************************!*\
  !*** ./assets/src/frontend/components/PrintReceipt.vue?vue&type=style&index=0&id=11ba6300&lang=less& ***!
  \*******************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _node_modules_mini_css_extract_plugin_dist_loader_js_node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_less_loader_dist_cjs_js_node_modules_vue_loader_lib_index_js_vue_loader_options_PrintReceipt_vue_vue_type_style_index_0_id_11ba6300_lang_less___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/mini-css-extract-plugin/dist/loader.js!../../../../node_modules/css-loader/dist/cjs.js!../../../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../../../node_modules/less-loader/dist/cjs.js!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./PrintReceipt.vue?vue&type=style&index=0&id=11ba6300&lang=less& */ "./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/PrintReceipt.vue?vue&type=style&index=0&id=11ba6300&lang=less&");\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/PrintReceipt.vue?')},"./assets/src/frontend/components/PrintReceiptHtml.vue?vue&type=style&index=0&id=2db58d4b&lang=less&":
/*!***********************************************************************************************************!*\
  !*** ./assets/src/frontend/components/PrintReceiptHtml.vue?vue&type=style&index=0&id=2db58d4b&lang=less& ***!
  \***********************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _node_modules_mini_css_extract_plugin_dist_loader_js_node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_less_loader_dist_cjs_js_node_modules_vue_loader_lib_index_js_vue_loader_options_PrintReceiptHtml_vue_vue_type_style_index_0_id_2db58d4b_lang_less___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/mini-css-extract-plugin/dist/loader.js!../../../../node_modules/css-loader/dist/cjs.js!../../../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../../../node_modules/less-loader/dist/cjs.js!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./PrintReceiptHtml.vue?vue&type=style&index=0&id=2db58d4b&lang=less& */ "./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/PrintReceiptHtml.vue?vue&type=style&index=0&id=2db58d4b&lang=less&");\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/PrintReceiptHtml.vue?')},"./assets/src/frontend/components/ProductSearch.vue?vue&type=style&index=0&id=64fc4f12&lang=less&":
/*!********************************************************************************************************!*\
  !*** ./assets/src/frontend/components/ProductSearch.vue?vue&type=style&index=0&id=64fc4f12&lang=less& ***!
  \********************************************************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _node_modules_mini_css_extract_plugin_dist_loader_js_node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_less_loader_dist_cjs_js_node_modules_vue_loader_lib_index_js_vue_loader_options_ProductSearch_vue_vue_type_style_index_0_id_64fc4f12_lang_less___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/mini-css-extract-plugin/dist/loader.js!../../../../node_modules/css-loader/dist/cjs.js!../../../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../../../node_modules/less-loader/dist/cjs.js!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./ProductSearch.vue?vue&type=style&index=0&id=64fc4f12&lang=less& */ "./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/less-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./assets/src/frontend/components/ProductSearch.vue?vue&type=style&index=0&id=64fc4f12&lang=less&");\n\n\n//# sourceURL=webpack://wepos/./assets/src/frontend/components/ProductSearch.vue?')},"./node_modules/vue-loader/lib/runtime/componentNormalizer.js":
/*!********************************************************************!*\
  !*** ./node_modules/vue-loader/lib/runtime/componentNormalizer.js ***!
  \********************************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ normalizeComponent)\n/* harmony export */ });\n/* globals __VUE_SSR_CONTEXT__ */\n\n// IMPORTANT: Do NOT use ES2015 features in this file (except for modules).\n// This module is a runtime utility for cleaner component module output and will\n// be included in the final webpack user bundle.\n\nfunction normalizeComponent(\n  scriptExports,\n  render,\n  staticRenderFns,\n  functionalTemplate,\n  injectStyles,\n  scopeId,\n  moduleIdentifier /* server only */,\n  shadowMode /* vue-cli only */\n) {\n  // Vue.extend constructor export interop\n  var options =\n    typeof scriptExports === 'function' ? scriptExports.options : scriptExports\n\n  // render functions\n  if (render) {\n    options.render = render\n    options.staticRenderFns = staticRenderFns\n    options._compiled = true\n  }\n\n  // functional template\n  if (functionalTemplate) {\n    options.functional = true\n  }\n\n  // scopedId\n  if (scopeId) {\n    options._scopeId = 'data-v-' + scopeId\n  }\n\n  var hook\n  if (moduleIdentifier) {\n    // server build\n    hook = function (context) {\n      // 2.3 injection\n      context =\n        context || // cached call\n        (this.$vnode && this.$vnode.ssrContext) || // stateful\n        (this.parent && this.parent.$vnode && this.parent.$vnode.ssrContext) // functional\n      // 2.2 with runInNewContext: true\n      if (!context && typeof __VUE_SSR_CONTEXT__ !== 'undefined') {\n        context = __VUE_SSR_CONTEXT__\n      }\n      // inject component styles\n      if (injectStyles) {\n        injectStyles.call(this, context)\n      }\n      // register component module identifier for async chunk inferrence\n      if (context && context._registeredComponents) {\n        context._registeredComponents.add(moduleIdentifier)\n      }\n    }\n    // used by ssr in case component is cached and beforeCreate\n    // never gets called\n    options._ssrRegister = hook\n  } else if (injectStyles) {\n    hook = shadowMode\n      ? function () {\n          injectStyles.call(\n            this,\n            (options.functional ? this.parent : this).$root.$options.shadowRoot\n          )\n        }\n      : injectStyles\n  }\n\n  if (hook) {\n    if (options.functional) {\n      // for template-only hot-reload because in that case the render fn doesn't\n      // go through the normalizer\n      options._injectStyles = hook\n      // register for functional component in vue file\n      var originalRender = options.render\n      options.render = function renderWithStyleInjection(h, context) {\n        hook.call(context)\n        return originalRender(h, context)\n      }\n    } else {\n      // inject component registration as beforeCreate hook\n      var existing = options.beforeCreate\n      options.beforeCreate = existing ? [].concat(existing, hook) : [hook]\n    }\n  }\n\n  return {\n    exports: scriptExports,\n    options: options\n  }\n}\n\n\n//# sourceURL=webpack://wepos/./node_modules/vue-loader/lib/runtime/componentNormalizer.js?")},"./node_modules/vue-mugen-scroll/dist/vue-mugen-scroll.common.js":
/*!***********************************************************************!*\
  !*** ./node_modules/vue-mugen-scroll/dist/vue-mugen-scroll.common.js ***!
  \***********************************************************************/(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nfunction _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }\n\nvar throttle = _interopDefault(__webpack_require__(/*! throttleit */ \"./node_modules/throttleit/index.js\"));\nvar inViewport = _interopDefault(__webpack_require__(/*! element-in-view */ \"./node_modules/element-in-view/dist/element-in-view.common.js\"));\n\nvar triggers = ['scroll', 'resize'];\n\nvar MugenScroll = {\n  name: 'mugen-scroll',\n  props: {\n    handler: {\n      type: Function,\n      required: true\n    },\n    shouldHandle: {\n      type: Boolean,\n      default: true\n    },\n    threshold: {\n      type: Number,\n      default: 0\n    },\n    handleOnMount: {\n      type: Boolean,\n      default: true\n    },\n    scrollContainer: {\n      type: String\n    }\n  },\n  mounted: function mounted() {\n    this.checkInView();\n  },\n  methods: {\n    checkInView: function checkInView() {\n      var this$1 = this;\n\n      var execute = function () {\n        // The element can be removed\n        if (!this$1.$refs.scroll) {\n          return\n        }\n\n        var inView = inViewport(this$1.$refs.scroll, {\n          threshold: this$1.threshold\n        });\n        if (this$1.shouldHandle && inView) {\n          this$1.handler();\n        }\n      };\n\n      // checkInView right after this component is mounted\n      if (this.handleOnMount) {\n        execute();\n      }\n\n      if (this.scrollContainer) {\n        var parent = this;\n        while ((parent = parent.$parent) && !this._scrollContainer) {\n          this$1._scrollContainer = parent.$refs[this$1.scrollContainer];\n        }\n        // Ensure it's html element (ref could be component)\n        if (this._scrollContainer && this._scrollContainer.$el) {\n          this._scrollContainer = this._scrollContainer.$el;\n        }\n      }\n\n      this._scrollContainer = this._scrollContainer || window;\n\n      // Add event listeners\n      this.check = throttle(execute, 200);\n      triggers.forEach(function (event) { return this$1._scrollContainer.addEventListener(event, this$1.check); });\n    }\n  },\n  render: function render(h) {\n    return h('div', {\n      staticClass: 'mugen-scroll',\n      ref: 'scroll'\n    }, this.$slots.default)\n  },\n  beforeDestroy: function beforeDestroy() {\n    var this$1 = this;\n\n    triggers.forEach(function (event) { return this$1._scrollContainer.removeEventListener(event, this$1.check); });\n  }\n};\n\nif (typeof window !== 'undefined' && window.Vue) {\n  window.Vue.component(MugenScroll.name, MugenScroll);\n}\n\nmodule.exports = MugenScroll;\n\n\n//# sourceURL=webpack://wepos/./node_modules/vue-mugen-scroll/dist/vue-mugen-scroll.common.js?")}},__webpack_module_cache__={};function __webpack_require__(e){var n=__webpack_module_cache__[e];if(void 0!==n)return n.exports;var t=__webpack_module_cache__[e]={exports:{}};return __webpack_modules__[e](t,t.exports,__webpack_require__),t.exports}__webpack_require__.n=e=>{var n=e&&e.__esModule?()=>e.default:()=>e;return __webpack_require__.d(n,{a:n}),n},__webpack_require__.d=(e,n)=>{for(var t in n)__webpack_require__.o(n,t)&&!__webpack_require__.o(e,t)&&Object.defineProperty(e,t,{enumerable:!0,get:n[t]})},__webpack_require__.o=(e,n)=>Object.prototype.hasOwnProperty.call(e,n),__webpack_require__.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})};var __webpack_exports__=__webpack_require__("./assets/src/frontend/main.js")})();