var el = wp.element.createElement,
    registerBlockType = wp.blocks.registerBlockType,
    BlockControls = wp.editor.BlockControls;

if ( tc_event_sponsors_logo_block_editor.since_611 ) {
    var InspectorControls = wp.blockEditor.InspectorControls,
        ServerSideRender = wp.serverSideRender;

} else {
    var InspectorControls = wp.editor.InspectorControls,
        ServerSideRender = wp.components.ServerSideRender;
}

var AlignmentToolbar = wp.editor.AlignmentToolbar,
    RichText = wp.editor.RichText,
    SelectControl = wp.components.SelectControl,
    RangeControl = wp.components.RangeControl,
    TextControl = wp.components.TextControl,
    ToggleControl = wp.components.ToggleControl;

var __ = wp.i18n.__;

registerBlockType( 'tickera/event-sponsors-logo', {
    title: __( 'Event Sponsors Logo' ),
    description: __( 'Shows sponsors image / logo of an event' ),
    icon: 'format-image',
    category: 'widgets',
    keywords: [
        __( 'Tickera' ),
        __( 'Sponsors' ),
        __( 'Logo' )
    ],
    supports: {
        html: false
    },
    attributes: {
        event_id: {
            type: 'string',
        },
    },
    edit: function( props ) {

        var events = jQuery.parseJSON( tc_event_sponsors_logo_block_editor.events ),
            event_ids = [];

        events.forEach( function( entry ) {
            event_ids.push( { value: entry[ 0 ], label: entry[ 1 ] } );
        } );

        return [
            el(
                InspectorControls,
                { key: 'controls' },
                el(
                    SelectControl,
                    {
                        label: __( 'Event' ),
                        className: 'tc-gb-component',
                        value: props.attributes.event_id,
                        onChange: function change_val( value ) {
                            return props.setAttributes( { event_id: value } );
                        },
                        options: event_ids
                    }
                ),
            ),
            el( ServerSideRender, {
                block: "tickera/event-sponsors-logo",
                attributes: props.attributes
            } )

        ];
    },
    save: function( props ) {
        return null;
    },
} );
