<?php
global $tc;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( isset( $_POST[ 'tc_delete_selected_data_permanently' ] ) && current_user_can( 'manage_options' ) ) {

    if ( check_admin_referer( 'delete_info' ) && isset( $_POST[ 'tc_delete_plugin_data' ] ) ) {

        ini_set( 'max_input_time', 0 );
        ini_set( 'max_execution_time', 0 );
        set_time_limit( 0 );
        @ini_set( 'memory_limit', '1024M' );

        do_action( 'tc_delete_plugins_data', tc_sanitize_array2( $_POST[ 'tc_delete_plugin_data' ] ) );
        $message = __( 'All selected data has been permanently deleted successfully.', 'tc' );
    }
}

$tickera_plugins_and_addons = apply_filters( 'tc_delete_info_plugins_list', array( 'tickera' => $tc->title ) );

$action_url = add_query_arg( array(
    'post_type' => 'tc_events',
    'page' => 'tc_settings',
    'tab' => 'tickera_delete_info'
), admin_url( 'edit.php' ) );
?>
<div class="wrap tc_wrap" id="tc_delete_info">
    <?php if ( isset( $message ) ) { ?>
        <div id="message" class="updated fade"><p><?php echo esc_html( $message ); ?></p></div>
    <?php } ?>
    <div id="poststuff" class="metabox-holder tc-settings">
        <form id="tc-delete-info" method='post' action='<?php echo esc_url( $action_url ); ?>'>
            <?php wp_nonce_field( 'delete_info' ); ?>
            <div class="postbox">
                <h3><span><?php _e( 'Delete Information stored by the plugin and its add-ons', 'tc' ); ?></span></h3>
                <div class="inside">
                    <span class="description"></span>
                    <table class="form-table" cellspacing="0" id="status">
                        <tbody>
                        <tr>
                            <th><?php _e( 'Plugin', 'tc' ); ?></th>
                            <th><?php _e( 'Confirm', 'tc' ); ?></th>
                        </tr>
                        <?php foreach ( $tickera_plugins_and_addons as $plugin_name => $plugin_title ) { ?>
                            <tr>
                                <td><?php echo esc_html( $plugin_title ); ?></td>
                                <td><input type="checkbox" value="yes" name="tc_delete_plugin_data[<?php echo esc_attr( $plugin_name ); ?>]"/><?php _e( 'Delete', 'tc' ); ?>
                                </td>
                            </tr>
                        <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <?php submit_button( __( 'Delete selected data permanently', 'tc' ), 'primary', 'tc_delete_selected_data_permanently', true ); ?>
        </form>
        <?php do_action( 'tc_after_delete_info' ); ?>
    </div>
</div>
