<?php
/**
 * Exports ACtions
 *
 * These are actions related to exporting data from RestroPress.
 *
 * @package     RPRESS
 * @subpackage  Admin/Export
 * @copyright   Copyright (c) 2018, Magnigenie
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 */
if ( ! defined( 'ABSPATH' ) ) { exit; }

/**
 * Process the fooditem file generated by a batch export
 *
 * @since 2.4
 * @return void
 */
function rpress_process_batch_export_fooditem() {

	if( ! wp_verify_nonce( $_REQUEST['nonce'], 'rpress-batch-export' ) ) {
		wp_die( __( 'Nonce verification failed', 'restropress' ), __( 'Error', 'restropress' ), array( 'response' => 403 ) );
	}

	require_once RP_PLUGIN_DIR . 'includes/admin/reporting/export/class-batch-export.php';
	$class = sanitize_text_field( $_REQUEST['class'] );
	do_action( 'rpress_batch_export_class_include', $class );

	$export = new $class;
	$export->export();

}
add_action( 'rpress_fooditem_batch_export', 'rpress_process_batch_export_fooditem' );

/**
 * Export all the customers to a CSV file.
 *
 * Note: The WordPress Database API is being used directly for performance
 * reasons (workaround of calling all posts and fetch data respectively)
 *
 * @since  1.0.0
 * @return void
 */
function rpress_export_all_customers() {
	require_once RP_PLUGIN_DIR . 'includes/admin/reporting/class-export-customers.php';

	$customer_export = new RPRESS_Customers_Export();

	$customer_export->export();
}
add_action( 'rpress_email_export', 'rpress_export_all_customers' );

/**
 * Exports all the fooditems to a CSV file using the RPRESS_Export class.
 *
 * @since  1.0.0
 * @return void
 */
function rpress_export_all_fooditems_history() {
	require_once RP_PLUGIN_DIR . 'includes/admin/reporting/class-export-fooditem-history.php';

	$file_fooditem_export = new RPRESS_RestroPress_History_Export();

	$file_fooditem_export->export();
}
add_action( 'rpress_fooditems_history_export', 'rpress_export_all_fooditems_history' );

/**
 * Add a hook allowing extensions to register a hook on the batch export process
 *
 * @since 1.0
 * @return void
 */
function rpress_register_batch_exporters() {
	if ( is_admin() ) {
		do_action( 'rpress_register_batch_exporter' );
	}
}
add_action( 'plugins_loaded', 'rpress_register_batch_exporters', 99 );

/**
 * Register the payments batch exporter
 * @since 1.0
 */
function rpress_register_payments_batch_export() {
	add_action( 'rpress_batch_export_class_include', 'rpress_include_payments_batch_processer', 10, 1 );
}
add_action( 'rpress_register_batch_exporter', 'rpress_register_payments_batch_export', 10 );

/**
 * Loads the payments batch process if needed
 *
 * @since 1.0
 * @param  string $class The class being requested to run for the batch export
 * @return void
 */
function rpress_include_payments_batch_processer( $class ) {

	if ( 'RPRESS_Batch_Payments_Export' === $class ) {
		require_once RP_PLUGIN_DIR . 'includes/admin/reporting/export/class-batch-export-payments.php';
	}

}

/**
 * Register the customers batch exporter
 * @since 1.0
 */
function rpress_register_customers_batch_export() {
	add_action( 'rpress_batch_export_class_include', 'rpress_include_customers_batch_processer', 10, 1 );
}
add_action( 'rpress_register_batch_exporter', 'rpress_register_customers_batch_export', 10 );

/**
 * Loads the customers batch process if needed
 *
 * @since 1.0
 * @param  string $class The class being requested to run for the batch export
 * @return void
 */
function rpress_include_customers_batch_processer( $class ) {

	if ( 'RPRESS_Batch_Customers_Export' === $class ) {
		require_once RP_PLUGIN_DIR . 'includes/admin/reporting/export/class-batch-export-customers.php';
	}

}

/**
 * Register the fooditem products batch exporter
 *
 * @since  1.0.0
 */
function rpress_register_fooditems_batch_export() {
	add_action( 'rpress_batch_export_class_include', 'rpress_include_fooditems_batch_processer', 10, 1 );
}
add_action( 'rpress_register_batch_exporter', 'rpress_register_fooditems_batch_export', 10 );

/**
 * Loads the file fooditems batch process if needed
 *
 * @since  1.0.0
 * @param  string $class The class being requested to run for the batch export
 * @return void
 */
function rpress_include_fooditems_batch_processer( $class ) {

	if ( 'RPRESS_Batch_RestroPress_Export' === $class ) {
		require_once RP_PLUGIN_DIR . 'includes/admin/reporting/export/class-batch-export-fooditems.php';
	}

}

/**
 * Register the file fooditems batch exporter
 * @since 1.0
 */
function rpress_register_file_fooditems_batch_export() {
	add_action( 'rpress_batch_export_class_include', 'rpress_include_file_fooditems_batch_processer', 10, 1 );
}
add_action( 'rpress_register_batch_exporter', 'rpress_register_file_fooditems_batch_export', 10 );

/**
 * Loads the file fooditems batch process if needed
 *
 * @since 1.0
 * @param  string $class The class being requested to run for the batch export
 * @return void
 */
function rpress_include_file_fooditems_batch_processer( $class ) {

	if ( 'RPRESS_Batch_File_Orders_Export' === $class ) {
		require_once RP_PLUGIN_DIR . 'includes/admin/reporting/export/class-batch-export-orders.php';
	}
}

/**
 * Register the sales batch exporter
 *
 * @since 1.0
 */
function rpress_register_sales_export_batch_export() {
	add_action( 'rpress_batch_export_class_include', 'rpress_include_sales_export_batch_processer', 10, 1 );
}
add_action( 'rpress_register_batch_exporter', 'rpress_register_sales_export_batch_export', 10 );

/**
 * Loads the sales export batch process if needed
 *
 * @since 1.0
 * @param  string $class The class being requested to run for the batch export
 * @return void
 */
function rpress_include_sales_export_batch_processer( $class ) {
	if ( 'RPRESS_Batch_Sales_Export' === $class ) {
		require_once RP_PLUGIN_DIR . 'includes/admin/reporting/export/class-batch-export-sales.php';
	}
}

/**
 * Register the earnings report batch exporter
 *
 * @since 1.0
 */
function rpress_register_earnings_report_batch_export() {
	add_action( 'rpress_batch_export_class_include', 'rpress_include_earnings_report_batch_processer', 10, 1 );
}
add_action( 'rpress_register_batch_exporter', 'rpress_register_earnings_report_batch_export', 10 );

/**
 * Loads the earnings report batch process if needed
 *
 * @since 1.0
 * @param  string $class The class being requested to run for the batch export
 * @return void
 */
function rpress_include_earnings_report_batch_processer( $class ) {
	if ( 'RPRESS_Batch_Earnings_Report_Export' === $class ) {
		require_once RP_PLUGIN_DIR . 'includes/admin/reporting/export/class-batch-export-earnings-report.php';
	}
}

/**
 * Register the API requests batch exporter
 *
 * @since 1.0
 */
function rpress_register_api_requests_batch_export() {
	add_action( 'rpress_batch_export_class_include', 'rpress_include_api_requests_batch_processer', 10, 1 );
}
add_action( 'rpress_register_batch_exporter', 'rpress_register_api_requests_batch_export', 10 );

/**
 * Loads the API requests batch process if needed
 *
 * @since 1.0
 * @param  string $class The class being requested to run for the batch export
 * @return void
 */
function rpress_include_api_requests_batch_processer( $class ) {
	if ( 'RPRESS_Batch_API_Requests_Export' === $class ) {
		require_once RP_PLUGIN_DIR . 'includes/admin/reporting/export/class-batch-export-api-requests.php';
	}
}
