<div class="wrap">
    <div id="account_activation_container">
        <div class="account_activation_wrapper">
            <div class="redi-setting-header">
                <h3><?php _e(' Reservation page', 'redi-restaurant-reservation'); ?></h3>
            </div>
            <div class="redi-setting-body">
                <div class="redi-body-form-inputs">
                    <p><span><?php _e('You can create dedicated reservation page below, or you can skip this step and create page manually. When you create page manually, insert [redireservation] shortcode to the page.', 'redi-restaurant-reservation'); ?></span></p>
                    <label for="reservation-page-input"><?php _e('Page name', 'redi-restaurant-reservation'); ?>*
                        <input type="text" name="reservation-page-input" id="reservation-page-create" placeholder="">
                    </label>
                    <div class="error_validation_message"></div>
                </div>
                <div class="redi-body-button">
                    <input type="submit" class="page_creation_res" data-type="page_skip" value="Skip">
                    <input type="submit" class="page_creation_res" data-type="page_create" value="Next">
                    <span id="loading"></span>
                </div>
            </div>
        </div>
    </div>    
</div>           
<script>
    jQuery(".page_creation_res").on("click", function() {
        jQuery(".error_validation_message").html('');
        jQuery("#loading").addClass('spinner_ctm');
        jQuery(this).prop('disabled','disabled');
        let type = jQuery(this).data('type');
        let data = '';
        let consent = '';

        data = jQuery("#reservation-page-create").val();
        if(data == '' && type == 'page_create'){
            jQuery( ".error_validation_message" ).html("Page name is required");
            jQuery(".page_creation_res").removeAttr('disabled');
            jQuery("#loading").removeClass('spinner_ctm');
            return true;
        }
    
        jQuery.post(ajaxurl, { action: "redi_restaurant-page_create", get: "createPageForReDiReservation", type: type, pagedata: data, redi_plugin_nonce: "<?php echo wp_create_nonce('redi_restaurant_ajax') ?>" } , function(response) {
                jQuery("#loading").removeClass('spinner_ctm');
                if(response == "success") {
                    location.reload();
                }else if(response == "page_skiped"){
                    location.reload();
                } else {
                    jQuery( ".error_validation_message" ).html(response);
                }
        }).done(function () {
            jQuery(".page_creation_res").removeAttr('disabled');
        });
    });
</script>
