<?php
if ( ! class_exists( 'ReDiRestaurantReservationMixPanel' ) ) 
{
    class ReDiRestaurantReservationMixPanel{
        public static function send_data_mixpanel($eventname, $pluginVersion){
            $admin_email = get_option('admin_email');
            $admin_data = get_user_by( 'email', $admin_email );
            $distinct_id = hash('md5', $admin_email . '-' . $admin_data->data->user_registered);
            $mixpanelToken = '126c27585fa83cdfa1c3d2c3330e6c1b';
            $mixpanelURL = 'https://api.mixpanel.com/track/';
            $data = array(
                'event' => $eventname,
                'properties' => array(
                    'token' => $mixpanelToken,
                    'distinct_id' => $distinct_id,
                    'product' => 'ReDi Restaurant Reservation version ' . $pluginVersion
                ),
            );
            $jsonData = json_encode($data);
            $response = wp_remote_post($mixpanelURL, array(
                'body' => array(
                    'data' => base64_encode($jsonData),
                ),
                'timeout' => 40,
                'sslverify' => true,
                'headers' => array(
                    'Content-Type' => 'application/json'
                )
            ));
            if ( is_wp_error( $response ) || wp_remote_retrieve_response_code( $response ) != 200 ) {
                $error_message = is_wp_error($response) ? $response->get_error_message() : 'Request failed.';
            } 
        }
    }
}

?>