<?php

global $wp_version;

if (version_compare($wp_version, '5.2') >= 0) {
    realestate_health_permalink();
} else {
    return;
}

function realestate_health_permalink()
{
    function realestate_add_permalink_test($tests)
    {
        $tests['direct']['permalink'] = array(
            'label' => __('Wrong Permalink', 'real-estate-right-now'),
            'test' => 'realestate_permalink_test',
        );
        return $tests;
    }
  
   $realestateurl = esc_url($_SERVER['REQUEST_URI']);
	if (strpos($realestateurl, '/options-permalink.php') === false) {
		$permalinkopt = get_option('permalink_structure');
		if ($permalinkopt != '/%postname%/')
				add_filter('site_status_tests', 'realestate_add_permalink_test');
	}
  
    
    function realestate_permalink_test()
    {


        $result = array(
            'badge' => array(
                'label' => __('Critical', 'real-estate-right-now'), // Performance
                'color' => 'red', // orange',
            ),
            'test2' => 'Bill_plugin',
            'status' => 'critical',
            'label' => __('Wrong Permalink Settings', 'real-estate-right-now'),
            'description' =>  sprintf(
                '<p>%s</p>',
                __('Please, fix it to avoid 404 error page.
                     To correct, just go to 
                     Dashboard => Settings => Permalinks => Post Name (check)
                     Then, click Save Changes.','real-estate-right-now')
            ),
        );
        return $result;
    }
}
