<?php

use Api\Wpl\routes\route;
use Api\Wpl\managers\UserManager;
use Api\Wpl\models\business\wplApi;
use Api\Wpl\managers\ListingManager;
use Api\Wpl\models\core\Properties\Properties;


// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

/**
 * The version of this plugin.
 *
 * @since    1.0.0
 *
 * @var string The current version of this plugin.
 */
define('WPLAPI_VERSION', '2.0.0');

/**
 * 	Define sms setting option name constant to our plugin directory.
 *
 * 	@since 1.0.0
 */
define('WPLAPI_TWILIO', 'wpl_api_sms_settings');

/**
 * 	Define path constant to our plugin directory.
 *
 * 	@since 1.0.0
 */
define('WPLAPI_DIR', plugin_dir_path(__FILE__));

/**
 * 	Define URL constant to our plugin directory.
 *
 * 	@since 1.0.0
 */
define('WPLAPI_URL', plugins_url('', __FILE__));
/**
 * 	Define Plugin name constant to our plugin directory.
 *
 * 	@since 1.0.0
 */
if (!defined('WPL_API_PLUGIN')) {
    define('WPL_API_PLUGIN', __('WPL REST API', 'wpl-api'));
}

/**
 * Check if the vendor directory exist
 *
 * @since 1.0.0
 */
if (!is_dir(WPLAPI_DIR . 'vendor/')) {
    wp_send_json('First you should install PHP dependencies');
}

/**
 * key for JWT signing and validation, shouldn't be changed
 *
 * @since 1.0.0
 */


//SECRET_KEY_JWT Is not required in this implementation

//if (!defined('SECRET_KEY_JWT')) {
//    wp_send_json('JWT is not configurated properly');
//}

require_once(WPLAPI_DIR . 'vendor/autoload.php');

class Controller
{

    protected $settings;

    public function __construct() {
        add_action( 'rest_api_init', array($this, 'wpl_api'));
    }

    public function wpl_api()
    {
        $properties = new Properties();
        $route = new route(new ListingManager($properties), $properties, new UserManager());
        $route->register_routes();
    }

    /**
     * Begins execution of the plugin.
     * @since 1.0.0
     */
    public function run() {
        $lang = isset($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2) : 'en';
        $plugin = new wplApi($lang);
        $plugin->run();
    }
}

// we GO!!!!!!!!
(new Controller())->run();
