<?php

class TestApiSaveSmsOptions extends WP_UnitTestCase {

    public function testSmsSaveOptions() {

        $token = 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJlbWFpbCI6ImFsYW5AcmVhbHR5bmEuY29tIn0.rEMxnT6YtgJBy2CBViOsdN9UGs6rkVrMWfd97JFA__0';
        $request = wp_remote_post('http://localhost/wp-json/wpl_api/v1/save-sms-setting',
            array(
                'body' => array(
                    'AccountSID'   => 'ACf79af7552b2907d26f3e34b39b65e94c',
                    'TokenID'      => 'b541365ff952e49fc374764d679ee15b',
                    'SenderNumber' => '+15005550006'),
                'headers' => array(
                    'Authorization' => 'Bearer ' . $token
                )
            )
        );
        $response = json_decode(wp_remote_retrieve_body($request) ?? '', true);

        try {

            switch ($response['success']) {
                case true:
                    $this->assertEquals(200, wp_remote_retrieve_response_code( $request ));
                    $this->assertEquals($this->getSuccessJson(), wp_remote_retrieve_body($request));
                    break;
                case false:
                    $this->assertEquals(200, wp_remote_retrieve_response_code( $request ));
                    $this->assertEquals($this->getErrorJson(), wp_remote_retrieve_body($request));
                    break;
            }

        } catch (\Exception $e) {
            $this->assertEquals(200, wp_remote_retrieve_response_code($request));
            $this->assertEquals($this->getAuthErrorJson(), wp_remote_retrieve_body($request));
        }
    }

    protected function getSuccessJson() {
        return '{"success":true,"data":{"message":"SMS Settings are saves successfully."}}';
    }

    protected function getErrorJson() {
        return '{"success":false,"data":{"message":"Sms settings already registered"}}';
    }

    protected function getAuthErrorJson() {
        return '{"success":false,"data":{"message":"Signature verification failed. Please generate token first."}}';
    }
}