<?php

class TestApiResetToken extends WP_UnitTestCase {

    public function testResetToken() {

        $token = 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJlbWFpbCI6ImFsYW5AcmVhbHR5bmEuY29tIn0.rEMxnT6YtgJBy2CBViOsdN9UGs6rkVrMWfd97JFA__0';
        $request = wp_remote_get('http://localhost/wp-json/wpl_api/v1/reset-token',
            array('headers' => array(
                'Authorization' => 'Bearer ' . $token
            ))
        );

        $response = json_decode(wp_remote_retrieve_body($request) ?? '', true);

        try {
            switch ($response) {
                case true:
                    $this->assertEquals(200, wp_remote_retrieve_response_code( $request ));
                    $this->assertEquals('true', wp_remote_retrieve_body($request));
                    break;
                case false:
                    $this->assertEquals(200, wp_remote_retrieve_response_code( $request ));
                    $this->assertEquals('false', wp_remote_retrieve_body($request));
                    break;
            }
        } catch (\Exception $e) {
            $this->assertEquals($this->getErrorJson(), wp_remote_retrieve_body($request));
        }
    }

    protected function getErrorJson() {
        return '{"success":false,"data":{"message":"Signature verification failed. Please generate token first."}}';
    }
}