<?php

class TestApiRegister extends WP_UnitTestCase {

    public function testRegisterSuccess() {

        try {
            $token = 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJlbWFpbCI6ImFsYW5AcmVhbHR5bmEuY29tIn0.rEMxnT6YtgJBy2CBViOsdN9UGs6rkVrMWfd97JFA__0';
            $response = wp_remote_post(
                'http://localhost/wp-json/wpl_api/v1/register',
                array(
                    'body' => array(
                        'name'        => 'Developer',
                        'email'       => 'api@realtyna.com',
                        'phone'       => '+982374892734',
                        'password'    => '123321aA',
                        're-password' => '123321aA'
                    ),
                    'headers' => array(
                        'Authorization' => 'Bearer ' . $token
                    )
                )
            );
            $this->assertEquals($this->getSuccessJson(), wp_remote_retrieve_body($response));
        } catch (\Exception $e) {
            $this->assertArrayHasKey('data', json_decode(wp_remote_retrieve_body($response) ?? '',true));
        }
    }

    public function testEmailError() {

        try {
            $token = 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJlbWFpbCI6ImFsYW5AcmVhbHR5bmEuY29tIn0.rEMxnT6YtgJBy2CBViOsdN9UGs6rkVrMWfd97JFA__0';
            $response = wp_remote_post(
                'http://localhost/wp-json/wpl_api/v1/register',
                array(
                    'body' => array(
                        'name'        => 'Developer',
                        'email'       => 'api@realtyna.com',
                        'phone'       => '+982374892734',
                        'password'    => '123321aA',
                        're-password' => '123321aA'
                    ),
                    'headers' => array(
                        'Authorization' => 'Bearer ' . $token
                    )
                )
            );
            $this->assertEquals($this->getEmailErrorJson(), wp_remote_retrieve_body($response));
        } catch (\Exception $e) {
            $this->assertArrayHasKey('data', json_decode(wp_remote_retrieve_body($response) ?? '',true));
        }
    }

    public function testPasswordError() {

        try {
            $token = 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJlbWFpbCI6ImFsYW5AcmVhbHR5bmEuY29tIn0.rEMxnT6YtgJBy2CBViOsdN9UGs6rkVrMWfd97JFA__0';
            $response = wp_remote_post(
                'http://localhost/wp-json/wpl_api/v1/register',
                array(
                    'body' => array(
                        'name'        => 'Developer',
                        'email'       => 'api@realtyna.com',
                        'phone'       => '+982374892734',
                        'password'    => '234234',
                        're-password' => '123321aA'
                    ),
                    'headers' => array(
                        'Authorization' => 'Bearer ' . $token
                    )
                )
            );
            $this->assertEquals($this->getPasswordErrorJson(), wp_remote_retrieve_body($response));
        } catch (\Exception $e) {
            $this->assertArrayHasKey('data', json_decode(wp_remote_retrieve_body($response) ?? '',true));
        }
    }

    protected function getSuccessJson() {
        return '{"success":true,"data":{"message":"User is created successfully."}}';
    }

    protected function getEmailErrorJson() {
        return '{"success":false,"data":{"message":"The Email is already registered. Try a different Email address."}}';
    }

    protected function getPasswordErrorJson() {
        return '{"success":false,"data":{"message":"password and the repeat are not matching."}}';
    }
}