<?php

_wpl_import('libraries.users');
_wpl_import('libraries.property');
_wpl_import('libraries.addon_crm');
_wpl_import('libraries.addon_crm.requests');
_wpl_import('libraries.addon_crm.tickets');
_wpl_import('libraries.addon_save_searches');

use Api\Wpl\models\core\Auth\Auth;
use Api\Wpl\models\core\Database\Database as DB;

/**
 * Function: Format Listing Results
 **/
if (!function_exists('listingsFixFields')) {
    function listingsFixFields($listings, $fields, $remove_fields=true) {
        foreach ($listings as $k1 => $listing) {
            foreach ($listing as $k2 => $attr) {
                if (in_array($k2,['finalized','confirmed'])) {
                    $listings[$k1][$k2]=boolval($attr);
                } elseif (empty(trim($attr)) OR substr($k2,-strlen('_options'),strlen('_options'))==='_options' OR substr($k2,-strlen('_unit'),strlen('_unit'))=='_unit' OR substr($k2,-strlen('_si'),strlen('_si'))=='_si' OR substr($k2,-strlen('_distance'),strlen('_distance'))=='_distance' OR substr($k2,-strlen('_distance_by'),strlen('_distance_by'))=='_distance_by' OR $k2=='rendered') {
                    if ($remove_fields) unset($listings[$k1][$k2]);
                } else {
                    if (array_key_exists($k2,$fields)) {
                        switch ($fields[$k2]['type']) {
                            case 'select':
                                $options = json_decode($fields[$k2]['options'] ?? '',true);
                                $items = array();
                                if (isset($options['params']) and is_array($options['params'])) {
                                    foreach ($options['params'] as $k => $v) {
                                        $items[$v['key']] = $v['value'];
                                    }
                                }
                                @$attr = $items[$attr];
                                break;

                            case 'multiselect':
                                $options = json_decode($fields[$k2]['options'] ?? '',true);
                                $options_arr = array();
                                if (isset($options['params']) and is_array($options['params'])) {
                                    foreach ($options['params'] as $option) {
                                        $options_arr[$option['key']]=$option['value'];
                                    }
                                }
                                $selected_options = array_filter(explode(',',$listing[$k2]));
                                if (isset($selected_options) and !empty($selected_options)) {
                                    $new_values = '';
                                    foreach ($selected_options as $selected_option) {
                                        $new_values .= $options_arr[$selected_option].',';
                                    }
                                }
                                $attr = substr($new_values,0,strlen($new_values)-1);
                                $new_values = '';
                                break;

                            case 'feature':
                                if (empty(trim($listing["{$k2}_options"] ?? ''))) {
                                    $attr = boolval($listing[$k2]);
                                } else {
                                    if ($fields[$k2]['options']) {
                                        $options = json_decode($fields[$k2]['options'] ?? '',true);
                                        $options_arr = array();
                                        if (isset($options['values']) and is_array($options['values'])) {
                                            foreach ($options['values'] as $option) {
                                                $options_arr[$option['key']]=$option['value'];
                                            }
                                        }
                                        $selected_options = array_filter(explode(',',$listing["{$k2}_options"]));

                                        if (isset($selected_options) and !empty($selected_options)) {
                                            $new_values = '';
                                            foreach ($selected_options as $selected_option) {
                                                $new_values .= $options_arr[$selected_option].',';
                                            }
                                        }
                                        $attr = substr($new_values,0,strlen($new_values)-1);
                                        $new_values = '';
                                    }
                                }
                                break;
                        }
                        $tmp_k2 = str_replace([' ','_/_'],'_',$fields[$k2]['name']);
                        $tmp_k2 = str_replace("?",' ',$tmp_k2);

                        if ($remove_fields) unset($listings[$k1][$k2]);
                        $listings[$k1][trim(strtolower($tmp_k2 ?? ''))] = $attr;
                    }
                }
            }
        }
        return $listings;
    }
}

/**
 * Function: Add WP User
 **/
if (!function_exists('add_wp_user')) {
    function add_wp_user($req) {
        $errors = [];
        if (!isset($req['user_login']) or empty($req['user_login'])) $errors[]=array('code'=>'empty_user_login','message'=>'parameter user_login is required');
        if (!isset($req['user_pass']) or empty($req['user_pass'])) $errors[]=array('code'=>'empty_user_pass','message'=>'parameter user_pass is required');
        if (!isset($req['user_email']) or empty($req['user_email'])) {
            $errors[]=array('code'=>'empty_user_email','message'=>'parameter user_email is required');
        } else {
            if (!is_email($req['user_email'])) $errors[]=array('code'=>'not_valid_user_pass','message'=>'parameter user_email is not valid');
        }
        if (!empty($errors) and count($errors)) return array('errors'=>$errors);

        @$username = $req['user_login'];
        @$password = $req['user_pass'];
        @$email = $req['user_email'];

        $result = wp_create_user($username,$password,$email);
        if(is_wp_error($result)){
            return $result->get_error_message();
        }else{
            return get_user_by('id', $result);
        }
    }
}

/**
 * Function: Format Dynamic Fields
 **/
if (!function_exists('getDynamicFields')) {
    function getDynamicFields($all_fields,$request) {
        global $wpdb;
        $fields = [];
        foreach ($all_fields as $field) {
            if ($field->table_column != null) {
                $type = $field->type;
                switch ($type) {
                    case 'multiselect':
                    case 'select':
                        $all_options = json_decode($field->options ?? '',true)['params'];
                        $options = [];
                        foreach ($all_options as $option) {
                            $options[]=['value'=>$option['key'],'label'=>$option['value']];
                        }
                        $fields[]=[
                            'label'=>$field->name,
                            'key'=>$field->table_column,
                            'choices'=>$options,
                            'type'=>'integer'
                        ];
                    break;

                    case 'date':
                        $fields[]=['label'=>$field->name,'key'=>$field->table_column,'type'=>'datetime'];
                    break;

                    case 'mmprice':
                    case 'mmarea':
                        $fields[]=['label'=>$field->name.' Min','key'=>$field->table_column,'type'=>'number'];
                        $fields[]=['label'=>$field->name.' Max','key'=>$field->table_column.'_max','type'=>'number'];
                    break;

                    case 'mmnumber':
                        $fields[]=['label'=>$field->name.' Min','key'=>$field->table_column,'type'=>'integer'];
                        $fields[]=['label'=>$field->name.' Max','key'=>$field->table_column.'_max','type'=>'integer'];
                    break;

                    case 'feature':
                        $all_options = json_decode($field->options ?? '',true);
                        $options = [];
                        switch ($all_options['type']) {
                            case 'none':
                            $options=[['value'=>"0",'label'=>'No'],['value'=>"1",'label'=>'Yes']];
                            $fields[]=[
                                'label'=>$field->name,
                                'key'=>$field->table_column,
                                'choices'=>$options,
                                'type'=>'integer'
                            ];
                            break;

                            default:
                            foreach ($all_options['values'] as $option) {
                                $options[]=['value'=>"$option[key]",'label'=>$option['value']];
                            }
                            $fields[]=[
                                'label'=>$field->name,
                                'key'=>$field->table_column,
                                'choices'=>$options,
                                'type'=>'integer'
                            ];
                            break;
                        }
                    break;

                    case 'multiple':
                        $search = (is_multisite() AND isset($request['blog_id']) AND !empty($request['blog_id'])) ? " AND blog_id = '".intval($request['blog_id'])."'" : '';
                        $values_source = json_decode($field->options ?? '',true)['values_source'];
                        $options = json_decode($wpdb->get_row("SELECT * FROM `{$wpdb->base_prefix}wpl_settings` WHERE `setting_name` = '$values_source' $search")->setting_value ?? '',true);
                        $new_options = [];
                        foreach ($options as $i => $option) {
                            $new_options[] = [
                                'value'=>"$i",
                                'label'=>$option
                            ];
                        }
                        $fields[]=[
                            'label'=>$field->name,
                            'key'=>$field->table_column,
                            'choices'=>$new_options,
                            'type'=>'integer'
                        ];
                    break;

                    case 'property_types':
                        $search = (is_multisite() AND is_multisite() AND isset($request['blog_id']) AND !empty($request['blog_id'])) ? " AND blog_id = '".intval($request['blog_id'])."'" : '';
                        $options = $wpdb->get_results("SELECT * FROM `{$wpdb->base_prefix}wpl_property_types` WHERE `enabled`=1 $search");
                        $new_options = [];
                        foreach ($options as $option) {
                            $new_options[]=[
                                'value'=>$option->id,
                                'label'=>$option->name
                            ];
                        }
                        $fields[]=[
                            'label'=>$field->name,
                            'key'=>$field->table_column,
                            'choices'=>$new_options,
                            'type'=>'integer'
                        ];
                    break;

                    case 'listings':
                        $search = (is_multisite() AND isset($request['blog_id']) AND !empty($request['blog_id'])) ? " AND blog_id = '".intval($request['blog_id'])."'" : '';
                        $options = $wpdb->get_results("SELECT * FROM `{$wpdb->base_prefix}wpl_listing_types` WHERE `enabled`=1 $search");
                        $new_options = [];
                        foreach ($options as $option) {
                            $new_options[]=[
                                'value'=>$option->id,
                                'label'=>$option->name
                            ];
                        }
                        $fields[]=[
                            'label'=>$field->name,
                            'key'=>$field->table_column,
                            'choices'=>$new_options,
                            'type'=>'integer'
                        ];
                    break;

                    case 'tag':
                    case 'neighborhood':
                    case 'boolean':
                        $options = [['value'=>"0",'label'=>'No'],['value'=>"1",'label'=>'Yes']];
                        $fields[]=[
                            'label'=>$field->name,
                            'key'=>$field->table_column,
                            'choices'=>$options,
                            'type'=>'integer'
                        ];
                    break;

                    default:
                        if (substr($field->table_column, 0, strlen('location')) == 'location' and substr($field->table_column, -strlen('_name')) == '_name') break;
                        $f_value = ['label' => $field->name, 'key' => $field->table_column];
                        switch ($field->type) {
                            case 'text':
                            $f_value['type']='string';
                            break;

                            case 'textarea':
                            $f_value['type']='text';
                            break;

                            case 'number':
                            case 'price':
                            $f_value['type']='number';
                            break;
                        }

                        switch ($field->table_column) {
                            case 'bedrooms':
                            case 'bathrooms':
                            case 'saved_searches':
                            case 'logins':
                            $f_value['type']='integer';
                            break;

                            case 'living_area':
                            case 'lot_area':
                            case 'price':
                            $f_value['type']='number';
                            break;
                        }
                        $fields[]=$f_value;
                    break;
                }
            }
        }
        return $fields;
    }
}