<?php
require dirname(__FILE__) . "/functions.php";

use Api\Wpl\models\core\Auth\Auth;
use Api\Wpl\models\core\Database\Database as DB;

/**
 * Get User Fields
 **/
register_rest_route( $this->namespace, '/get-user-fields', array(
    'methods'             => 'GET',
    'callback'            => function () {
        global $wpdb;
        $userId = (new Auth)->getUserIdByToken();
        if ($userId > 0) {
            $search = '';
            $search .= (is_multisite() AND isset($_REQUEST['blog_id']) AND !empty($_REQUEST['blog_id'])) ? " AND blog_id = '".intval($_REQUEST['blog_id'])."'" : '';

            $true_false = [['value'=>0,'label'=>'No'],['value'=>1,'label'=>'Yes']];
            $male_female = [['value'=>0,'label'=>'Female'],['value'=>1,'label'=>'Male']];

            return [
                ['key'=>'membership_id', 'choices' => is_multisite() ? $wpdb->get_results("SELECT CONCAT('ID:',id,', BlogID:',blog_id) `sample`, id `value`, membership_name label FROM {$wpdb->base_prefix}wpl_users WHERE id < 0 $search", ARRAY_A) : $wpdb->get_results("SELECT CONCAT('ID:',id,') `sample`, id `value`, membership_name label FROM {$wpdb->base_prefix}wpl_users WHERE id < 0 $search", ARRAY_A)],
                ['key'=>'membership_type', 'choices' => is_multisite() ? $wpdb->get_results("SELECT CONCAT('ID:',id,', BlogID:',blog_id) `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_user_group_types WHERE `enabled` = 1 $search", ARRAY_A) : $wpdb->get_results("SELECT CONCAT('ID:',id,') `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_user_group_types WHERE `enabled` = 1 $search", ARRAY_A)],
                ['key'=>'index', 'type'=>'number'],
                ['key'=>'access_propertywizard', 'choices' => $true_false],
                ['key'=>'access_propertyshow', 'choices' => $true_false],
                ['key'=>'access_propertylisting', 'choices' => $true_false],
                ['key'=>'access_profilewizard', 'choices' => $true_false],
                ['key'=>'access_confirm', 'choices' => $true_false],
                ['key'=>'access_propertymanager', 'choices' => $true_false],
                ['key'=>'access_delete', 'choices' => $true_false],
                ['key'=>'access_public_profile', 'choices' => $true_false],
                ['key'=>'access_change_user', 'choices' => $true_false],
                ['key'=>'access_receive_notifications', 'choices' => $true_false],
                ['key'=>'first_name'],
                ['key'=>'last_name'],
                ['key'=>'about', 'type'=>'text'],
                ['key'=>'company_name'],
                ['key'=>'company_address', 'type'=>'text'],
                ['key'=>'website'],
                ['key'=>'main_email'],
                ['key'=>'secondary_email'],
                ['key'=>'sex', 'choices' => $male_female],
                ['key'=>'tel'],
                ['key'=>'fax'],
                ['key'=>'mobile'],
                ['key'=>'languages'],
                ['key'=>'location1_id', 'choices' => is_multisite() ? $wpdb->get_results("SELECT CONCAT('ID:',id,', BlogID:',blog_id) `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location1 WHERE `enabled` = 1 $search", ARRAY_A) : $wpdb->get_results("SELECT CONCAT('ID:',id,') `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location1 WHERE `enabled` = 1 $search", ARRAY_A)],
                ['key'=>'location2_id', 'choices' => is_multisite() ? $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,', BlogID:',blog_id) `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location2 WHERE 1 $search", ARRAY_A) : $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,') `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location2 WHERE 1 $search", ARRAY_A)],
                ['key'=>'location3_id', 'choices' => is_multisite() ? $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,', BlogID:',blog_id) `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location3 WHERE 1 $search", ARRAY_A) : $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,') `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location3 WHERE 1 $search", ARRAY_A)],
                ['key'=>'location4_id', 'choices' => is_multisite() ? $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,', BlogID:',blog_id) `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location4 WHERE 1 $search", ARRAY_A) : $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,') `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location4 WHERE 1 $search", ARRAY_A)],
                ['key'=>'location5_id', 'choices' => is_multisite() ? $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,', BlogID:',blog_id) `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location5 WHERE 1 $search", ARRAY_A) : $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,') `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location5 WHERE 1 $search", ARRAY_A)],
                ['key'=>'location6_id', 'choices' => is_multisite() ? $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,', BlogID:',blog_id) `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location6 WHERE 1 $search", ARRAY_A) : $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,') `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location6 WHERE 1 $search", ARRAY_A)],
                ['key'=>'location7_id', 'choices' => is_multisite() ? $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,', BlogID:',blog_id) `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location7 WHERE 1 $search", ARRAY_A) : $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,') `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location7 WHERE 1 $search", ARRAY_A)],
                ['key'=>'show_address', 'choices' => $true_false],
                ['key'=>'zip_id'],
                ['key'=>'zip_name'],
                //['key'=>'maccess_num_prop'],
                //['key'=>'maccess_num_feat'],
                //['key'=>'maccess_num_hot'],
                //['key'=>'maccess_num_pic'],
                //['key'=>'maccess_period'],
                //['key'=>'maccess_price'],
                //['key'=>'maccess_price_unit'],
                //['key'=>'maccess_lrestrict'],
                //['key'=>'maccess_listings'],
                //['key'=>'maccess_ptrestrict'],
                //['key'=>'maccess_property_types'],
                //['key'=>'maccess_renewable'],
                //['key'=>'maccess_renewal_price'],
                //['key'=>'maccess_renewal_price_unit'],
                //['key'=>'maccess_upgradable'],
                //['key'=>'maccess_upgradable_to'],
                //['key'=>'maccess_short_description'],
                //['key'=>'maccess_long_description'],
                //['key'=>'maccess_wpl_color'],
                ['key'=>'expired', 'choices' => $true_false],
                ['key'=>'expiry_date', 'type'=>'datetime'],
                ['key'=>'textsearch'],
                ['key'=>'location_text'],
                //['key'=>'rendered'],
                ['key'=>'last_modified_time_stamp'],
                //['key'=>'profile_picture'],
                //['key'=>'company_logo'],
                //['key'=>'maccess_lrestrict_pshow'],
                //['key'=>'maccess_ptrestrict_pshow'],
                //['key'=>'maccess_listings_pshow'],
                //['key'=>'maccess_property_types_pshow'],
                //['key'=>'maccess_lrestrict_plisting'],
                //['key'=>'maccess_ptrestrict_plisting'],
                //['key'=>'maccess_listings_plisting'],
                //['key'=>'maccess_property_types_plisting'],
                ['key'=>'access_clone', 'choices' => $true_false],
                ['key'=>'access_propertystats', 'choices' => $true_false],
                //['key'=>'maccess_crm'],
                //['key'=>'online_status'],
                ['key'=>'access_CRM', 'choices' => $true_false],
                //['key'=>'crm_selected_fields'],
                //['key'=>'crm_cookies'],
                //['key'=>'access_complex_addon'],
                //['key'=>'access_multi_agents'],
            ];
        } else {
            return [];
        }
    },
    'permission_callback' => array( $this, 'permissionCheck' )
    )
);

/**
 * Get Ticket Fields
 **/
register_rest_route( $this->namespace, '/get-ticket-fields', array(
    'methods'             => 'GET',
    'callback'            => function () {
        global $wpdb;
        $userId = (new Auth)->getUserIdByToken();
        if ($userId > 0) {
            $search = '';
            $search .= (is_multisite() AND isset($_REQUEST['blog_id']) AND !empty($_REQUEST['blog_id'])) ? " AND blog_id = '".intval($_REQUEST['blog_id'])."'" : '';

            $true_false = [['value'=>0,'label'=>'No'],['value'=>1,'label'=>'Yes']];
            $status = [['value'=>'Open','label'=>'Open'],['value'=>'In Progress','label'=>'In Progress'],['value'=>'Waiting','label'=>'Waiting'],['value'=>'Closed','label'=>'Closed'],['value'=>'Done','label'=>'Done'],['value'=>'Cold','label'=>'Cold']];
            $priority = [['value'=>'Low','label'=>'Low'],['value'=>'Medium','label'=>'Medium'],['value'=>'High','label'=>'High'],['value'=>'Urgent','label'=>'Urgent'],['value'=>'Emergency','label'=>'Emergency'],['value'=>'Critical','label'=>'Critical']];

            return [
                ['key'=>'contact_id','choices'=>$wpdb->get_results("SELECT id `value`, CONCAT(first_name,' ',last_name,'(',email,')') label FROM {$wpdb->base_prefix}wpl_addon_crm_contacts WHERE 1 $search", ARRAY_A)],
                ['key'=>'agent_id','choices'=>$wpdb->get_results("SELECT u.id `value`, replace(CONCAT(u.first_name,' ',u.last_name,'(',u.main_email,', ',wu.user_email,')'),'(, ','(') label FROM (SELECT * FROM {$wpdb->base_prefix}wpl_users WHERE id IN (SELECT id FROM {$wpdb->base_prefix}users)) u INNER JOIN {$wpdb->base_prefix}users wu ON wu.id = u.id WHERE 1 $search", ARRAY_A)],
                ['key'=>'archived','choices'=>$true_false],
                ['key'=>'status','choices'=>$status],
                ['key'=>'priority','choices'=>explode(',',implode(',',range(1,10)))],
                ['key'=>'subject','type'=>'string'],
                ['key'=>'message','type'=>'text']
            ];
        } else {
            return [];
        }
    },
    'permission_callback' => array( $this, 'permissionCheck' )
)
);

/**
 * Get Contact Fields
 **/
register_rest_route( $this->namespace, '/get-contact-fields', array(
    'methods'             => 'GET',
    'callback'            => function () {
        global $wpdb;
        $userId = (new Auth)->getUserIdByToken();
        if ($userId > 0) {
            $search = '';
            $search .= (is_multisite() AND isset($_REQUEST['blog_id']) AND !empty($_REQUEST['blog_id'])) ? " AND blog_id = '".intval($_REQUEST['blog_id'])."'" : '';
            $fields = [];
            $all_fields = $wpdb->get_results("SELECT * FROM {$wpdb->base_prefix}wpl_dbst WHERE `kind` = 3 AND `enabled` > 0 AND `table_name`='wpl_addon_crm_contacts' $search");
            $fields = getDynamicFields($all_fields,$_REQUEST);
            $fields[]=['key'=>'owner','choices'=>$wpdb->get_results("SELECT u.id `value`, replace(CONCAT(u.first_name,' ',u.last_name,'(',u.main_email,', ',wu.user_email,')'),'(, ','(') label FROM (SELECT * FROM {$wpdb->base_prefix}wpl_users WHERE id IN (SELECT id FROM {$wpdb->base_prefix}users)) u INNER JOIN {$wpdb->base_prefix}users wu ON wu.id = u.id WHERE 1 $search", ARRAY_A)];
            $fields[]=['key'=>'create_user', 'choices'=>[
                    ['value'=>0,'label'=>'Disabled'],
                    ['value'=>1,'label'=>'Enabled']
                ]
            ];
            return $fields;
        } else {
            return [];
        }
    },
    'permission_callback' => array( $this, 'permissionCheck' )
)
);

/**
 * Get Request Fields
 **/
register_rest_route( $this->namespace, '/get-request-fields', array(
    'methods'             => 'GET',
    'callback'            => function () {
        global $wpdb;
        $userId = (new Auth)->getUserIdByToken();
        if ($userId > 0) {
            $search = '';
            $search .= (is_multisite() AND isset($_REQUEST['blog_id']) AND !empty($_REQUEST['blog_id'])) ? " AND blog_id = '".intval($_REQUEST['blog_id'])."'" : '';
            $fields = [];
            $all_fields = $wpdb->get_results("SELECT * FROM {$wpdb->base_prefix}wpl_dbst WHERE `kind` = 3 AND `enabled` > 0 AND `table_name`='wpl_addon_crm_requests' $search");
            $fields = getDynamicFields($all_fields,$_REQUEST);
            $fields[]=[
                'label'=>'Contact','key'=>'cid', 'choices'=>$wpdb->get_results("SELECT id value, TRIM(CONCAT(first_name,' ',last_name,' (',email,')')) label FROM {$wpdb->base_prefix}wpl_addon_crm_contacts",ARRAY_A)
            ];
            $fields[]=['key'=>'location1_id', 'choices' => is_multisite() ? $wpdb->get_results("SELECT CONCAT('ID:',id,', BlogID:',blog_id) `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location1 WHERE `enabled` = 1 $search", ARRAY_A) : $wpdb->get_results("SELECT CONCAT('ID:',id,') `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location1 WHERE `enabled` = 1 $search", ARRAY_A)];
            $fields[]=['key'=>'location2_id', 'choices' => is_multisite() ? $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,', BlogID:',blog_id) `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location2 WHERE 1 $search", ARRAY_A) : $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,') `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location2 WHERE 1 $search", ARRAY_A)];
            $fields[]=['key'=>'location3_id', 'choices' => is_multisite() ? $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,', BlogID:',blog_id) `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location3 WHERE 1 $search", ARRAY_A) : $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,') `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location3 WHERE 1 $search", ARRAY_A)];
            $fields[]=['key'=>'location4_id', 'choices' => is_multisite() ? $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,', BlogID:',blog_id) `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location4 WHERE 1 $search", ARRAY_A) : $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,') `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location4 WHERE 1 $search", ARRAY_A)];
            $fields[]=['key'=>'location5_id', 'choices' => is_multisite() ? $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,', BlogID:',blog_id) `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location5 WHERE 1 $search", ARRAY_A) : $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,') `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location5 WHERE 1 $search", ARRAY_A)];
            $fields[]=['key'=>'location6_id', 'choices' => is_multisite() ? $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,', BlogID:',blog_id) `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location6 WHERE 1 $search", ARRAY_A) : $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,') `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location6 WHERE 1 $search", ARRAY_A)];
            $fields[]=['key'=>'location7_id', 'choices' => is_multisite() ? $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,', BlogID:',blog_id) `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location7 WHERE 1 $search", ARRAY_A) : $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,') `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location7 WHERE 1 $search", ARRAY_A)];
            $fields[]=['key'=>'zip_id'];
            $fields[]=['key'=>'zip_name'];
            return $fields;
        } else {
            return [];
        }
    },
    'permission_callback' => array( $this, 'permissionCheck' )
)
);

/**
 * Get Contact Request Fields
 **/
register_rest_route( $this->namespace, '/get-contact-request-fields', array(
    'methods'             => 'GET',
    'callback'            => function () {
        global $wpdb;
        $userId = (new Auth)->getUserIdByToken();
        if ($userId > 0) {
            $search = '';
            $search .= (is_multisite() AND isset($_REQUEST['blog_id']) AND !empty($_REQUEST['blog_id'])) ? " AND blog_id = '".intval($_REQUEST['blog_id'])."'" : '';
            $fields = [];
            
            $contact_fields = $wpdb->get_results("SELECT * FROM {$wpdb->base_prefix}wpl_dbst WHERE `kind` = 3 AND `enabled` > 0 AND `table_name`='wpl_addon_crm_contacts' $search");
            $fields1 = getDynamicFields($contact_fields,$_REQUEST);
            
            $request_fields = $wpdb->get_results("SELECT * FROM {$wpdb->base_prefix}wpl_dbst WHERE `kind` = 3 AND `enabled` > 0 AND `table_name`='wpl_addon_crm_requests' $search");
            $fields2 = getDynamicFields($request_fields,$_REQUEST);
            $fields2[]=[
                'label'=>'Contact','key'=>'cid', 'choices'=>$wpdb->get_results("SELECT id value, TRIM(CONCAT(first_name,' ',last_name,' (',email,')')) label FROM {$wpdb->base_prefix}wpl_addon_crm_contacts",ARRAY_A)
            ];
            $fields2[]=['key'=>'location1_id', 'choices' => is_multisite() ? $wpdb->get_results("SELECT CONCAT('ID:',id,', BlogID:',blog_id) `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location1 WHERE `enabled` = 1 $search", ARRAY_A) : $wpdb->get_results("SELECT CONCAT('ID:',id,') `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location1 WHERE `enabled` = 1 $search", ARRAY_A)];
            $fields2[]=['key'=>'location2_id', 'choices' => is_multisite() ? $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,', BlogID:',blog_id) `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location2 WHERE 1 $search", ARRAY_A) : $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,') `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location2 WHERE 1 $search", ARRAY_A)];
            $fields2[]=['key'=>'location3_id', 'choices' => is_multisite() ? $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,', BlogID:',blog_id) `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location3 WHERE 1 $search", ARRAY_A) : $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,') `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location3 WHERE 1 $search", ARRAY_A)];
            $fields2[]=['key'=>'location4_id', 'choices' => is_multisite() ? $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,', BlogID:',blog_id) `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location4 WHERE 1 $search", ARRAY_A) : $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,') `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location4 WHERE 1 $search", ARRAY_A)];
            $fields2[]=['key'=>'location5_id', 'choices' => is_multisite() ? $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,', BlogID:',blog_id) `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location5 WHERE 1 $search", ARRAY_A) : $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,') `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location5 WHERE 1 $search", ARRAY_A)];
            $fields2[]=['key'=>'location6_id', 'choices' => is_multisite() ? $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,', BlogID:',blog_id) `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location6 WHERE 1 $search", ARRAY_A) : $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,') `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location6 WHERE 1 $search", ARRAY_A)];
            $fields2[]=['key'=>'location7_id', 'choices' => is_multisite() ? $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,', BlogID:',blog_id) `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location7 WHERE 1 $search", ARRAY_A) : $wpdb->get_results("SELECT CONCAT('ID:',id,', ParentID:',parent,') `sample`, id `value`, `name` label FROM {$wpdb->base_prefix}wpl_location7 WHERE 1 $search", ARRAY_A)];
            $fields2[]=['key'=>'zip_id'];
            $fields2[]=['key'=>'zip_name'];
            $fields2[]=['key'=>'create_user', 'choices'=>[
                    ['value'=>0,'label'=>'Disabled'],
                    ['value'=>1,'label'=>'Enabled']
                ]
            ];
            return array_merge($fields1,$fields2);
        } else {
            return [];
        }
    },
    'permission_callback' => array( $this, 'permissionCheck' )
)
);

/**
 * Get Listing Fields
 **/
register_rest_route( $this->namespace, '/get-listing-fields', array(
    'methods'             => 'GET',
    'callback'            => function () {
        global $wpdb;
        $kind = isset($_REQUEST['kind']) ? $_REQUEST['kind'] : 0;
        $userId = (new Auth)->getUserIdByToken();
        if ($userId > 0) {
            $search = '';
            $search .= (is_multisite() AND isset($_REQUEST['blog_id']) AND !empty($_REQUEST['blog_id'])) ? " AND blog_id = '".intval($_REQUEST['blog_id'])."'" : '';
            $search .= " AND kind = '".intval($kind)."'";
            $fields = [];
            $all_fields = $wpdb->get_results("SELECT * FROM {$wpdb->base_prefix}wpl_dbst WHERE `enabled` > 0 AND `table_name`='wpl_properties' $search");
            $fields = getDynamicFields($all_fields,$_REQUEST);
            $fields[] = [
                [
                    "label"=>"Publish",
                    "key"=>"confirmed",
                    "choices"=>[
                        ["value"=>"0","label"=>"Unpublish"],
                        ["value"=>"1","label"=>"Publish"],
                    ],
                ]
            ];
            return $fields;
        } else {
            return [];
        }
    },
    'permission_callback' => array( $this, 'permissionCheck' )
)
);