<?php
require dirname(__FILE__) . "/functions.php";

_wpl_import('libraries.users');
_wpl_import('libraries.property');
_wpl_import('libraries.addon_crm');
_wpl_import('libraries.addon_crm.requests');
_wpl_import('libraries.addon_crm.tickets');
_wpl_import('libraries.addon_save_searches');

use Api\Wpl\models\core\Auth\Auth;
use Api\Wpl\models\core\Database\Database as DB;

/**
 * Add a Contact
 **/
register_rest_route( $this->namespace, '/add-contact', array(
        'methods'             => 'POST',
        'callback'            => function () {
            global $wpdb;
            $headers = getallheaders();
            if (isset($headers['X-Blog-Id']) and !empty($headers['X-Blog-Id'])) $blog_id = $headers['X-Blog-Id'];
            $all_fields = $wpdb->get_results("SELECT * FROM {$wpdb->base_prefix}wpl_dbst WHERE `kind` = 3 AND `enabled` > 0 AND `table_name`='wpl_addon_crm_contacts'");
            $params = [];
            foreach ($_REQUEST as $k1 => $v1) {
                foreach ($all_fields as $k2 => $v2) {
                    if ($k1==$v2->table_column) {
                        $params[$v2->table_column]=$v1;
                    }
                }
            }
            
            if (isset($_REQUEST['create_user']) and !empty($_REQUEST['create_user'])) {
                if ( false == email_exists( $_REQUEST['email'] ) ) {
                    $full_name = trim($_REQUEST['first_name'].' '.$_REQUEST['last_name']);
                    if (!empty($full_name)) {
                        $random_password = wp_generate_password( 8, false );
                        $user_id = wp_insert_user([
                            'user_login'    =>$_REQUEST['email'],
                            'user_pass'     =>$random_password,
                            'user_email'    =>$_REQUEST['email'],
                            'display_name'  =>$full_name
                        ]);
                        \wpl_users::add_user_to_wpl($user_id);
                    }
                } else {
                    $user_id = get_user_by('email',$_REQUEST['email'])->ID;
                }
                $res['user_id'] = $user_id;
                $params['user_id'] = $user_id;
            }
            $params['owner'] = intval($_REQUEST['owner']) ?? $wpdb->get_row("SELECT setting_value FROM {$wpdb->base_prefix}wpl_settings WHERE setting_name = 'crm_lead_distributor'".(is_multisite() ? " AND blog_id='$blog_id'" : ''))->setting_value;
            
            $wpdb->insert("{$wpdb->base_prefix}wpl_addon_crm_contacts", $params);
            $id = $wpdb->insert_id;
            $res['contact_id']=$id;
            return ['status'=>'success', 'data'=>$res];
        },
        'permission_callback' => array( $this, 'permissionCheck' )
    )
);

/**
 * Add a Request
 **/
register_rest_route( $this->namespace, '/add-request', array(
        'methods'             => 'POST',
        'callback'            => function () {
            global $wpdb;
            $all_fields = $wpdb->get_results("SELECT * FROM {$wpdb->base_prefix}wpl_dbst WHERE `kind` = 3 AND `enabled` > 0 AND `table_name`='wpl_addon_crm_requests'");
            $params = [];
            foreach ($_REQUEST as $k1 => $v1) {
                foreach ($all_fields as $k2 => $v2) {
                    if ($k1==$v2->table_column) {
                        $params[$v2->table_column]=$v1;
                    }
                }
            }
            
            $wpdb->insert("{$wpdb->base_prefix}wpl_addon_crm_requests", $params);
            $id = $wpdb->insert_id;
            return ['status'=>'success', 'data'=>['request_id'=>$id]];
        },
        'permission_callback' => array( $this, 'permissionCheck' )
    )
);

/**
 * Add a Request
 **/
register_rest_route( $this->namespace, '/add-contact-request', array(
        'methods'             => 'POST',
        'callback'            => function () {
            global $wpdb;
            $headers = getallheaders();
            if (isset($headers['X-Blog-Id']) and !empty($headers['X-Blog-Id'])) $_REQUEST['blog_id'] = $headers['X-Blog-Id'];
            $res = [];
            $errors = [];
            if (!isset($_REQUEST['email']) or empty($_REQUEST['email'])) $errors[]='Field email is empty.';
            if (!isset($_REQUEST['first_name']) or empty($_REQUEST['first_name'])) $errors[]='Field first_name is empty.';
            if (!isset($_REQUEST['last_name']) or empty($_REQUEST['last_name'])) $errors[]='Field last_name is empty.';
            if (count($errors)) return ['errors'=>$errors];
            
            if (isset($_REQUEST['create_user']) and !empty($_REQUEST['create_user'])) {
                $full_name = trim($_REQUEST['first_name'].' '.$_REQUEST['last_name']);
                
                if ( false == email_exists( $_REQUEST['email'] ) ) {
                    $random_password = wp_generate_password( $length = 8, $include_standard_special_chars = false );
                    $user_id = wp_create_user( $_REQUEST['email'], $random_password, $_REQUEST['email'] );
                    wp_update_user( array( 'ID' => $user_id, 'display_name' => $full_name, 'user_nicename' => $full_name ) );
                } else {
                    $user_id = get_user_by('email',$_REQUEST['email'])->ID;
                }
                $res['user_id'] = $user_id;
            }
            
            $all_fields = $wpdb->get_results("SELECT * FROM {$wpdb->base_prefix}wpl_dbst WHERE `kind` = 3 AND `enabled` > 0 AND `table_name`='wpl_addon_crm_contacts'");
            $params = [];
            foreach ($_REQUEST as $k1 => $v1) {
                foreach ($all_fields as $k2 => $v2) {
                    if ($k1==$v2->table_column) {
                        $params[$v2->table_column]=$v1;
                    }
                }
            }
            $blog_id = (is_multisite() AND isset($_REQUEST['blog_id']) AND !empty($_REQUEST['blog_id'])) ? intval($_REQUEST['blog_id']) : '1';
            $params['owner'] = intval($_REQUEST['owner']) ?? $wpdb->get_row("SELECT setting_value FROM {$wpdb->base_prefix}wpl_settings WHERE setting_name = 'crm_lead_distributor'".(is_multisite() ? " AND blog_id='$blog_id'" : ''))->setting_value;
            $wpdb->insert("{$wpdb->base_prefix}wpl_addon_crm_contacts", array_merge($params,['user_id'=>$user_id ?? 0]));
            $cid = $wpdb->insert_id;
            
            $all_fields = $wpdb->get_results("SELECT * FROM {$wpdb->base_prefix}wpl_dbst WHERE `kind` = 3 AND `enabled` > 0 AND `table_name`='wpl_addon_crm_requests'");
            $params = [];
            foreach ($_REQUEST as $k1 => $v1) {
                foreach ($all_fields as $k2 => $v2) {
                    if ($k1==$v2->table_column) {
                        $params[$v2->table_column]=$v1;
                    }
                }
            }
            
            $params['cid'] = $cid;
            
            $wpdb->insert("{$wpdb->base_prefix}wpl_addon_crm_requests", $params);
            $id = $wpdb->insert_id;
            $res['request_id']=$id;
            $res['contact_id']=$cid;
            return ['status'=>'success', 'data'=>$res];
        },
        'permission_callback' => array( $this, 'permissionCheck' )
    )
);

/**
 * Add a Listing
 **/
register_rest_route( $this->namespace, '/add-listing', array(
        'methods'             => 'POST',
        'callback'            => function () {
            global $wpdb;
            $kind = isset($_REQUEST['kind']) ? $_REQUEST['kind'] : 0;
            $all_fields = $wpdb->get_results("SELECT * FROM {$wpdb->base_prefix}wpl_dbst WHERE `kind` = '$kind' AND `enabled` > 0 AND `table_name`='wpl_properties'");
            $params = [];
            foreach ($_REQUEST as $k1 => $v1) {
                foreach ($all_fields as $k2 => $v2) {
                    if ($k1==$v2->table_column) {
                        $params[$v2->table_column]=$v1;
                    }
                }
            }
            
            $wpdb->insert("{$wpdb->base_prefix}wpl_properties", $params);
            $id = $wpdb->insert_id;
            return ['status'=>'success', 'data'=>['property_id'=>$id]];
        },
        'permission_callback' => array( $this, 'permissionCheck' )
    )
);

/**
 * Add a Ticket
 **/
register_rest_route( $this->namespace, '/add-ticket', array(
        'methods'             => 'POST',
        'callback'            => function () {
            global $wpdb;
            if (isset($_REQUEST['contact_id']) and isset($_REQUEST['agent_id']) and !empty($_REQUEST['contact_id']) and !empty($_REQUEST['agent_id'])) {
                $tid = (new \wpl_addon_crm_ticket)->generate_tid();
                $result1 = $wpdb->insert("{$wpdb->base_prefix}wpl_addon_crm_tickets", array(
                        'tid'       =>$tid,
                        'cid'       =>$_REQUEST['contact_id'],
                        'owner'     =>$_REQUEST['agent_id'],
                        'archive'   =>isset($_REQUEST['archived']) ? 1 : '0',
                        'status'    =>isset($_REQUEST['status']) ? 1 : 0,
                        'subject'   =>$_REQUEST['subject'],
                        'priority'  =>isset($_REQUEST['priority']) ? $_REQUEST['priority'] : 3
                    )
                );
                $id = $wpdb->insert_id;
                $result2 = $wpdb->insert("{$wpdb->base_prefix}wpl_addon_crm_ticket_posts", array(
                        'tid'           =>$tid,
                        'message'       =>$_REQUEST['message'],
                        'sender'        =>0,
                        'attachments'   =>'',
                        'date_added'    =>current_time('mysql', 1),
                        'parsed'        =>0
                    )
                );
                if($result1 and $result2) {
                    return $wpdb->get_row("SELECT * FROM {$wpdb->base_prefix}wpl_addon_crm_tickets t INNER JOIN {$wpdb->base_prefix}wpl_addon_crm_ticket_posts tp ON t.id = tp.id WHERE t.id = '$id'");
                } else {
                    return array('errors'=>array('code'=>'add_ticket_failed','message'=>'adding the ticket failed'));
                }
            } else {
                $errors = [];
                if (!isset($_REQUEST['contact_id']) or empty($_REQUEST['contact_id'])) $errors[] = array('code'=>'empty_contact_id','message'=>'contact_id is required');
                if (!isset($_REQUEST['agent_id']) or empty($_REQUEST['agent_id'])) $errors[] = array('code'=>'empty_agent_id','message'=>'agent_id is required');
                // if (!isset($_REQUEST['archived']) or empty($_REQUEST['archived'])) $errors[] = array('code'=>'empty_archived','message'=>'archived is required');
                if (!isset($_REQUEST['status']) or empty($_REQUEST['status'])) $errors[] = array('code'=>'empty_status','message'=>'status is required');
                if (!isset($_REQUEST['priority']) or empty($_REQUEST['priority'])) $errors[] = array('code'=>'empty_priority','message'=>'priority is required');
                
                return array('errors'=>$errors);
            }
        },
        'permission_callback' => array( $this, 'permissionCheck' )
    )
);

/**
 * Add a WP User
 **/
register_rest_route( $this->namespace, '/add-wp-user', array(
        'methods'             => 'POST',
        'callback'            => function () {
            return add_wp_user($_REQUEST);
        },
        'permission_callback' => array( $this, 'permissionCheck' )
    )
);

/**
 * Add a User
 **/
register_rest_route( $this->namespace, '/add-user', array(
        'methods'             => 'POST',
        'callback'            => function () {
            @$email = $_REQUEST['user_email'];
            $user_id = null;
            
            if (email_exists( $email )) {
                $user = get_user_by('email',$email);
            } else {
                $user = add_wp_user($_REQUEST);
            }
            if ($user) {
                $user_id = $user->ID;
                \wpl_users::add_user_to_wpl($user_id);
                return \wpl_users::get_wpl_user($user_id);
            } else {
                return array('errors'=>array('code'=>'user_id_failed','message'=>'user not found'));
            }
        },
        'permission_callback' => array( $this, 'permissionCheck' )
    )
);