<?php


namespace Api\Wpl\routes\libs;


use Api\Wpl\models\business\License;
use Firebase\JWT\JWT;

class Auth {
    public $userId = null;

    function detectUser(\WP_REST_Request $request) {
//        $userId = get_current_user_id();
//        if(!empty($userId)) {
//            $user = get_user_by('ID', $userId);
//            $this->_checkUser($user);
//            $this->userId = $userId;
//            return;
//        }

        if (License::hasValidLicense()) {
            $accessToken = $request->get_param('access_token');
            if(empty($accessToken)) {
                $accessToken = $_SERVER['HTTP_AUTHORIZATION'];
                if($accessToken) {
                    list($accessToken) = sscanf($accessToken, 'Bearer %s');
                }
            }
        }
        $accessToken = trim($accessToken ?? '');

        if(empty($accessToken)) {
            $accessToken = $request->get_header('X-REALTYNA-INTERNAL-TOKEN');
            if($accessToken) {
                list($accessToken) = sscanf($accessToken, 'Bearer %s');
            }
        }

        if( empty( trim($accessToken ?? '') ) ) {
            return;
        }
        try {
            if(defined('SECRET_KEY_JWT')){
                $JWTSecret = SECRET_KEY_JWT;
            }else{
                $JWTSecret = NONCE_SALT;
            }
            $data = JWT::decode(
                $accessToken,
                $JWTSecret,
                array('HS256')
            );
            $userId = $data->data->user_id;
            if(!$userId){
                $userId = get_user_by('email', $data->data->email)->ID;
            }
        } catch (\Exception $e) {
            throw new \Exception('token is wrong');
        }

        $user = get_user_by('ID', $userId);
        $this->_checkUser($user);
        if($user) {
            $this->userId = $userId;
            set_current_user($this->userId);
        }
    }

    private function _checkUser($user) {
        if(empty($user)) {
            throw new \Exception('User not found');
        }
        if(empty($user->roles)) {
            throw new \Exception('User not found');
        }
    }

    public function getUserId() {
        return $this->userId;
    }

    public function isLoggedIn() {
        return !empty($this->userId);
    }

    public function isAdmin() {
        $user = get_user_by('ID', $this->getUserId());
        return !empty($user->allcaps['administrator']);
    }
}