<?php


namespace Api\Wpl\routes\api;


use Api\Wpl\routes\libs\Auth;
use Api\Wpl\routes\libs\AuthRequired;

class SearchApi extends Api
{
    public function addSearchAction($criteria, string $name, AuthRequired $auth)
    {
        if(!is_array($criteria)) {
            $criteria = json_decode(str_replace('\"', '"', $criteria ?? ''), true);
        }

        $query_string = 'wplpage=1&wplview=property_listing&wplpcc=map_box&wplpagination=normal&' . http_build_query($criteria);

        $full_url = \wpl_sef::get_wpl_permalink(true) ?? '';
        if (strpos($full_url, '?')) $url = "{$full_url}&{$query_string}";
        else $url = "{$full_url}?{$query_string}";

        $values = [];
        $values['name'] = $name;
        $values['alias'] = null;
        $values['kind'] = 0;
        $values['url'] = $url;
        $values['user_id'] = $auth->getUserId();
        $values['criteria'] = $criteria;

        if (!\wpl_global::check_addon('save_searches')) {
            $id = time() . '';
            $values['id'] = $id;
            add_option("wpl_api_save_search.{$auth->getUserId()}.{$id}", json_encode($values ?? ''), '', 'yes');
            return array(
                'message' => __('The search is saved successfully.', 'wpl-api')
            );
        }
        \_wpl_import('libraries.addon_save_searches');
        $save_searches = new \wpl_addon_save_searches();
        $save_searches->save($values);
        return array(
            'message' => __('The search is saved successfully.', 'wpl-api')
        );
    }

    public function searchListAction(AuthRequired $auth)
    {
        if (!\wpl_global::check_addon('save_searches')) {
            $query = "SELECT option_value FROM #__options where option_name LIKE 'wpl_api_save_search.{$auth->getUserId()}%'";
            $save_searches = \wpl_db::select($query, 'loadAssocList');
            $searches = [];
            foreach ($save_searches as $save_search) {
                $item = json_decode($save_search['option_value'] ?? '', true);
                if (!empty($item)) {
                    $item['id'] = $item['id'] . '';
                    $searches[] = $item;
                }
            }
        } else {
            \_wpl_import('libraries.addon_save_searches');
            $save_searches = new \wpl_addon_save_searches();
            $searches = $save_searches->get(null, $auth->getUserId());
        }

        $settings = get_option('wpl_api_map_options');
        foreach ($searches as &$search) {
            if(is_string($search['criteria']))
            {
                $search['criteria'] = json_decode($search['criteria'] ?? '', true);
            }
            if (empty($search['criteria']['latitude'])) {
                $search['criteria']['latitude'] = $settings['latitude'];
                $search['criteria']['longitude'] = $settings['longitude'];
                $search['criteria']['zoom'] = $settings['zoom'];
            }
        }
        return $searches;
    }

    public function filterAction(Auth $auth)
    {
        $widgetId = 1;
        $widgetInfo = get_option('widget_wpl_search_widget');
        $instance = $widgetInfo[$widgetId];
        $search = new \wpl_search_widget();
        $rendered = $search->render_search_fields($instance, $widgetId);
        $return = [];
        foreach ($rendered as $key => $field) {
            $searchOption = $instance['data'][$key];
            $type = $field['field_data']['type'];
            $options = [];
            $unit = '';

            if ($type == 'locations') {
                continue;
            }
            $minValue = 0;
            $maxValue = 1000000;
            $step = 10000;
            switch ($type) {
                case 'select':
                    foreach ($field['field_options']['params'] as $option) {
                        if ($option['enabled']) {
                            $options[] = [
                                'name' => __($option['value'], 'real-estate-listing-realtyna-wpl'),
                                'value' => $option['key'],
                            ];
                        }
                    }
                    break;
                case 'listings':
                    $listings = \wpl_global::get_listings();
                    $current_user = \wpl_users::get_wpl_user($auth->getUserId());
                    $availables = (isset($current_user->maccess_lrestrict_plisting) and $current_user->maccess_lrestrict_plisting and trim($current_user->maccess_listings_plisting ?? '', ', ') != '') ? explode(',', trim($current_user->maccess_listings_plisting ?? '', ', ')) : array();
                    foreach ($listings as $listing) {
                        // Skip if listing type is not allowed for this user
                        if (is_array($availables) and count($availables) and !in_array($listing['id'], $availables)) continue;
                        $options[] = [
                            'name' => __($listing['name'], 'real-estate-listing-realtyna-wpl'),
                            'value' => $listing['id'],
                        ];
                    }
                    break;
				case 'ptcategory':
					$field['field_data']['table_column'] = 'ptcategory';
					$categories = \wpl_property_types::get_property_type_categories();
                    foreach ($categories as $category) {
                        $options[] = [
                            'name' => $category['name'],
                            'value' => $category['name'],
                        ];
                    }
                    break;
                case 'price':
                    $unit = '$';
                case 'number':
                    $minMaxStep = explode(',', $field['search_options']);
                    if (!empty($minMaxStep[1])) {
                        $minValue = $minMaxStep[0];
                        $maxValue = $minMaxStep[1];
                        $step = $minMaxStep[2];
                    }
                    break;
                case 'feature' :
                    $featureOptions = json_decode($field['field_data']['options'] ?? '', true);
                    if (!empty($featureOptions['values'])) {
                        foreach ($featureOptions['values'] as $featureOption) {
                            if ($featureOption['enabled']) {
                                $options[] = [
                                    'name' => __($featureOption['value'], 'real-estate-listing-realtyna-wpl'),
                                    'value' => $featureOption['key'],
                                ];
                            }
                        }
                    }
                    break;
                case 'area':
                    $extoptions = explode(',', $searchOption['extoption']);
                    $min_value = $extoptions[0];
                    $max_value = $extoptions[1];
                    $division = $extoptions[2];
                    $default_unit_id = $extoptions[3];

                    $condition = '';
                    if ($default_unit_id) $condition .= " AND `id`='" . $default_unit_id . "'";

                    $units = \wpl_units::get_units(2, 1, $condition);
                    $unit = count($units) == 1 ? $units[0]['name'] : '';
                    $minValue = $min_value;
                    $maxValue = $max_value;
                    $step = $division;
                    break;
                case 'property_types':
                    $property_types = \wpl_global::get_property_types();

                    foreach ($property_types as $property_type) {
                        $options[] = [
                            'name' => __($property_type['name'], 'real-estate-listing-realtyna-wpl'),
                            'value' => $property_type['id'],
                        ];
                    }
            }
            $show_type = $searchOption['type'];

            if(empty($show_type)) {
                $show_type = $type;
            }
            if($show_type == 'checkbox') {
                $show_type = 'checkboxes';
            }
            if($show_type == 'option_multiple') {
                $show_type = 'checkboxes';
            }
            $return[] = [
                'name' => $field['field_data']['name'],
                'show_type' => $show_type,
                'type' => $type,
                'unit' => $unit,
                'min' => intval($minValue),
                'max' => intval($maxValue),
                'step' => intval($step),
                'key' => $field['field_data']['table_column'],
                'options' => $options,
            ];
        }

        return $return;
    }

    public function removeSaveSearchAction(AuthRequired $auth, int $search_id)
    {
        if (!\wpl_global::check_addon('save_searches')) {
            delete_option("wpl_api_save_search.{$auth->getUserId()}.{$search_id}");
            return array(
                'message' => __('Saved search is removed successfully.', 'wpl-api')
            );
        }
        \_wpl_import('libraries.addon_save_searches');
        $save_searches = new \wpl_addon_save_searches();
        $search = $save_searches->get($search_id);
        if (empty($search) || $search['user_id'] != $auth->getUserId()) {
            throw new \Exception('Save search could be found.');
        }
        $result = $save_searches->delete($search_id);
        if (!$result) {
            throw new \Exception('Save search could be found.');
        }
        return array(
            'message' => __('Saved search is removed successfully.', 'wpl-api')
        );
    }

    public function saveSearchListAction(\WP_REST_Request $request)
    {
        _wpl_import('libraries.addon_save_searches');
        $user_id = $request['id'] ?? '';

        $user_id = trim($user_id) ? $user_id : \wpl_users::get_cur_user_id();

        $query = "SELECT * FROM `#__wpl_addon_save_searches` WHERE `user_id`='$user_id' ORDER BY `creation_date` DESC";
        return \wpl_db::select($query, 'loadAssocList');
    }
}
