<?php


namespace Api\Wpl\routes\api;

use Api\Wpl\routes\libs\Auth;
use Api\Wpl\routes\libs\AuthAdmin;
use Api\Wpl\routes\libs\AuthRequired;

class Api {
    static function runAction($api, $action, $defaults, \WP_REST_Request $request) {
        $apiInstance = new $api;
        try {
            if(!empty($_GET['debug']) && $_GET['debug'] == 'WPL_ENABLE_DEBUG') {
                error_reporting(E_ALL);
                ini_set('display_errors', 1);
            }
            if(!method_exists($apiInstance, $action)) {
                throw new \Exception('method not found');
            }
            $_POST = $request->get_params();
            $_REQUEST = $request->get_params();

            $parameters = self::getParameters($api, $action);
            $arguments = [];
            foreach ($parameters as $parameter) {
                $name = $parameter['name'];
                $type = $parameter['type'];
                $allowsNull = $parameter['allowsNull'];
                if($type == 'WP_REST_Request') {
                    $value = $request;
                } elseif(strpos($parameter['type'] ?? '', '\Auth') !== false) {


                    /** @var Auth $auth */
                    $auth = new $parameter['type']();
                    $auth->detectUser($request);
                    if(!$auth->isLoggedIn() && (strpos($parameter['type'] ?? '', '\AuthRequired') > 0 || strpos($parameter['type'] ?? '', '\AuthAdmin') > 0)) {
                        throw new \Exception('access token required');
                    }

                    if(strpos($parameter['type'] ?? '', '\AuthAdmin') !== false && !$auth->isAdmin()) {
                        throw new \Exception('permission denied');
                    }
                    $value = $auth;
                } else {
                    $value = $request->get_param($name);
                }

                if($value === null && array_key_exists($name, $defaults)) {
                    $value = $defaults[$name];
                }

                if($value === null && !$allowsNull) {
                    throw new \Exception("parameter '$name' is required");
                }
                if($type == 'int' && $value !== null && !is_numeric($value)) {
                    throw new \Exception("parameter '$name' should be numeric");
                }
                if(is_string($value)) {
                    $value = trim($value);
                }
                $arguments[$name] = $value;
            }
            static::detectBlog();
            $response = call_user_func_array([$apiInstance, $action], $arguments);
            // convert object to array
            $data = json_decode(json_encode(static::formatResponse($response) ?? '', JSON_INVALID_UTF8_IGNORE), true);
            return [
                'success' => true,
                'data' => $data,
            ];
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'data' => [
                    'code' => 'rest_wpl_error',
                    'message' => $exception->getMessage(),
                ],
            ];
        }
    }

    static function detectBlog() {
        $blog_id = @$_SERVER['HTTP_X_BLOG_ID'];

        if(empty($blog_id)) {
            return;
        }
        $row = \wpl_db::select("SELECT * FROM `#__franchise_level` where website_status = 'true' and blog_id = $blog_id;", 'loadAssoc');
        if(!empty($row)) {
            switch_to_blog((int)$blog_id);
        }
    }

    static function getParameters($api, $action) {
        $method = (new \ReflectionClass($api))->getMethod($action);
        $doc = $method->getDocComment();
        $return = [];
        $matches = [];
        preg_match_all('/@param(.*)/', $doc, $matches);
        foreach ($matches[1] as $param) {
            $param = trim($param ?? '');
            $param = explode(' ', $param);
            $type = array_shift($param) ?? '';
            if(strpos($type, '$') === 0) {
                $name = $type;
                $type = null;
            } else {
                $name = array_shift($param);
            }
            $name = str_replace('$', '', $name);
            $description = implode(' ', $param);
            $allowsNull = substr($type, 0, 1) === '?';
            $return[$name] = compact('type', 'name', 'description', 'allowsNull');
        }
        $parameters = $method->getParameters();
        foreach ($parameters as $parameter) {
            $type = $parameter->getType();
            $name = $parameter->getName();
            if(!empty($type)) {
                $type = $type->getName();
            }
            if(!empty($return[$name])) {
                $return[$name]['type'] = empty($type) ? $return[$name]['type'] : $type;
            } else {
                $return[$name] = [
                    'type' => empty($type) ? null : $type,
                    'name' => $parameter->getName(),
                    'allowsNull' => $parameter->allowsNull(),
                ];
            }
        }
        return $return;
    }

    static function formatResponse($response) {
        // have empty object in json
        if(is_object($response) && empty($response)) {
            return $response;
        }
        if(is_array($response)) {
            foreach ($response as $key => $value) {
                $response[$key] = static::formatResponse($value);
            }
        }
        if($response === null) {
            $response = '';
        }
        return $response;
    }
}