<?php

namespace Api\Wpl\responses;

class Error {

    /**
     * @var array
     * Mapping of status codes to reason phrases
     */
    static protected $API_STATUS_TEXTS = array(

        'registration' => array(
            1 => 'The Email is already registered. Try a different Email address.',
            2 => 'Some or all of required filed entries are invalid.',
            3 => 'password and the repeat are not matching.',
            4 => 'Phone number is wrong.'
        ),
        'auth' => array(
            1 => 'Authentication failed.',
            2 => 'JWT is not configurated properly',
            3 => 'Signature verification failed. Please generate token first.'
        ),
        'common' => array(
            1 => 'No property could be found.',
            2 => 'Properties Types could not be found',
            3 => 'Something went wrong with SQL query',
            4 => 'Sorry something went wrong',
            5 => 'User id does not exist.',
            6 => 'No Saved Search could be found.',
            7 => 'No Sort Options could be found.'
        ),
    );

    static public function handler(
        $value,
        $key,
        $status = 200
    ) {
        $return = array(
            'message' => self::$API_STATUS_TEXTS[$value][$key]
        );
        wp_send_json_error(
            $return,$status
        );
    }
}