<?php

namespace Api\Wpl\models\imported\Twilio;

class Sms {

    /* @var int this holds value of User ID */
    protected $UserId;

    /* @var string this holds value of Phone number */
    protected $PhoneNumber = "";

    /**
     * Set The User Id
     * @param $UserId
     */
    public function SetUserId($UserId) {
        $this->UserId = $UserId;
    }

    /**
     * Set The user Phone number
     * @param $PhoneNumber
     */
    public function SetPhoneNumber($PhoneNumber) {
        $this->PhoneNumber = $PhoneNumber;
    }

    /**
     * Send the SMS code using Twilio
     */
    public function send() {

        $SmsCode = $this->getSmsCode($this->UserId);

        if ($this->getTwlOptions() != false) {

            try {

                $TwlOptions = $this->getTwlOptions();
                $client = new \Twilio\Rest\Client($TwlOptions['AccountSID'], $TwlOptions['TokenID']);

                $message = $client->messages->create(
                    $this->PhoneNumber, // Text this number
                    array(
                        'from' => $TwlOptions['SenderNumber'], // From a valid Twilio number
                        'body' => "SMS Code: {$SmsCode['sms_code']}"
                    )
                );

                wp_send_json_success(array(
                    'message' => 'Sms Code sent successfully.'
                ));

            } catch (\Exception $e) {
                $this->deleteSmsCode($this->UserId);
                wp_send_json_error( array(
                    'message' => $e->getMessage())
                );
            }
        }

        $this->deleteSmsCode($this->UserId);
        wp_send_json_error(array('message' => 'Twilio is not configurated properly.'));
    }

    /**
     * Get The Sms Code from Option table
     */
    protected function getSmsCode($userid) {
        return (get_option("sms_code_{$userid}"))
            ? get_option("sms_code_{$userid}")
            : wp_send_json_error(array(
                'message' => 'SMS code is wrong, please try password reset again.')
            );
    }

    /**
     * Get saved options
     * @return array of saved options
     */
    protected function getTwlOptions() {
        return (get_option('wpl_api_sms_settings'))
            ? get_option('wpl_api_sms_settings')
            : false;
    }

    /**
     * Deletes sms code into the option table by user id
     * @param $userid
     */
    protected function deleteSmsCode($userid) {
        return delete_option("sms_code_{$userid}");
    }
}