<?php

namespace Api\Wpl\models\imported\Twilio;

class Settings {

    /* @var string Account SID */
    protected $AccountSID = "";

    /* @var string Token ID */
    protected $TokenID = "";

    /* @var string number of sender */
    protected $SenderNumber = "";

    /**
     * Set The Twilio Account SID
     * @param $sid
     */
    public function setAccountSID($sid) {
        $this->AccountSID = $sid;
    }

    /**
     * Set The Twilio Token ID
     * @param $token
     */
    public function setTokenID($token) {
        $this->TokenID = $token;
    }

    /**
     * Set The Twilio Sender Number
     * @param $number
     */
    public function setSenderNumber($number) {
        $this->SenderNumber = $number;
    }

    /**
     * Deletes the twilio settings into the option table
     * @return mixed
     */
    public function delete() {
    	
        // if option is successfully deleted
        if (delete_option('wpl_api_sms_settings')) {
            wp_send_json_success(array(
            	'message' => 'SMS settings are reset successfully.')
            );
        }
        
        wp_send_json_error(array(
        	'message' => 'SMS settings is not registered yet.')
        );
    }

    /**
     * Save The Twilio Settings into the option table
     */
    public function save() {

    	//  if the option exist
        if (get_option('wpl_api_sms_settings')) {
            wp_send_json_error(array(
            	'message' => 'Sms settings already registered.')
            );
        }

        $settings = array(
            'AccountSID'   => $this->AccountSID,
            'TokenID'      => $this->TokenID,
            'SenderNumber' => $this->SenderNumber
        );

        //  if the option does not exist
        if (add_option( 'wpl_api_sms_settings', $settings, '', 'yes' ) != false) {
            wp_send_json_success(array(
            	'message' => 'SMS Settings are saves successfully.')
            );
        }

    }
}