<?php

namespace Api\Wpl\models\imported\Notifications;

class OneSignalSetting {

    /**
     * @var string
     */
    private $appId = '';

    /**
     * @var string
     */
    private $AuthKey = '';

    /**
     * @var array
     */
    private $content = ["en" => 'A new property is added'];

    /**
     * @var array
     */
    private $headings = ["en" => 'New Property'];

    /**
     * @param array $request
     */
    public function __construct($request = false) {

        if ($request) {
            $this->appId   = $request->get_param('appId');
            $this->AuthKey = $request->get_param('AuthKey');
        }
    }

    public function save() {

        $settings = array(
            'appId'    => $this->appId,
            'AuthKey'  => $this->AuthKey,
            'content'  => $this->content,
            'headings' => $this->headings
        );

        if (update_option( 'wpl_api_onesignal_options', $settings, '', 'yes' ) == true) {
            wp_send_json_success(array(
                'message' => 'OneSignal Settings are saved successfully.')
            );
        }

        wp_send_json_error(array(
            'message' => 'The record already exists. Please modify your entry.')
        );
    }

    public function getSettings() {

        $settings = get_option('wpl_api_onesignal_options');
        ($settings)
            ? wp_send_json_success($settings)
            : wp_send_json_error(array('message' => 'First you should save OneSignal settings.'));
    }
}