<?php

namespace Api\Wpl\models\imported\Notifications;

class OneSignalHttpConnection {

    /**
     * @var string
     */
    private $apiUrl = 'https://onesignal.com/api/v1/notifications';

    /**
     * @var string
     */
    private $userAgent = 'REALTYNA REST API';

    /**
     * @var int
     */
    private $timeout = 30;

    public function __construct() {

        if (!function_exists("curl_init")) {
            wp_send_json_error(array(
                'message' => 'Curl module is not available on this system')
            );
        }
    }

    public function curlRequest($postData = array(), $authKey) {

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_URL, $this->apiUrl);
        curl_setopt($ch, CURLOPT_REFERER, '');
        curl_setopt($ch, CURLOPT_USERAGENT, $this->userAgent);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        if(!empty($postData)) {

            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, (is_array($postData))
                ? http_build_query($postData)
                : $postData
            );
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

        }

        curl_setopt($ch, CURLOPT_TIMEOUT, $this->timeout);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json; charset=utf-8',
                'Authorization: Basic '.$authKey.'')
        );
        $output = curl_exec($ch);
        curl_close($ch);

        return $output;
    }
}