<?php

namespace Api\Wpl\models\imported\Notifications;

use Api\Wpl\models\core\Database\Database;
use Api\Wpl\models\AbstractModel;

class CronManager extends AbstractModel {

    public function everyMinuteAction() {

        foreach ((new Config())->tasks() as $taskName => $taskParams) {

            if ($this->timeMatches($taskParams)) {
                $functionName = $taskName."Task";
                $this->$functionName();
            }
        }
    }

    /**
     * @param $str
     * @return bool
     */
    protected function timeMatches($str) {

        list($minute, $hour, $day, $month) = explode(" ", $str);

        if($this->timeNumbersMatch($minute, intval(date("i"))) ||
            $this->timeNumbersMatch($hour, intval(date("H"))) ||
            $this->timeNumbersMatch($day, intval(date("d"))) ||
            $this->timeNumbersMatch($month, intval(date("m")))
        ) {
            return true;
        }

        return false;   
    }

    /**
     * @param $str
     * @param $current
     * @return bool
     */
    protected function timeNumbersMatch($str, $current) {

        if (substr($str ?? '', 0, 2) == "1/") {
            return $current % substr($str, 2) == 0;
        }

        if (strpos($str ?? '', ",") !== false) {
            return $current % substr($str, 2) == 0;
        }

        if ($str == "*") {
            return true;
        }

        return intval($str) == $current;
    }

    protected function pushNotificationTask() {

        $query  = "SELECT id FROM {$this->wpdb->base_prefix}wpl_properties ";
        $query .= "WHERE add_date > NOW() - INTERVAL 1 MINUTE AND add_date < NOW()  and finalized = 1 and expired = 0 and kind = 0 and deleted = 0";

        $rows = Database::getRows(
            $query
        );

        $settings = get_option(
            'wpl_api_onesignal_options'
        );

        if ($rows) {

            foreach ($rows as $row) {

                $content  = ["en" => $settings['content']['en']];
                $headings = ["en" => $settings['headings']['en']];

                $fields = [
                    'app_id' => $settings['appId'],
                    'included_segments' => array('All'),
                    'data' => array(
                        "body"      => $settings['content']['en'],
                        "title"     => $settings['headings']['en'],
                        'listingId' => $row['id']
                    ),
                    'contents' => $content,
                    'headings' => $headings
                ];

                $oneSignal = new OneSignalHttpConnection();
                $oneSignal->curlRequest(json_encode($fields ?? ''), $settings['AuthKey']);
            }
        } else {
            wp_send_json_error();
        }
    }
}