<?php

namespace Api\Wpl\models\imported\Map;

class Settings {

    /* @var string this holds value of latitude */
    protected $latitude = "";

    /* @var string this holds value of longitude */
    protected $longitude = "";

    /* @var string this holds value of zoom level */
    protected $zoom = "";

    /**
     * Set the Latitude
     * @param $lat
     */
    public function setLatitude($lat) {
        $this->latitude = $lat;
    }

    /**
     * Set the Longitude
     * @param $lng
     */
    public function setLongitude($lng) {
        $this->longitude = $lng;
    }

    /**
     * Set the zoom level
     * @param $zoomLevel
     */
    public function setZoom($zoomLevel) {
        $this->zoom = $zoomLevel;
    }

    /**
     * Save the map settings into the option table
     */
    public function save() {

        $settings = array(
            'latitude'  => $this->latitude,
            'longitude' => $this->longitude,
            'zoom'      => $this->zoom
        );

        if (update_option( 'wpl_api_map_options', $settings, '', 'yes' ) == true) {
            wp_send_json_success(array(
            	'message' => 'Map Settings are saved successfully.')
            );
        }

        wp_send_json_error(array(
        	'message' => 'The record already exists. Please modify your entry.')
        );
    }
}