<?php

namespace Api\Wpl\models\imported\Idx;

class Idx {

	/**
	 * @var string
	 */
	private $apiUrl = 'https://idx.realtyfeed.com/listings/';

	/**
	 * @var string
	 */
	private $AuthToken = '';

	/**
	 * @param array $request
	 */
	public function __construct( $request = false ) {

		if ( $request ) {
			$this->AuthToken = $request->get_param( 'token' );
		}
	}

	public function save() {

		$settings = array(
			'token'         => $this->AuthToken,
			'last_page_num' => 0
		);
		if ( update_option( 'wpl_api_idx_options', $settings, '', 'yes' ) == true ) {
			wp_send_json_success( array(
					'message' => 'IDx Settings are saved successfully.'
				)
			);
		}
		wp_send_json_error( array(
				'message' => 'The record already exists. Please modify your entry.'
			)
		);
	}

	public function import() {

		$idx = get_option( 'wpl_api_idx_options' );

		if ( $idx ) {
			try {
				$args = array(
					'timeout' => 120,
					'headers' => array( 'Authorization' => 'Token ' . $idx['token'] )
				);
				if ( $idx['last_page_num'] == false ) {
					$url      = $this->apiUrl;
					$response = wp_remote_get( $url, $args );
				} else {
					$url      = $this->apiUrl . '?page=' . $idx['last_page_num'];
					$response = wp_remote_get( $url, $args );
				}
				if ( wp_remote_retrieve_response_code( $response ) == 200 ) {
					$options = array(
						'token'         => $idx['token'],
						'last_page_num' => $idx['last_page_num'] + 1
					);
					update_option( 'wpl_api_idx_options', $options );

					wp_send_json_success( array(
						'lastImprotedPageNum' => "{$idx['last_page_num']}"
					) );
				}
				wp_send_json_error( wp_remote_retrieve_body( $response ) );
			} catch ( \Exception $e ) {
				wp_send_json_error( array(
						'message' => $e->getMessage()
					)
				);
			}
		}
		wp_send_json_error( array(
				'message' => 'IDX option does not exist'
			)
		);
	}
}