<?php

namespace Api\Wpl\models\imported\Email;

use Api\Wpl\models\core\Database\Database as DB;
use Api\Wpl\models\AbstractModel;

class Sender extends AbstractModel {

	public function     sendEmail( $request ) {

		$url     = $this->getListingUrl(
			$request->get_param( 'listing_id' )
		);
		$message  = "There is a new request for info about a listing.\r\n";
		$message .= " \r\n";
		$message .= "Listing: $url \r\n";
		$message .= " \r\n";
		$message .= "Full Name: {$request->get_param('user')} \r\n";
		$message .= "Phone Number: {$request->get_param('phone')} \r\n";
		$message .= "Email: {$request->get_param('email')} \r\n";
		$message .= " \r\n";
		$message .= "Message: {$request->get_param('text')}";

		$mail = new Email();
		$mail->setUser( $request->get_param( 'user' ) );
		$mail->setEmailFrom( $request->get_param( 'email' ) );
		$mail->setEmailTo( $request->get_param( 'agent_email' ) );
		$mail->setSubject( 'New Listing Information Request' );
		$mail->setMessage( $message );
		$mail->send();
	}

	/**
	 * @param $listingId
	 *
	 * @return string
	 */
	protected function getListingUrl( $listingId ) {

		$alias = DB::getRow(
			"SELECT alias 
               FROM {$this->wpdb->base_prefix}wpl_properties 
             WHERE id = ?", $listingId
		);

		return ( $alias )
			? get_site_url() . '/properties/' . $listingId . '-' . $alias['alias']
			: get_site_url();
	}
}
