<?php

namespace Api\Wpl\models\imported\Email;

class Email {

	/* @var string this holds the full name of receiver */
	protected $fullName = "";

	/* @var string this holds the text message to send */
	protected $message = "";

	/* @var string this holds value of replay email */
	protected $replayTo = "";

	/* @var string this holds value of header email address */
	protected $emailFrom = "";

	/* @var string this holds value of agent email address */
	protected $emailTo = "";

	/* @var string */
	protected $subject = "";

	/**
	 * Here we set the user that should receive the msg.
	 *
	 * @param User $user
	 *
	 * @return void
	 */
	public function setUser( $user ) {
		$this->fullName = $user;
	}

	/**
	 * set email from address
	 *
	 * @param $emailFrom
	 *
	 * @return void
	 */
	public function setEmailFrom( $emailFrom ) {
		$this->replayTo = $emailFrom;
	}

	/**
	 * This sets the message that will be sent.
	 * @return void
	 */
	public function setMessage( $data ) {
		$this->message = $data;
	}

	/**
	 * set Agent email address which will receive the message
	 *
	 * @param $to
	 */
	public function setEmailTo( $to ) {
		$this->emailTo = $to;
	}

	/**
	 * @param $subj
	 */
	public function setSubject( $subj ) {
		$this->subject = $subj;
	}

	/**
	 * Call mailer
	 * @return void
	 */
	public function send() {
		$this->sendWithPHPMailer();
	}

	/**
	 * Save the SMTP settings into the option table
	 *
	 * @param $request
	 */
	public function SaveSmtpSettings( $request ) {

		$smtpSettings = array(
			'smtpHost'     => $request->get_param( 'smtpHost' ),
			'smtpPort'     => $request->get_param( 'smtpPort' ),
			'smtpSecure'   => $request->get_param( 'smtpSecure' ),
			'smtpUsername' => $request->get_param( 'smtpUsername' ),
			'smtpPassword' => $request->get_param( 'smtpPassword' )
		);
		if ( update_option( 'wpl_api_smtp_setting', $smtpSettings ) ) {
			wp_send_json_success( array(
					'message' => 'SMTP Settings are saves successfully.'
				)
			);
		}
		wp_send_json_error( array(
				'message' => 'The record already exists. Please modify your entry.'
			)
		);

	}

	/**
	 * Get the SMTP settings
	 */
	public function GetSmtpSettings() {

		if ( $this->checkSmtpRemote() ) {
			wp_send_json_success( get_option( 'wpl_api_smtp_setting' ) );
		}
		wp_send_json_error( array(
				'message' => 'The record does not exists.'
			)
		);
	}

	/**
	 * Check the SMTP settings
	 * @return bool
	 */
	protected function checkSmtpRemote() {

		return ( get_option( 'wpl_api_smtp_setting' ) )
			? true
			: false;
	}

	/**
	 * Get the SMTP setting from the option table
	 * @return array
	 */
	protected function getSmtpSetting() {

		$settings = get_option( 'wpl_api_smtp_setting' );

		$smtp = array(
			'smtpHost'     => $settings['smtpHost'], // SMTP servers
			'smtpPort'     => $settings['smtpPort'], // SMTP port
			'smtpSecure'   => $settings['smtpSecure'], // Encryption type
			'smtpUsername' => $settings['smtpUsername'], // SMTP username
			'smtpPassword' => $settings['smtpPassword'], // SMTP password
		);

		return $smtp;
	}

	/**
	 * Function that actually sends email using PHPMailer
	 */
	protected function sendWithPHPMailer() {

		//create instance of library class PHPMailer
		$mail = new \PHPMailer();

		//add repay address to PHPMailer object
		if ( $this->replayTo != '' ) {
			$mail->AddReplyTo( $this->replayTo );
		}
		if ( $this->emailFrom != '' ) {
			$mail->setFrom( $this->emailFrom );
		}
		//set good charset
		$mail->CharSet = 'UTF-8';

		//in case remote smtp is set, authenticate remotely
		if ( $this->checkSmtpRemote() ) {

			// get the smtp settings
			$mailSettings = $this->getSmtpSetting();
			$mail->isSMTP(); // Set mailer to use SMTP
			$mail->Host       = $mailSettings['smtpHost']; // Specify main and backup SMTP servers
			$mail->SMTPAuth   = true; // Enable SMTP authentication
			$mail->Username   = $mailSettings['smtpUsername']; // SMTP username
			$mail->Password   = $mailSettings['smtpPassword']; // SMTP password
			$mail->SMTPSecure = $mailSettings['smtpSecure']; // Enable TLS encryption, `ssl` also accepted
			$mail->Port       = $mailSettings['smtpPort'];
			$mail->setFrom( $mailSettings['smtpUsername'] );
			$mail->addAddress( $this->emailTo ); // set the target
			$mail->Subject = $this->subject;  //set the topic
			$mail->Body    = $this->message; //set the message from class variable

			if ( ! $mail->send() ) {
				wp_send_json_error( array(
						'message' => 'Message could not be sent.',
						'reason'  => $mail->ErrorInfo
					)
				);
			} else {
				wp_send_json_success( array(
						'message' => 'Message has been sent.'
					)
				);
			}
		}

		wp_send_json_error( array(
				'message' => 'Message could not be sent.',
				'reason'  => 'Fist you should configure SMTP.'
			)
		);
	}
}
