<?php

namespace Api\Wpl\models\core\User;

use Api\Wpl\models\AbstractModel;
use Api\Wpl\models\core\Auth\Auth;
use Api\Wpl\models\core\Database\Database as DB;

class Wpluser extends AbstractModel {

  /*
  * @var string
  */
  public function getList() {

      $query  = "SELECT id,first_name,last_name,company_name,company_address,website,main_email,sex,tel,fax,mobile,zip_id ";
      $query .= "FROM {$this->wpdb->base_prefix}wpl_users WHERE id >= ?";

      $wplUserData = DB::getRows(
          $query,array(1)
      );
  
     wp_send_json(array_reverse($wplUserData));
     
  }
    
  /*
  * @desc Get username for zapier auth
  */
  public function getUserData () {

       $userId = (new Auth)->getUserIdByToken();
       
       $username = DB::getRow("SELECT user_login FROM ".$this->wpdb->base_prefix."users WHERE id = ?", 
          array($userId)
       );
      
       wp_send_json( array(
          'status'   => 'Success',
          'username' => $username['user_login']
       ));
  }
  
  public function getCRMContacts()
  {
      // Check if CRM is addon is Installed
      if (false == $this->addonExists('crm')) {
          
          wp_send_json_error(
             array(
                 'message' => 'CRM addon is not installed in WPL, please install it first'
           ),404 );
      }
      
      // Get CRM contacts
      $query = DB::getRows("SELECT id,first_name,last_name,email,tel FROM {$this->wpdb->base_prefix}wpl_addon_crm_contacts WHERE id >= ?",0);
      
      return (!$query) ?
        wp_send_json_error(array(
          'message'=> 'No CRM Contact found'
          ),404) :
       wp_send_json(array_reverse($query));
      
  }
  
  protected function addonExists($addon)
  {
      
      if (empty($addon) || !is_string($addon)) {
          return false;
      }
      
      $queryResult =  DB::getRow("SELECT id FROM {$this->wpdb->base_prefix}wpl_addons WHERE addon_name = ?",$addon);

      return (false == $queryResult || !is_array($queryResult)) ? false : true;
      
  }
}