<?php

namespace Api\Wpl\models\core\User;

class UserChangePassword {

    /**
     * @var string
     */
    private $email;

    /**
     * @var string
     */
    private $sms_code;

    /**
     * @var string
     */
    private $password;

    /**
     * @var string
     */
    private $re_password;

    /**
     * @param array $request
     */
    public function __construct(array $request) {

        $this->email       = $request['email'];
        $this->sms_code    = $request['code'];
        $this->password    = $request['password'];
        $this->re_password = $request['re-password'];

    }

    /**
     * @return bool
     */
    public function validateData() {

        $user = $this->GetUserByEmail();

        if ($user != false) {

            $options = $this->getSmsCodeByUserId($user->ID);

            if ($this->sms_code != $options['sms_code']) {
                wp_send_json_error(array(
                    'message' => __('Sms Code is incorrect.', 'wpl-api') )
                );
            }

            if ($this->password != $this->re_password) {
                wp_send_json_error(array(
                    'message' => __('password and the repeat are not matching.', 'wpl-api') )
                );
            }

            if ($options['user_id'] == $user->ID) {
                return true;
            }

            return false;
        }

        wp_send_json_error(array(
            'message' => __('Email does not exist.', 'wpl-api') )
        );
    }

    public function updatePassword() {

        $user = $this->GetUserByEmail();

        wp_set_password( $this->password, $user->ID);
        // delete sms code
        delete_option("sms_code_{$user->ID}");

        wp_send_json_success(array(
            'message' => __('Password changed successfully.', 'wpl-api')
        ));
    }

    protected function GetUserByEmail() {
        return get_user_by('email', $this->email);
    }

    protected function getSmsCodeByUserId($UserId) {
        $sms_options = get_option("sms_code_{$UserId}");
        return $sms_options;
    }
}