<?php

namespace Api\Wpl\models\core\User;

class UserAuth {

    /**
     * @var bool
     */
    private $remember;

    /**
     * @var string
     */
    private $email;

    /**
     * @var string
     */
    private $password;

    public function __construct(array $request) {

        $this->remember = (isset($request['remember'])) ? true : false;
        $this->email = $request['email'];
        $this->password = $request['password'];;
    }

    public function signOn() {
        global $wpdb;
        $authData = array(
            'user_login'    => $this->email,
            'user_password' => $this->password,
            'remember'      => $this->remember
        );

        // disable event
        \wpl_events::$wpl_events = array();
        $user = wp_signon( $authData, false );

        if ( is_wp_error($user) ) {
            wp_send_json_error(array(
                'message' => __('Authentication failed.', 'wpl-api') )
            );
        }

        wp_set_current_user($user->ID, $authData);
        wp_set_auth_cookie($user->ID, $remember, false);

        $user = wp_get_current_user();


        $wpl_user = $wpdb->get_row("SELECT * FROM {$wpdb->base_prefix}wpl_users WHERE id = '".$user->ID."'",ARRAY_A);

        $first_name = (isset($wpl_user['first_name']) and !empty(isset($wpl_user['first_name']))) ? $wpl_user['first_name'] : get_user_meta($user->ID,'first_name',true);
        $last_name = (isset($wpl_user['last_name']) and !empty(isset($wpl_user['last_name']))) ? $wpl_user['last_name'] : get_user_meta($user->ID,'last_name',true);
        $tel = (isset($wpl_user['tel']) and !empty(isset($wpl_user['tel']))) ? $wpl_user['tel'] : get_user_meta($user->ID,'phone_number',true);

if(\wpl_global::check_addon('crm')) {
        \_wpl_import('libraries.event_handlers.addon_crm');

        \wpl_events_crm::user_login(array(
            array(
                'user_id' => $user->ID,
                'params' => array('device' => 'mobile')
            ),
        ));
}
        wp_send_json_success(array(
            'message'  => __('Authentication passed successfully.', 'wpl-api'),
            'user_id'  => get_current_user_id(),
            'name'  => $first_name . ($last_name ? ' ' . $last_name : ''),
            'first_name'  => $first_name,
            'last_name'  => $last_name,
            'email'  => $user->user_email,
            'username' => $user->user_login,
            'profile_image'  => $wpl_user['profile_picture'] ? get_site_url() . "/wp-content/uploads/WPL/users/" . $wpl_user['id'] . "/" . $wpl_user['profile_picture'] : '',
            'phone'  => $tel,
            'is_admin' => ($user->allcaps['administrator']) ? true : false
        ));

    }
}