<?php

namespace Api\Wpl\models\core\Settings;

use Api\Wpl\models\core\Database\Database;

class SettingBuilder
{

    public function AddItems()
    {
        $items = array(
            $this->AddListingType(),
            $this->AddPropertyType(),
            $this->AddPricePeriod(),
            $this->AddBedRoom(),
            $this->AddBathRoom(),
            array(
                'name' => __('Price Range', 'wpl-api'),
                'type' => 'Input',
                'key' => 'price',
                'placeholders' => array(
                    'min', 'max'
                )
            ),
            array(
                'name' => __('Living Area (Sqft)', 'wpl-api'),
                'type' => 'Input',
                'key' => 'sqft',
                'placeholders' => array(
                    'min', 'max'
                )
            ),
            /*            array(
                            'name' => __('Keywords', 'wpl-api'),
                            'type' => 'Input',
                            'key'  => 'keywords',
                            'placeholders' => array("")
                        ),*/
            $this->AddTags('tags'),
            $this->AddNeighborHood('neighborhood'),
            $this->AddAppliances('feature'),
            $this->AddFeatures('feature')
        );

        $this->items = $items;
        return $this;
    }

    public function build()
    {
        return wp_send_json_success($this);
    }

    ################### protected functions ###################


    protected function AddListingType()
    {
        $types = Database::getRows(
            "select id,name, parent
               from {$this->GlobalSetting()}wpl_listing_types 
              where enabled = ?", true
        );
        $Listingtypes = $this->DefaultResponse(0);
        $Listingtypes ['results'][] = $this->DefaultTypes(0);
        foreach ($types as $type) {

            // array of listing types
            $Listingtypes ['results'][] = array(
                'id' => $type['id'],
                'parent' => $type['parent'],
                'type' => __($type['name'], 'wpl-api')
            );
        }
        return $Listingtypes;
    }

    protected function AddPropertyType()
    {
        $types = Database::getRows(
            "select id,name 
               from {$this->GlobalSetting()}wpl_property_types 
              where enabled = ?", true
        );
        $PropertyTypes = $this->DefaultResponse(1);
        $PropertyTypes ['results'][] = $this->DefaultTypes(1);
        foreach ($types as $type) {
            // array of listing types
            $PropertyTypes ['results'][] = array(
                'id' => $type['id'],
                'type' => __($type['name'], 'wpl-api')
            );
        }
        return $PropertyTypes;
    }

    protected function AddPricePeriod()
    {
        $flexInfo = Database::getRow("select options from {$this->GlobalSetting()}wpl_dbst where table_column = 'price_period' and kind = 0");
        $options = json_decode($flexInfo['options'] ?? '', true);

        $pricePeriod = $this->DefaultResponse(8);

        $pricePeriod ['results'][] = $this->DefaultTypes(1);
        foreach ($options['params'] as $option) {
            $pricePeriod ['results'][] = array(
                'id' => $option['key'],
                'type' => __($option['value'], 'wpl-api')
            );
        }

        return $pricePeriod;
    }

    protected function AddBedRoom()
    {
        $rooms = $this->DefaultResponse(2);
        $rooms['results'] = array(
            array('text' => __('ANY', 'wpl-api'), 'min' => '0', 'max' => '10', 'selected' => true),
            array('text' => '+1', 'min' => '1', 'max' => '10'),
            array('text' => '+2', 'min' => '2', 'max' => '10'),
            array('text' => '+3', 'min' => '3', 'max' => '10'),
            array('text' => '+4', 'min' => '4', 'max' => '10'),
            array('text' => '+5', 'min' => '5', 'max' => '10')
        );

        return $rooms;
    }

    protected function AddBathRoom()
    {
        $rooms = $this->DefaultResponse(3);
        $rooms['results'] = array(
            array('text' => __('ANY', 'wpl-api'), 'min' => '0', 'max' => '10', 'selected' => true),
            array('text' => '+1', 'min' => '1', 'max' => '10'),
            array('text' => '+2', 'min' => '2', 'max' => '10'),
            array('text' => '+3', 'min' => '3', 'max' => '10'),
            array('text' => '+4', 'min' => '4', 'max' => '10'),
            array('text' => '+5', 'min' => '5', 'max' => '10')
        );

        return $rooms;
    }

    protected function getFlexWithId($type, $category = null) {
        // we must send id and name to client, because we will need the related ID
        $query = "select id, name from {$this->GlobalSetting()}wpl_dbst where type = ?";
        if(!empty($category)) {
            $query .= ' and category = ' . $category;
        }
        $rows = Database::getRows($query, $type);
        $resultWithId = [];
        foreach ($rows as $row) {
            $resultWithId[] = [
                'id' => $row['id'],
                'type' => __($row['name'], 'wpl-api')
            ];
        }
        return $resultWithId;
    }

    protected function AddAppliances($type = false)
    {
        $appliances = Database::getRows(
            "select distinct name 
               from {$this->GlobalSetting()}wpl_dbst 
              where type = ? and category = 5", $type
        );
        $arrappliance = $this->DefaultResponse(4);
        if ($appliances) {
            foreach ($appliances as $appliance) {
                $arrappliance['results'][] = __($appliance['name'], 'wpl-api');
            }
        } else {
            $arrappliance['results'] = [];
        }
        $arrappliance['result'] = $this->getFlexWithId($type, 5);
        return $arrappliance;
    }

    protected function AddFeatures($type = false)
    {
        $features = Database::getRows(
            "select distinct name 
               from {$this->GlobalSetting()}wpl_dbst 
              where type = ? and category = 4", $type
        );
        $arrappliance = $this->DefaultResponse(7);
        if ($features) {
            foreach ($features as $appliance) {
                $arrappliance['results'][] = __($appliance['name'], 'wpl-api');
            }
        } else {
            $arrappliance['results'] = [];
        }
        $arrappliance['result'] = $this->getFlexWithId($type, 4);
        return $arrappliance;
    }

    protected function AddNeighborHood($type = false)
    {
        $NeighborHoods = Database::getRows(
            "select distinct name 
               from {$this->GlobalSetting()}wpl_dbst 
              where type = ?", $type
        );
        $arrNeighborHood = $this->DefaultResponse(5);
        if ($NeighborHoods) {
            foreach ($NeighborHoods as $neighborHood) {
                $arrNeighborHood['results'][] = __($neighborHood['name'], 'wpl-api');
            }
        } else {
            $arrNeighborHood['results'] = [];
        }
        $arrNeighborHood['result'] = $this->getFlexWithId($type);
        return $arrNeighborHood;
    }

    protected function AddTags($type = false)
    {
        $tags = Database::getRows(
            "select distinct name 
               from {$this->GlobalSetting()}wpl_dbst 
              where type = ?", $type
        );
        $arrTags = $this->DefaultResponse(6);
        if ($tags) {
            foreach ($tags as $tag) {
                $arrTags['results'][] = $tag['name'];
            }
        } else {
            $arrTags['results'] = [];
        }
        return $arrTags;
    }

    protected function DefaultTypes($num)
    {
        $types = array(
            0 => array('id' => '-1', 'type' => __('Any', 'wpl-api')),
            1 => array('id' => '-1', 'type' => __('Any', 'wpl-api')),
        );
        return $types[$num];
    }

    protected function DefaultResponse($num)
    {
        $response = array(
            0 => array('name' => __('Listing Type', 'wpl-api'), 'type' => 'DropDown', 'key' => 'listing_type'),
            1 => array('name' => __('Property Type', 'wpl-api'), 'type' => 'DropDown', 'key' => 'property_type'),
            2 => array('name' => __('Bedrooms', 'wpl-api'), 'type' => 'Tabs', 'key' => 'bedroom'),
            3 => array('name' => __('Bathrooms', 'wpl-api'), 'type' => 'Tabs', 'key' => 'bathroom'),
            4 => array('name' => __('Appliances', 'wpl-api'), 'type' => 'Checkbox', 'key' => 'appliances'),
            5 => array('name' => __('Neighborhood', 'wpl-api'), 'type' => 'Checkbox', 'key' => 'neighborhoods'),
            6 => array('name' => __('Tags', 'wpl-api'), 'type' => 'Checkbox', 'key' => 'tags'),
            7 => array('name' => __('Features', 'wpl-api'), 'type' => 'Checkbox', 'key' => 'features'),
            8 => array('name' => __('Price Period', 'wpl-api'), 'type' => 'DropDown', 'key' => 'price_period'),
        );
        return $response[$num];
    }

    protected function GlobalSetting()
    {
        global $wpdb;
        return $wpdb->prefix;
    }
}