<?php

namespace Api\Wpl\models\core\Search;

use Api\Wpl\models\AbstractModel;
use Api\Wpl\models\core\Database\Database as DB;

class Builder extends AbstractModel
{

    /** @var string */
    protected $price;

    /** @var string */
    protected $bathroom;

    /** @var string */
    protected $bedroom;

    /** @var string */
    protected $coordinates;

    /** @var string */
    protected $squareFoot;

    /** @var string */
    protected $tags;

    /** @var string */
    protected $neighborhood;

    /** @var string */
    protected $appliances;

    /** @var string */
    protected $lotarea;

    /** @var string */
    protected $room;

    /** @var string */
    protected $livingarea;

    /** @var string */
    protected $buildyear;

    /**
     * @param $listingType
     */
    public function setListingType($listingType)
    {
        $this->listing = $listingType;
        return $this;
    }

    /**
     * @return bool|string
     */
    public function getListingType()
    {
        if ($this->listing != false and $this->listing > 0) {
            $this->listing = sprintf("%s=%s", "listing", $this->listing);
        }
        if ($this->listing < 0) {
            $this->listing = false;
        }
        return $this->listing;
    }

    /**
     * @param $propertyType
     */
    public function setPropertyType($propertyType)
    {
        $this->PropertyType = $propertyType;
        return $this;
    }

    /**
     * @return bool|string
     */
    public function getPropertyType()
    {
        if ($this->PropertyType != false and $this->PropertyType > 0) {
            $this->PropertyType = sprintf("%s=%s", "property_type", $this->PropertyType);
        }
        if ($this->PropertyType < 0) {
            $this->PropertyType = false;
        }
        return $this->PropertyType;
    }

    /**
     * @param $min_price
     */
    public function setMinPrice($min_price)
    {
        $this->minPrice = $min_price;
        return $this;
    }

    /**
     * @return bool|string
     */
    public function getMinPrice()
    {
        return $this->minPrice;
    }

    /**
     * @param $max_price
     */
    public function setMaxPrice($max_price)
    {
        $this->maxPrice = $max_price;
        return $this;
    }

    /**
     * @return bool|string
     */
    public function getMaxPrice()
    {
        return $this->maxPrice;
    }

    public function setMinLotArea($min_lot_area)
    {
        $this->MinLotArea = $min_lot_area;
        return $this;
    }

    public function getMinLotArea()
    {
        return $this->MinLotArea;
    }

    public function setMaxLotArea($max_lot_area)
    {
        $this->MaxLotArea = $max_lot_area;
        return $this;
    }

    public function getMaxLotArea()
    {
        return $this->MaxLotArea;
    }

    public function setMinbathroom($min_bathroom)
    {
        $this->minBathroom = $min_bathroom;
        return $this;
    }

    /**
     * @return bool|string
     */
    public function getMinbathroom()
    {
        return $this->minBathroom;
    }

    /**
     * @param $max_bathroom
     */
    public function setMaxbathroom($max_bathroom)
    {
        $this->maxBathroom = $max_bathroom;
        return $this;
    }

    /**
     * @return bool|string
     */
    public function getMaxbathroom()
    {
        return $this->maxBathroom;
    }

    /**
     * @param $min_bedroom
     */
    public function setMinbedroom($min_bedroom)
    {
        $this->Minbedroom = $min_bedroom;
        return $this;
    }

    /**
     * @return bool|string
     */
    public function getMinbedroom()
    {
        return $this->Minbedroom;
    }

    /**
     * @param $max_bedroom
     */
    public function setMaxbedroom($max_bedroom)
    {
        $this->maxBedroom = $max_bedroom;
        return $this;
    }

    /**
     * @return bool|string
     */
    public function getMaxbedroom()
    {
        return $this->maxBedroom;
    }

    /**
     * @param $min_room
     */
    public function setMinroom($min_room)
    {
        $this->Minroom = $min_room;
        return $this;
    }

    /**
     * @return bool|string
     */
    public function getMinroom()
    {
        return $this->Minroom;
    }

    /**
     * @param $max_room
     */
    public function setMaxroom($max_room)
    {
        $this->maxRoom = $max_room;
        return $this;
    }

    /**
     * @return bool|string
     */
    public function getMaxroom()
    {
        return $this->maxRoom;
    }

    /**
     * @param $min_livingarea
     */
    public function setMinlivingarea($min_livingarea)
    {
        $this->Minlivingarea = $min_livingarea;
        return $this;
    }

    /**
     * @return bool|string
     */
    public function getMinlivingarea()
    {
        return $this->Minlivingarea;
    }

    /**
     * @param $max_livingarea
     */
    public function setMaxlivingarea($max_livingarea)
    {
        $this->maxLivingarea = $max_livingarea;
        return $this;
    }

    /**
     * @return bool|string
     */
    public function getMaxlivingarea()
    {
        return $this->maxLivingarea;
    }


    /**
     * @param $min_buildyear
     */
    public function setMinbuildyear($min_buildyear)
    {
        $this->Minbuildyear = $min_buildyear;
        return $this;
    }

    /**
     * @return bool|string
     */
    public function getMinbuildyear()
    {
        return $this->Minbuildyear;
    }

    /**
     * @param $max_buildyear
     */
    public function setMaxbuildyear($max_buildyear)
    {
        $this->maxBuildyear = $max_buildyear;
        return $this;
    }

    /**
     * @return bool|string
     */
    public function getMaxbuildyear()
    {
        return $this->maxBuildyear;
    }

    /**
     * @param $minsqft
     */
    public function setMinsqft($minsqft)
    {
        $this->minSqft = $minsqft;
        return $this;
    }

    /**
     * @return bool|string
     */
    public function getMinsqft()
    {
        return $this->minSqft;
    }

    /**
     * @param $maxsqft
     */
    public function setMaxsqft($maxsqft)
    {
        $this->maxSqft = $maxsqft;
        return $this;
    }

    /**
     * @return bool|string
     */
    public function getMaxsqft()
    {
        return $this->maxSqft;
    }

    /**
     * @param $swlat
     */
    public function setSwlat($swlat)
    {
        $this->swlat = $swlat;
        return $this;
    }

    /**
     * @return bool|string
     */
    public function getSwlat()
    {
        return $this->swlat;
    }

    /**
     * @param $swlng
     */
    public function setSwlng($swlng)
    {
        $this->swlng = $swlng;
        return $this;
    }

    /**
     * @return bool|string
     */
    public function getSwlng()
    {
        return $this->swlng;
    }

    /**
     * @param $nelat
     */
    public function setNelat($nelat)
    {
        $this->nelat = $nelat;
        return $this;
    }

    public function setListingId($listing_id)
    {
        $this->listing_id = $listing_id;
        return $this;
    }

    /**
     * @return bool|string
     */
    public function getNelat()
    {
        return $this->nelat;
    }

    /**
     * @param $nelng
     */
    public function setNelng($nelng)
    {
        $this->nelng = $nelng;
        return $this;
    }

    /**
     * @return bool|string
     */
    public function getNelng()
    {
        return $this->nelng;
    }

    protected function WhereCoordinates()
    {
        if ($this->getSwlat() and
            $this->getNelat() and
            $this->getSwlng() and
            $this->getNelng()) {
            $this->coordinates = sprintf(
                "%s BETWEEN %s AND %s AND %s BETWEEN %s AND %s",
                "googlemap_lt", $this->getSwlat(), $this->getNelat(), "googlemap_ln", $this->getSwlng(), $this->getNelng()
            );
            return $this->coordinates;
        }
    }

    protected function WhereLotArea($column = "lot_area")
    {

        if ($this->getMinLotArea() and $this->getMaxLotArea()) {
            $this->lotarea = sprintf(
                "%s >= %s and %s <= %s", $column, $this->getMinLotArea(), $column, $this->getMaxLotArea()
            );
            return $this->lotarea;
        }

        if ($this->getMinLotArea() || $this->getMaxLotArea()) {
            $this->lotarea = ($this->getMinLotArea() != false)
                ? sprintf("%s >= %s", $column, $this->getMinLotArea())
                : sprintf("%s <= %s", $column, $this->getMaxLotArea());
            return $this->lotarea;
        }
        $this->lotarea = false;
        return $this->lotarea;
    }

    protected function WhereSquareFoot($column = "living_area")
    {

        if ($this->getMinsqft() and $this->getMaxsqft()) {
            $this->squareFoot = sprintf(
                "%s >= %s and %s <= %s", $column, $this->getMinsqft(), $column, $this->getMaxsqft()
            );
            return $this->squareFoot;
        }

        if ($this->getMinsqft() || $this->getMaxsqft()) {
            $this->squareFoot = ($this->getMinsqft() != false)
                ? sprintf("%s >= %s", $column, $this->getMinsqft())
                : sprintf("%s <= %s", $column, $this->getMaxsqft());
            return $this->squareFoot;
        }
        $this->squareFoot = false;
        return $this->squareFoot;
    }

    protected function WhereBedroom($column = "bedrooms")
    {

        if ($this->getMinbedroom() and $this->getMaxbedroom()) {
            $this->bedroom = sprintf(
                "%s >= %s and %s <= %s", $column, $this->getMinbedroom(), $column, $this->getMaxbedroom()
            );
            return $this->bedroom;
        }

        if ($this->getMinbedroom() || $this->getMaxbedroom()) {
            $this->bedroom = ($this->getMinbedroom() != false)
                ? sprintf("%s >= %s", $column, $this->getMinbedroom())
                : sprintf("%s <= %s", $column, $this->getMaxbedroom());
            return $this->bedroom;
        }
        $this->bedroom = false;
        return $this->bedroom;
    }

    protected function WhereListingId()
    {

        if (empty($this->listing_id)) {
            return false;
        }
        return 'id = ' . $this->listing_id;
    }

    protected function WhereRoom($column = "rooms")
    {

        if ($this->getMinroom() and $this->getMaxroom()) {
            $this->room = sprintf(
                "%s >= %s and %s <= %s", $column, $this->getMinroom(), $column, $this->getMaxroom()
            );
            return $this->room;
        }

        if ($this->getMinroom() || $this->getMaxroom()) {
            $this->room = ($this->getMinroom() != false)
                ? sprintf("%s >= %s", $column, $this->getMinroom())
                : sprintf("%s <= %s", $column, $this->getMaxroom());
            return $this->room;
        }
        $this->room = false;
        return $this->room;
    }

    protected function WhereLivingarea($column = "living_area")
    {

        if ($this->getMinlivingarea() and $this->getMaxlivingarea()) {
            $this->livingarea = sprintf(
                "%s >= %s and %s <= %s", $column, $this->getMinlivingarea(), $column, $this->getMaxlivingarea()
            );
            return $this->livingarea;
        }

        if ($this->getMinlivingarea() || $this->getMaxlivingarea()) {
            $this->livingarea = ($this->getMinlivingarea() != false)
                ? sprintf("%s >= %s", $column, $this->getMinlivingarea())
                : sprintf("%s <= %s", $column, $this->getMaxlivingarea());
            return $this->livingarea;
        }
        $this->livingarea = false;
        return $this->livingarea;
    }

    protected function WhereBuildyear($column = "build_year")
    {

        if ($this->getMinbuildyear() and $this->getMaxbuildyear()) {
            $this->buildyear = sprintf(
                "%s >= %s and %s <= %s", $column, $this->getMinbuildyear(), $column, $this->getMaxbuildyear()
            );
            return $this->buildyear;
        }

        if ($this->getMinbuildyear() || $this->getMaxbuildyear()) {
            $this->buildyear = ($this->getMinbuildyear() != false)
                ? sprintf("%s >= %s", $column, $this->getMinbuildyear())
                : sprintf("%s <= %s", $column, $this->getMaxbuildyear());
            return $this->buildyear;
        }
        $this->buildyear = false;
        return $this->buildyear;
    }

    /**
     * @param array $column
     * @return bool|string
     */
    protected function WhereBathroom($column = "bathrooms")
    {

        if ($this->getMinbathroom() and $this->getMaxbathroom()) {
            $this->bathroom = sprintf(
                "%s >= %s and %s <= %s", $column, $this->getMinbathroom(), $column, $this->getMaxbathroom()
            );
            return $this->bathroom;
        }

        if ($this->getMinbathroom() || $this->getMaxbathroom()) {
            $this->bathroom = ($this->getMinbathroom() != false)
                ? sprintf("%s >= %s", $column, $this->getMinbathroom())
                : sprintf("%s <= %s", $column, $this->getMaxbathroom());
            return $this->bathroom;
        }
        $this->bathroom = false;
        return $this->bathroom;
    }

    /**
     * @param array $price
     * @return This|string
     */
    protected function WherePrice($column = "price")
    {

        if ($this->getMinPrice() and $this->getMaxPrice()) {
            $this->price = sprintf(
                "%s >= %s and %s <= %s", $column, $this->getMinPrice(), $column, $this->getMaxPrice()
            );
            return $this->price;
        }

        if ($this->getMinPrice() || $this->getMaxPrice()) {
            $this->price = ($this->getMinPrice() != false)
                ? sprintf("%s >= %s", $column, $this->getMinPrice())
                : sprintf("%s <= %s", $column, $this->getMaxPrice());
            return $this->price;
        }
        $this->price = false;
        return $this->price;
    }

    /**
     * @param $tags
     *
     * @return bool|string
     */
    public function whereTags($tags)
    {
        if (isset($tags) and !empty($tags)) {
            $this->tags = $this->getWhereConditions($tags);
            return $this->tags;
        }
        return false;
    }

    /**
     * @param $neighborhood
     *
     * @return bool|string
     */
    public function whereNeighborhoods($neighborhoods)
    {
        if (isset($neighborhoods) and !empty($neighborhoods)) {
            $this->neighborhood = $this->getWhereConditions($neighborhoods);
            return $this->neighborhood;
        }
        return false;
    }

    /**
     * @param $appliances
     *
     * @return bool|string
     */
    public function whereAppliances($appliances)
    {
        if (isset($appliances) and !empty($appliances)) {
            $this->appliances = $this->getWhereConditions($appliances);
            return $this->appliances;
        }
        return false;
    }

    /**
     * @return string
     */
    public function build()
    {

        $where = array_filter(array(
            $this->WhereCoordinates(),
            $this->WhereListingId(),
            $this->WherePrice(),
            $this->WhereBathroom(),
            $this->WhereBedroom(),
            $this->WhereRoom(),
            $this->WhereLivingarea(),
            $this->WhereBuildyear(),
            $this->WhereSquareFoot(),
            $this->WhereLotArea(),
            $this->getListingType(),
            $this->getPropertyType(),
            $this->tags,
            $this->neighborhood,
            $this->appliances
        ));
        return $where;
    }

    /**
     * @param $options
     *
     * @return bool|string
     */
    protected function getWhereConditions($filters)
    {

        $response = array();
        $fields = "'" . implode("','", explode(',', $filters)) . "'";

        $columns = DB::getRows(
            "SELECT table_column 
                FROM {$this->wpdb->base_prefix}wpl_dbst 
             WHERE enabled = ? AND table_name = ? AND name IN ($fields)",
            array(1, 'wpl_properties')
        );
        if ($columns != false) {
            foreach ($columns as $column) {
                $response[] = $column['table_column'] . " = 1";
            }
            if (sizeof($response)) {
                return implode(' OR ', $response);
            }
        }
        return false;
    }
}