<?php

namespace Api\Wpl\models\core\Properties;

use Api\Wpl\models\core\Search\Builder;
use Api\Wpl\models\AbstractModel;
use Api\Wpl\models\core\Database\Database;

class PropertiesSort extends AbstractModel {

    protected $field_name;

    /**
     * Set Property Sort ID
     * @param $id
     * @return $this
     */
    public function SetSortId($id) {
        $this->sortId = $id;
        return $this;
    }

    /**
     * Property Sort ID
     * @return int
     */
    protected function GetSortId() {
        return $this->sortId;
    }

    /**
     * Set The Sort Field Name
     * @return bool|string
     */
    public function GetSortFieldName() {
        $field_name = Database::getRow("
            SELECT field_name 
                FROM {$this->wpdb->base_prefix}wpl_sort_options 
            WHERE id = ? AND enabled = ?", array($this->GetSortId(), true)
        );
        if ($field_name) {
            $ConvertedFieldName = $this->ConvertSortFieldName($field_name['field_name']);
            return $ConvertedFieldName;
        }
        return false;
    }

    /**
     * Get Converted Sort Field Name
     * @return string
     */
    protected function ConvertSortFieldName($field) {
	    $findme = 'p.';
	    if (strpos($field ?? '', $findme) !== false) {
		    $explodeFieldName = explode(
			    '.', $field
		    );
		    $converted_field = (isset($explodeFieldName)
			    ? $explodeFieldName[1]
			    : $field
		    );
		    return $converted_field;
	    }
	    return false;
    }

    /**
     * Get The Where condition
     */
    public function GetWhere($request) {

        if ($request instanceof \WP_REST_Request) {
            $builder = (
                new Builder())->setSwlat($request->get_param('swlat'))->setSwlng($request->get_param('swlng'))
                    ->setNelat($request->get_param('nelat'))->setNelng($request->get_param('nelng'))
                    ->setMinsqft($request->get_param('minsqft'))->setMaxsqft($request->get_param('maxsqft'))
                    ->setMinPrice($request->get_param('minprice'))->setMaxPrice($request->get_param('maxprice'))
                    ->setMaxbedroom($request->get_param('maxbedroom'))->setMinbedroom($request->get_param('minbedroom'))
                    ->setMinbathroom($request->get_param('minbathroom'))->setMaxbathroom($request->get_param('maxbathroom'))
                    ->setListingType($request->get_param('listing_type'))->setPropertyType($request->get_param('property_type')
            );
            $builder->whereTags($request->get_param('tags'));
            $builder->whereNeighborhoods($request->get_param('neighborhoods'));
            $builder->whereAppliances($request->get_param('appliances'));
            return $builder->build();
        }
    }
}