<?php

namespace Api\Wpl\models\core\Properties;

use Api\Wpl\managers\SettingsManager;
use Api\Wpl\models\core\Auth\Auth;
use Api\Wpl\models\core\Database\Database;

class PropertiesSave {

	/** @var \wpdb */
	protected $wpdb;

	/**
	 * @var array
	 */
	protected $settingNames = array(
		'location1_keyword',
		'location2_keyword',
		'location3_keyword',
		'location4_keyword',
		'location5_keyword',
		'location6_keyword',
		'location7_keyword'
	);

	/**
	 * Default Location keywords
	 * @var array
	 */
	protected $LocationKeywords = array(
		'Country',
		'State',
		'City'
	);

	/**
	 * Allowed Address Keys
	 * @var array
	 */
	protected $allowedAddressKeys = array(
		"county",
		"state",
		"city",
		"zipcode",
		"street",
		"street_number",
		"street_suffix"
	);

	/**
	 * @var array
	 */
	protected $mlsColumnlist = array(
		'mls_server_id' => 0,
		'mls_class_id'  => 0,
		'mls_query_id'  => 0
	);

	/**
	 * @var array
	 */
	protected $listingStatusList = array(
		'confirmed' => 1,
		'finalized' => 1,
		'parent'    => 0
	);

	/**
	 * @var array
	 */
	protected $listingTypes = array(
		'For Rent',
		'Vacation Rental'
	);

	/**
	 * @var PropertiesMapper
	 */
	protected $storage;

	/**
	 * @param PropertiesMapper $data
	 */
	public function __construct( PropertiesMapper $data ) {

		global $wpdb;
		// Using the $wpdb Object
		$this->wpdb    = $wpdb;
		$this->storage = $data;
	}

    /**
     * @param $propertyData
     * @return string
     * @author david.m
     */
	public function getPropertyTitle($propertyData) {
        $propertyTitlePattern = SettingsManager::getPropertyTitlePattern();
        if(empty($propertyTitlePattern)) {
            $propertyTitlePattern = '[property_type] [listing]';
        }
        $listing = '';
        if(isset($propertyData['listing'])) {
            $row = Database::getRow("select * from {$this->wpdb->base_prefix}wpl_listing_types where id = ?", array($propertyData['listing']));
            if(isset($row['name'])){
                $listing = $row['name'];
            }
        }
        $propertyType = '';
        if(isset($propertyData['property_type'])) {
            $row = Database::getRow("select * from {$this->wpdb->base_prefix}wpl_property_types where id = ?", array($propertyData['property_type']));
            if(isset($row['name'])){
                $propertyType = $row['name'];
            }
        }

        $propertyData['property_type'] = __($propertyType, 'wpl-api');
        $propertyData['listing'] = __($listing, 'wpl-api');
        $propertyData['listing_type'] = __($listing, 'wpl-api');

        preg_match_all('/\[([^\]]*)\]/', $propertyTitlePattern, $matchesPattern);
        $rendered = $propertyTitlePattern;
        foreach ($matchesPattern[1] as $field) {
            $rendered = str_replace('[' . $field . ']', stripslashes($propertyData[$field] ?? ''), $rendered);
        }
        return $rendered;
    }
	public function save($edit=false) {
		// Validate price period
		$this->isPricePeriodValid( $pricePeriod );

		$address = $this->storage->getAddress();
		$locations = $this->getLocationColumnNames();
		// Values of location
		$locValue = $this->getLocationValues();
		// Get User ID
		$userId = ( new Auth() )->getUserIdByToken();
		// Check if price period is necessary
		$pricePeriod = $this->checkNeedPricePeriod( $this->storage->getListingType() );
		// features
		$features = $this->getFeatures();
		// appliances
		$appliances = $this->getAppliances();
		// neighborhoods
		$neighborhoods = $this->getNeighborhoods();

		$pic_numb = (isset( $this->storage ) AND is_array($this->storage->getImage())) ? count( $this->storage->getImage() ) : 0;

		$price = str_replace(['K','M','B','T'],['000','000000','000000000','000000000000'],$this->storage->getPrice());

		// $city = $this->getLocation($locValue['city'],str_replace(['_id','_name','location'],'',$locations['city']));
		// $state = $this->getLocation($locValue['state'],str_replace(['_id','_name','location'],'',$locations['state']));
		// $country = $this->getLocation($locValue['country'],str_replace(['_id','_name','location'],'',$locations['country']));

		//$_address = $address['street_number'].' '.$address['street'].' '.$address['street_suffix'].($city?", $city":'').($state?", $state":'').', '.$address['zipcode'];
		$_address = $address['street_number'].' '.$address['street'].' '.$address['street_suffix'].($address['state']?" $address[state]":'').($address['city']?" $address[city]":'').($address['country']?" $address[country]":'').' '.$address['zipcode'];
		$lt_ln = (isset($_address) AND !empty($_address)) ? $this->getLatLng($_address) : null;

        $rs_data = json_decode(file_get_contents('php://input') ?? '', true);
		$user_id = (isset($rs_data['user_id']) and !empty($rs_data['user_id'])) ? $rs_data['user_id'] : null;
		$user_id = $user_id==null ? $_REQUEST['user_id'] : $userId;

		$user = get_userdata( $user_id );
		if ( $user === false ) {
		    wp_send_json_error( array(
				'message' => 'Insert operation has failed.',
				'reason'  => 'user not found'
			) );
			return false;
		}

		$lt = (isset($rs_data['latitude']) and !empty($rs_data['latitude'])) ? $rs_data['latitude'] : "";
		$ln = (isset($rs_data['longitude']) and !empty($rs_data['longitude'])) ? $rs_data['longitude'] : "";
		if (!isset($lt) or empty($lt)) $lt = (isset($_REQUEST['latitude']) and !empty($_REQUEST['latitude'])) ? $_REQUEST['latitude'] : "";
		if (!isset($ln) or empty($ln)) $ln = (isset($_REQUEST['longitude']) and !empty($_REQUEST['longitude'])) ? $_REQUEST['longitude'] : "";

		$prop_address = (isset($rs_data['address']) and !empty($rs_data['address'])) ? $rs_data['address'] : "";
		if (!isset($prop_address) or empty($prop_address)) $prop_address = (isset($_REQUEST['address']) and !empty($_REQUEST['address'])) ? $_REQUEST['address'] : "";

		if (isset($lt) and isset($ln)) $lt_ln = array($lt, $ln);
		$living_area_unit = $this->storage->getSquareFootageUnit() ? $this->getSquareFootageUnitId( $this->storage->getSquareFootageUnit() ) : '';
		$lot_area_unit = $this->storage->getLotAreaUnit() ? $this->getLotAreaUnitId( $this->storage->getLotAreaUnit() ) : '';

		if ((!isset($living_area_unit) or empty($living_area_unit)) and ($_REQUEST['sqft_unit_id'] or $rs_data['sqft_unit_id'])) {
		    if (isset($_REQUEST['sqft_unit_id'])) {
		        $living_area_unit = $_REQUEST['sqft_unit_id'];
		    } elseif (isset($_REQUEST['sqft_unit_id'])) {
		        $living_area_unit = $rs_data['sqft_unit_id'];
		    }
		}

		if ((!isset($lot_area_unit) or empty($lot_area_unit)) and ($_REQUEST['lot_unit_id'] or $rs_data['lot_unit_id'])) {
		    if (isset($_REQUEST['lot_unit_id'])) {
		        $lot_area_unit = $_REQUEST['lot_unit_id'];
		    } elseif (isset($_REQUEST['lot_unit_id'])) {
		        $lot_area_unit = $rs_data['lot_unit_id'];
		    }
		}

		$build_year = empty($this->storage->getYearBuilt()) ? 0 : $this->storage->getYearBuilt();

// When we are done, restore the translations for the default locale.
//$l10n[ $textdomain ] = $backup;

		$data = array(
			'user_id'             => $user_id,
			'mls_id'              => $this->storage->getMlsId(),
			'mls_id_num'          => $this->getLastMlsId(),
			'field_308'           => $this->storage->getDescription(),
            $locations['country'] => $address['county'],
            $locations['state']   => $address['state'],
            $locations['city']    => $address['city'],
            'field_42'            => $address['street'],
            'street_no'           => $address['street_number'],
            'street_suffix'       => $address['street_suffix'],
            'zip_name'            => $address['zipcode'],
//			'field_3002'          => $prop_address,
			'location_text'       => $prop_address,
			'pic_numb'            => $pic_numb,
//			'location1_id'        => $this->getLocationIdByCounty(),
            'location1_id'        => '276', //@david.m set manually
			'location2_id'        => $this->getStateIdByName(),
			'bedrooms'            => $this->storage->getBedrooms(),
			'bathrooms'           => $this->storage->getBathrooms(),
			'half_bathrooms'      => $this->storage->getHalfBathrooms(),
			'add_date'            => date( "Y-m-d H:i:s" ),
			'last_finalize_date'  => date( "Y-m-d H:i:s" ),
			//'listing'             => $this->storage->getListingType() ? $this->getListingTypeId( $this->storage->getListingType() ) : '',
			'listing'             => $this->storage->getListingType() ? $this->storage->getListingType() : '',
			//'property_type'       => $this->storage->getPropertyType() ? $this->getPropertyTypeId( $this->storage->getPropertyType() ) : '',
			'property_type'       => $this->storage->getPropertyType() ? $this->storage->getPropertyType() : '',
			'price'               => (float) filter_var( $price, FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION ),
			'price_si'            => (float) filter_var( $price, FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION ),
			'price_unit'          => $this->storage->getPriceUnit() ? $this->getPriceUnitId( $this->storage->getPriceUnit() ) : '',
			'price_period'        => $this->storage->getPricePeriod() ? $this->storage->getPricePeriod() : '',
			'living_area'         => $this->storage->getSquareFootage(),
			'living_area_si'      => $this->storage->getSquareFootage(),
			'living_area_unit'    => $living_area_unit,
			'lot_area_si'         => $this->storage->getLotArea(),
			'lot_area'            => $this->storage->getLotArea(),
			'lot_area_unit'       => $lot_area_unit,
			'build_year'          => $build_year,
			'googlemap_lt'        => $lt_ln ? $lt_ln[0] : '',
			'googlemap_ln'        => $lt_ln ? $lt_ln[1] : ''
		);

		$data['field_313'] = $this->getPropertyTitle($data);

		if ($edit) {
			$data['id'] = $this->storage->getListingId();
			if($user->allcaps['administrator']){
			    unset($data['user_id']);
            }
		}

		$data = array_filter( $data );

		$result = array_merge(
			$data,
			( $this->checkAddOn( 'mls' ) ) ? $this->mlsColumnlist : [],
			$this->listingStatusList,
			$features,
			$appliances,
			$neighborhoods
		);

		if($this->checkAddOn( 'aps' )){
		    $lat = empty($data['googlemap_lt']) ? 0 : $data['googlemap_lt'];
		    $lng = empty($data['googlemap_lt']) ? 0 : $data['googlemap_ln'];
            $result['geopoints'] = "POINT($lat $lng)";
        }


		try {
			if (!$edit) {
				$listingtId = Database::insert(
					"{$this->wpdb->base_prefix}wpl_properties", $result
				);
			} else {
				Database::update(
					"{$this->wpdb->base_prefix}wpl_properties", $result, "id = $data[id]"
				);
				$listingtId = $data['id'];
			}
			if ( $listingtId ) {

				if (isset($this->storage) AND is_array($this->storage->getImage())) {
					$this->saveExternalImages( $this->storage->getImage(), $listingtId );
				}
				header('Content-Type: application/json');
				echo json_encode(array('success'=>true,'data'=>array(
					'message'    => __('Property successfully added.', 'wpl-api'),
					'listing_id' => $listingtId
				)));
				die;
			}
			wp_send_json_error( array(
				'message' => 'Insert operation has failed.'
			) );
		} catch ( \PDOException $e ) {
			wp_send_json_error( array(
				'message' => 'Insert operation has failed.',
				'reason'  => $e->getMessage()
			) );
		}
	}

	/**
	 * Using this method you can save external images
	 */
	protected function saveExternalImages( array $images, $lastInsertId ) {

		if ( sizeof( $images ) != false ) {

			$images = array_map( function ( $image ) use ( $lastInsertId ) {
				$data = array(
					'parent_id'     => $lastInsertId,
					'creation_date' => date( "Y-m-d H:i:s" ),
					'item_type'     => 'gallery',
					'item_cat'      => 'external',
					'item_name'     => 'external_image' . $lastInsertId,
					'item_extra3'   => $image
				);

				Database::insert(
					"{$this->wpdb->base_prefix}wpl_items", $data
				);
			}, $images );
		}
	}

	protected function getNeighborhoods() {

		$data = array();

		$string = implode( ',', $this->storage->getNeighborhoods() );
		$names  = explode( ',', $string );

		if ( isset( $names ) ) {
            if(is_numeric($names[0])) {
                $fields   = "'" . implode( "','", $names ) . "'";
                $Neighborhoods = Database::getRows(
                    "SELECT table_column FROM {$this->wpdb->base_prefix}wpl_dbst as dbst WHERE dbst.id IN ($fields)"
                );
            }else {
                $fields   = "'" . implode( "','", $names ) . "'";
                $Neighborhoods = Database::getRows(
                    "SELECT table_column FROM {$this->wpdb->base_prefix}wpl_dbst as dbst WHERE dbst.name IN ($fields)"
                );
            }

			if ( $Neighborhoods ) {
				foreach ( $Neighborhoods as $Neighborhood ) {
					$data[ $Neighborhood['table_column'] ] = 1;
				}
				return $data;
			}
			return array();
		}
		return array();
	}
	
	protected function getAppliances() {

		$data = array();

		$string = implode( ',', $this->storage->getAppliances() );
		$names  = explode( ',', $string );
		
		if ( isset( $names ) ) {

            if(is_numeric($names[0])) {
                $fields   = "'" . implode( "','", $names ) . "'";
                $Appliances = Database::getRows(
                    "SELECT table_column FROM {$this->wpdb->base_prefix}wpl_dbst as dbst WHERE dbst.id IN ($fields)"
                );
            }else {
                $fields   = "'" . implode( "','", $names ) . "'";
                $Appliances = Database::getRows(
                    "SELECT table_column FROM {$this->wpdb->base_prefix}wpl_dbst as dbst WHERE dbst.name IN ($fields)"
                );
            }

			if ( $Appliances ) {
				foreach ( $Appliances as $Appliance ) {
					$data[ $Appliance['table_column'] ] = 1;
				}
				return $data;
			}
			return array();
		}
		return array();
	}

	protected function getFeatures() {

		$data = array();

		$string = implode( ',', $this->storage->getFeatures() );
		$names  = explode( ',', $string );

		if ( isset( $names ) ) {
		    if(is_numeric($names[0])) {
                $fields   = "'" . implode( "','", $names ) . "'";
                $features = Database::getRows(
                    "SELECT table_column FROM {$this->wpdb->base_prefix}wpl_dbst as dbst WHERE dbst.id IN ($fields)"
                );
            }else {
                $fields = "'" . implode("','", $names) . "'";
                $features = Database::getRows(
                    "SELECT table_column FROM {$this->wpdb->base_prefix}wpl_dbst as dbst WHERE dbst.name IN ($fields)"
                );
            }
			if ( $features ) {
				foreach ( $features as $feature ) {
					$data[ $feature['table_column'] ] = 1;
				}
				return $data;
			}
			return array();
		}
		return array();
	}

	protected function getAddress() {

		$address       = $this->storage->getAddress();
		$addressValues = array();
		if (is_array($address)) {
			foreach ( $address as $value ) {
				$addressValues = $value;
			}
		}

		return $addressValues;
	}

	/**
	 * Get The Location Values After Validation
	 *
	 * @param array $locations
	 */
	protected function getLocationValues() {

		$notAllowedKeys = array_diff(
			array_keys(
				$this->getAddress()
			),
			$this->allowedAddressKeys
		);
		if ( $notAllowedKeys ) {
			wp_send_json_error( array(
				'message' => 'Array of Address is not valid.'
			) );
		}

		return $this->getAddress();
	}

	/**
	 * Get the location column names
	 * @return array
	 */
	protected function getLocationColumnNames() {

		$settingNames = "'" . implode( "','", $this->settingNames ) . "'";

		$settings = Database::getRows(
			"SELECT setting_name,setting_value FROM {$this->wpdb->base_prefix}wpl_settings as settings WHERE settings.setting_name IN ($settingNames)"
		);
		$matched  = array();

		foreach ( $settings as $setting ) {
			if ( in_array( $setting['setting_value'], $this->LocationKeywords ) ) {
				$matched[ strtolower( $setting['setting_value'] ) ] = str_replace( '_keyword', '_name', $setting['setting_name'] );
			}
		}

		return $matched;
	}

	/**
	 * Get the listing type id
	 *
	 * @param $listingType
	 */
	protected function getListingTypeId( $listingType ) {
		$types = Database::getRow(
			"SELECT * FROM {$this->wpdb->base_prefix}wpl_listing_types as types WHERE types.enabled = ? and types.name = ?", array(
				true,
				$listingType
			)
		);

		return ( $types == false )
			? wp_send_json_error( array(
				'message' => 'Unknown Listing Type.'
			) )
			: $types['id'];
	}

	/**
	 * Get The Property Type ID
	 *
	 * @param $PropertyType
	 */
	protected function getPropertyTypeId( $PropertyType ) {

		$types = Database::getRow(
			"SELECT * FROM {$this->wpdb->base_prefix}wpl_property_types as types WHERE types.enabled = ? and types.name = ?",
			array(
				true,
				$PropertyType
			)
		);

		return ( $types == false )
			? wp_send_json_error( array(
				'message' => 'Unknown Property Type.'
			) )
			: $types['id'];
	}

	/**
	 * Get Id of Price Unit
	 *
	 * @param $unit
	 */
	protected function getPriceUnitId( $unit ) {
        $unit = str_replace('\U','\u',$unit);
		$unit = Database::getRow(
			"SELECT * FROM {$this->wpdb->base_prefix}wpl_units as unit WHERE unit.enabled = ? and unit.extra = ? and unit.type = ?",
			array(
				true,
				$unit,
				4
			)
		);

		return ( $unit == false )
			? wp_send_json_error( array(
				'message' => 'Unknown unit type of price.'
			) )
			: $unit['id'];
	}

	/**
	 * Get Id of Square Footage Unit
	 *
	 * @param $unit
	 */
	protected function getSquareFootageUnitId( $unit ) {

		$unit = Database::getRow(
			"SELECT * FROM {$this->wpdb->base_prefix}wpl_units as unit WHERE unit.enabled = ? and unit.name = ? and unit.type = ?",
			array(
				true,
				$unit,
				2
			)
		);

		return ( $unit == false )
			? wp_send_json_error( array(
				'message' => 'Unknown unit type of square footage.'
			) )
			: $unit['id'];
	}

	/**
	 * Get Id of Lot Area Unit
	 *
	 * @param $unit
	 */
	protected function getLotAreaUnitId( $unit ) {

		$unit = Database::getRow(
			"SELECT * FROM {$this->wpdb->base_prefix}wpl_units as unit WHERE unit.enabled = ? and unit.name = ? and unit.type = ?",
			array(
				true,
				$unit,
				2
			)
		);

		return ( $unit == false )
			? wp_send_json_error( array(
				'message' => 'Unknown unit type of lot area.'
			) )
			: $unit['id'];
	}

	/**
	 * Get the location id by country
	 */
	protected function getLocationIdByCounty() {

		$location = $this->getAddress();

		$locationId = Database::getRow(
			"SELECT * FROM {$this->wpdb->base_prefix}wpl_location1 as location WHERE location.enabled = ? and location.name = ?",
			array(
				true,
				$location['county']
			)
		);

		return ( $locationId == false )
			? false
			: $locationId['id'];
	}

	/**
	 * Get the state id
	 */
	protected function getStateIdByName() {

		$location = $this->getAddress();

		$stateId = Database::getRow(
			"SELECT * FROM {$this->wpdb->base_prefix}wpl_location2 as state WHERE state.name = ? or state.abbr = ?",
			array(
				$location['state'],
				$location['state']
			)
		);

		return ( $stateId == false )
			? false
			: $stateId['id'];
	}

	/**
	 * Validate price period
	 */
	protected function isPricePeriodValid( $status ) {

		if ( $status == true and empty( $this->storage->getPricePeriod() ) ) {
			wp_send_json_error( array(
				'message' => 'Price Period is not valid.'
			) );
		}
	}

	protected function checkNeedPricePeriod( $listingType ) {

		if ( in_array( $listingType, $this->listingTypes ) ) {
			return true;
		}

		return false;
	}

	protected function getPricePeriodId( $type ) {

		$types = Database::getRow(
			"SELECT * FROM {$this->wpdb->base_prefix}wpl_dbst WHERE table_column = ?",
			array(
				'price_period'
			)
		);

		$periods = json_decode( $types['options'] ?? '', true );

		foreach ( $periods['params'] as $value ) {
			if ( $value['value'] == $type ) {
				$key = $value['key'];
			}
		}

		return $key;
	}

	protected function getLastMlsId() {

		$mls = Database::getRow(
			"SELECT mls_id_num FROM {$this->wpdb->base_prefix}wpl_properties ORDER BY id DESC LIMIT 1"
		);

		return $mls['mls_id_num'] + 1;
	}

	/**
	 * Check installed Add-on by name
	 */
	protected function checkAddOn( $addon ) {

		$add_on = Database::getRow(
			"SELECT * FROM {$this->wpdb->base_prefix}wpl_addons WHERE addon_name = ?",
			array(
				$addon
			)
		);

		return ( $add_on == false ) ? false : true;
	}

	/**
	 * Get the LatLng by address from WPL
	 * @return array
	 */
	private function getLatLng($address) {
		return \wpl_locations::get_LatLng($address);
	}

	/**
	 * Get the Location by address from WPL
	 * @return string
	 */
	private function getLocation($location_id = NULL, $level = 1) {
		return \wpl_locations::get_location($location_id, $level);
	}
}