<?php

namespace Api\Wpl\models\core\Properties;

use Api\Wpl\models\core\Database\Database;

class PropertiesManager extends Paginator {
    
    /**
     * Returns pagination Payload
     * @param $paginator
     * @return array
     */
    public static function getPaginationPayload($paginator) {
        if ($paginator instanceof Paginator) {
            return array(
                'current_page'  => $paginator->getPage(),
                'next_page'     => $paginator->getPage() + 1,
                'previous_page' => ($paginator->getPage() == 1) ? 1 : $paginator->getPage() - 1,
                'total_page'    => $paginator->getPages(),
            );
        }
    }

    /**
     * Return the total number of objects.
     */
    public static function getTotalCount($prefix, $where) {
        $count = Database::getRow("
            SELECT COUNT(id) AS total FROM {$prefix}wpl_properties WHERE {$where}"
        );
        return $count['total'];
    }
}