<?php

namespace Api\Wpl\models\core\Properties;

use Api\Wpl\models\core\Database\Database;
use Api\Wpl\models\core\Search\Builder;

class PropertiesList
{

    public function GetWhere($request)
    {

        if ($request instanceof \WP_REST_Request) {
            $builder = (new Builder())->setSwlat($request->get_param('swlat'))->setSwlng($request->get_param('swlng'))
                ->setNelat($request->get_param('nelat'))->setNelng($request->get_param('nelng'))
                ->setListingId($request->get_param('listing_id'))
                ->setMinsqft($request->get_param('minsqft'))->setMaxsqft($request->get_param('maxsqft'))
                ->setMinPrice($request->get_param('minprice'))->setMaxPrice($request->get_param('maxprice'))
                ->setMaxbedroom($request->get_param('maxbedroom'))->setMinbedroom($request->get_param('minbedroom'))
                ->setMinbathroom($request->get_param('minbathroom'))->setMaxbathroom($request->get_param('maxbathroom'))
                ->setListingType($request->get_param('listing_type'))->setPropertyType($request->get_param('property_type')
                );
            $builder->whereTags($request->get_param('tags'));
            $builder->whereNeighborhoods($request->get_param('neighborhoods'));
            $builder->whereAppliances($request->get_param('appliances'));
            return $builder->build();
        }
    }
}