<?php

namespace Api\Wpl\models\core\Properties;

use Api\Wpl\models\core\Database\Database;
use Api\Wpl\models\AbstractModel;

class PropertiesFavorite extends AbstractModel {

    /**
     * Set The User ID
     * @param $UserId
     * @return $this
     */
    public function SetUserId($UserId) {
        $this->UserId = $UserId;
        return $this;
    }

    /**
     * Get The User ID
     * @return mixed
     */
    public function GetUserId() {
        return $this->UserId;
    }

    /**
     * Set the Listing Id
     * @param $ListingId
     * @return $this
     */
    public function SetListingId($ListingId) {
        $this->ListingId = $ListingId;
        return $this;
    }

    /**
     * Get The Listing ID
     * @return mixed
     */
    public function GetListingId() {
        return $this->ListingId;
    }

    public function add() {

        $data = array(
            'user_id' => $this->GetUserId(),
            'property_id' => $this->GetListingId()
        );
        $user = get_userdata(
            $this->GetUserId()
        );

        if ( $user === false ) {
            //user id does not exist
            AbstractModel::respondError(
                __('User id does not exist.', 'wpl-api')
            );
        }
        $lastInsertId = Database::insert(
            "{$this->wpdb->base_prefix}wpl_addon_pro_favorites",$data
        );
        if ($lastInsertId) {
            wp_send_json_success(array(
                'message' => __('Property added in favorite list successfully.', 'wpl-api')
            ));
        }
    }

    public function delete() {

        $user = get_userdata(
            $this->GetUserId()
        );

        if ($user === false) {
            // user id does not exist
            AbstractModel::respondError(
                __('User id does not exist.', 'wpl-api')
            );
        } else {
            // delete listing from favorite list
            Database::delete(
                "{$this->wpdb->base_prefix}wpl_addon_pro_favorites",
                "user_id = ? and property_id = ?",array(
                    $this->GetUserId(),
                    $this->GetListingId()
                )
            );
            // return response
            wp_send_json_success(array(
                'message' => __('The listing is removed from Favorites successfully.', 'wpl-api')
            ));
        }
    }
}