<?php


namespace Api\Wpl\models\core\Properties;

use Api\Wpl\models\core\Auth\Auth;
use Api\Wpl\models\core\Database\Database;
use wpl_db;
use wpl_property;

class PropertiesDelete
{
    /** @var \wpdb */
    protected $wpdb;

    /**
     * @var PropertiesMapper
     */
    protected $storage;

    public function __construct( PropertiesMapper $data ) {

        global $wpdb;
        // Using the $wpdb Object
        $this->wpdb    = $wpdb;
        $this->storage = $data;
    }

    public function delete()
    {
        if(!class_exists('wpl_property') || !class_exists('wpl_db'))
        {
            wp_send_json_error( array(
                'message' => 'WPL Pro is not configured correctly'
            ), 200 );
        }
        if(!$this->storage->getListingId() && !$this->storage->getMlsId())
        {
            wp_send_json_error( array(
                'message' => 'Please input either MLS ID or Internal Listing ID'
            ), 200 );
        }
        if($this->storage->getListingId())
        {
            $lid = $this->storage->getListingId();
            $idsArray = explode(",",$lid);
            try
            {
                foreach($idsArray as $id)
                {
                    if(!wpl_db::get('id','wpl_properties','id',$id))
                    {
                        wp_send_json_error( array(
                            'message' => 'Listing with id equal to ' . $id . ' does not exist'
                        ), 200 );
                    }
                    wpl_property::purge($id);
                }
            }
            catch(Exception $e)
            {
                wp_send_json_error( array(
                    'message' => 'Insert operation has failed.',
                    'reason'  => $e->getMessage()
                ) );
            }
        }
        else
        {
            $mlsid = $this->storage->getMlsId();
            $idsArray = explode(",",$mlsid);
            try
            {
                foreach($idsArray as $id)
                {
                    $lid = wpl_db::get('id', 'wpl_properties', 'mls_id', $id);
                    if(!$lid)
                    {
                        wp_send_json_error( array(
                            'message' => 'Listing with mls id equal to ' . $id . ' does not exist'
                        ), 200 );
                    }
                    wpl_property::purge($lid);
                }
            }
            catch(Exception $e)
            {
                wp_send_json_error( array(
                    'message' => 'Insert operation has failed.',
                    'reason'  => $e->getMessage()
                ) );
            }
        }
        wp_send_json_success( array(
            'message'    => __('Properties deleted successfully', 'wpl-api')
        ), 201 );
    }
}