<?php

namespace Api\Wpl\models\core\Error;

class Error {

    /* @var this will hold the message itself */
    private $message = "";

    /* @var this will hold reason of error */
    private $reason = "";

    /**
     * Allow to quickly define values with constructor
     *
     * @param string $message error message
     * @param string $reason
     * @return void
     */
    public function __construct(
        $message = "",
        $reason = ""
    ) {
        $this->message = $message;
        $this->reason = $reason;
    }

    /**
     * returns the message of error
     *
     * @return string message
     */
    protected function getMessage() {
        return $this->message;
    }

    /**
     * Returns the associated field name of error
     *
     * @return void
     */
    protected function getErrorReason() {
        return $this->reason;
    }

}